/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips;

import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.SymmetricKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.ValidatedSymmetricKey;

class PrivilegedUtils {
    PrivilegedUtils() {
    }

    static ValidatedSymmetricKey getValidatedKey(SymmetricKey symmetricKey) {
        return new ValidatedSymmetricKey(symmetricKey.getAlgorithm(), PrivilegedUtils.getKeyBytes(symmetricKey));
    }

    static byte[] getKeyBytes(final SymmetricKey symmetricKey) {
        return AccessController.doPrivileged(new PrivilegedAction<byte[]>(){

            @Override
            public byte[] run() {
                return symmetricKey.getKeyBytes();
            }
        });
    }

    static void checkPermission(final Permission permission) {
        final SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    securityManager.checkPermission(permission);
                    return null;
                }
            });
        }
    }
}

