/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general;

import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AsymmetricKeyPairGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AsymmetricPrivateKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AsymmetricPublicKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Parameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsStatus;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class GuardedAsymmetricKeyPairGenerator<T extends Parameters, P extends AsymmetricPublicKey, S extends AsymmetricPrivateKey>
implements AsymmetricKeyPairGenerator<T, P, S> {
    private T parameters;

    GuardedAsymmetricKeyPairGenerator(T t) {
        FipsStatus.isReady();
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved factory in approved only mode");
        }
        this.parameters = t;
    }

    @Override
    public final T getParameters() {
        return this.parameters;
    }

    @Override
    public final AsymmetricKeyPair<P, S> generateKeyPair() {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to generate key for unapproved algorithm in approved only mode");
        }
        return this.doGenerateKeyPair();
    }

    protected abstract AsymmetricKeyPair<P, S> doGenerateKeyPair();
}

