/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider;

import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.DHGenParameterSpec;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.DHDomainParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsDH;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.spec.DHDomainParameterSpec;

class DHAlgorithmParameterGeneratorSpi
extends AlgorithmParameterGeneratorSpi {
    private final String algorithm;
    protected SecureRandom random;
    protected int strength = 2048;
    private int l = 0;
    private final BouncyCastleFipsProvider fipsProvider;

    public DHAlgorithmParameterGeneratorSpi(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string) {
        this.fipsProvider = bouncyCastleFipsProvider;
        this.algorithm = string;
    }

    protected void engineInit(int n, SecureRandom secureRandom) {
        this.strength = n;
        this.random = secureRandom;
        if (CryptoServicesRegistrar.isInApprovedOnlyMode() && n < 2048) {
            throw new InvalidParameterException("Attempt to initialize parameter generation of less than 2048 bits in approved mode");
        }
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DHGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException(this.algorithm + " parameter generator requires a DHGenParameterSpec for initialization");
        }
        DHGenParameterSpec dHGenParameterSpec = (DHGenParameterSpec)algorithmParameterSpec;
        this.strength = dHGenParameterSpec.getPrimeSize();
        if (CryptoServicesRegistrar.isInApprovedOnlyMode() && this.strength < 2048) {
            throw new InvalidAlgorithmParameterException("Attempt to initialize parameter generation of less than 2048 bits in approved mode");
        }
        this.l = dHGenParameterSpec.getExponentSize();
        this.random = secureRandom;
    }

    protected AlgorithmParameters engineGenerateParameters() {
        AlgorithmParameters algorithmParameters;
        FipsDH.DomainParametersGenerator domainParametersGenerator = this.random != null ? new FipsDH.DomainParametersGenerator(new FipsDH.DomainGenParameters(this.strength), this.random) : new FipsDH.DomainParametersGenerator(new FipsDH.DomainGenParameters(this.strength), this.fipsProvider.getDefaultSecureRandom());
        DHDomainParameters dHDomainParameters = domainParametersGenerator.generateDomainParameters();
        try {
            algorithmParameters = AlgorithmParameters.getInstance(this.algorithm, this.fipsProvider);
            algorithmParameters.init(new DHDomainParameterSpec(dHDomainParameters.getP(), dHDomainParameters.getQ(), dHDomainParameters.getG(), dHDomainParameters.getJ(), this.l, dHDomainParameters.getValidationParameters()));
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception.getMessage(), exception);
        }
        return algorithmParameters;
    }
}

