/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Algorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.AsymmetricECGOST3410PrivateKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.interfaces.ECGOST3410PrivateKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.GOST3410Util;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.ProvKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.spec.ECDomainParameterSpec;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.spec.ECGOST3410PrivateKeySpec;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.spec.GOST3410ParameterSpec;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvECGOST3410PrivateKey
implements ECGOST3410PrivateKey,
ProvKey<AsymmetricECGOST3410PrivateKey> {
    private static final long serialVersionUID = 7245981689601667138L;
    private transient AsymmetricECGOST3410PrivateKey baseKey;

    ProvECGOST3410PrivateKey(Algorithm algorithm, ECGOST3410PrivateKey eCGOST3410PrivateKey) {
        GOST3410ParameterSpec<ECDomainParameterSpec> gOST3410ParameterSpec = eCGOST3410PrivateKey.getParams();
        this.baseKey = new AsymmetricECGOST3410PrivateKey(algorithm, GOST3410Util.convertToECParams(gOST3410ParameterSpec), eCGOST3410PrivateKey.getS());
    }

    ProvECGOST3410PrivateKey(Algorithm algorithm, ECGOST3410PrivateKeySpec eCGOST3410PrivateKeySpec) {
        this.baseKey = new AsymmetricECGOST3410PrivateKey(algorithm, GOST3410Util.convertToECParams(eCGOST3410PrivateKeySpec.getParams()), eCGOST3410PrivateKeySpec.getS());
    }

    ProvECGOST3410PrivateKey(AsymmetricECGOST3410PrivateKey asymmetricECGOST3410PrivateKey) {
        this.baseKey = asymmetricECGOST3410PrivateKey;
    }

    @Override
    public AsymmetricECGOST3410PrivateKey getBaseKey() {
        return this.baseKey;
    }

    @Override
    public String getAlgorithm() {
        return this.baseKey.getAlgorithm().getName();
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    @Override
    public GOST3410ParameterSpec<ECDomainParameterSpec> getParams() {
        return GOST3410Util.convertToECSpec(this.baseKey.getParameters());
    }

    @Override
    public BigInteger getS() {
        return this.baseKey.getS();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ProvECGOST3410PrivateKey)) {
            return false;
        }
        ProvECGOST3410PrivateKey provECGOST3410PrivateKey = (ProvECGOST3410PrivateKey)object;
        return this.baseKey.equals(provECGOST3410PrivateKey.baseKey);
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Strings.lineSeparator();
        stringBuilder.append("ECGOST3410 Private Key").append(string);
        try {
            stringBuilder.append("    S: ").append(this.getS().toString(16)).append(string);
        }
        catch (Exception exception) {
            stringBuilder.append("RESTRICTED").append(string);
        }
        return stringBuilder.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Algorithm algorithm = (Algorithm)objectInputStream.readObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new AsymmetricECGOST3410PrivateKey(algorithm, byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.baseKey.getAlgorithm());
        objectOutputStream.writeObject(this.getEncoded());
    }
}

