/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.spec;

import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.DigestAlgorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsSHS;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Arrays;

public class DSADomainParametersGenerationParameterSpec
implements AlgorithmParameterSpec {
    public static final int DIGITAL_SIGNATURE_USAGE = 1;
    public static final int KEY_ESTABLISHMENT_USAGE = 2;
    private final int l;
    private final int n;
    private final int certainty;
    private final BigInteger p;
    private final BigInteger q;
    private final byte[] seed;
    private final int usageIndex;
    private final DigestAlgorithm digestAlgorithm;

    public DSADomainParametersGenerationParameterSpec(int n, int n2, int n3) {
        this(n, n2, n3, -1);
    }

    public DSADomainParametersGenerationParameterSpec(int n, int n2, int n3, int n4) {
        this(FipsSHS.Algorithm.SHA256, n, n2, n3, null, null, null, n4);
    }

    public DSADomainParametersGenerationParameterSpec(BigInteger bigInteger, BigInteger bigInteger2) {
        this(FipsSHS.Algorithm.SHA256, bigInteger.bitLength(), bigInteger2.bitLength(), 0, bigInteger, bigInteger2, null, -1);
    }

    public DSADomainParametersGenerationParameterSpec(BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray, int n) {
        this(FipsSHS.Algorithm.SHA256, bigInteger.bitLength(), bigInteger2.bitLength(), 0, bigInteger, bigInteger2, Arrays.clone(byArray), n);
    }

    private DSADomainParametersGenerationParameterSpec(DigestAlgorithm digestAlgorithm, int n, int n2, int n3, BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray, int n4) {
        this.digestAlgorithm = digestAlgorithm;
        this.l = n;
        this.n = n2;
        this.certainty = n3;
        this.p = bigInteger;
        this.q = bigInteger2;
        this.seed = byArray;
        this.usageIndex = n4;
    }

    public DSADomainParametersGenerationParameterSpec withDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        return new DSADomainParametersGenerationParameterSpec(digestAlgorithm, this.l, this.n, this.certainty, this.p, this.q, this.seed, this.usageIndex);
    }

    public int getL() {
        return this.l;
    }

    public int getN() {
        return this.n;
    }

    public int getCertainty() {
        return this.certainty;
    }

    public int getUsageIndex() {
        return this.usageIndex;
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public byte[] getSeed() {
        return Arrays.clone(this.seed);
    }

    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }
}

