/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.log;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import net.snowflake.client.core.EventHandler;
import net.snowflake.client.core.EventUtil;
import net.snowflake.client.log.ArgSupplier;
import net.snowflake.client.log.SFFormatter;
import net.snowflake.client.log.SFLogger;

public class JDK14Logger
implements SFLogger {
    private Logger jdkLogger;
    private Set<String> logMethods = new HashSet<String>(Arrays.asList("debug", "error", "info", "trace", "warn"));
    private static boolean isLegacyLoggerInit = false;

    public JDK14Logger(String name) {
        this.jdkLogger = Logger.getLogger(name);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.jdkLogger.isLoggable(Level.FINE);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.jdkLogger.isLoggable(Level.SEVERE);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.jdkLogger.isLoggable(Level.INFO);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.jdkLogger.isLoggable(Level.FINEST);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.jdkLogger.isLoggable(Level.WARNING);
    }

    @Override
    public void debug(String msg) {
        this.logInternal(Level.FINE, msg);
    }

    @Override
    public void debug(String msg, Object ... arguments) {
        this.logInternal(Level.FINE, msg, arguments);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.logInternal(Level.FINE, msg, t);
    }

    @Override
    public void error(String msg) {
        this.logInternal(Level.SEVERE, msg);
    }

    @Override
    public void error(String msg, Object ... arguments) {
        this.logInternal(Level.SEVERE, msg, arguments);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.logInternal(Level.SEVERE, msg, t);
    }

    @Override
    public void info(String msg) {
        this.logInternal(Level.INFO, msg);
    }

    @Override
    public void info(String msg, Object ... arguments) {
        this.logInternal(Level.INFO, msg, arguments);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.logInternal(Level.INFO, msg, t);
    }

    @Override
    public void trace(String msg) {
        this.logInternal(Level.FINEST, msg);
    }

    @Override
    public void trace(String msg, Object ... arguments) {
        this.logInternal(Level.FINEST, msg, arguments);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.logInternal(Level.FINEST, msg, t);
    }

    @Override
    public void warn(String msg) {
        this.logInternal(Level.WARNING, msg);
    }

    @Override
    public void warn(String msg, Object ... arguments) {
        this.logInternal(Level.WARNING, msg, arguments);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.logInternal(Level.WARNING, msg, t);
    }

    private void logInternal(Level level, String msg) {
        if (this.jdkLogger.isLoggable(level)) {
            String[] source = this.findSourceInStack();
            this.jdkLogger.logp(level, source[0], source[1], msg);
        }
    }

    private void logInternal(Level level, String msg, Object ... arguments) {
        if (this.jdkLogger.isLoggable(level)) {
            String[] source = this.findSourceInStack();
            this.jdkLogger.logp(level, source[0], source[1], this.refactorString(msg), JDK14Logger.evaluateLambdaArgs(arguments));
        }
    }

    private void logInternal(Level level, String msg, Throwable t) {
        if (this.jdkLogger.isLoggable(level)) {
            String[] source = this.findSourceInStack();
            this.jdkLogger.logp(level, source[0], source[1], msg, t);
        }
    }

    public static void addHandler(Handler handler) {
        Logger snowflakeLogger = Logger.getLogger(SFFormatter.CLASS_NAME_PREFIX);
        snowflakeLogger.addHandler(handler);
    }

    public static void setLevel(Level level) {
        Logger snowflakeLogger = Logger.getLogger(SFFormatter.CLASS_NAME_PREFIX);
        snowflakeLogger.setLevel(level);
    }

    public static synchronized void honorTracingParameter(Level level) {
        if (!isLegacyLoggerInit && System.getProperty("java.util.logging.config.file") == null && System.getProperty("java.util.logging.config.class") == null) {
            JDK14Logger.legacyLoggerInit(level);
            isLegacyLoggerInit = true;
        }
    }

    private String refactorString(String original) {
        StringBuilder sb = new StringBuilder();
        int argCount = 0;
        for (int i = 0; i < original.length(); ++i) {
            if (original.charAt(i) == '{' && i < original.length() - 1 && original.charAt(i + 1) == '}') {
                sb.append(String.format("{%d}", argCount));
                ++argCount;
                ++i;
                continue;
            }
            sb.append(original.charAt(i));
        }
        return sb.toString();
    }

    private String[] findSourceInStack() {
        StackTraceElement[] stackTraces = Thread.currentThread().getStackTrace();
        String[] results = new String[2];
        for (int i = 0; i < stackTraces.length; ++i) {
            if (!this.logMethods.contains(stackTraces[i].getMethodName())) continue;
            for (int j = i; j < stackTraces.length; ++j) {
                if (this.logMethods.contains(stackTraces[j].getMethodName())) continue;
                results[0] = stackTraces[j].getClassName();
                results[1] = stackTraces[j].getMethodName();
                return results;
            }
        }
        return results;
    }

    @Deprecated
    private static void legacyLoggerInit(Level level) {
        String defaultLogSizeVal = System.getProperty("snowflake.jdbc.log.size");
        String defaultLogCountVal = System.getProperty("snowflake.jdbc.log.count");
        int logSize = 1000000000;
        int logCount = 2;
        if (defaultLogSizeVal != null) {
            try {
                logSize = Integer.parseInt(defaultLogSizeVal);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (defaultLogCountVal != null) {
            try {
                logCount = Integer.parseInt(defaultLogCountVal);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        EventHandler eventHandler = EventUtil.getEventHandlerInstance();
        eventHandler.setLevel(Level.INFO);
        eventHandler.setFormatter(new SimpleFormatter());
        JDK14Logger.addHandler(eventHandler);
        Logger snowflakeLoggerInformaticaV1 = Logger.getLogger("com.snowflake");
        snowflakeLoggerInformaticaV1.setLevel(level);
        snowflakeLoggerInformaticaV1.addHandler(eventHandler);
        try {
            FileHandler fileHandler = new FileHandler("%t/snowflake_jdbc%u.log", logSize, logCount, true);
            fileHandler.setFormatter(new SFFormatter());
            fileHandler.setLevel(level);
            JDK14Logger.addHandler(fileHandler);
            JDK14Logger.setLevel(level);
            snowflakeLoggerInformaticaV1.addHandler(fileHandler);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Object[] evaluateLambdaArgs(Object ... args) {
        Object[] result = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            result[i] = args[i] instanceof ArgSupplier ? ((ArgSupplier)args[i]).get() : args[i];
        }
        return result;
    }
}

