/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.VarCharVector;

public class VarCharConverter
extends AbstractArrowVectorConverter {
    private VarCharVector varCharVector;

    public VarCharConverter(ValueVector valueVector, int columnIndex, DataConversionContext context) {
        super(SnowflakeType.TEXT.name(), valueVector, columnIndex, context);
        this.varCharVector = (VarCharVector)valueVector;
    }

    @Override
    public String toString(int index) {
        byte[] bytes = this.toBytes(index);
        return bytes == null ? null : new String(bytes, StandardCharsets.UTF_8);
    }

    @Override
    public byte[] toBytes(int index) {
        return this.isNull(index) ? null : this.varCharVector.get(index);
    }

    @Override
    public Object toObject(int index) {
        return this.toString(index);
    }

    @Override
    public short toShort(int index) {
        String str = this.toString(index);
        if (str == null) {
            return 0;
        }
        return Short.parseShort(str);
    }

    @Override
    public int toInt(int index) {
        String str = this.toString(index);
        if (str == null) {
            return 0;
        }
        return Integer.parseInt(str);
    }

    @Override
    public long toLong(int index) {
        String str = this.toString(index);
        if (str == null) {
            return 0L;
        }
        return Long.parseLong(str);
    }

    @Override
    public float toFloat(int index) {
        String str = this.toString(index);
        if (str == null) {
            return 0.0f;
        }
        return Float.parseFloat(str);
    }

    @Override
    public double toDouble(int index) {
        String str = this.toString(index);
        if (str == null) {
            return 0.0;
        }
        return Double.parseDouble(str);
    }

    @Override
    public BigDecimal toBigDecimal(int index) {
        String str = this.toString(index);
        if (str == null) {
            return null;
        }
        return new BigDecimal(str);
    }
}

