/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeConnectString;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.internal.snowflake.common.core.ResourceBundleManager;

public class SnowflakeDriver
implements Driver {
    static SnowflakeDriver INSTANCE;
    public static final Properties EMPTY_PROPERTIES;
    public static String implementVersion;
    private static final DriverPropertyInfo[] EMPTY_INFO;
    static int majorVersion;
    static int minorVersion;
    static long patchVersion;
    protected static boolean disableIncidents;
    private static final ResourceBundleManager versionResourceBundleManager;

    private static void initializeClientVersionFromManifest() {
        try {
            String[] versionBreakdown;
            implementVersion = versionResourceBundleManager.getLocalizedMessage("version");
            if (implementVersion != null) {
                versionBreakdown = implementVersion.split("\\.");
                if (versionBreakdown.length != 3) {
                    throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Invalid Snowflake JDBC Version: " + implementVersion);
                }
            } else {
                throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Snowflake JDBC Version is not set. Ensure version.properties is included.");
            }
            majorVersion = Integer.parseInt(versionBreakdown[0]);
            minorVersion = Integer.parseInt(versionBreakdown[1]);
            patchVersion = Long.parseLong(versionBreakdown[2]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean acceptsURL(String url) {
        return SnowflakeConnectString.parse(url, EMPTY_PROPERTIES).isValid();
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        SnowflakeConnectString conStr = SnowflakeConnectString.parse(url, info);
        if (!conStr.isValid()) {
            return null;
        }
        return new SnowflakeConnectionV1(url, info);
    }

    @Override
    public int getMajorVersion() {
        return majorVersion;
    }

    @Override
    public int getMinorVersion() {
        return minorVersion;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return EMPTY_INFO;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    public static boolean isDisableIncidents() {
        return disableIncidents;
    }

    public static void setDisableIncidents(boolean throttleIncidents) {
        disableIncidents = throttleIncidents;
    }

    public static final void main(String[] args) {
        Package pkg;
        if (args.length > 0 && "--version".equals(args[0]) && (pkg = Package.getPackage("net.snowflake.client.jdbc")) != null) {
            System.out.println(pkg.getImplementationVersion());
        }
    }

    static {
        EMPTY_PROPERTIES = new Properties();
        implementVersion = null;
        EMPTY_INFO = new DriverPropertyInfo[0];
        majorVersion = 0;
        minorVersion = 0;
        patchVersion = 0L;
        disableIncidents = false;
        versionResourceBundleManager = ResourceBundleManager.getSingleton("net.snowflake.client.jdbc.version");
        try {
            INSTANCE = new SnowflakeDriver();
            DriverManager.registerDriver(INSTANCE);
        }
        catch (SQLException ex) {
            throw new IllegalStateException("Unable to register " + SnowflakeDriver.class.getName(), ex);
        }
        SnowflakeDriver.initializeClientVersionFromManifest();
    }
}

