/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FieldVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.VectorLoader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.VectorSchemaRoot;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.dictionary.Dictionary;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.dictionary.DictionaryProvider;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.ArrowDictionaryBatch;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.Field;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.Schema;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.DictionaryUtility;

public abstract class ArrowReader
implements DictionaryProvider,
AutoCloseable {
    protected final BufferAllocator allocator;
    private VectorLoader loader;
    private VectorSchemaRoot root;
    private Map<Long, Dictionary> dictionaries;
    private boolean initialized = false;

    protected ArrowReader(BufferAllocator allocator) {
        this.allocator = allocator;
    }

    public VectorSchemaRoot getVectorSchemaRoot() throws IOException {
        this.ensureInitialized();
        return this.root;
    }

    public Map<Long, Dictionary> getDictionaryVectors() throws IOException {
        this.ensureInitialized();
        return this.dictionaries;
    }

    @Override
    public Dictionary lookup(long id) {
        if (!this.initialized) {
            throw new IllegalStateException("Unable to lookup until reader has been initialized");
        }
        return this.dictionaries.get(id);
    }

    public abstract boolean loadNextBatch() throws IOException;

    public abstract long bytesRead();

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean closeReadSource) throws IOException {
        if (this.initialized) {
            this.root.close();
            for (Dictionary dictionary : this.dictionaries.values()) {
                dictionary.getVector().close();
            }
        }
        if (closeReadSource) {
            this.closeReadSource();
        }
    }

    protected abstract void closeReadSource() throws IOException;

    protected abstract Schema readSchema() throws IOException;

    protected abstract ArrowDictionaryBatch readDictionary() throws IOException;

    protected void ensureInitialized() throws IOException {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
    }

    private void initialize() throws IOException {
        Schema originalSchema = this.readSchema();
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList<FieldVector> vectors = new ArrayList<FieldVector>();
        HashMap<Long, Dictionary> dictionaries = new HashMap<Long, Dictionary>();
        for (Field field : originalSchema.getFields()) {
            Field updated = DictionaryUtility.toMemoryFormat(field, this.allocator, dictionaries);
            fields.add(updated);
            vectors.add(updated.createVector(this.allocator));
        }
        Schema schema = new Schema(fields, originalSchema.getCustomMetadata());
        this.root = new VectorSchemaRoot(schema, vectors, 0);
        this.loader = new VectorLoader(this.root);
        this.dictionaries = Collections.unmodifiableMap(dictionaries);
        for (int i = 0; i < dictionaries.size(); ++i) {
            ArrowDictionaryBatch dictionaryBatch = this.readDictionary();
            this.loadDictionary(dictionaryBatch);
        }
    }

    protected void prepareLoadNextBatch() throws IOException {
        this.ensureInitialized();
        this.root.setRowCount(0);
    }

    protected void loadRecordBatch(ArrowRecordBatch batch) {
        try {
            this.loader.load(batch);
        }
        finally {
            batch.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadDictionary(ArrowDictionaryBatch dictionaryBatch) {
        long id = dictionaryBatch.getDictionaryId();
        Dictionary dictionary = this.dictionaries.get(id);
        if (dictionary == null) {
            throw new IllegalArgumentException("Dictionary ID " + id + " not defined in schema");
        }
        FieldVector vector = dictionary.getVector();
        VectorSchemaRoot root = new VectorSchemaRoot(Collections.singletonList(vector.getField()), Collections.singletonList(vector), 0);
        VectorLoader loader = new VectorLoader(root);
        try {
            loader.load(dictionaryBatch.getDictionary());
        }
        finally {
            dictionaryBatch.close();
        }
    }
}

