/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.cms;

import java.io.InputStream;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.InputDecryptor;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.MacCalculator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.io.TeeInputStream;

public class RecipientOperator {
    private final AlgorithmIdentifier algorithmIdentifier;
    private final Object operator;

    public RecipientOperator(InputDecryptor decryptor) {
        this.algorithmIdentifier = decryptor.getAlgorithmIdentifier();
        this.operator = decryptor;
    }

    public RecipientOperator(MacCalculator macCalculator) {
        this.algorithmIdentifier = macCalculator.getAlgorithmIdentifier();
        this.operator = macCalculator;
    }

    public InputStream getInputStream(InputStream dataIn) {
        if (this.operator instanceof InputDecryptor) {
            return ((InputDecryptor)this.operator).getInputStream(dataIn);
        }
        return new TeeInputStream(dataIn, ((MacCalculator)this.operator).getOutputStream());
    }

    public boolean isMacBased() {
        return this.operator instanceof MacCalculator;
    }

    public byte[] getMac() {
        return ((MacCalculator)this.operator).getMac();
    }
}

