/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips;

import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.PasswordBasedDeriver;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.PasswordConverter;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsAlgorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsDigestAlgorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsPasswordBasedDeriverFactory;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsSHS;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.PKCS5S2ParametersGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Arrays;

public final class FipsPBKD {
    private static final FipsAlgorithm ALGORITHM_PBKDF2 = new FipsAlgorithm("PBKDF2");
    public static final ParametersBuilder PBKDF2 = new ParametersBuilder();

    private FipsPBKD() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeriverFactory
    extends FipsPasswordBasedDeriverFactory<Parameters> {
        @Override
        public PasswordBasedDeriver<Parameters> createDeriver(final Parameters parameters) {
            final PKCS5S2ParametersGenerator<Parameters> pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator<Parameters>(parameters, FipsSHS.createHMac(parameters.getPRF()));
            pKCS5S2ParametersGenerator.init(parameters.getPassword(), parameters.getSalt(), parameters.getIterationCount());
            return new PasswordBasedDeriver<Parameters>(){

                @Override
                public Parameters getParameters() {
                    return parameters;
                }

                @Override
                public byte[] deriveKey(PasswordBasedDeriver.KeyType keyType, int n) {
                    return pKCS5S2ParametersGenerator.deriveKey(keyType, n);
                }

                @Override
                public byte[][] deriveKeyAndIV(PasswordBasedDeriver.KeyType keyType, int n, int n2) {
                    return pKCS5S2ParametersGenerator.deriveKeyAndIV(keyType, n, n2);
                }
            };
        }
    }

    public static final class Parameters
    extends FipsParameters {
        private final FipsDigestAlgorithm digestAlgorithm;
        private final PasswordConverter converter;
        private final byte[] password;
        private final byte[] salt;
        private final int iterationCount;

        private Parameters(FipsDigestAlgorithm fipsDigestAlgorithm, PasswordConverter passwordConverter, byte[] byArray, int n, byte[] byArray2) {
            super(ALGORITHM_PBKDF2);
            this.digestAlgorithm = fipsDigestAlgorithm;
            this.converter = passwordConverter;
            this.password = byArray;
            this.iterationCount = n;
            this.salt = byArray2;
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                if (byArray2.length < 16) {
                    throw new FipsUnapprovedOperationError("salt must be at least 128 bits");
                }
                if (byArray.length < 14) {
                    throw new FipsUnapprovedOperationError("password must be at least 112 bits");
                }
            }
        }

        private Parameters(FipsDigestAlgorithm fipsDigestAlgorithm, PasswordConverter passwordConverter, char[] cArray) {
            this(fipsDigestAlgorithm, passwordConverter, passwordConverter.convert(cArray), 1024, new byte[20]);
        }

        public Parameters withSalt(byte[] byArray) {
            return new Parameters(this.digestAlgorithm, this.converter, this.getPassword(), this.iterationCount, Arrays.clone(byArray));
        }

        public Parameters withIterationCount(int n) {
            return new Parameters(this.digestAlgorithm, this.converter, this.getPassword(), n, this.salt);
        }

        byte[] getPassword() {
            return Arrays.clone(this.password);
        }

        public FipsDigestAlgorithm getPRF() {
            return this.digestAlgorithm;
        }

        public byte[] getSalt() {
            return Arrays.clone(this.salt);
        }

        public int getIterationCount() {
            return this.iterationCount;
        }

        public PasswordConverter getConverter() {
            return this.converter;
        }

        protected void finalize() {
            Arrays.fill(this.password, (byte)0);
        }
    }

    public static final class ParametersBuilder
    extends FipsParameters {
        ParametersBuilder() {
            super(ALGORITHM_PBKDF2);
        }

        public Parameters using(byte[] byArray) {
            return this.using(FipsSHS.Algorithm.SHA1_HMAC, byArray);
        }

        public Parameters using(FipsDigestAlgorithm fipsDigestAlgorithm, byte[] byArray) {
            return new Parameters(fipsDigestAlgorithm, null, Arrays.clone(byArray), 1024, new byte[20]);
        }

        public Parameters using(PasswordConverter passwordConverter, char[] cArray) {
            return new Parameters(FipsSHS.Algorithm.SHA1_HMAC, passwordConverter, cArray);
        }

        public Parameters using(FipsDigestAlgorithm fipsDigestAlgorithm, PasswordConverter passwordConverter, char[] cArray) {
            return new Parameters(fipsDigestAlgorithm, passwordConverter, passwordConverter.convert(cArray), 1024, new byte[20]);
        }
    }
}

