/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.macs;

import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.CipherParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.DataLengthException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.InvalidCipherTextException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.Mac;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.modes.AEADBlockCipher;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.AEADParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.KeyParameter;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.ParametersWithIV;

public class GMac
implements Mac {
    private final AEADBlockCipher cipher;
    private final int macSizeBits;

    public GMac(AEADBlockCipher aEADBlockCipher) {
        this.cipher = aEADBlockCipher;
        this.macSizeBits = 128;
    }

    public GMac(AEADBlockCipher aEADBlockCipher, int n) {
        this.cipher = aEADBlockCipher;
        this.macSizeBits = n;
    }

    public void init(CipherParameters cipherParameters) throws IllegalArgumentException {
        if (!(cipherParameters instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("GMAC requires ParametersWithIV");
        }
        ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
        byte[] byArray = parametersWithIV.getIV();
        KeyParameter keyParameter = (KeyParameter)parametersWithIV.getParameters();
        this.cipher.init(true, new AEADParameters(keyParameter, this.macSizeBits, byArray));
    }

    public String getAlgorithmName() {
        return this.cipher.getUnderlyingCipher().getAlgorithmName() + "-GMAC";
    }

    public int getMacSize() {
        return this.macSizeBits / 8;
    }

    public void update(byte by) throws IllegalStateException {
        this.cipher.processAADByte(by);
    }

    public void update(byte[] byArray, int n, int n2) throws DataLengthException, IllegalStateException {
        this.cipher.processAADBytes(byArray, n, n2);
    }

    public int doFinal(byte[] byArray, int n) throws DataLengthException, IllegalStateException {
        try {
            return this.cipher.doFinal(byArray, n);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new IllegalStateException(invalidCipherTextException.toString());
        }
    }

    public void reset() {
        this.cipher.reset();
    }
}

