/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params;

import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.DerivationParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Arrays;

public final class KDFDoublePipelineIterationParameters
implements DerivationParameters {
    public static final int BEFORE_ITER = 0;
    public static final int AFTER_ITER = 1;
    public static final int AFTER_FIXED = 2;
    private static final int UNUSED_R = 32;
    private final byte[] ki;
    private final boolean useCounter;
    private final int r;
    private final byte[] fixedInputData;
    private final int counterLocation;

    private KDFDoublePipelineIterationParameters(int n, byte[] byArray, byte[] byArray2, int n2, boolean bl) {
        if (byArray == null) {
            throw new IllegalArgumentException("A KDF requires Ki (a seed) as input");
        }
        this.counterLocation = n;
        this.ki = Arrays.clone(byArray);
        this.fixedInputData = byArray2 == null ? new byte[0] : Arrays.clone(byArray2);
        if (n2 != 8 && n2 != 16 && n2 != 24 && n2 != 32) {
            throw new IllegalArgumentException("Length of counter should be 8, 16, 24 or 32");
        }
        this.r = n2;
        this.useCounter = bl;
    }

    public static KDFDoublePipelineIterationParameters createWithCounter(int n, byte[] byArray, byte[] byArray2, int n2) {
        return new KDFDoublePipelineIterationParameters(n, byArray, byArray2, n2, true);
    }

    public static KDFDoublePipelineIterationParameters createWithoutCounter(byte[] byArray, byte[] byArray2) {
        return new KDFDoublePipelineIterationParameters(0, byArray, byArray2, 32, false);
    }

    public int getCounterLocation() {
        return this.counterLocation;
    }

    public byte[] getKI() {
        return this.ki;
    }

    public boolean useCounter() {
        return this.useCounter;
    }

    public int getR() {
        return this.r;
    }

    public byte[] getFixedInputData() {
        return Arrays.clone(this.fixedInputData);
    }
}

