/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake.s3upload;

import java.io.InputStream;
import net.snowflake.spark.snowflake.s3upload.ConvertibleOutputStream;

class StreamPart {
    private ConvertibleOutputStream stream;
    private int partNumber;
    static final StreamPart POISON = new StreamPart(null, -1);

    public StreamPart(ConvertibleOutputStream convertibleOutputStream, int n) {
        this.stream = convertibleOutputStream;
        this.partNumber = n;
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public ConvertibleOutputStream getOutputStream() {
        return this.stream;
    }

    public InputStream getInputStream() {
        return this.stream.toInputStream();
    }

    public long size() {
        return this.stream.size();
    }

    public String toString() {
        return String.format("[Part number %d %s]", this.partNumber, this.stream == null ? "with null stream" : String.format("containing %.2f MB", (double)this.size() / 1048576.0));
    }
}

