/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake.io;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ObjectNode;
import net.snowflake.spark.snowflake.ConstantString;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper$;
import net.snowflake.spark.snowflake.Parameters;
import net.snowflake.spark.snowflake.SnowflakeSQLStatement;
import net.snowflake.spark.snowflake.SnowflakeTelemetry$;
import net.snowflake.spark.snowflake.TelemetryTypes$;
import net.snowflake.spark.snowflake.Utils$;
import net.snowflake.spark.snowflake.io.CloudStorage;
import net.snowflake.spark.snowflake.io.CloudStorageOperations$;
import net.snowflake.spark.snowflake.io.SupportedFormat$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Enumeration;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;

public final class StageReader$ {
    public static final StageReader$ MODULE$;
    private final ObjectMapper mapper;
    private final Logger logger;
    private final String OUTPUT_BYTES;

    static {
        new StageReader$();
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    private Logger logger() {
        return this.logger;
    }

    private String OUTPUT_BYTES() {
        return this.OUTPUT_BYTES;
    }

    public RDD<String> readFromStage(SQLContext sqlContext, Parameters.MergedParameters params, SnowflakeSQLStatement statement, Enumeration.Value format) {
        Connection conn = DefaultJDBCWrapper$.MODULE$.getConnector(params);
        Tuple2<CloudStorage, String> tuple2 = CloudStorageOperations$.MODULE$.createStorageClient(params, conn, CloudStorageOperations$.MODULE$.createStorageClient$default$3(), CloudStorageOperations$.MODULE$.createStorageClient$default$4());
        if (tuple2 != null) {
            Tuple2 tuple22;
            CloudStorage storage = (CloudStorage)tuple2._1();
            String stage = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)storage, (Object)stage);
            CloudStorage storage2 = (CloudStorage)tuple23._1();
            String stage2 = (String)tuple23._2();
            boolean compress = params.sfCompress();
            String compressFormat = params.sfCompress() ? "gzip" : "none";
            Utils$.MODULE$.genPrologueSql(params).execute(params.bindVariableEnabled(), conn);
            Utils$.MODULE$.executePreActions(DefaultJDBCWrapper$.MODULE$, conn, params, params.table());
            String prefix = Random$.MODULE$.alphanumeric().take(10).mkString("");
            ResultSet res = this.buildUnloadStatement(params, statement, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"@", "/", "/"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{stage2, prefix})), compressFormat, format).execute(params.bindVariableEnabled(), conn);
            ResultSetMetaData sch = res.getMetaData();
            Predef$.MODULE$.assert(sch.getColumnCount() == 3);
            String string = sch.getColumnName(1);
            String string2 = "rows_unloaded";
            Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null));
            String string3 = sch.getColumnTypeName(1);
            String string4 = "NUMBER";
            Predef$.MODULE$.assert(!(string3 != null ? !string3.equals(string4) : string4 != null));
            String string5 = sch.getColumnName(3);
            String string6 = "output_bytes";
            Predef$.MODULE$.assert(!(string5 != null ? !string5.equals(string6) : string6 != null));
            boolean first = res.next();
            Predef$.MODULE$.assert(first);
            this.sendEgressUsage(res.getLong(3), conn);
            boolean second = res.next();
            Predef$.MODULE$.assert(!second);
            Utils$.MODULE$.executePostActions(DefaultJDBCWrapper$.MODULE$, conn, params, params.table());
            SnowflakeTelemetry$.MODULE$.send(DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn).getTelemetry());
            return storage2.download(sqlContext.sparkContext(), format, compress, prefix);
        }
        throw new MatchError(tuple2);
    }

    private SnowflakeSQLStatement buildUnloadStatement(Parameters.MergedParameters params, SnowflakeSQLStatement statement, String location, String compression, Enumeration.Value format) {
        Enumeration.Value value;
        block6: {
            Tuple2 tuple2;
            block5: {
                block4: {
                    Utils$.MODULE$.setLastSelect(statement.toString());
                    value = format;
                    Enumeration.Value value2 = SupportedFormat$.MODULE$.CSV();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block4;
                    tuple2 = new Tuple2((Object)new ConstantString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                 |FILE_FORMAT = (\n                 |    TYPE=CSV\n                 |    COMPRESSION='", "'\n                 |    FIELD_DELIMITER='|'\n                 |    FIELD_OPTIONALLY_ENCLOSED_BY='\"'\n                 |    ESCAPE_UNENCLOSED_FIELD = none\n                 |    NULL_IF= ()\n                 |  )\n                 |  "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{compression})))).stripMargin()).$bang(), (Object)new ConstantString("FROM (").$plus(statement).$plus(")"));
                    break block5;
                }
                Enumeration.Value value4 = SupportedFormat$.MODULE$.JSON();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block6;
                tuple2 = new Tuple2((Object)new ConstantString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                 |FILE_FORMAT = (\n                 |    TYPE=JSON\n                 |    COMPRESSION='", "'\n                 |)\n                 |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{compression})))).stripMargin()).$bang(), (Object)new ConstantString("FROM (SELECT object_construct(*) FROM (").$plus(statement).$plus("))"));
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 != null) {
                Tuple2 tuple23;
                SnowflakeSQLStatement formatStmt = (SnowflakeSQLStatement)tuple22._1();
                SnowflakeSQLStatement queryStmt = (SnowflakeSQLStatement)tuple22._2();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)formatStmt, (Object)queryStmt);
                SnowflakeSQLStatement formatStmt2 = (SnowflakeSQLStatement)tuple24._1();
                SnowflakeSQLStatement queryStmt2 = (SnowflakeSQLStatement)tuple24._2();
                SnowflakeSQLStatement result = new ConstantString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COPY INTO '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{location}))).$plus(queryStmt2).$plus(formatStmt2).$plus("MAX_FILE_SIZE = ").$plus(params.s3maxfilesize());
                Utils$.MODULE$.setLastCopyUnload(result.toString());
                return result;
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError((Object)value);
    }

    private Enumeration.Value buildUnloadStatement$default$5() {
        return SupportedFormat$.MODULE$.CSV();
    }

    private void sendEgressUsage(long bytes, Connection conn) {
        ObjectNode metric = this.mapper().createObjectNode();
        metric.put(this.OUTPUT_BYTES(), bytes);
        SnowflakeTelemetry$.MODULE$.addLog((Tuple2<Tuple2<Enumeration.Value, ObjectNode>, Object>)new Tuple2((Object)new Tuple2((Object)TelemetryTypes$.MODULE$.SPARK_EGRESS(), (Object)metric), (Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
        SnowflakeTelemetry$.MODULE$.send(DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn).getTelemetry());
        this.logger().debug(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Data Egress Usage: ", " bytes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)bytes)})))).stripMargin());
    }

    private StageReader$() {
        MODULE$ = this;
        this.mapper = new ObjectMapper();
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.OUTPUT_BYTES = "output_bytes";
    }
}

