/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake.io;

import java.sql.Connection;
import java.sql.ResultSet;
import net.snowflake.spark.snowflake.ConstantString;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper$;
import net.snowflake.spark.snowflake.EmptySnowflakeSQLStatement$;
import net.snowflake.spark.snowflake.Parameters;
import net.snowflake.spark.snowflake.SnowflakeSQLStatement;
import net.snowflake.spark.snowflake.TableName;
import net.snowflake.spark.snowflake.Utils$;
import net.snowflake.spark.snowflake.io.CloudStorage;
import net.snowflake.spark.snowflake.io.CloudStorageOperations$;
import net.snowflake.spark.snowflake.io.SupportedFormat$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;

public final class StageWriter$ {
    public static final StageWriter$ MODULE$;
    private final Logger net$snowflake$spark$snowflake$io$StageWriter$$log;

    static {
        new StageWriter$();
    }

    public Logger net$snowflake$spark$snowflake$io$StageWriter$$log() {
        return this.net$snowflake$spark$snowflake$io$StageWriter$$log;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToStage(RDD<String> rdd, StructType schema2, SaveMode saveMode, Parameters.MergedParameters params, Enumeration.Value format) {
        Tuple2<CloudStorage, String> tuple2;
        block4: {
            Connection conn;
            block5: {
                if (params.table().isEmpty()) {
                    throw new IllegalArgumentException("For save operations you must specify a Snowflake table name with the 'dbtable' parameter");
                }
                SnowflakeSQLStatement prologueSql = Utils$.MODULE$.genPrologueSql(params);
                this.net$snowflake$spark$snowflake$io$StageWriter$$log().debug(prologueSql.toString());
                conn = DefaultJDBCWrapper$.MODULE$.getConnector(params);
                try {
                    Tuple2 tuple22;
                    prologueSql.execute(params.bindVariableEnabled(), conn);
                    tuple2 = CloudStorageOperations$.MODULE$.createStorageClient(params, conn, true, (Option<String>)None$.MODULE$);
                    if (tuple2 == null) break block4;
                    CloudStorage storage = (CloudStorage)tuple2._1();
                    String stage = (String)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)storage, (Object)stage);
                    CloudStorage storage2 = (CloudStorage)tuple23._1();
                    String stage2 = (String)tuple23._2();
                    List<String> filesToCopy = storage2.upload(rdd, format, (Option<String>)None$.MODULE$, storage2.upload$default$4());
                    if (!filesToCopy.nonEmpty()) break block5;
                    this.writeToTable(conn, schema2, saveMode, params, ((String)filesToCopy.head()).substring(0, ((String)filesToCopy.head()).indexOf("/")), stage2, format);
                }
                catch (Throwable throwable) {
                    void var7_7;
                    var7_7.close();
                    throw throwable;
                }
            }
            conn.close();
            return;
        }
        throw new MatchError(tuple2);
    }

    private void writeToTable(Connection conn, StructType schema2, SaveMode saveMode, Parameters.MergedParameters params, String file, String tempStage, Enumeration.Value format) {
        TableName table2 = (TableName)params.table().get();
        TableName tempTable = new TableName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_staging_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table2.name().replace('\"', '_'), ((Object)BoxesRunTime.boxToInteger((int)Math.abs(Random$.MODULE$.nextInt()))).toString()})));
        SaveMode saveMode2 = saveMode;
        SaveMode saveMode3 = SaveMode.Overwrite;
        TableName targetTable = !(saveMode2 != null ? !saveMode2.equals(saveMode3) : saveMode3 != null) && params.useStagingTable() ? tempTable : table2;
        try {
            Object object;
            SaveMode saveMode4 = saveMode;
            SaveMode saveMode5 = SaveMode.Overwrite;
            if (!(saveMode4 != null ? !saveMode4.equals(saveMode5) : saveMode5 != null) && DefaultJDBCWrapper$.MODULE$.tableExists(conn, table2.toString())) {
                if (params.useStagingTable()) {
                    if (params.truncateTable()) {
                        DefaultJDBCWrapper.DataBaseOperations qual$1 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                        String x$3 = tempTable.name();
                        String x$4 = table2.name();
                        boolean x$5 = qual$1.createTableLike$default$3();
                        qual$1.createTableLike(x$3, x$4, x$5);
                    }
                    object = BoxedUnit.UNIT;
                } else if (params.truncateTable()) {
                    DefaultJDBCWrapper.DataBaseOperations qual$2 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                    String x$6 = table2.name();
                    boolean x$7 = qual$2.truncateTable$default$2();
                    qual$2.truncateTable(x$6, x$7);
                    object = BoxedUnit.UNIT;
                } else {
                    DefaultJDBCWrapper.DataBaseOperations qual$3 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                    String x$8 = table2.name();
                    boolean x$9 = qual$3.dropTable$default$2();
                    object = BoxesRunTime.boxToBoolean((boolean)qual$3.dropTable(x$8, x$9));
                }
            } else {
                object = BoxedUnit.UNIT;
            }
            SaveMode saveMode6 = saveMode;
            SaveMode saveMode7 = SaveMode.Overwrite;
            if (!(saveMode6 == null ? saveMode7 != null : !saveMode6.equals(saveMode7)) || !DefaultJDBCWrapper$.MODULE$.tableExists(conn, table2.toString())) {
                DefaultJDBCWrapper.DataBaseOperations qual$4 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                String x$10 = targetTable.name();
                StructType x$11 = schema2;
                Parameters.MergedParameters x$12 = params;
                boolean x$13 = false;
                boolean x$14 = false;
                boolean x$15 = qual$4.createTable$default$6();
                qual$4.createTable(x$10, x$11, x$12, x$13, x$14, x$15);
            }
            Utils$.MODULE$.executePreActions(DefaultJDBCWrapper$.MODULE$, conn, params, (Option<TableName>)Option$.MODULE$.apply((Object)targetTable));
            SnowflakeSQLStatement copyStatement = this.copySql(schema2, saveMode, params, targetTable, file, tempStage, format, conn);
            this.net$snowflake$spark$snowflake$io$StageWriter$$log().debug(Utils$.MODULE$.sanitizeQueryText(copyStatement.toString()));
            ResultSet resultSet = copyStatement.execute(params.bindVariableEnabled(), conn);
            if (params.continueOnError()) {
                long rowSkipped = 0L;
                while (resultSet.next()) {
                    rowSkipped += resultSet.getLong("rows_parsed") - resultSet.getLong("rows_loaded");
                }
                this.net$snowflake$spark$snowflake$io$StageWriter$$log().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ON_ERROR: Continue -> Skipped ", " rows"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)rowSkipped)})));
            }
            Utils$.MODULE$.setLastCopyLoad(copyStatement.toString());
            Utils$.MODULE$.executePostActions(DefaultJDBCWrapper$.MODULE$, conn, params, (Option<TableName>)Option$.MODULE$.apply((Object)targetTable));
            SaveMode saveMode8 = saveMode;
            SaveMode saveMode9 = SaveMode.Overwrite;
            if (!(saveMode8 != null ? !saveMode8.equals(saveMode9) : saveMode9 != null) && params.useStagingTable()) {
                boolean x$17;
                String x$16;
                DefaultJDBCWrapper.DataBaseOperations qual$5 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                if (qual$5.tableExists(x$16 = table2.toString(), x$17 = qual$5.tableExists$default$2())) {
                    DefaultJDBCWrapper.DataBaseOperations qual$6 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                    String x$18 = table2.name();
                    String x$19 = tempTable.name();
                    boolean x$20 = qual$6.swapTable$default$3();
                    qual$6.swapTable(x$18, x$19, x$20);
                    DefaultJDBCWrapper.DataBaseOperations qual$7 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                    String x$21 = tempTable.name();
                    boolean x$22 = qual$7.dropTable$default$2();
                    qual$7.dropTable(x$21, x$22);
                } else {
                    DefaultJDBCWrapper.DataBaseOperations qual$8 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                    String x$23 = table2.name();
                    String x$24 = tempTable.name();
                    boolean x$25 = qual$8.renameTable$default$3();
                    qual$8.renameTable(x$23, x$24, x$25);
                }
            } else {
                conn.commit();
            }
            return;
        }
        catch (Exception exception) {
            Object object;
            SaveMode saveMode10 = saveMode;
            SaveMode saveMode11 = SaveMode.Overwrite;
            if (!(saveMode10 != null ? !saveMode10.equals(saveMode11) : saveMode11 != null) && params.useStagingTable()) {
                TableName tableName = targetTable;
                TableName tableName2 = tempTable;
                if (!(tableName != null ? !((Object)tableName).equals(tableName2) : tableName2 != null)) {
                    DefaultJDBCWrapper.DataBaseOperations qual$9 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                    String x$26 = tempTable.name();
                    boolean x$27 = qual$9.dropTable$default$2();
                    object = BoxesRunTime.boxToBoolean((boolean)qual$9.dropTable(x$26, x$27));
                } else {
                    object = BoxedUnit.UNIT;
                }
            } else {
                object = BoxedUnit.UNIT;
            }
            this.net$snowflake$spark$snowflake$io$StageWriter$$log().error(new StringBuilder().append((Object)"Error occurred while loading files to Snowflake: ").append((Object)exception).toString());
            throw exception;
        }
    }

    private SnowflakeSQLStatement copySql(StructType schema2, SaveMode saveMode, Parameters.MergedParameters params, TableName table2, String file, String tempStage, Enumeration.Value format, Connection conn) {
        Option<Map<String, String>> option;
        block6: {
            Enumeration.Value value;
            block9: {
                SnowflakeSQLStatement snowflakeSQLStatement;
                SnowflakeSQLStatement mappingFromString;
                SnowflakeSQLStatement mappingToString;
                block8: {
                    block7: {
                        None$ none$;
                        SnowflakeSQLStatement fromString;
                        block5: {
                            block4: {
                                SaveMode saveMode2 = saveMode;
                                SaveMode saveMode3 = SaveMode.Append;
                                if ((saveMode2 == null ? saveMode3 != null : !saveMode2.equals(saveMode3)) && params.columnMap().isDefined()) {
                                    throw new UnsupportedOperationException("The column mapping only works in append mode.");
                                }
                                fromString = new ConstantString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FROM @", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tempStage, file}))).$bang();
                                option = params.columnMap();
                                if (!(option instanceof Some)) break block4;
                                Some some = (Some)option;
                                Map map = (Map)some.x();
                                none$ = new Some(map.toList().map((Function1)new Serializable(schema2){
                                    public static final long serialVersionUID = 0L;
                                    private final StructType schema$1;

                                    /*
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final Tuple2<Object, String> apply(Tuple2<String, String> x0$1) {
                                        Tuple2<String, String> tuple2 = x0$1;
                                        if (tuple2 == null) throw new MatchError(tuple2);
                                        String key = (String)tuple2._1();
                                        String value = (String)tuple2._2();
                                        try {
                                            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)(this.schema$1.fieldIndex(key) + 1)), (Object)value);
                                        }
                                        catch (Exception exception) {
                                            StageWriter$.MODULE$.net$snowflake$spark$snowflake$io$StageWriter$$log().error(new StringBuilder().append((Object)"Error occurred while column mapping: ").append((Object)exception).toString());
                                            throw exception;
                                        }
                                    }
                                    {
                                        this.schema$1 = schema$1;
                                    }
                                }, List$.MODULE$.canBuildFrom()));
                                break block5;
                            }
                            if (!None$.MODULE$.equals(option)) break block6;
                            none$ = None$.MODULE$;
                        }
                        None$ mappingList = none$;
                        mappingToString = this.getMappingToString$1((Option)mappingList, params, table2, format, conn);
                        mappingFromString = this.getMappingFromString$1((Option)mappingList, fromString, schema2, format);
                        value = format;
                        Enumeration.Value value2 = SupportedFormat$.MODULE$.CSV();
                        Enumeration.Value value3 = value;
                        if (value2 != null ? !value2.equals(value3) : value3 != null) break block7;
                        snowflakeSQLStatement = new ConstantString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |FILE_FORMAT = (\n               |    TYPE=CSV\n               |    FIELD_DELIMITER='|'\n               |    NULL_IF=()\n               |    FIELD_OPTIONALLY_ENCLOSED_BY='\"'\n               |    TIMESTAMP_FORMAT='TZHTZM YYYY-MM-DD HH24:MI:SS.FF3'\n               |    DATE_FORMAT='TZHTZM YYYY-MM-DD HH24:MI:SS.FF3'\n               |  )\n           "})).s((Seq)Nil$.MODULE$))).stripMargin()).$bang();
                        break block8;
                    }
                    Enumeration.Value value4 = SupportedFormat$.MODULE$.JSON();
                    Enumeration.Value value5 = value;
                    if (value4 != null ? !value4.equals(value5) : value5 != null) break block9;
                    snowflakeSQLStatement = new ConstantString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |FILE_FORMAT = (\n               |    TYPE = JSON\n               |)\n           "})).s((Seq)Nil$.MODULE$))).stripMargin()).$bang();
                }
                SnowflakeSQLStatement formatString = snowflakeSQLStatement;
                SnowflakeSQLStatement truncateCol = params.truncateColumns() ? new ConstantString("TRUNCATECOLUMNS = TRUE").$bang() : EmptySnowflakeSQLStatement$.MODULE$.apply();
                SnowflakeSQLStatement purge2 = params.purge() ? new ConstantString("PURGE = TRUE").$bang() : EmptySnowflakeSQLStatement$.MODULE$.apply();
                SnowflakeSQLStatement onError = params.continueOnError() ? new ConstantString("ON_ERROR = CONTINUE").$bang() : EmptySnowflakeSQLStatement$.MODULE$.apply();
                return new ConstantString("copy into").$plus(table2.name()).$plus(mappingToString).$plus(mappingFromString).$plus(formatString).$plus(truncateCol).$plus(purge2).$plus(onError);
            }
            throw new MatchError((Object)value);
        }
        throw new MatchError(option);
    }

    private final SnowflakeSQLStatement getMappingToString$1(Option list, Parameters.MergedParameters params$1, TableName table$1, Enumeration.Value format$1, Connection conn$1) {
        Enumeration.Value value;
        block4: {
            SnowflakeSQLStatement snowflakeSQLStatement;
            block3: {
                block2: {
                    value = format$1;
                    Enumeration.Value value2 = SupportedFormat$.MODULE$.JSON();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                    StructType tableSchema = DefaultJDBCWrapper$.MODULE$.resolveTable(conn$1, table$1.name(), params$1);
                    snowflakeSQLStatement = list.isEmpty() || ((SeqLike)list.get()).isEmpty() ? new ConstantString("(").$plus(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])tableSchema.fields()).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(StructField x$2) {
                            return x$2.name();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(",")).$plus(")") : new ConstantString("(").$plus(((TraversableOnce)((List)list.get()).map((Function1)new Serializable(params$1){
                        public static final long serialVersionUID = 0L;
                        private final Parameters.MergedParameters params$1;

                        public final String apply(Tuple2<Object, String> x) {
                            return this.params$1.keepOriginalColumnNameCase() ? Utils$.MODULE$.quotedNameIgnoreCase((String)x._2()) : Utils$.MODULE$.ensureQuoted((String)x._2());
                        }
                        {
                            this.params$1 = params$1;
                        }
                    }, List$.MODULE$.canBuildFrom())).mkString(", ")).$plus(")");
                    break block3;
                }
                Enumeration.Value value4 = SupportedFormat$.MODULE$.CSV();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                snowflakeSQLStatement = list.isEmpty() || ((SeqLike)list.get()).isEmpty() ? EmptySnowflakeSQLStatement$.MODULE$.apply() : new ConstantString("(").$plus(((TraversableOnce)((List)list.get()).map((Function1)new Serializable(params$1){
                    public static final long serialVersionUID = 0L;
                    private final Parameters.MergedParameters params$1;

                    public final String apply(Tuple2<Object, String> x) {
                        return this.params$1.keepOriginalColumnNameCase() ? Utils$.MODULE$.quotedNameIgnoreCase((String)x._2()) : Utils$.MODULE$.ensureQuoted((String)x._2());
                    }
                    {
                        this.params$1 = params$1;
                    }
                }, List$.MODULE$.canBuildFrom())).mkString(", ")).$plus(")");
            }
            return snowflakeSQLStatement;
        }
        throw new MatchError((Object)value);
    }

    private final SnowflakeSQLStatement getMappingFromString$1(Option list, SnowflakeSQLStatement from, StructType schema$1, Enumeration.Value format$1) {
        Enumeration.Value value;
        block7: {
            SnowflakeSQLStatement snowflakeSQLStatement;
            block6: {
                block5: {
                    SnowflakeSQLStatement snowflakeSQLStatement2;
                    value = format$1;
                    Enumeration.Value value2 = SupportedFormat$.MODULE$.JSON();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block5;
                    if (list.isEmpty() || ((SeqLike)list.get()).isEmpty()) {
                        String names = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])schema$1.fields()).map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply(StructField x) {
                                return "parse_json($1):".concat(x.name());
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(",");
                        snowflakeSQLStatement2 = new ConstantString("from (select").$plus(names).$plus(from).$plus("tmp)");
                    } else {
                        snowflakeSQLStatement2 = new ConstantString("from (select").$plus(((TraversableOnce)((List)list.get()).map((Function1)new Serializable(schema$1){
                            public static final long serialVersionUID = 0L;
                            private final StructType schema$1;

                            public final String apply(Tuple2<Object, String> x) {
                                return "parse_json($1):".concat(this.schema$1.apply(x._1$mcI$sp() - 1).name());
                            }
                            {
                                this.schema$1 = schema$1;
                            }
                        }, List$.MODULE$.canBuildFrom())).mkString(", ")).$plus(from).$plus("tmp)");
                    }
                    snowflakeSQLStatement = snowflakeSQLStatement2;
                    break block6;
                }
                Enumeration.Value value4 = SupportedFormat$.MODULE$.CSV();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block7;
                snowflakeSQLStatement = list.isEmpty() || ((SeqLike)list.get()).isEmpty() ? from : new ConstantString("from (select").$plus(((TraversableOnce)((List)list.get()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<Object, String> x) {
                        return "tmp.$".concat(((Object)BoxesRunTime.boxToInteger((int)x._1$mcI$sp())).toString());
                    }
                }, List$.MODULE$.canBuildFrom())).mkString(", ")).$plus(from).$plus("tmp)");
            }
            return snowflakeSQLStatement;
        }
        throw new MatchError((Object)value);
    }

    private StageWriter$() {
        MODULE$ = this;
        this.net$snowflake$spark$snowflake$io$StageWriter$$log = LoggerFactory.getLogger(this.getClass());
    }
}

