/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake;

import java.net.URI;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSSessionCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.BasicAWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.InstanceProfileCredentialsProvider;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageCredentialsSharedAccessSignature;
import net.snowflake.spark.snowflake.ConstantString;
import net.snowflake.spark.snowflake.EmptySnowflakeSQLStatement$;
import net.snowflake.spark.snowflake.FSType$;
import net.snowflake.spark.snowflake.Parameters;
import net.snowflake.spark.snowflake.SnowflakeSQLStatement;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.sql.SQLContext;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;

public final class CloudCredentialsUtils$ {
    public static final CloudCredentialsUtils$ MODULE$;

    static {
        new CloudCredentialsUtils$();
    }

    public SnowflakeSQLStatement getSnowflakeCredentialsString(SQLContext sqlContext, Parameters.MergedParameters params) {
        SnowflakeSQLStatement snowflakeSQLStatement;
        Enumeration.Value value = params.rootTempDirStorageType();
        Enumeration.Value value2 = FSType$.MODULE$.LocalFile();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            throw new UnsupportedOperationException("only supports Azure and S3 stage");
        }
        Enumeration.Value value4 = FSType$.MODULE$.Azure();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            StorageCredentialsSharedAccessSignature creds = this.getAzureCreds(params);
            snowflakeSQLStatement = this.getSnowflakeCredentialsStringForAzure(creds);
        } else {
            Enumeration.Value value6 = FSType$.MODULE$.S3();
            Enumeration.Value value7 = value;
            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                AWSCredentials creds = this.getAWSCreds(sqlContext, params);
                snowflakeSQLStatement = this.getSnowflakeCredentialsStringForAWS(creds);
            } else {
                snowflakeSQLStatement = EmptySnowflakeSQLStatement$.MODULE$.apply();
            }
        }
        return snowflakeSQLStatement;
    }

    public SnowflakeSQLStatement getSnowflakeCredentialsStringForAWS(AWSCredentials creds) {
        String string;
        String awsAccessKey = creds.getAWSAccessKeyId();
        String awsSecretKey = creds.getAWSSecretKey();
        AWSCredentials aWSCredentials = creds;
        if (aWSCredentials instanceof AWSSessionCredentials) {
            AWSSessionCredentials aWSSessionCredentials = (AWSSessionCredentials)aWSCredentials;
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AWS_TOKEN='", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{aWSSessionCredentials.getSessionToken()}));
        } else {
            string = "";
        }
        String tokenString = string;
        return new ConstantString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |CREDENTIALS = (\n       |    AWS_KEY_ID='", "'\n       |    AWS_SECRET_KEY='", "'\n       |    ", "\n       |)\n       |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{awsAccessKey, awsSecretKey, tokenString})))).stripMargin().trim()).$bang();
    }

    public SnowflakeSQLStatement getSnowflakeCredentialsStringForAzure(StorageCredentialsSharedAccessSignature creds) {
        String sasToken = creds.getToken();
        return new ConstantString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |CREDENTIALS = (\n       |    AZURE_SAS_TOKEN='", "'\n       |)\n       |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sasToken})))).stripMargin().trim()).$bang();
    }

    public AWSCredentials getAWSCreds(SQLContext sqlContext, Parameters.MergedParameters params) {
        Enumeration.Value value = params.rootTempDirStorageType();
        Enumeration.Value value2 = FSType$.MODULE$.S3();
        return !(value != null ? !value.equals(value2) : value2 != null) ? (AWSCredentials)params.temporaryAWSCredentials().getOrElse((Function0)new Serializable(sqlContext, params){
            public static final long serialVersionUID = 0L;
            private final SQLContext sqlContext$1;
            private final Parameters.MergedParameters params$1;

            public final AWSCredentials apply() {
                return CloudCredentialsUtils$.MODULE$.load(this.params$1.rootTempDir(), this.sqlContext$1.sparkContext().hadoopConfiguration());
            }
            {
                this.sqlContext$1 = sqlContext$1;
                this.params$1 = params$1;
            }
        }) : null;
    }

    public StorageCredentialsSharedAccessSignature getAzureCreds(Parameters.MergedParameters params) {
        Enumeration.Value value = params.rootTempDirStorageType();
        Enumeration.Value value2 = FSType$.MODULE$.Azure();
        return !(value != null ? !value.equals(value2) : value2 != null) ? (StorageCredentialsSharedAccessSignature)params.temporaryAzureStorageCredentials().orNull(Predef$.MODULE$.$conforms()) : null;
    }

    private Tuple2<String, String> getS3Credentials(URI uri, Configuration conf) {
        if (uri.getHost() == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid hostname in URI ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri})));
        }
        String accessKey = null;
        String secretAccessKey = null;
        String userInfo = uri.getUserInfo();
        if (userInfo != null) {
            int index = userInfo.indexOf(58);
            if (index != -1) {
                accessKey = userInfo.substring(0, index);
                secretAccessKey = userInfo.substring(index + 1);
            } else {
                accessKey = userInfo;
            }
        }
        String scheme = uri.getScheme();
        String accessKeyProperty = String.format("fs.%s.awsAccessKeyId", scheme);
        String secretAccessKeyProperty = String.format("fs.%s.awsSecretAccessKey", scheme);
        if (accessKey == null) {
            accessKey = conf.get(accessKeyProperty);
        }
        if (secretAccessKey == null) {
            secretAccessKey = conf.get(secretAccessKeyProperty);
        }
        if (accessKey == null && secretAccessKey == null) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"AWS Access Key ID and Secret Access Key must be specified as the username or password (respectively) of a ").append((Object)scheme).append((Object)" URL, or by setting the ").append((Object)accessKeyProperty).append((Object)" or ").append((Object)secretAccessKeyProperty).append((Object)" properties (respectively).").toString());
        }
        if (accessKey == null) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"AWS Access Key ID must be specified as the username of a ").append((Object)scheme).append((Object)" URL, or by setting the ").append((Object)accessKeyProperty).append((Object)" property.").toString());
        }
        if (secretAccessKey == null) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"AWS Secret Access Key must be specified as the password of a ").append((Object)scheme).append((Object)" URL, or by setting the ").append((Object)secretAccessKeyProperty).append((Object)" property.").toString());
        }
        return new Tuple2((Object)accessKey, (Object)secretAccessKey);
    }

    public AWSCredentials load(String tempPath, Configuration hadoopConfiguration) {
        String string;
        block6: {
            AWSCredentials aWSCredentials;
            block4: {
                block5: {
                    URI uri;
                    block2: {
                        Tuple2<String, String> tuple2;
                        block3: {
                            Tuple2 tuple22;
                            uri = new URI(tempPath);
                            string = uri.getScheme();
                            boolean bl = "s3".equals(string) ? true : "s3n".equals(string);
                            if (!bl) break block2;
                            tuple2 = this.getS3Credentials(uri, hadoopConfiguration);
                            if (tuple2 == null) break block3;
                            String accessKey = (String)tuple2._1();
                            String secretAccessKey = (String)tuple2._2();
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)accessKey, (Object)secretAccessKey);
                            String accessKey2 = (String)tuple23._1();
                            String secretAccessKey2 = (String)tuple23._2();
                            aWSCredentials = new BasicAWSCredentials(accessKey2, secretAccessKey2);
                            break block4;
                        }
                        throw new MatchError(tuple2);
                    }
                    if (!"s3a".equals(string)) break block5;
                    aWSCredentials = (AWSCredentials)Option$.MODULE$.apply((Object)uri.getUserInfo()).flatMap((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Option<BasicAWSCredentials> apply(String userInfo) {
                            None$ none$;
                            if (userInfo.contains(":")) {
                                Tuple2 tuple2;
                                String[] stringArray = userInfo.split(":");
                                Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                                if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) throw new MatchError((Object)stringArray);
                                String accessKey = (String)((SeqLike)option.get()).apply(0);
                                String secretKey = (String)((SeqLike)option.get()).apply(1);
                                Tuple2 tuple22 = tuple2 = new Tuple2((Object)accessKey, (Object)secretKey);
                                String accessKey2 = (String)tuple22._1();
                                String secretKey2 = (String)tuple22._2();
                                none$ = new Some((Object)new BasicAWSCredentials(accessKey2, secretKey2));
                                return none$;
                            } else {
                                none$ = None$.MODULE$;
                            }
                            return none$;
                        }
                    }).orElse((Function0)new Serializable(hadoopConfiguration){
                        public static final long serialVersionUID = 0L;
                        private final Configuration hadoopConfiguration$1;

                        public final Option<BasicAWSCredentials> apply() {
                            String accessKey = this.hadoopConfiguration$1.get("fs.s3a.access.key", null);
                            String secretKey = this.hadoopConfiguration$1.get("fs.s3a.secret.key", null);
                            return accessKey == null || secretKey == null ? None$.MODULE$ : new Some((Object)new BasicAWSCredentials(accessKey, secretKey));
                        }
                        {
                            this.hadoopConfiguration$1 = hadoopConfiguration$1;
                        }
                    }).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final AWSCredentials apply() {
                            return new InstanceProfileCredentialsProvider().getCredentials();
                        }
                    });
                    break block4;
                }
                if (!"file".equals(string)) break block6;
                aWSCredentials = null;
            }
            return aWSCredentials;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unrecognized scheme ", "; expected s3, s3n, or s3a"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
    }

    private CloudCredentialsUtils$() {
        MODULE$ = this;
    }
}

