/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake;

import java.sql.Connection;
import java.sql.Statement;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.spark.snowflake.RunningQuery;
import net.snowflake.spark.snowflake.SnowflakeTelemetry$;
import net.snowflake.spark.snowflake.SparkConnectorContext$;
import org.apache.spark.SparkContext;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class SparkConnectorContext$ {
    public static final SparkConnectorContext$ MODULE$;
    private final Map<String, Set<RunningQuery>> net$snowflake$spark$snowflake$SparkConnectorContext$$runningQueries;
    private final Logger logger;
    private boolean net$snowflake$spark$snowflake$SparkConnectorContext$$isConfigLogged;
    private final Object locker;

    static {
        new SparkConnectorContext$();
    }

    public Map<String, Set<RunningQuery>> net$snowflake$spark$snowflake$SparkConnectorContext$$runningQueries() {
        return this.net$snowflake$spark$snowflake$SparkConnectorContext$$runningQueries;
    }

    public Map<String, Set<RunningQuery>> getRunningQueries() {
        return this.net$snowflake$spark$snowflake$SparkConnectorContext$$runningQueries();
    }

    public void registerSparkListenerIfNotYet(SparkContext sparkContext) {
        this.withSyncAndDoNotThrowException((Function0<BoxedUnit>)new Serializable(sparkContext){
            public static final long serialVersionUID = 0L;
            private final SparkContext sparkContext$3;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String appId = this.sparkContext$3.applicationId();
                if (!SparkConnectorContext$.MODULE$.net$snowflake$spark$snowflake$SparkConnectorContext$$runningQueries().keySet().contains((Object)appId)) {
                    SparkConnectorContext$.MODULE$.logger().info(new StringBuilder().append((Object)"Spark connector register listener for: ").append((Object)appId).toString());
                    SparkConnectorContext$.MODULE$.net$snowflake$spark$snowflake$SparkConnectorContext$$runningQueries().put((Object)appId, (Object)Set$.MODULE$.empty());
                    this.sparkContext$3.addSparkListener((SparkListenerInterface)new SparkListener(this, appId){
                        private final String appId$1;

                        public void onApplicationEnd(SparkListenerApplicationEnd applicationEnd) {
                            try {
                                SparkConnectorContext$.MODULE$.cancelRunningQueries(this.appId$1);
                                return;
                            }
                            finally {
                                super.onApplicationEnd(applicationEnd);
                            }
                        }
                        {
                            this.appId$1 = appId$1;
                        }
                    });
                }
            }
            {
                this.sparkContext$3 = sparkContext$3;
            }
        });
    }

    public void cancelRunningQueries(String appId) {
        this.withSyncAndDoNotThrowException((Function0<BoxedUnit>)new Serializable(appId){
            public static final long serialVersionUID = 0L;
            private final String appId$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Option queries = SparkConnectorContext$.MODULE$.net$snowflake$spark$snowflake$SparkConnectorContext$$runningQueries().get((Object)this.appId$2);
                if (queries.nonEmpty()) {
                    ((IterableLike)queries.get()).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(RunningQuery rq) {
                            try {
                                if (!rq.conn().isClosed()) {
                                    Statement statement = rq.conn().createStatement();
                                    String sessionID = ((SnowflakeConnectionV1)rq.conn()).getSessionID();
                                    SparkConnectorContext$.MODULE$.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Canceling query ", " for session: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rq.queryID(), sessionID})));
                                    statement.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select SYSTEM$CANCEL_QUERY('", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rq.queryID()})));
                                    statement.close();
                                }
                            }
                            catch (Throwable throwable) {
                                SparkConnectorContext$.MODULE$.logger().warn("Fail to cancel running queries: ", throwable);
                            }
                        }
                    });
                    SparkConnectorContext$.MODULE$.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finish cancelling all queries for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.appId$2})));
                    SparkConnectorContext$.MODULE$.net$snowflake$spark$snowflake$SparkConnectorContext$$runningQueries().remove((Object)this.appId$2);
                } else {
                    SparkConnectorContext$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No running query for: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.appId$2})));
                }
            }
            {
                this.appId$2 = appId$2;
            }
        });
    }

    public void addRunningQuery(SparkContext sparkContext, Connection conn, String queryID) {
        this.withSyncAndDoNotThrowException((Function0<BoxedUnit>)new Serializable(sparkContext, conn, queryID){
            public static final long serialVersionUID = 0L;
            private final SparkContext sparkContext$1;
            public final Connection conn$1;
            public final String queryID$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkConnectorContext$.MODULE$.registerSparkListenerIfNotYet(this.sparkContext$1);
                String appId = this.sparkContext$1.applicationId();
                String sessionID = ((SnowflakeConnectionV1)this.conn$1).getSessionID();
                SparkConnectorContext$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Add running query for ", " session: ", " queryId: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{appId, sessionID, this.queryID$1})));
                Option queries = SparkConnectorContext$.MODULE$.net$snowflake$spark$snowflake$SparkConnectorContext$$runningQueries().get((Object)appId);
                queries.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.addRunningQuery.1 $outer;

                    public final boolean apply(Set<RunningQuery> x$1) {
                        return x$1.add((Object)new RunningQuery(this.$outer.conn$1, this.$outer.queryID$1));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.sparkContext$1 = sparkContext$1;
                this.conn$1 = conn$1;
                this.queryID$1 = queryID$1;
            }
        });
    }

    public void removeRunningQuery(SparkContext sparkContext, Connection conn, String queryID) {
        this.withSyncAndDoNotThrowException((Function0<BoxedUnit>)new Serializable(sparkContext, conn, queryID){
            public static final long serialVersionUID = 0L;
            private final SparkContext sparkContext$2;
            public final Connection conn$2;
            public final String queryID$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String appId = this.sparkContext$2.applicationId();
                String sessionID = ((SnowflakeConnectionV1)this.conn$2).getSessionID();
                SparkConnectorContext$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Remove running query for ", " session: ", " queryId: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{appId, sessionID, this.queryID$2})));
                Option queries = SparkConnectorContext$.MODULE$.net$snowflake$spark$snowflake$SparkConnectorContext$$runningQueries().get((Object)appId);
                queries.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.removeRunningQuery.1 $outer;

                    public final boolean apply(Set<RunningQuery> x$2) {
                        return x$2.remove((Object)new RunningQuery(this.$outer.conn$2, this.$outer.queryID$2));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.sparkContext$2 = sparkContext$2;
                this.conn$2 = conn$2;
                this.queryID$2 = queryID$2;
            }
        });
    }

    public Logger logger() {
        return this.logger;
    }

    public boolean net$snowflake$spark$snowflake$SparkConnectorContext$$isConfigLogged() {
        return this.net$snowflake$spark$snowflake$SparkConnectorContext$$isConfigLogged;
    }

    public void net$snowflake$spark$snowflake$SparkConnectorContext$$isConfigLogged_$eq(boolean x$1) {
        this.net$snowflake$spark$snowflake$SparkConnectorContext$$isConfigLogged = x$1;
    }

    private Object locker() {
        return this.locker;
    }

    public void recordConfig() {
        this.withSyncAndDoNotThrowException((Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                if (!SparkConnectorContext$.MODULE$.net$snowflake$spark$snowflake$SparkConnectorContext$$isConfigLogged()) {
                    SparkConnectorContext$.MODULE$.net$snowflake$spark$snowflake$SparkConnectorContext$$isConfigLogged_$eq(true);
                    SparkConnectorContext$.MODULE$.logger().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Spark Connector system config: "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SnowflakeTelemetry$.MODULE$.getClientConfig().toPrettyString()}))).toString());
                }
            }
        });
    }

    private void withSyncAndDoNotThrowException(Function0<BoxedUnit> block) {
        try {
            Object object = this.locker();
            synchronized (object) {
                block.apply$mcV$sp();
            }
        }
        catch (Throwable throwable) {
            this.logger().warn(new StringBuilder().append((Object)"Hit un-caught exception: ").append((Object)throwable.getMessage()).toString());
        }
    }

    private SparkConnectorContext$() {
        MODULE$ = this;
        this.net$snowflake$spark$snowflake$SparkConnectorContext$$runningQueries = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.net$snowflake$spark$snowflake$SparkConnectorContext$$isConfigLogged = false;
        this.locker = new Object();
    }
}

