/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeFileTransferConfig;
import net.snowflake.client.jdbc.SnowflakeFileTransferMetadata;
import net.snowflake.spark.snowflake.Parameters$;
import net.snowflake.spark.snowflake.ProxyInfo;
import net.snowflake.spark.snowflake.SnowflakeConnectorException;
import net.snowflake.spark.snowflake.SnowflakeTelemetry$;
import net.snowflake.spark.snowflake.SparkConnectorContext$;
import net.snowflake.spark.snowflake.TelemetryConstValues$;
import net.snowflake.spark.snowflake.Utils$;
import net.snowflake.spark.snowflake.io.CloudStorage;
import net.snowflake.spark.snowflake.io.CloudStorageOperations$;
import net.snowflake.spark.snowflake.io.FileUploadResult;
import net.snowflake.spark.snowflake.io.SingleElementIterator;
import net.snowflake.spark.snowflake.io.SnowflakeResultSetRDD$;
import net.snowflake.spark.snowflake.io.SupportedFormat$;
import net.snowflake.spark.snowflake.test.TestHook$;
import net.snowflake.spark.snowflake.test.TestHookFlag$;
import org.apache.spark.TaskContext$;
import org.apache.spark.rdd.RDD;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;

public abstract class CloudStorage$class {
    /*
     * WARNING - void declaration
     */
    public static int retrySleepTimeInMS(CloudStorage $this, int retry) {
        void var2_2;
        int expectedTime = $this.RETRY_SLEEP_TIME_UNIT_IN_MS() * (int)Math.pow(2.0, retry);
        expectedTime = Math.min(expectedTime, $this.MAX_SLEEP_TIME_IN_MS());
        expectedTime = expectedTime / 2 + Random$.MODULE$.nextInt(expectedTime / 2);
        return (int)var2_2;
    }

    public static String getFileName(CloudStorage $this, int fileIndex, Enumeration.Value format, boolean compress) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)fileIndex), format.toString(), compress ? ".gz" : ""}));
    }

    public static Tuple2 getStageInfo(CloudStorage $this, boolean isWrite, String fileName) {
        return new Tuple2((Object)new HashMap(), (Object)Nil$.MODULE$);
    }

    public static String getStageInfo$default$2(CloudStorage $this) {
        return "";
    }

    public static OutputStream upload(CloudStorage $this, String fileName, Option dir, boolean compress) {
        return $this.createUploadStream(fileName, (Option<String>)dir, compress, (Map<String, String>)((Map)$this.getStageInfo(true, $this.getStageInfo$default$2())._1()));
    }

    public static List upload(CloudStorage $this, RDD data, Enumeration.Value format, Option dir, boolean compress) {
        return $this.uploadRDD((RDD<String>)data, format, (Option<String>)dir, compress, (Map<String, String>)((Map)$this.getStageInfo(true, $this.getStageInfo$default$2())._1()));
    }

    public static Enumeration.Value upload$default$2(CloudStorage $this) {
        return SupportedFormat$.MODULE$.CSV();
    }

    public static boolean upload$default$4(CloudStorage $this) {
        return true;
    }

    public static void checkUploadMetadata(CloudStorage $this, Option storageInfo, Option fileTransferMetadata) {
        if (storageInfo.isEmpty() && fileTransferMetadata.isEmpty() || storageInfo.isDefined() && fileTransferMetadata.isDefined()) {
            String errorMessage = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hit internal error: Either storageInfo or fileTransferMetadata\n           | must be set. storageInfo=", "\n           | fileTransferMetadata=", "\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)storageInfo.isDefined()), BoxesRunTime.boxToBoolean((boolean)fileTransferMetadata.isDefined())})))).stripMargin();
            CloudStorageOperations$.MODULE$.log().info((String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", "\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SnowflakeResultSetRDD$.MODULE$.WORKER_LOG_PREFIX(), errorMessage})))).stripMargin())).filter((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(char x$5) {
                    return x$5 >= ' ';
                }
            }));
            throw new SnowflakeConnectorException(errorMessage);
        }
    }

    public static SingleElementIterator uploadPartition(CloudStorage $this, Iterator rows, Enumeration.Value format, boolean compress, String directory, int partitionID, Option storageInfo, Option fileTransferMetadata) {
        String fileName = $this.getFileName(partitionID, format, compress);
        $this.checkUploadMetadata((Option<Map<String, String>>)storageInfo, (Option<SnowflakeFileTransferMetadata>)fileTransferMetadata);
        try {
            return CloudStorage$class.doUploadPartition($this, rows, format, compress, directory, partitionID, storageInfo, fileTransferMetadata);
        }
        catch (Throwable throwable) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            String errmsg = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", ", ",\n             | stacktrace: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{throwable.getClass().toString(), throwable.getMessage(), stringWriter.toString()})))).stripMargin();
            int attemptNumber = TaskContext$.MODULE$.get().attemptNumber();
            SnowflakeTelemetry$.MODULE$.sendTelemetryOOB($this.sfURL(), $this.getClass().getSimpleName(), TelemetryConstValues$.MODULE$.OPERATION_WRITE(), attemptNumber, $this.maxRetryCount(), false, $this.proxyInfo().isDefined(), (Option<String>)None$.MODULE$, (Option<Throwable>)new Some((Object)throwable));
            if ($this.useExponentialBackoff()) {
                int sleepTime = $this.retrySleepTimeInMS(attemptNumber + 1);
                CloudStorageOperations$.MODULE$.log().info((String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": hit upload error:\n               | partition ID:", " ", "\n               | attemptNumber=", "\n               | backoffTime=", "\n               | error details: [ ", " ]\n               |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SnowflakeResultSetRDD$.MODULE$.WORKER_LOG_PREFIX(), BoxesRunTime.boxToInteger((int)partitionID), fileName, BoxesRunTime.boxToInteger((int)attemptNumber), Utils$.MODULE$.getTimeString(sleepTime), errmsg})))).stripMargin())).filter((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(char x$6) {
                        return x$6 >= ' ';
                    }
                }));
                Thread.sleep(sleepTime);
            } else {
                CloudStorageOperations$.MODULE$.log().warn((String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": hit upload error:\n               | partition ID:", " ", "\n               | attemptNumber=", "\n               | Skip exponential backoff sleep because\n               | ", " is 'off'.\n               | Please enable it if necessary, for example, cloud service\n               | throttling issues happen.\n               |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SnowflakeResultSetRDD$.MODULE$.WORKER_LOG_PREFIX(), BoxesRunTime.boxToInteger((int)partitionID), fileName, BoxesRunTime.boxToInteger((int)attemptNumber), Parameters$.MODULE$.PARAM_USE_EXPONENTIAL_BACKOFF()})))).stripMargin())).filter((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(char x$7) {
                        return x$7 >= ' ';
                    }
                }));
            }
            throw throwable;
        }
    }

    private static SingleElementIterator doUploadPartition(CloudStorage $this, Iterator rows, Enumeration.Value format, boolean compress, String directory, int partitionID, Option storageInfo, Option fileTransferMetadata) {
        String fileName = $this.getFileName(partitionID, format, compress);
        CloudStorageOperations$.MODULE$.log().info((String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":\n         | Start writing partition ID:", " as ", "\n         | TaskInfo: ", "\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SnowflakeResultSetRDD$.MODULE$.WORKER_LOG_PREFIX(), BoxesRunTime.boxToInteger((int)partitionID), fileName, SnowflakeTelemetry$.MODULE$.getTaskInfo().toPrettyString()})))).stripMargin())).filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char x$8) {
                return x$8 >= ' ';
            }
        }));
        long rowCount = 0L;
        long dataSize = 0L;
        String processTimeInfo = "";
        long startTime = System.currentTimeMillis();
        if (storageInfo.isDefined()) {
            None$ uploadStream = None$.MODULE$;
            while (rows.hasNext()) {
                if (uploadStream.isEmpty()) {
                    uploadStream = new Some((Object)$this.createUploadStream(fileName, (Option<String>)new Some((Object)directory), compress, (Map<String, String>)((Map)storageInfo.get())));
                }
                byte[] oneRow = ((String)rows.next()).getBytes("UTF-8");
                ((OutputStream)uploadStream.get()).write(oneRow);
                ((OutputStream)uploadStream.get()).write(10);
                ++rowCount;
                dataSize += (long)(Predef$.MODULE$.byteArrayOps(oneRow).size() + 1);
            }
            if (uploadStream.isDefined()) {
                ((OutputStream)uploadStream.get()).close();
            }
            long endTime = System.currentTimeMillis();
            processTimeInfo = (String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"read_and_upload_time:\n           | ", "\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.getTimeString(endTime - startTime)})))).stripMargin())).filter((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(char x$9) {
                    return x$9 >= ' ';
                }
            });
        } else if (fileTransferMetadata.isDefined()) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(0x400000);
            while (rows.hasNext()) {
                outputStream.write(((String)rows.next()).getBytes("UTF-8"));
                outputStream.write(10);
                ++rowCount;
            }
            byte[] data = outputStream.toByteArray();
            dataSize = Predef$.MODULE$.byteArrayOps(data).size();
            outputStream.close();
            Properties proxyProperties = new Properties();
            Option<ProxyInfo> option = $this.proxyInfo();
            if (option instanceof Some) {
                Some some = (Some)option;
                ProxyInfo proxyInfoValue = (ProxyInfo)some.x();
                proxyInfoValue.setProxyForJDBC(proxyProperties);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                if (!None$.MODULE$.equals(option)) {
                    throw new MatchError(option);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            long startUploadTime = System.currentTimeMillis();
            ByteArrayInputStream inStream = new ByteArrayInputStream(data);
            SnowflakeFileTransferAgent.uploadWithoutConnection((SnowflakeFileTransferConfig)SnowflakeFileTransferConfig.Builder.newInstance().setSnowflakeFileTransferMetadata((SnowflakeFileTransferMetadata)fileTransferMetadata.get()).setUploadStream((InputStream)inStream).setRequireCompress(compress).setOcspMode(OCSPMode.FAIL_OPEN).setProxyProperties(proxyProperties).build());
            long endTime = System.currentTimeMillis();
            processTimeInfo = (String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"read_and_upload_time:\n           | ", "\n           | read_time: ", "\n           | upload_time: ", "\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.getTimeString(endTime - startTime), Utils$.MODULE$.getTimeString(startUploadTime - startTime), Utils$.MODULE$.getTimeString(endTime - startUploadTime)})))).stripMargin())).filter((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(char x$10) {
                    return x$10 >= ' ';
                }
            });
        }
        if (TaskContext$.MODULE$.get().attemptNumber() < 2) {
            TestHook$.MODULE$.raiseExceptionIfTestFlagEnabled(TestHookFlag$.MODULE$.TH_GCS_UPLOAD_RAISE_EXCEPTION(), "Negative test to raise error when uploading data for the first two attempts");
        }
        CloudStorageOperations$.MODULE$.log().info((String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":\n         | Finish writing partition ID:", " ", "\n         | write row count is ", ".\n         | Uncompressed data size is ", ".\n         | ", "\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SnowflakeResultSetRDD$.MODULE$.WORKER_LOG_PREFIX(), BoxesRunTime.boxToInteger((int)partitionID), fileName, BoxesRunTime.boxToLong((long)rowCount), Utils$.MODULE$.getSizeString(dataSize), processTimeInfo})))).stripMargin())).filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char x$11) {
                return x$11 >= ' ';
            }
        }));
        return new SingleElementIterator(new FileUploadResult(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{directory, fileName})), dataSize));
    }

    public static List uploadRDD(CloudStorage $this, RDD data, Enumeration.Value format, Option dir, boolean compress, Map storageInfo) {
        Option option;
        block4: {
            String string;
            block3: {
                block2: {
                    String string2;
                    Some some;
                    String str;
                    option = dir;
                    if (!(option instanceof Some) || (str = (String)(some = (Some)option).x()) == null) break block2;
                    string = string2 = str;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                string = Random$.MODULE$.alphanumeric().take(10).mkString("");
            }
            String directory = string;
            CloudStorageOperations$.MODULE$.log().info((String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":\n         | Begin to process and upload data for ", "\n         | partitions: directory=", " ", " ", "\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SnowflakeResultSetRDD$.MODULE$.MASTER_LOG_PREFIX(), BoxesRunTime.boxToInteger((int)data.getNumPartitions()), directory, format.toString(), BoxesRunTime.boxToBoolean((boolean)compress)})))).stripMargin())).filter((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(char x$12) {
                    return x$12 >= ' ';
                }
            }));
            RDD fileUploadResults = data.mapPartitionsWithIndex((Function2)new Serializable($this, directory, format, compress, storageInfo){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CloudStorage $outer;
                private final String directory$1;
                private final Enumeration.Value format$3;
                private final boolean compress$7;
                private final Map storageInfo$3;

                public final SingleElementIterator apply(int x0$1, Iterator<String> x1$1) {
                    Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), x1$1);
                    if (tuple2 != null) {
                        int index = tuple2._1$mcI$sp();
                        Iterator rows = (Iterator)tuple2._2();
                        SparkConnectorContext$.MODULE$.recordConfig();
                        SingleElementIterator singleElementIterator = this.$outer.uploadPartition((Iterator<String>)rows, this.format$3, this.compress$7, this.directory$1, index, (Option<Map<String, String>>)new Some((Object)this.storageInfo$3), (Option<SnowflakeFileTransferMetadata>)None$.MODULE$);
                        return singleElementIterator;
                    }
                    throw new MatchError((Object)tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.directory$1 = directory$1;
                    this.format$3 = format$3;
                    this.compress$7 = compress$7;
                    this.storageInfo$3 = storageInfo$3;
                }
            }, data.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(FileUploadResult.class));
            return Predef$.MODULE$.refArrayOps((Object[])fileUploadResults.collect()).toList();
        }
        throw new MatchError((Object)option);
    }

    public static Enumeration.Value uploadRDD$default$2(CloudStorage $this) {
        return SupportedFormat$.MODULE$.CSV();
    }

    public static boolean uploadRDD$default$4(CloudStorage $this) {
        return true;
    }

    /*
     * Exception decompiling
     */
    public static InputStream createDownloadStreamWithRetry(CloudStorage $this, String fileName, boolean compress, Map storageInfo, int maxRetryCount) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [0 : 331->735)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static InputStream download(CloudStorage $this, String fileName, boolean compress) {
        return $this.createDownloadStream(fileName, compress, (Map<String, String>)((Map)$this.getStageInfo(false, fileName)._1()));
    }

    public static Enumeration.Value download$default$2(CloudStorage $this) {
        return SupportedFormat$.MODULE$.CSV();
    }

    public static boolean download$default$3(CloudStorage $this) {
        return true;
    }

    public static String download$default$4(CloudStorage $this) {
        return "";
    }

    public static void $init$(CloudStorage $this) {
        $this.net$snowflake$spark$snowflake$io$CloudStorage$_setter_$RETRY_SLEEP_TIME_UNIT_IN_MS_$eq(1500);
        $this.net$snowflake$spark$snowflake$io$CloudStorage$_setter_$MAX_SLEEP_TIME_IN_MS_$eq(180000);
        $this.net$snowflake$spark$snowflake$io$CloudStorage$$processedFileCount_$eq(0);
    }
}

