/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.AmazonS3;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.ObjectMetadata;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.PartETag;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.UploadPartRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.UploadPartResult;
import net.snowflake.spark.snowflake.Utils$;
import net.snowflake.spark.snowflake.io.CloudStorageOperations$;
import net.snowflake.spark.snowflake.io.SnowflakeResultSetRDD$;
import net.snowflake.spark.snowflake.io.StorageInfo$;
import net.snowflake.spark.snowflake.test.TestHook$;
import net.snowflake.spark.snowflake.test.TestHookFlag$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=f!B\u0001\u0003\u0001\tY!\u0001F*4+Bdw.\u00193PkR\u0004X\u000f^*ue\u0016\fWN\u0003\u0002\u0004\t\u0005\u0011\u0011n\u001c\u0006\u0003\u000b\u0019\t\u0011b\u001d8po\u001ad\u0017m[3\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0003\n\u0015\u0005Q\u0011a\u00018fiN\u0011\u0001\u0001\u0004\t\u0003\u001bEi\u0011A\u0004\u0006\u0003\u0007=Q\u0011\u0001E\u0001\u0005U\u00064\u0018-\u0003\u0002\u0013\u001d\taq*\u001e;qkR\u001cFO]3b[\"AA\u0003\u0001B\u0001B\u0003%a#\u0001\u0005tg\rc\u0017.\u001a8u\u0007\u0001\u0001\"a\u0006\u0013\u000e\u0003aQ!!\u0007\u000e\u0002\u0005M\u001c$BA\u000e\u001d\u0003!\u0019XM\u001d<jG\u0016\u001c(BA\u000f\u001f\u0003%\tW.\u0019>p]\u0006<8O\u0003\u0002 A\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\"E\u0005!!\u000e\u001a2d\u0015\t\u0019\u0003\"\u0001\u0004dY&,g\u000e^\u0005\u0003Ka\u0011\u0001\"Q7bu>t7k\r\u0005\tO\u0001\u0011\t\u0011)A\u0005Q\u0005!Q.\u001a;b!\tIC&D\u0001+\u0015\tY\u0003$A\u0003n_\u0012,G.\u0003\u0002.U\tqqJ\u00196fGRlU\r^1eCR\f\u0007\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\u0002\u0017M$xN]1hK&sgm\u001c\t\u0005c]R$H\u0004\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14'\u0001\u0004Qe\u0016$WMZ\u0005\u0003qe\u00121!T1q\u0015\t14\u0007\u0005\u00022w%\u0011A(\u000f\u0002\u0007'R\u0014\u0018N\\4\t\u0011y\u0002!\u0011!Q\u0001\n}\n!BY;gM\u0016\u00148+\u001b>f!\t\u0011\u0004)\u0003\u0002Bg\t\u0019\u0011J\u001c;\t\u0011\r\u0003!\u0011!Q\u0001\ni\nAAZ5mK\")Q\t\u0001C\u0001\r\u00061A(\u001b8jiz\"baR%K\u00172k\u0005C\u0001%\u0001\u001b\u0005\u0011\u0001\"\u0002\u000bE\u0001\u00041\u0002\"B\u0014E\u0001\u0004A\u0003\"B\u0018E\u0001\u0004\u0001\u0004\"\u0002 E\u0001\u0004y\u0004\"B\"E\u0001\u0004Q\u0004bB(\u0001\u0001\u0004%I\u0001U\u0001\u0017kN,W*\u001e7uSBdWM\u00117pG.,\u0006\u000f\\8bIV\t\u0011\u000b\u0005\u00023%&\u00111k\r\u0002\b\u0005>|G.Z1o\u0011\u001d)\u0006\u00011A\u0005\nY\u000b!$^:f\u001bVdG/\u001b9mK\ncwnY6Va2|\u0017\rZ0%KF$\"a\u0016.\u0011\u0005IB\u0016BA-4\u0005\u0011)f.\u001b;\t\u000fm#\u0016\u0011!a\u0001#\u0006\u0019\u0001\u0010J\u0019\t\ru\u0003\u0001\u0015)\u0003R\u0003])8/Z'vYRL\u0007\u000f\\3CY>\u001c7.\u00169m_\u0006$\u0007\u0005C\u0004`\u0001\u0001\u0007I\u0011\u00021\u0002!\u0011\fG/Y*ju\u0016LeNQ;gM\u0016\u0014X#A \t\u000f\t\u0004\u0001\u0019!C\u0005G\u0006!B-\u0019;b'&TX-\u00138Ck\u001a4WM]0%KF$\"a\u00163\t\u000fm\u000b\u0017\u0011!a\u0001\u007f!1a\r\u0001Q!\n}\n\u0011\u0003Z1uCNK'0Z%o\u0005V4g-\u001a:!\u0011\u001dA\u0007A1A\u0005\n%\fQCY=uK\u0006\u0013(/Y=PkR\u0004X\u000f^*ue\u0016\fW.F\u0001k!\ti1.\u0003\u0002m\u001d\t)\")\u001f;f\u0003J\u0014\u0018-_(viB,Ho\u0015;sK\u0006l\u0007B\u00028\u0001A\u0003%!.\u0001\fcsR,\u0017I\u001d:bs>+H\u000f];u'R\u0014X-Y7!\u0011\u001d\u0001\b\u00011A\u0005\nE\fQ\u0002^8uC2$\u0015\r^1TSj,W#\u0001:\u0011\u0005I\u001a\u0018B\u0001;4\u0005\u0011auN\\4\t\u000fY\u0004\u0001\u0019!C\u0005o\u0006\tBo\u001c;bY\u0012\u000bG/Y*ju\u0016|F%Z9\u0015\u0005]C\bbB.v\u0003\u0003\u0005\rA\u001d\u0005\u0007u\u0002\u0001\u000b\u0015\u0002:\u0002\u001dQ|G/\u00197ECR\f7+\u001b>fA!9A\u0010\u0001a\u0001\n\u0013\t\u0018a\u0004;pi\u0006dW\u000b\u001d7pC\u0012$\u0016.\\3\t\u000fy\u0004\u0001\u0019!C\u0005\u007f\u0006\u0019Bo\u001c;bYV\u0003Hn\\1e)&lWm\u0018\u0013fcR\u0019q+!\u0001\t\u000fmk\u0018\u0011!a\u0001e\"9\u0011Q\u0001\u0001!B\u0013\u0011\u0018\u0001\u0005;pi\u0006dW\u000b\u001d7pC\u0012$\u0016.\\3!\u0011%\tI\u0001\u0001b\u0001\n\u0013\tY!A\u0005qCJ$X\tV1hgV\u0011\u0011Q\u0002\t\u0007\u0003\u001f\t)\"!\u0007\u000e\u0005\u0005E!bAA\n\u001f\u0005!Q\u000f^5m\u0013\u0011\t9\"!\u0005\u0003\u0013\u0005\u0013(/Y=MSN$\bcA\u0015\u0002\u001c%\u0019\u0011Q\u0004\u0016\u0003\u0011A\u000b'\u000f^#UC\u001eD\u0001\"!\t\u0001A\u0003%\u0011QB\u0001\u000ba\u0006\u0014H/\u0012+bON\u0004\u0003\u0002CA\u0013\u0001\u0001\u0007I\u0011\u00021\u0002\rA\f'\u000f^%e\u0011%\tI\u0003\u0001a\u0001\n\u0013\tY#\u0001\u0006qCJ$\u0018\nZ0%KF$2aVA\u0017\u0011!Y\u0016qEA\u0001\u0002\u0004y\u0004bBA\u0019\u0001\u0001\u0006KaP\u0001\ba\u0006\u0014H/\u00133!\u0011%\t)\u0004\u0001b\u0001\n\u0013\t9$\u0001\u0006ck\u000e\\W\r\u001e(b[\u0016,\u0012A\u000f\u0005\b\u0003w\u0001\u0001\u0015!\u0003;\u0003-\u0011WoY6fi:\u000bW.\u001a\u0011\t\u0013\u0005}\u0002A1A\u0005\n\u0005\u0005\u0013aB6fs:\u000bW.Z\u000b\u0003\u0003\u0007\u0002B!!\u0012\u0002L5\u0011\u0011q\t\u0006\u0004\u0003\u0013z\u0011\u0001\u00027b]\u001eL1\u0001PA$\u0011!\ty\u0005\u0001Q\u0001\n\u0005\r\u0013\u0001C6fs:\u000bW.\u001a\u0011\t\u0015\u0005M\u0003\u0001#b\u0001\n\u0013\t)&A\u0006j]&$(+Z9vKN$XCAA,!\rI\u0013\u0011L\u0005\u0004\u00037R#AH%oSRL\u0017\r^3Nk2$\u0018\u000e]1siV\u0003Hn\\1e%\u0016\fX/Z:u\u0011)\ty\u0006\u0001E\u0001B\u0003&\u0011qK\u0001\rS:LGOU3rk\u0016\u001cH\u000f\t\u0005\u000b\u0003G\u0002\u0001R1A\u0005\n\u0005\u0015\u0014\u0001D5oSR\u0014Vm\u001d9p]N,WCAA4!\rI\u0013\u0011N\u0005\u0004\u0003WR#!H%oSRL\u0017\r^3Nk2$\u0018\u000e]1siV\u0003Hn\\1e%\u0016\u001cX\u000f\u001c;\t\u0015\u0005=\u0004\u0001#A!B\u0013\t9'A\u0007j]&$(+Z:q_:\u001cX\r\t\u0005\t\u0003g\u0002A\u0011\u0001\u0002\u0002v\u00051r-\u001a;ECR\f\u0017J\u001c\"vM\u001a,'OR8s)\u0016\u001cH\u000f\u0006\u0002\u0002xA)!'!\u001f\u0002~%\u0019\u00111P\u001a\u0003\u000b\u0005\u0013(/Y=\u0011\u0007I\ny(C\u0002\u0002\u0002N\u0012AAQ=uK\"9\u0011Q\u0011\u0001\u0005\n\u0005\u001d\u0015aD;qY>\fG\rR1uC\u000eCWO\\6\u0015\u0007]\u000bI\tC\u0004\u0002\f\u0006\r\u0005\u0019A)\u0002\u0017%\u001cH*Y:u\u0007\",hn\u001b\u0005\b\u0003\u001f\u0003A\u0011BAI\u0003=!w.\u00169m_\u0006$wJ\\3QCJ$H#A,\t\u000f\u0005U\u0005\u0001\"\u0011\u0002\u0018\u0006)qO]5uKR\u0019q+!'\t\u000f\u0005m\u00151\u0013a\u0001\u007f\u0005\t!\rC\u0004\u0002\u0016\u0002!\t%a(\u0015\u000f]\u000b\t+a)\u0002(\"A\u00111TAO\u0001\u0004\t9\bC\u0004\u0002&\u0006u\u0005\u0019A \u0002\u0007=4g\rC\u0004\u0002*\u0006u\u0005\u0019A \u0002\u00071,g\u000eC\u0004\u0002.\u0002!\t%!%\u0002\u000b\rdwn]3")
public class S3UploadOutputStream
extends OutputStream {
    private final AmazonS3 s3Client;
    private final ObjectMetadata meta;
    private final int bufferSize;
    private final String file;
    private boolean useMultipleBlockUpload;
    private int dataSizeInBuffer;
    private final ByteArrayOutputStream byteArrayOutputStream;
    private long totalDataSize;
    private long totalUploadTime;
    private final ArrayList<PartETag> partETags;
    private int partId;
    private final String bucketName;
    private final String keyName;
    private InitiateMultipartUploadRequest initRequest;
    private InitiateMultipartUploadResult initResponse;
    private volatile byte bitmap$0;

    private InitiateMultipartUploadRequest initRequest$lzycompute() {
        S3UploadOutputStream s3UploadOutputStream = this;
        synchronized (s3UploadOutputStream) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.initRequest = new InitiateMultipartUploadRequest(this.bucketName(), this.keyName(), this.meta);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.initRequest;
        }
    }

    private InitiateMultipartUploadResult initResponse$lzycompute() {
        S3UploadOutputStream s3UploadOutputStream = this;
        synchronized (s3UploadOutputStream) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.initResponse = this.s3Client.initiateMultipartUpload(this.initRequest());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.initResponse;
        }
    }

    private boolean useMultipleBlockUpload() {
        return this.useMultipleBlockUpload;
    }

    private void useMultipleBlockUpload_$eq(boolean x$1) {
        this.useMultipleBlockUpload = x$1;
    }

    private int dataSizeInBuffer() {
        return this.dataSizeInBuffer;
    }

    private void dataSizeInBuffer_$eq(int x$1) {
        this.dataSizeInBuffer = x$1;
    }

    private ByteArrayOutputStream byteArrayOutputStream() {
        return this.byteArrayOutputStream;
    }

    private long totalDataSize() {
        return this.totalDataSize;
    }

    private void totalDataSize_$eq(long x$1) {
        this.totalDataSize = x$1;
    }

    private long totalUploadTime() {
        return this.totalUploadTime;
    }

    private void totalUploadTime_$eq(long x$1) {
        this.totalUploadTime = x$1;
    }

    private ArrayList<PartETag> partETags() {
        return this.partETags;
    }

    private int partId() {
        return this.partId;
    }

    private void partId_$eq(int x$1) {
        this.partId = x$1;
    }

    private String bucketName() {
        return this.bucketName;
    }

    private String keyName() {
        return this.keyName;
    }

    private InitiateMultipartUploadRequest initRequest() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.initRequest$lzycompute() : this.initRequest;
    }

    private InitiateMultipartUploadResult initResponse() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.initResponse$lzycompute() : this.initResponse;
    }

    public byte[] getDataInBufferForTest() {
        return this.byteArrayOutputStream().toByteArray();
    }

    private void uploadDataChunk(boolean isLastChunk) {
        if (isLastChunk && !this.useMultipleBlockUpload()) {
            long start = System.currentTimeMillis();
            this.meta.setContentLength((long)this.dataSizeInBuffer());
            this.byteArrayOutputStream().close();
            byte[] buffer = this.byteArrayOutputStream().toByteArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer, 0, this.dataSizeInBuffer());
            this.s3Client.putObject(this.bucketName(), this.keyName(), (InputStream)inputStream, this.meta);
            long usedTime = System.currentTimeMillis() - start;
            this.totalUploadTime_$eq(this.totalUploadTime() + usedTime);
            CloudStorageOperations$.MODULE$.log().info((String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":\n           | Finish uploading file ", " without AWS multiple parts API\n           | because the data size is less than the buffer size:\n           | bufferSize=", "\n           | compressedSize=", "\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SnowflakeResultSetRDD$.MODULE$.WORKER_LOG_PREFIX(), this.file, Utils$.MODULE$.getSizeString(this.bufferSize), Utils$.MODULE$.getSizeString(this.dataSizeInBuffer())})))).stripMargin())).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(char x$41) {
                    return x$41 >= ' ';
                }
            }));
        } else {
            this.doUploadOnePart();
            if (isLastChunk) {
                this.byteArrayOutputStream().close();
                long start = System.currentTimeMillis();
                CompleteMultipartUploadRequest compRequest = new CompleteMultipartUploadRequest(this.bucketName(), this.keyName(), this.initResponse().getUploadId(), this.partETags());
                this.s3Client.completeMultipartUpload(compRequest);
                long usedTime = System.currentTimeMillis() - start;
                this.totalUploadTime_$eq(this.totalUploadTime() + usedTime);
                CloudStorageOperations$.MODULE$.log().info((String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":\n             | Finish uploading file ", " with AWS multiple parts API:\n             | bufferSize=", " chunkCount=", "\n             | compressedSize=", "\n             |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SnowflakeResultSetRDD$.MODULE$.WORKER_LOG_PREFIX(), this.file, Utils$.MODULE$.getSizeString(this.bufferSize), BoxesRunTime.boxToInteger((int)this.partId()), Utils$.MODULE$.getSizeString(this.totalDataSize())})))).stripMargin())).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(char x$42) {
                        return x$42 >= ' ';
                    }
                }));
            }
        }
    }

    private void doUploadOnePart() {
        long start = System.currentTimeMillis();
        this.useMultipleBlockUpload_$eq(true);
        byte[] buffer = this.byteArrayOutputStream().toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer, 0, this.dataSizeInBuffer());
        UploadPartRequest uploadRequest = new UploadPartRequest().withBucketName(this.bucketName()).withKey(this.keyName()).withUploadId(this.initResponse().getUploadId()).withPartNumber(this.partId()).withInputStream((InputStream)inputStream).withPartSize((long)this.dataSizeInBuffer());
        UploadPartResult uploadResult = this.s3Client.uploadPart(uploadRequest);
        this.partETags().add(uploadResult.getPartETag());
        this.totalDataSize_$eq(this.totalDataSize() + (long)this.dataSizeInBuffer());
        this.dataSizeInBuffer_$eq(0);
        this.partId_$eq(this.partId() + 1);
        this.byteArrayOutputStream().reset();
        long usedTime = System.currentTimeMillis() - start;
        this.totalUploadTime_$eq(this.totalUploadTime() + usedTime);
        if (this.partId() == 3) {
            TestHook$.MODULE$.raiseExceptionIfTestFlagEnabled(TestHookFlag$.MODULE$.TH_FAIL_UPLOAD_AWS_2ND_BLOCK(), "Negative test to raise error after upload 2nd parts");
        }
    }

    @Override
    public void write(int b) {
        if (this.dataSizeInBuffer() >= this.bufferSize) {
            this.uploadDataChunk(false);
        }
        this.byteArrayOutputStream().write(b);
        this.dataSizeInBuffer_$eq(this.dataSizeInBuffer() + 1);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        int inputSize = len - off;
        if (inputSize + this.dataSizeInBuffer() <= this.bufferSize) {
            this.byteArrayOutputStream().write(b, off, inputSize);
            this.dataSizeInBuffer_$eq(this.dataSizeInBuffer() + inputSize);
        } else {
            int partSize;
            int firstPartSize = this.bufferSize - this.dataSizeInBuffer();
            if (firstPartSize > 0) {
                this.byteArrayOutputStream().write(b, off, firstPartSize);
                this.dataSizeInBuffer_$eq(this.dataSizeInBuffer() + firstPartSize);
            }
            int leftLen = len - firstPartSize;
            int newOff = off + firstPartSize;
            do {
                this.uploadDataChunk(false);
                partSize = Math.min(this.bufferSize, leftLen);
                this.byteArrayOutputStream().write(b, newOff, partSize);
                this.dataSizeInBuffer_$eq(this.dataSizeInBuffer() + partSize);
                newOff += partSize;
            } while ((leftLen -= partSize) > 0);
        }
    }

    @Override
    public void close() {
        if (this.dataSizeInBuffer() > 0) {
            this.uploadDataChunk(true);
        }
    }

    public S3UploadOutputStream(AmazonS3 s3Client, ObjectMetadata meta, Map<String, String> storageInfo, int bufferSize, String file) {
        this.s3Client = s3Client;
        this.meta = meta;
        this.bufferSize = bufferSize;
        this.file = file;
        this.useMultipleBlockUpload = false;
        this.dataSizeInBuffer = 0;
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        this.totalDataSize = 0L;
        this.totalUploadTime = 0L;
        this.partETags = new ArrayList();
        this.partId = 1;
        this.bucketName = (String)storageInfo.apply((Object)StorageInfo$.MODULE$.BUCKET_NAME());
        this.keyName = ((String)storageInfo.apply((Object)StorageInfo$.MODULE$.PREFIX())).concat(file);
    }
}

