/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake.io;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.time.LocalDateTime;
import java.util.TimeZone;
import net.snowflake.client.jdbc.SnowflakeResultSet;
import net.snowflake.spark.snowflake.ConstantString;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper$;
import net.snowflake.spark.snowflake.EmptySnowflakeSQLStatement$;
import net.snowflake.spark.snowflake.Parameters;
import net.snowflake.spark.snowflake.SnowflakeConnectorException;
import net.snowflake.spark.snowflake.SnowflakeSQLStatement;
import net.snowflake.spark.snowflake.SnowflakeTelemetry$;
import net.snowflake.spark.snowflake.SparkConnectorContext$;
import net.snowflake.spark.snowflake.TableName;
import net.snowflake.spark.snowflake.TelemetryConstValues$;
import net.snowflake.spark.snowflake.Utils$;
import net.snowflake.spark.snowflake.io.CloudStorage;
import net.snowflake.spark.snowflake.io.CloudStorageOperations$;
import net.snowflake.spark.snowflake.io.FileUploadResult;
import net.snowflake.spark.snowflake.io.SnowflakeResultSetRDD$;
import net.snowflake.spark.snowflake.io.SupportedFormat$;
import net.snowflake.spark.snowflake.io.WriteTableState;
import net.snowflake.spark.snowflake.io.package$;
import net.snowflake.spark.snowflake.test.TestHook$;
import net.snowflake.spark.snowflake.test.TestHookFlag$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.SetLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.util.Random$;

public final class StageWriter$ {
    public static final StageWriter$ MODULE$;
    private final Logger log;

    static {
        new StageWriter$();
    }

    public Logger log() {
        return this.log;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToStage(SQLContext sqlContext, RDD<String> rdd, StructType schema2, SaveMode saveMode, Parameters.MergedParameters params, Enumeration.Value format) {
        Tuple2<CloudStorage, String> tuple2;
        block8: {
            if (params.table().isEmpty()) {
                throw new IllegalArgumentException("For save operations you must specify a Snowflake table name with the 'dbtable' parameter");
            }
            Option<SnowflakeSQLStatement> prologueSql = Utils$.MODULE$.genPrologueSql(params);
            this.log().debug(prologueSql.toString());
            Connection conn = DefaultJDBCWrapper$.MODULE$.getConnector(params);
            try {
                Tuple2 tuple22;
                prologueSql.foreach((Function1)new Serializable(params, conn){
                    public static final long serialVersionUID = 0L;
                    private final Parameters.MergedParameters params$1;
                    private final Connection conn$1;

                    public final ResultSet apply(SnowflakeSQLStatement x) {
                        return x.execute(this.params$1.bindVariableEnabled(), this.conn$1);
                    }
                    {
                        this.params$1 = params$1;
                        this.conn$1 = conn$1;
                    }
                });
                tuple2 = CloudStorageOperations$.MODULE$.createStorageClient(params, conn, true, (Option<String>)None$.MODULE$, "load");
                if (tuple2 == null) break block8;
                CloudStorage storage = (CloudStorage)tuple2._1();
                String stage = (String)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)storage, (Object)stage);
                CloudStorage storage2 = (CloudStorage)tuple23._1();
                String stage2 = (String)tuple23._2();
                long startTime = System.currentTimeMillis();
                List<FileUploadResult> fileUploadResults = storage2.upload(rdd, format, (Option<String>)None$.MODULE$, storage2.upload$default$4());
                long startCopyInto = System.currentTimeMillis();
                if (fileUploadResults.nonEmpty()) {
                    String firstFileName = ((FileUploadResult)fileUploadResults.head()).fileName();
                    this.writeToTable(sqlContext, conn, schema2, saveMode, params, firstFileName.substring(0, firstFileName.indexOf("/")), stage2, format, fileUploadResults);
                } else if (params.skipWriteWhenWritingEmptyDataFrame()) {
                    this.log().info((String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":\n             | Skip to execute COPY INTO TABLE command because\n             | no file is uploaded.\n             |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SnowflakeResultSetRDD$.MODULE$.MASTER_LOG_PREFIX()})))).stripMargin())).filter((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(char x$2) {
                            return x$2 >= ' ';
                        }
                    }));
                } else {
                    this.log().info((String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":\n             | use dummy prefix to handle the special case that no file is uploaded.\n             |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SnowflakeResultSetRDD$.MODULE$.MASTER_LOG_PREFIX()})))).stripMargin())).filter((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(char x$3) {
                            return x$3 >= ' ';
                        }
                    }));
                    this.writeToTable(sqlContext, conn, schema2, saveMode, params, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dummy_not_exist_prefix_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Object)BoxesRunTime.boxToLong((long)Math.abs(Random$.MODULE$.nextLong()))).toString()})), stage2, format, fileUploadResults);
                }
                long endTime = System.currentTimeMillis();
                this.log().info((String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":\n             | Total job time is ", "\n             | including read & upload time:\n             | ", "\n             | and COPY time: ", ".\n             |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SnowflakeResultSetRDD$.MODULE$.MASTER_LOG_PREFIX(), Utils$.MODULE$.getTimeString(endTime - startTime), Utils$.MODULE$.getTimeString(startCopyInto - startTime), Utils$.MODULE$.getTimeString(endTime - startCopyInto)})))).stripMargin())).filter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(char x$4) {
                        return x$4 >= ' ';
                    }
                }));
                SnowflakeTelemetry$.MODULE$.send(DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn).getTelemetry());
            }
            catch (Throwable throwable) {
                void var8_8;
                SnowflakeTelemetry$.MODULE$.send(DefaultJDBCWrapper$.MODULE$.DataBaseOperations((Connection)var8_8).getTelemetry());
                var8_8.close();
                throw throwable;
            }
            conn.close();
            return;
        }
        throw new MatchError(tuple2);
    }

    private void writeToTable(SQLContext sqlContext, Connection conn, StructType schema2, SaveMode saveMode, Parameters.MergedParameters params, String file, String tempStage, Enumeration.Value format, List<FileUploadResult> fileUploadResults) {
        if (!params.useStagingTable() && params.truncateTable()) {
            this.writeToTableWithoutStagingTable(sqlContext, conn, schema2, saveMode, params, file, tempStage, format, fileUploadResults);
        } else {
            this.writeToTableWithStagingTable(sqlContext, conn, schema2, saveMode, params, file, tempStage, format, fileUploadResults);
        }
    }

    private void writeToTableWithoutStagingTable(SQLContext sqlContext, Connection conn, StructType schema2, SaveMode saveMode, Parameters.MergedParameters params, String file, String tempStage, Enumeration.Value format, List<FileUploadResult> fileUploadResults) {
        String tableName = ((TableName)params.table().get()).name();
        WriteTableState writeTableState = new WriteTableState(conn);
        try {
            boolean tableExists2 = DefaultJDBCWrapper$.MODULE$.tableExists(params, tableName);
            SaveMode saveMode2 = saveMode;
            SaveMode saveMode3 = SaveMode.Overwrite;
            if (!(saveMode2 != null ? !saveMode2.equals(saveMode3) : saveMode3 != null)) {
                if (tableExists2 && !params.truncateTable()) {
                    writeTableState.dropTable(tableName);
                }
            }
            if (tableExists2) {
                if (params.truncateTable()) {
                    SaveMode saveMode4 = saveMode;
                    SaveMode saveMode5 = SaveMode.Overwrite;
                    if (!(saveMode4 != null ? !saveMode4.equals(saveMode5) : saveMode5 != null)) {
                        writeTableState.truncateTable(tableName);
                    }
                }
            } else {
                writeTableState.createTable(tableName, schema2, params);
            }
            writeTableState.copyIntoTable(sqlContext, schema2, saveMode, params, file, tempStage, format, fileUploadResults);
            writeTableState.commit();
            return;
        }
        catch (Throwable throwable) {
            writeTableState.rollback();
            this.log().error(new StringBuilder().append((Object)"Error occurred while loading files to Snowflake: ").append((Object)throwable).toString());
            throw throwable;
        }
    }

    public String getStageTableName(String tableName) {
        String trimmedName = tableName.trim();
        String postfix = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_staging_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Object)BoxesRunTime.boxToInteger((int)Math.abs(Random$.MODULE$.nextInt()))).toString()}));
        return trimmedName.endsWith("\"") ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{trimmedName.substring(0, trimmedName.length() - 1), postfix})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{trimmedName, postfix}));
    }

    private void writeToTableWithStagingTable(SQLContext sqlContext, Connection conn, StructType schema2, SaveMode saveMode, Parameters.MergedParameters params, String file, String tempStage, Enumeration.Value format, List<FileUploadResult> fileUploadResults) {
        TableName table2 = (TableName)params.table().get();
        TableName tempTable = new TableName(params.stagingTableNameRemoveQuotesOnly() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_staging_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table2.name().replace('\"', '_'), ((Object)BoxesRunTime.boxToInteger((int)Math.abs(Random$.MODULE$.nextInt()))).toString()})) : this.getStageTableName(table2.name()));
        SaveMode saveMode2 = saveMode;
        SaveMode saveMode3 = SaveMode.Overwrite;
        TableName targetTable = !(saveMode2 != null ? !saveMode2.equals(saveMode3) : saveMode3 != null) && params.useStagingTable() ? tempTable : table2;
        try {
            Object object;
            boolean tableExists2 = DefaultJDBCWrapper$.MODULE$.tableExists(params, table2.toString());
            SaveMode saveMode4 = saveMode;
            SaveMode saveMode5 = SaveMode.Overwrite;
            if (!(saveMode4 != null ? !saveMode4.equals(saveMode5) : saveMode5 != null) && tableExists2) {
                if (params.useStagingTable()) {
                    if (params.truncateTable()) {
                        DefaultJDBCWrapper.DataBaseOperations qual$7 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                        String x$28 = tempTable.name();
                        String x$29 = table2.name();
                        boolean x$30 = qual$7.createTableLike$default$3();
                        qual$7.createTableLike(x$28, x$29, x$30);
                    }
                    object = BoxedUnit.UNIT;
                } else if (params.truncateTable()) {
                    DefaultJDBCWrapper.DataBaseOperations qual$8 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                    String x$31 = table2.name();
                    boolean x$32 = qual$8.truncateTable$default$2();
                    qual$8.truncateTable(x$31, x$32);
                    object = BoxedUnit.UNIT;
                } else {
                    DefaultJDBCWrapper.DataBaseOperations qual$9 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                    String x$33 = table2.name();
                    boolean x$34 = qual$9.dropTable$default$2();
                    object = BoxesRunTime.boxToBoolean((boolean)qual$9.dropTable(x$33, x$34));
                }
            } else {
                object = BoxedUnit.UNIT;
            }
            SaveMode saveMode6 = saveMode;
            SaveMode saveMode7 = SaveMode.Overwrite;
            if (!(saveMode6 == null ? saveMode7 != null : !saveMode6.equals(saveMode7)) || !tableExists2) {
                DefaultJDBCWrapper.DataBaseOperations qual$10 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                String x$35 = targetTable.name();
                StructType x$36 = schema2;
                Parameters.MergedParameters x$37 = params;
                boolean x$38 = false;
                boolean x$39 = false;
                boolean x$40 = qual$10.createTable$default$6();
                qual$10.createTable(x$35, x$36, x$37, x$38, x$39, x$40);
            }
            Utils$.MODULE$.executePreActions(DefaultJDBCWrapper$.MODULE$, conn, params, (Option<TableName>)Option$.MODULE$.apply((Object)targetTable));
            this.executeCopyIntoTable(sqlContext, conn, schema2, saveMode, params, targetTable, file, tempStage, format, fileUploadResults);
            Utils$.MODULE$.executePostActions(DefaultJDBCWrapper$.MODULE$, conn, params, (Option<TableName>)Option$.MODULE$.apply((Object)targetTable));
            SaveMode saveMode8 = saveMode;
            SaveMode saveMode9 = SaveMode.Overwrite;
            if (!(saveMode8 != null ? !saveMode8.equals(saveMode9) : saveMode9 != null) && params.useStagingTable()) {
                if (tableExists2) {
                    DefaultJDBCWrapper.DataBaseOperations qual$11 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                    String x$41 = table2.name();
                    String x$42 = tempTable.name();
                    boolean x$43 = qual$11.swapTable$default$3();
                    qual$11.swapTable(x$41, x$42, x$43);
                    DefaultJDBCWrapper.DataBaseOperations qual$12 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                    String x$44 = tempTable.name();
                    boolean x$45 = qual$12.dropTable$default$2();
                    qual$12.dropTable(x$44, x$45);
                } else {
                    DefaultJDBCWrapper.DataBaseOperations qual$13 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                    String x$46 = table2.name();
                    String x$47 = tempTable.name();
                    boolean x$48 = qual$13.renameTable$default$3();
                    qual$13.renameTable(x$46, x$47, x$48);
                }
            } else {
                conn.commit();
            }
            return;
        }
        catch (Exception exception) {
            Object object;
            SaveMode saveMode10 = saveMode;
            SaveMode saveMode11 = SaveMode.Overwrite;
            if (!(saveMode10 != null ? !saveMode10.equals(saveMode11) : saveMode11 != null) && params.useStagingTable()) {
                TableName tableName = targetTable;
                TableName tableName2 = tempTable;
                if (!(tableName != null ? !((Object)tableName).equals(tableName2) : tableName2 != null)) {
                    DefaultJDBCWrapper.DataBaseOperations qual$14 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                    String x$49 = tempTable.name();
                    boolean x$50 = qual$14.dropTable$default$2();
                    object = BoxesRunTime.boxToBoolean((boolean)qual$14.dropTable(x$49, x$50));
                } else {
                    object = BoxedUnit.UNIT;
                }
            } else {
                object = BoxedUnit.UNIT;
            }
            this.log().error(new StringBuilder().append((Object)"Error occurred while loading files to Snowflake: ").append((Object)exception).toString());
            throw exception;
        }
    }

    public void executeCopyIntoTable(SQLContext sqlContext, Connection conn, StructType schema2, SaveMode saveMode, Parameters.MergedParameters params, TableName targetTable, String file, String tempStage, Enumeration.Value format, List<FileUploadResult> fileUploadResults) {
        Some some;
        ArrayBuffer progress = new ArrayBuffer();
        long start = System.currentTimeMillis();
        this.logAndAppend((ArrayBuffer<String>)progress, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Begin to write at ", " ("})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LocalDateTime.now()}))).append((Object)TimeZone.getDefault().getDisplayName()).append((Object)")").toString());
        LongRef totalSize = LongRef.create((long)0L);
        scala.collection.mutable.Set expectedFileSet = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        fileUploadResults.foreach((Function1)new Serializable(totalSize, expectedFileSet){
            public static final long serialVersionUID = 0L;
            private final LongRef totalSize$1;
            private final scala.collection.mutable.Set expectedFileSet$1;

            public final void apply(FileUploadResult fileUploadResult) {
                if (fileUploadResult.fileSize() > 0L) {
                    this.expectedFileSet$1.$plus$eq((Object)fileUploadResult.fileName());
                    this.totalSize$1.elem += fileUploadResult.fileSize();
                }
            }
            {
                this.totalSize$1 = totalSize$1;
                this.expectedFileSet$1 = expectedFileSet$1;
            }
        });
        this.logAndAppend((ArrayBuffer<String>)progress, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Total file count is ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)fileUploadResults.size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"non-empty files count is ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)expectedFileSet.size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"total file size is ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.getSizeString(totalSize.elem)}))).toString());
        boolean useFilesClause = false;
        if (TestHook$.MODULE$.isTestFlagEnabled(TestHookFlag$.MODULE$.TH_COPY_INTO_TABLE_MISS_FILES_SUCCESS())) {
            useFilesClause = true;
            some = new Some(expectedFileSet.grouped(2).toList().head());
        } else {
            some = new Some((Object)expectedFileSet);
        }
        Some firstCopyFileSet = some;
        SnowflakeSQLStatement copyStatement = this.copySql(schema2, saveMode, params, targetTable, file, tempStage, format, conn, useFilesClause, (Set<String>)((TraversableOnce)firstCopyFileSet.get()).toSet());
        this.log().debug(Utils$.MODULE$.sanitizeQueryText(copyStatement.toString()));
        this.logAndAppend((ArrayBuffer<String>)progress, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Now executing below command to write into table:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{copyStatement.toString()})));
        SnowflakeSQLStatement lastStatement = copyStatement;
        try {
            ResultSet resultSet;
            if (params.isExecuteQueryWithSyncMode()) {
                resultSet = copyStatement.execute(params.bindVariableEnabled(), conn);
            } else {
                ResultSet asyncRs = copyStatement.executeAsync(params.bindVariableEnabled(), conn);
                String queryID = ((SnowflakeResultSet)asyncRs).getQueryID();
                SparkConnectorContext$.MODULE$.addRunningQuery(sqlContext.sparkContext(), conn, queryID);
                this.logAndAppend((ArrayBuffer<String>)progress, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The query ID for async writing into table command is: ", "; "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{queryID}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The query ID URL is:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params.getQueryIDUrl(queryID)}))).toString());
                asyncRs.getMetaData();
                SparkConnectorContext$.MODULE$.removeRunningQuery(sqlContext.sparkContext(), conn, queryID);
                resultSet = asyncRs;
            }
            ResultSet resultSet2 = resultSet;
            long firstCopyEnd = System.currentTimeMillis();
            this.logAndAppend((ArrayBuffer<String>)progress, (String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"First COPY command is done in\n           | ", "\n           | at ", ", queryID is\n           | ", "\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.getTimeString(firstCopyEnd - start), LocalDateTime.now(), lastStatement.getLastQueryID()})))).stripMargin())).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(char x$5) {
                    return x$5 >= ' ';
                }
            }));
            Utils$.MODULE$.setLastCopyLoad(copyStatement.toString());
            scala.collection.mutable.Set<String> missedFileSet = this.getCopyMissedFiles(params, resultSet2, (scala.collection.mutable.Set<String>)expectedFileSet);
            if (missedFileSet.nonEmpty()) {
                ResultSet resultSet3;
                SnowflakeSQLStatement copyWithFileClause;
                Some secondCopyFileSet = TestHook$.MODULE$.isTestFlagEnabled(TestHookFlag$.MODULE$.TH_COPY_INTO_TABLE_MISS_FILES_FAIL()) ? new Some(missedFileSet.grouped(2).toList().head()) : new Some(missedFileSet);
                useFilesClause = true;
                lastStatement = copyWithFileClause = this.copySql(schema2, saveMode, params, targetTable, file, tempStage, format, conn, useFilesClause, (Set<String>)((TraversableOnce)secondCopyFileSet.get()).toSet());
                this.logAndAppend((ArrayBuffer<String>)progress, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Second COPY command: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{lastStatement})));
                this.log().warn(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Some files are not loaded into the table, execute additional COPY\n             | to load them: ", "\n             | "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getMissedFileInfo$1(missedFileSet)})))).stripMargin());
                if (params.isExecuteQueryWithSyncMode()) {
                    resultSet3 = copyWithFileClause.execute(params.bindVariableEnabled(), conn);
                } else {
                    ResultSet asyncRs = copyWithFileClause.executeAsync(params.bindVariableEnabled(), conn);
                    String queryID = ((SnowflakeResultSet)asyncRs).getQueryID();
                    SparkConnectorContext$.MODULE$.addRunningQuery(sqlContext.sparkContext(), conn, queryID);
                    this.logAndAppend((ArrayBuffer<String>)progress, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The query ID for 2nd async writing into table command is: ", "; "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{queryID}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The query ID URL is:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params.getQueryIDUrl(queryID)}))).toString());
                    asyncRs.getMetaData();
                    SparkConnectorContext$.MODULE$.removeRunningQuery(sqlContext.sparkContext(), conn, queryID);
                    resultSet3 = asyncRs;
                }
                ResultSet resultSet4 = resultSet3;
                long secondCopyEnd = System.currentTimeMillis();
                this.logAndAppend((ArrayBuffer<String>)progress, (String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Second COPY command is done in\n             | ", "\n             | at ", ", queryID is\n             | ", "\n             |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.getTimeString(secondCopyEnd - firstCopyEnd), LocalDateTime.now(), lastStatement.getLastQueryID()})))).stripMargin())).filter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(char x$7) {
                        return x$7 >= ' ';
                    }
                }));
                missedFileSet = this.getCopyMissedFiles(params, resultSet4, missedFileSet);
                if (missedFileSet.nonEmpty()) {
                    throw new SnowflakeConnectorException((String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"These files are missed when COPY INTO TABLE:\n               | ", "\n               | "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getMissedFileInfo$1(missedFileSet)})))).stripMargin())).filter((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(char x$8) {
                            return x$8 >= ' ';
                        }
                    }));
                }
            }
            long end = System.currentTimeMillis();
            this.logAndAppend((ArrayBuffer<String>)progress, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Succeed to write in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.getTimeString(end - start)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LocalDateTime.now()}))).toString());
            return;
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            String message = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fail to write in ", " at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.getTimeString(end - start), LocalDateTime.now()}));
            package$.MODULE$.logger().error(message);
            progress.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{message}));
            SnowflakeTelemetry$.MODULE$.sendQueryStatus(conn, TelemetryConstValues$.MODULE$.OPERATION_WRITE(), lastStatement.getLastQueryID(), TelemetryConstValues$.MODULE$.STATUS_FAIL(), end - start, (Option<Throwable>)new Some((Object)throwable), progress.mkString("\n"));
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.mutable.Set<String> getCopyMissedFiles(Parameters.MergedParameters params, ResultSet copyResultSet, scala.collection.mutable.Set<String> expectedFileSet) {
        void var6_6;
        void var5_5;
        void var4_4;
        void var8_8;
        String COPY_INTO_TABLE_RESULT_COLUMN_FILE = "file";
        String COPY_INTO_TABLE_RESULT_COLUMN_ROW_PARSED = "rows_parsed";
        String COPY_INTO_TABLE_RESULT_COLUMN_ROW_LOADED = "rows_loaded";
        ResultSetMetaData metadata = copyResultSet.getMetaData();
        scala.collection.mutable.Set columnNameSet = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), metadata.getColumnCount()).foreach((Function1)new Serializable(metadata, columnNameSet){
            public static final long serialVersionUID = 0L;
            private final ResultSetMetaData metadata$1;
            private final scala.collection.mutable.Set columnNameSet$1;

            public final scala.collection.mutable.Set<String> apply(int i) {
                return (scala.collection.mutable.Set)this.columnNameSet$1.$plus$eq((Object)this.metadata$1.getColumnName(i));
            }
            {
                this.metadata$1 = metadata$1;
                this.columnNameSet$1 = columnNameSet$1;
            }
        });
        if (columnNameSet.contains((Object)COPY_INTO_TABLE_RESULT_COLUMN_FILE) && (columnNameSet.contains((Object)COPY_INTO_TABLE_RESULT_COLUMN_ROW_PARSED) || columnNameSet.contains((Object)COPY_INTO_TABLE_RESULT_COLUMN_ROW_LOADED))) {
            scala.collection.mutable.Set missedFileSet = expectedFileSet.clone();
            long rowSkipped = 0L;
            while (copyResultSet.next()) {
                SetLike setLike;
                String fileFullName;
                String fileNameWithoutStage;
                if (params.continueOnError()) {
                    rowSkipped += copyResultSet.getLong(COPY_INTO_TABLE_RESULT_COLUMN_ROW_PARSED) - copyResultSet.getLong(COPY_INTO_TABLE_RESULT_COLUMN_ROW_LOADED);
                }
                if (missedFileSet.contains((Object)(fileNameWithoutStage = (fileFullName = copyResultSet.getString(COPY_INTO_TABLE_RESULT_COLUMN_FILE)).replaceAll(".*/([^/]+/[^/]+)$", "$1")))) {
                    setLike = missedFileSet.$minus$eq((Object)fileNameWithoutStage);
                    continue;
                }
                this.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Load file which isn't uploaded by SC: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileFullName})));
                setLike = BoxedUnit.UNIT;
            }
            if (params.continueOnError()) {
                this.log().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ON_ERROR: Continue -> Skipped ", " rows"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)rowSkipped)})));
            }
            return missedFileSet;
        }
        this.log().warn((String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fail to check the COPY result because format is not supported.\n           | The column names are: ", "\n           | Expect to include ", " and\n           | ", " and\n           | ", "\n           | "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var8_8.mkString(", "), var4_4, var5_5, var6_6})))).stripMargin())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char x$9) {
                return x$9 >= ' ';
            }
        }));
        return scala.collection.mutable.Set$.MODULE$.empty();
    }

    public SnowflakeSQLStatement copySql(StructType schema2, SaveMode saveMode, Parameters.MergedParameters params, TableName table2, String prefix, String tempStage, Enumeration.Value format, Connection conn, boolean useFilesClause, Set<String> filesToCopy) {
        Option<Map<String, String>> option;
        block8: {
            Enumeration.Value value;
            block11: {
                SnowflakeSQLStatement snowflakeSQLStatement;
                SnowflakeSQLStatement onError;
                SnowflakeSQLStatement snowflakeSQLStatement2;
                SnowflakeSQLStatement mappingFromString;
                SnowflakeSQLStatement mappingToString;
                block10: {
                    block9: {
                        None$ none$;
                        SnowflakeSQLStatement fromString;
                        block7: {
                            block6: {
                                SaveMode saveMode2 = saveMode;
                                SaveMode saveMode3 = SaveMode.Append;
                                if ((saveMode2 == null ? saveMode3 != null : !saveMode2.equals(saveMode3)) && params.columnMap().isDefined()) {
                                    throw new UnsupportedOperationException("The column mapping only works in append mode.");
                                }
                                fromString = new ConstantString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FROM @", "/", "/"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tempStage, prefix}))).$bang();
                                option = params.columnMap();
                                if (!(option instanceof Some)) break block6;
                                Some some = (Some)option;
                                Map map = (Map)some.x();
                                none$ = new Some(map.toList().map((Function1)new Serializable(schema2){
                                    public static final long serialVersionUID = 0L;
                                    private final StructType schema$1;

                                    /*
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final Tuple2<Object, String> apply(Tuple2<String, String> x0$1) {
                                        Tuple2<String, String> tuple2 = x0$1;
                                        if (tuple2 == null) throw new MatchError(tuple2);
                                        String key = (String)tuple2._1();
                                        String value = (String)tuple2._2();
                                        try {
                                            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)(this.schema$1.fieldIndex(key) + 1)), (Object)value);
                                        }
                                        catch (Exception exception) {
                                            StageWriter$.MODULE$.log().error(new StringBuilder().append((Object)"Error occurred while column mapping: ").append((Object)exception).toString());
                                            throw exception;
                                        }
                                    }
                                    {
                                        this.schema$1 = schema$1;
                                    }
                                }, List$.MODULE$.canBuildFrom()));
                                break block7;
                            }
                            if (!None$.MODULE$.equals(option)) break block8;
                            none$ = None$.MODULE$;
                        }
                        None$ mappingList = none$;
                        mappingToString = this.getMappingToString$1((Option)mappingList, params, table2, format, conn);
                        mappingFromString = this.getMappingFromString$1((Option)mappingList, fromString, schema2, params, format);
                        value = format;
                        Enumeration.Value value2 = SupportedFormat$.MODULE$.CSV();
                        Enumeration.Value value3 = value;
                        if (value2 != null ? !value2.equals(value3) : value3 != null) break block9;
                        snowflakeSQLStatement2 = new ConstantString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |FILE_FORMAT = (\n               |    TYPE=CSV\n               |    FIELD_DELIMITER='|'\n               |    NULL_IF=()\n               |    FIELD_OPTIONALLY_ENCLOSED_BY='\"'\n               |    TIMESTAMP_FORMAT='TZHTZM YYYY-MM-DD HH24:MI:SS.FF9'\n               |    DATE_FORMAT='TZHTZM YYYY-MM-DD HH24:MI:SS.FF9'\n               |    BINARY_FORMAT=BASE64\n               |  )\n           "})).s((Seq)Nil$.MODULE$))).stripMargin()).$bang();
                        break block10;
                    }
                    Enumeration.Value value4 = SupportedFormat$.MODULE$.JSON();
                    Enumeration.Value value5 = value;
                    if (value4 != null ? !value4.equals(value5) : value5 != null) break block11;
                    snowflakeSQLStatement2 = new ConstantString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |FILE_FORMAT = (\n               |    TYPE = JSON\n               |)\n           "})).s((Seq)Nil$.MODULE$))).stripMargin()).$bang();
                }
                SnowflakeSQLStatement formatString = snowflakeSQLStatement2;
                SnowflakeSQLStatement truncateCol = params.truncateColumns() ? new ConstantString("TRUNCATECOLUMNS = TRUE").$bang() : EmptySnowflakeSQLStatement$.MODULE$.apply();
                SnowflakeSQLStatement purge2 = params.purge() ? new ConstantString("PURGE = TRUE").$bang() : EmptySnowflakeSQLStatement$.MODULE$.apply();
                SnowflakeSQLStatement snowflakeSQLStatement3 = onError = params.continueOnError() ? new ConstantString("ON_ERROR = CONTINUE").$bang() : EmptySnowflakeSQLStatement$.MODULE$.apply();
                if (useFilesClause && filesToCopy.nonEmpty()) {
                    Set filesWithoutPrefix = (Set)filesToCopy.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String x) {
                            return x.substring(x.lastIndexOf("/") + 1);
                        }
                    }, Set$.MODULE$.canBuildFrom());
                    snowflakeSQLStatement = new ConstantString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FILES = ( '", "' )\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filesWithoutPrefix.mkString("' , '")})))).stripMargin()).$bang();
                } else {
                    snowflakeSQLStatement = EmptySnowflakeSQLStatement$.MODULE$.apply();
                }
                SnowflakeSQLStatement filesClause = snowflakeSQLStatement;
                return new ConstantString("copy into").$plus(table2.name()).$plus(mappingToString).$plus(mappingFromString).$plus(filesClause).$plus(formatString).$plus(truncateCol).$plus(purge2).$plus(onError);
            }
            throw new MatchError((Object)value);
        }
        throw new MatchError(option);
    }

    private void logAndAppend(ArrayBuffer<String> messages, String message) {
        this.log().info(message);
        messages.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{message}));
    }

    private final String getMissedFileInfo$1(scala.collection.mutable.Set missedFileSet) {
        return (String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"missedFileCount=", "\n             | Files: (", ")\n             |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)missedFileSet.size()), missedFileSet.mkString(", ")})))).stripMargin())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char x$6) {
                return x$6 >= ' ';
            }
        });
    }

    private final SnowflakeSQLStatement getMappingToString$1(Option list, Parameters.MergedParameters params$2, TableName table$1, Enumeration.Value format$1, Connection conn$2) {
        Enumeration.Value value;
        block4: {
            SnowflakeSQLStatement snowflakeSQLStatement;
            block3: {
                block2: {
                    value = format$1;
                    Enumeration.Value value2 = SupportedFormat$.MODULE$.JSON();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                    StructType tableSchema = DefaultJDBCWrapper$.MODULE$.resolveTable(conn$2, table$1.name(), params$2);
                    snowflakeSQLStatement = list.isEmpty() || ((SeqLike)list.get()).isEmpty() ? new ConstantString("(").$plus(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])tableSchema.fields()).map((Function1)new Serializable(params$2){
                        public static final long serialVersionUID = 0L;
                        private final Parameters.MergedParameters params$2;

                        public final String apply(StructField x) {
                            return this.params$2.quoteJsonFieldName() ? (this.params$2.keepOriginalColumnNameCase() ? Utils$.MODULE$.quotedNameIgnoreCase(x.name()) : Utils$.MODULE$.ensureQuoted(x.name())) : x.name();
                        }
                        {
                            this.params$2 = params$2;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(",")).$plus(")") : new ConstantString("(").$plus(((TraversableOnce)((List)list.get()).map((Function1)new Serializable(params$2){
                        public static final long serialVersionUID = 0L;
                        private final Parameters.MergedParameters params$2;

                        public final String apply(Tuple2<Object, String> x) {
                            return this.params$2.keepOriginalColumnNameCase() ? Utils$.MODULE$.quotedNameIgnoreCase((String)x._2()) : Utils$.MODULE$.ensureQuoted((String)x._2());
                        }
                        {
                            this.params$2 = params$2;
                        }
                    }, List$.MODULE$.canBuildFrom())).mkString(", ")).$plus(")");
                    break block3;
                }
                Enumeration.Value value4 = SupportedFormat$.MODULE$.CSV();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                snowflakeSQLStatement = list.isEmpty() || ((SeqLike)list.get()).isEmpty() ? EmptySnowflakeSQLStatement$.MODULE$.apply() : new ConstantString("(").$plus(((TraversableOnce)((List)list.get()).map((Function1)new Serializable(params$2){
                    public static final long serialVersionUID = 0L;
                    private final Parameters.MergedParameters params$2;

                    public final String apply(Tuple2<Object, String> x) {
                        return this.params$2.keepOriginalColumnNameCase() ? Utils$.MODULE$.quotedNameIgnoreCase((String)x._2()) : Utils$.MODULE$.ensureQuoted((String)x._2());
                    }
                    {
                        this.params$2 = params$2;
                    }
                }, List$.MODULE$.canBuildFrom())).mkString(", ")).$plus(")");
            }
            return snowflakeSQLStatement;
        }
        throw new MatchError((Object)value);
    }

    private final SnowflakeSQLStatement getMappingFromString$1(Option list, SnowflakeSQLStatement from, StructType schema$1, Parameters.MergedParameters params$2, Enumeration.Value format$1) {
        Enumeration.Value value;
        block7: {
            SnowflakeSQLStatement snowflakeSQLStatement;
            block6: {
                block5: {
                    SnowflakeSQLStatement snowflakeSQLStatement2;
                    value = format$1;
                    Enumeration.Value value2 = SupportedFormat$.MODULE$.JSON();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block5;
                    if (list.isEmpty() || ((SeqLike)list.get()).isEmpty()) {
                        String names = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])schema$1.fields()).map((Function1)new Serializable(params$2){
                            public static final long serialVersionUID = 0L;
                            private final Parameters.MergedParameters params$2;

                            public final String apply(StructField x) {
                                return "parse_json($1):".concat(this.params$2.quoteJsonFieldName() ? new StringBuilder().append((Object)"\"").append((Object)x.name()).append((Object)"\"").toString() : x.name());
                            }
                            {
                                this.params$2 = params$2;
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(",");
                        snowflakeSQLStatement2 = new ConstantString("from (select").$plus(names).$plus(from).$plus("tmp)");
                    } else {
                        snowflakeSQLStatement2 = new ConstantString("from (select").$plus(((TraversableOnce)((List)list.get()).map((Function1)new Serializable(schema$1, params$2){
                            public static final long serialVersionUID = 0L;
                            private final StructType schema$1;
                            private final Parameters.MergedParameters params$2;

                            public final String apply(Tuple2<Object, String> x) {
                                return "parse_json($1):".concat(this.params$2.quoteJsonFieldName() ? new StringBuilder().append((Object)"\"").append((Object)this.schema$1.apply(x._1$mcI$sp() - 1).name()).append((Object)"\"").toString() : this.schema$1.apply(x._1$mcI$sp() - 1).name());
                            }
                            {
                                this.schema$1 = schema$1;
                                this.params$2 = params$2;
                            }
                        }, List$.MODULE$.canBuildFrom())).mkString(", ")).$plus(from).$plus("tmp)");
                    }
                    snowflakeSQLStatement = snowflakeSQLStatement2;
                    break block6;
                }
                Enumeration.Value value4 = SupportedFormat$.MODULE$.CSV();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block7;
                snowflakeSQLStatement = list.isEmpty() || ((SeqLike)list.get()).isEmpty() ? from : new ConstantString("from (select").$plus(((TraversableOnce)((List)list.get()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<Object, String> x) {
                        return "tmp.$".concat(((Object)BoxesRunTime.boxToInteger((int)x._1$mcI$sp())).toString());
                    }
                }, List$.MODULE$.canBuildFrom())).mkString(", ")).$plus(from).$plus("tmp)");
            }
            return snowflakeSQLStatement;
        }
        throw new MatchError((Object)value);
    }

    private StageWriter$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

