/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake.streaming;

import java.security.PrivateKey;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import net.snowflake.ingest.SimpleIngestManager;
import net.snowflake.ingest.connection.HistoryRangeResponse;
import net.snowflake.ingest.connection.HistoryResponse;
import net.snowflake.ingest.connection.IngestStatus;
import net.snowflake.ingest.utils.StagedFileWrapper;
import net.snowflake.spark.snowflake.Parameters;
import net.snowflake.spark.snowflake.streaming.SnowflakeIngestConnector$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

public final class SnowflakeIngestConnector$ {
    public static final SnowflakeIngestConnector$ MODULE$;

    static {
        new SnowflakeIngestConnector$();
    }

    public Function0<List<Tuple2<String, IngestStatus>>> createHistoryChecker(SimpleIngestManager ingestManager) {
        ObjectRef beginMark = ObjectRef.create(null);
        return new Serializable(ingestManager, beginMark){
            public static final long serialVersionUID = 0L;
            private final SimpleIngestManager ingestManager$1;
            public final ObjectRef beginMark$1;

            public final List<Tuple2<String, IngestStatus>> apply() {
                HistoryResponse response = this.ingestManager$1.getHistory(null, null, (String)this.beginMark$1.elem);
                this.beginMark$1.elem = (String)Option$.MODULE$.apply((Object)response.getNextBeginMark()).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.createHistoryChecker.1 $outer;

                    public final String apply() {
                        return (String)this.$outer.beginMark$1.elem;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return response == null || response.files == null ? Nil$.MODULE$ : (List)JavaConversions$.MODULE$.asScalaBuffer(response.files).toList().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<Tuple2<String, IngestStatus>> apply(HistoryResponse.FileEntry entry) {
                        return entry.getPath() != null && Predef$.MODULE$.Boolean2boolean(entry.isComplete()) ? List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)entry.getPath(), (Object)entry.getStatus())})) : Nil$.MODULE$;
                    }
                }, List$.MODULE$.canBuildFrom());
            }
            {
                this.ingestManager$1 = ingestManager$1;
                this.beginMark$1 = beginMark$1;
            }
        };
    }

    public List<Tuple2<String, IngestStatus>> checkHistoryByRange(SimpleIngestManager ingestManager, long start, long end) {
        HistoryRangeResponse response = ingestManager.getHistoryRange(null, this.timestampToDate(start), this.timestampToDate(end));
        return response == null || response.files == null ? Nil$.MODULE$ : (List)JavaConversions$.MODULE$.asScalaBuffer(response.files).toList().flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Tuple2<String, IngestStatus>> apply(HistoryResponse.FileEntry entry) {
                return entry.getPath() != null && Predef$.MODULE$.Boolean2boolean(entry.isComplete()) ? List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)entry.getPath(), (Object)entry.getStatus())})) : Nil$.MODULE$;
            }
        }, List$.MODULE$.canBuildFrom());
    }

    private String timestampToDate(long time) {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(tz);
        return df.format(new Date(time - 1000L));
    }

    public SimpleIngestManager createIngestManager(String account, String user, String pipe, String host, PrivateKey privateKey2, int port, String scheme) {
        return new SimpleIngestManager(account, user, pipe, privateKey2, scheme, host, port);
    }

    public void ingestFiles(List<String> files, SimpleIngestManager manager) {
        manager.ingestFiles((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)files.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StagedFileWrapper apply(String x$1) {
                return new StagedFileWrapper(x$1);
            }
        }, List$.MODULE$.canBuildFrom())).asJava(), null);
    }

    public SimpleIngestManager createIngestManager(Parameters.MergedParameters param, String pipeName) {
        block4: {
            String string;
            block7: {
                int n;
                String scheme;
                String host;
                Regex accountPattern;
                block6: {
                    String t;
                    String string2;
                    String portStr;
                    Regex portPattern;
                    block5: {
                        Regex urlPattern = new StringOps(Predef$.MODULE$.augmentString("^(https?://)?([^:]+)(:\\d+)?$")).r();
                        portPattern = new StringOps(Predef$.MODULE$.augmentString(":(\\d+)")).r();
                        accountPattern = new StringOps(Predef$.MODULE$.augmentString("([^.]+).+")).r();
                        String string3 = param.sfURL().trim();
                        Option option = urlPattern.unapplySeq((CharSequence)string3);
                        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(3) != 0) break block4;
                        host = (String)((LinearSeqOptimized)option.get()).apply(1);
                        portStr = (String)((LinearSeqOptimized)option.get()).apply(2);
                        String string4 = scheme = param.isSslON() ? "https" : "http";
                        if (portStr != null) break block5;
                        n = param.isSslON() ? 443 : 80;
                        break block6;
                    }
                    string = portStr;
                    Option option = portPattern.unapplySeq((CharSequence)string);
                    if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) break block7;
                    String t2 = string2 = (t = (String)((LinearSeqOptimized)option.get()).apply(0));
                    n = new StringOps(Predef$.MODULE$.augmentString(t2)).toInt();
                }
                int port = n;
                String string5 = host;
                Option option = accountPattern.unapplySeq((CharSequence)string5);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                    String account;
                    String string6;
                    String account2 = string6 = (account = (String)((LinearSeqOptimized)option.get()).apply(0));
                    Predef$.MODULE$.require(param.privateKey().isDefined(), (Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "PEM Private key must be specified with 'pem_private_key' parameter";
                        }
                    });
                    PrivateKey privateKey2 = (PrivateKey)param.privateKey().get();
                    String pipe = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{param.sfDatabase(), param.sfSchema(), pipeName}));
                    SimpleIngestManager simpleIngestManager = this.createIngestManager(account2, param.sfUser(), pipe, host, privateKey2, port, scheme);
                    return simpleIngestManager;
                }
                throw new MatchError((Object)string5);
            }
            throw new MatchError((Object)string);
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"incorrect url: ").append((Object)param.sfURL()).toString());
    }

    public int createIngestManager$default$6() {
        return 443;
    }

    public String createIngestManager$default$7() {
        return "https";
    }

    private SnowflakeIngestConnector$() {
        MODULE$ = this;
    }
}

