/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake;

import java.io.Serializable;
import java.security.PrivateKey;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.jdbc.SnowflakePreparedStatement;
import net.snowflake.client.jdbc.telemetry.Telemetry;
import net.snowflake.client.jdbc.telemetry.TelemetryClient;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper$;
import net.snowflake.spark.snowflake.Parameters;
import net.snowflake.spark.snowflake.Parameters$;
import net.snowflake.spark.snowflake.SnowflakeTelemetry$;
import net.snowflake.spark.snowflake.TelemetryClientInfoFields$;
import net.snowflake.spark.snowflake.Utils$;
import org.apache.spark.sql.execution.datasources.jdbc.DriverRegistry$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}h!\u0002\r\u001a\u0001e\u0001\u0003\"B\u0014\u0001\t\u0003I\u0003b\u0002\u0017\u0001\u0005\u0004%I!\f\u0005\u0007m\u0001\u0001\u000b\u0011\u0002\u0018\t\u000f]\u0002!\u0019!C\u0005q!1q\b\u0001Q\u0001\neBQ\u0001\u0011\u0001\u0005\u0002\u0005CQ\u0001\u001e\u0001\u0005\u0002UDQ! \u0001\u0005\u0002yDq!!\u0001\u0001\t\u0003\t\u0019\u0001C\u0004\u0002\u000e\u0001!\t!a\u0004\t\u0011\u0005m\u0001\u0001\"\u0001\u001a\u0003;Aq!!\u000b\u0001\t\u0003\tY\u0003C\u0004\u0002*\u0001!\t!a\u000e\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@!9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0003bBA\u001f\u0001\u0011\u0005\u0011q\n\u0005\b\u0003+\u0002A\u0011AA,\u0011\u001d\t)\u0007\u0001C\u0001\u0003OBq!!\u0016\u0001\t\u0003\ti\u0007C\u0004\u0002f\u0001!\t!a\u001d\t\u000f\u0005\u0015\u0004\u0001\"\u0003\u0002z!9\u0011q\u0014\u0001\u0005\n\u0005\u0005\u0006bBA`\u0001\u0011\u0005\u0011\u0011\u0019\u0002\f\u0015\u0012\u00135i\u0016:baB,'O\u0003\u0002\u001b7\u0005I1O\\8xM2\f7.\u001a\u0006\u00039u\tQa\u001d9be.T!A\u0007\u0010\u000b\u0003}\t1A\\3u'\t\u0001\u0011\u0005\u0005\u0002#K5\t1EC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13E\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t!\u0006\u0005\u0002,\u00015\t\u0011$A\u0002m_\u001e,\u0012A\f\t\u0003_Qj\u0011\u0001\r\u0006\u0003cI\nQa\u001d7gi)T\u0011aM\u0001\u0004_J<\u0017BA\u001b1\u0005\u0019aunZ4fe\u0006!An\\4!\u0003\t)7-F\u0001:!\tQT(D\u0001<\u0015\ta4%\u0001\u0006d_:\u001cWO\u001d:f]RL!AP\u001e\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018aA3dA\u0005a!/Z:pYZ,G+\u00192mKR!!)\u0014,d!\t\u00195*D\u0001E\u0015\t)e)A\u0003usB,7O\u0003\u0002H\u0011\u0006\u00191/\u001d7\u000b\u0005qI%B\u0001&3\u0003\u0019\t\u0007/Y2iK&\u0011A\n\u0012\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\"\u0002(\u0007\u0001\u0004y\u0015\u0001B2p]:\u0004\"\u0001\u0015+\u000e\u0003ES!a\u0012*\u000b\u0003M\u000bAA[1wC&\u0011Q+\u0015\u0002\u000b\u0007>tg.Z2uS>t\u0007\"B,\u0007\u0001\u0004A\u0016!\u0002;bE2,\u0007CA-a\u001d\tQf\f\u0005\u0002\\G5\tAL\u0003\u0002^Q\u00051AH]8pizJ!aX\u0012\u0002\rA\u0013X\rZ3g\u0013\t\t'M\u0001\u0004TiJLgn\u001a\u0006\u0003?\u000eBQ\u0001\u001a\u0004A\u0002\u0015\fa\u0001]1sC6\u001c\bC\u00014r\u001d\t9wN\u0004\u0002i]:\u0011\u0011.\u001c\b\u0003U2t!aW6\n\u0003}I!A\u0007\u0010\n\u0005qi\u0012B\u0001\u000e\u001c\u0013\t\u0001\u0018$\u0001\u0006QCJ\fW.\u001a;feNL!A]:\u0003!5+'oZ3e!\u0006\u0014\u0018-\\3uKJ\u001c(B\u00019\u001a\u0003Q\u0011Xm]8mm\u0016$\u0016M\u00197f\rJ|W.T3uCR!!I^<}\u0011\u0015qu\u00011\u0001P\u0011\u0015Ax\u00011\u0001z\u0003\u0011\u00118/\u001c3\u0011\u0005AS\u0018BA>R\u0005E\u0011Vm];miN+G/T3uC\u0012\u000bG/\u0019\u0005\u0006I\u001e\u0001\r!Z\u0001\rO\u0016$8i\u001c8oK\u000e$xN\u001d\u000b\u0003\u001f~DQ\u0001\u001a\u0005A\u0002\u0015\fAb]2iK6\f7\u000b\u001e:j]\u001e$R\u0001WA\u0003\u0003\u0013Aa!a\u0002\n\u0001\u0004\u0011\u0015AB:dQ\u0016l\u0017\r\u0003\u0004\u0002\f%\u0001\r!Z\u0001\u0006a\u0006\u0014\u0018-\\\u0001\u0011g\u000eDW-\\1D_:4XM]:j_:$2\u0001WA\t\u0011\u001d\t\u0019B\u0003a\u0001\u0003+\tQAZ5fY\u0012\u00042aQA\f\u0013\r\tI\u0002\u0012\u0002\f'R\u0014Xo\u0019;GS\u0016dG-A\u0006uC\ndW-\u0012=jgR\u001cHCBA\u0010\u0003K\t9\u0003E\u0002#\u0003CI1!a\t$\u0005\u001d\u0011un\u001c7fC:DQ\u0001Z\u0006A\u0002\u0015DQaV\u0006A\u0002a\u000bA$\u001a=fGV$X\r\u0015:fa\u0006\u0014X\rZ%oi\u0016\u0014(/\u001e9uS\nd\u0017\u0010\u0006\u0003\u0002 \u00055\u0002bBA\u0018\u0019\u0001\u0007\u0011\u0011G\u0001\ngR\fG/Z7f]R\u00042\u0001UA\u001a\u0013\r\t)$\u0015\u0002\u0012!J,\u0007/\u0019:fIN#\u0018\r^3nK:$HCBA\u0010\u0003s\tY\u0004C\u0003O\u001b\u0001\u0007q\nC\u0003H\u001b\u0001\u0007\u0001,A\u0011fq\u0016\u001cW\u000f^3Qe\u0016\u0004\u0018M]3e#V,'/_%oi\u0016\u0014(/\u001e9uS\nd\u0017\u0010\u0006\u0003\u0002B\u0005\u001d\u0003c\u0001)\u0002D%\u0019\u0011QI)\u0003\u0013I+7/\u001e7u'\u0016$\bbBA\u0018\u001d\u0001\u0007\u0011\u0011G\u0001'Kb,7-\u001e;f!J,\u0007/\u0019:fIF+XM]=Bgft7-\u00138uKJ\u0014X\u000f\u001d;jE2LH\u0003BA!\u0003\u001bBq!a\f\u0010\u0001\u0004\t\t\u0004\u0006\u0004\u0002B\u0005E\u00131\u000b\u0005\u0006\u001dB\u0001\ra\u0014\u0005\u0006\u000fB\u0001\r\u0001W\u0001\u001aKb,7-\u001e;f#V,'/_%oi\u0016\u0014(/\u001e9uS\nd\u0017\u0010\u0006\u0004\u0002B\u0005e\u0013\u0011\r\u0005\b\u0003_\t\u0002\u0019AA.!\r\u0001\u0016QL\u0005\u0004\u0003?\n&!C*uCR,W.\u001a8u\u0011\u0019\t\u0019'\u0005a\u00011\u0006\u00191\u000f\u001e:\u0002)\u0015DXmY;uK&sG/\u001a:skB$\u0018N\u00197z)\u0019\ty\"!\u001b\u0002l!9\u0011q\u0006\nA\u0002\u0005m\u0003BBA2%\u0001\u0007\u0001\f\u0006\u0004\u0002B\u0005=\u0014\u0011\u000f\u0005\u0006\u001dN\u0001\ra\u0014\u0005\u0006\u000fN\u0001\r\u0001\u0017\u000b\u0007\u0003?\t)(a\u001e\t\u000b9#\u0002\u0019A(\t\u000b\u001d#\u0002\u0019\u0001-\u0016\t\u0005m\u0014\u0011\u0011\u000b\u0007\u0003{\n\u0019*!&\u0011\t\u0005}\u0014\u0011\u0011\u0007\u0001\t\u001d\t\u0019)\u0006b\u0001\u0003\u000b\u0013\u0011\u0001V\t\u0005\u0003\u000f\u000bi\tE\u0002#\u0003\u0013K1!a#$\u0005\u001dqu\u000e\u001e5j]\u001e\u00042AIAH\u0013\r\t\tj\t\u0002\u0004\u0003:L\bbBA\u0018+\u0001\u0007\u00111\f\u0005\b\u0003/+\u0002\u0019AAM\u0003\ty\u0007\u000fE\u0004#\u00037\u000bY&! \n\u0007\u0005u5EA\u0005Gk:\u001cG/[8oc\u0005yq-\u001a;DCR\fG._:u)f\u0004X\r\u0006\u0006\u0002$\u0006%\u00161WA\\\u0003w\u00032aQAS\u0013\r\t9\u000b\u0012\u0002\t\t\u0006$\u0018\rV=qK\"9\u00111\u0016\fA\u0002\u00055\u0016aB:rYRK\b/\u001a\t\u0004E\u0005=\u0016bAAYG\t\u0019\u0011J\u001c;\t\u000f\u0005Uf\u00031\u0001\u0002.\u0006I\u0001O]3dSNLwN\u001c\u0005\b\u0003s3\u0002\u0019AAW\u0003\u0015\u00198-\u00197f\u0011\u001d\tiL\u0006a\u0001\u0003?\taa]5h]\u0016$\u0017\u0001D4fiR+G.Z7fiJLH\u0003BAb\u0003/\u0004B!!2\u0002T6\u0011\u0011q\u0019\u0006\u0005\u0003\u0013\fY-A\u0005uK2,W.\u001a;ss*!\u0011QZAh\u0003\u0011QGMY2\u000b\u0007\u0005EW$\u0001\u0004dY&,g\u000e^\u0005\u0005\u0003+\f9MA\u0005UK2,W.\u001a;ss\")aj\u0006a\u0001\u001f\":q#a7\u0002b\u0006U\bc\u0001\u0012\u0002^&\u0019\u0011q\\\u0012\u0003\u0015\u0011,\u0007O]3dCR,G-\r\u0005$1\u0006\r\u00181^As\u0013\u0011\t)/a:\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\r\tIoI\u0001\u000bI\u0016\u0004(/Z2bi\u0016$\u0017'C\u0012\u0002n\u0006=\u0018\u0011_Au\u001d\r\u0011\u0013q^\u0005\u0004\u0003S\u001c\u0013'\u0002\u0012#G\u0005M(!B:dC2\f\u0017\u0007C\u0012Y\u0003o\fY0!?\n\t\u0005e\u0018q]\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a2\u0013\r\ni/a<\u0002~\u0006%\u0018'\u0002\u0012#G\u0005M\b")
public class JDBCWrapper {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ExecutionContext ec;

    private Logger log() {
        return this.log;
    }

    private ExecutionContext ec() {
        return this.ec;
    }

    public StructType resolveTable(Connection conn, String table, Parameters.MergedParameters params) {
        return this.resolveTableFromMeta(conn, DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn).tableMetaData(table), params);
    }

    public StructType resolveTableFromMeta(Connection conn, ResultSetMetaData rsmd, Parameters.MergedParameters params) {
        int ncols = rsmd.getColumnCount();
        StructField[] fields = new StructField[ncols];
        for (int i = 0; i < ncols; ++i) {
            String columnName = rsmd.getColumnLabel(i + 1);
            int dataType = rsmd.getColumnType(i + 1);
            int fieldSize = rsmd.getPrecision(i + 1);
            int fieldScale = rsmd.getScale(i + 1);
            boolean isSigned = rsmd.isSigned(i + 1);
            boolean nullable = rsmd.isNullable(i + 1) != 0;
            DataType columnType = this.getCatalystType(dataType, fieldSize, fieldScale, isSigned);
            fields[i] = new StructField(params.keepOriginalColumnNameCase() ? columnName : (columnName.matches("[_A-Z]([_0-9A-Z])*") ? columnName : new StringBuilder(2).append("\"").append(columnName).append("\"").toString()), columnType, nullable, StructField$.MODULE$.apply$default$4());
        }
        return new StructType(fields);
    }

    public Connection getConnector(Parameters.MergedParameters params) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String driverClassName = Utils$.MODULE$.JDBC_DRIVER();
        try {
            Class<?> driverClass = Utils$.MODULE$.classForName(driverClassName);
            DriverRegistry$.MODULE$.register(driverClass.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundException(new StringBuilder(50).append("Could not load a Snowflake JDBC driver class < ").append(driverClassName).append(" > ").toString(), e);
        }
        String sfURL = params.sfURL();
        String jdbcURL = new StringBuilder(17).append("jdbc:snowflake://").append(sfURL).toString();
        Properties jdbcProperties = new Properties();
        jdbcProperties.put("db", params.sfDatabase());
        jdbcProperties.put("schema", params.sfSchema());
        jdbcProperties.put("user", params.sfUser());
        Option<PrivateKey> option = params.privateKey();
        if (option instanceof Some) {
            Some some = (Some)option;
            PrivateKey privateKey = (PrivateKey)some.value();
            object5 = jdbcProperties.put("privateKey", privateKey);
        } else if (None$.MODULE$.equals(option)) {
            Object object6;
            Option<String> option2 = params.sfToken();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                String value = (String)some.value();
                object6 = jdbcProperties.put("token", value);
            } else if (None$.MODULE$.equals(option2)) {
                object6 = jdbcProperties.put("password", params.sfPassword());
            } else {
                throw new MatchError(option2);
            }
            object5 = object6;
        } else {
            throw new MatchError(option);
        }
        jdbcProperties.put("ssl", params.sfSSL());
        Object object7 = params.sfAccount().isDefined() ? jdbcProperties.put("account", params.sfAccount().get()) : BoxedUnit.UNIT;
        Object object8 = params.sfWarehouse().isDefined() ? jdbcProperties.put("warehouse", params.sfWarehouse().get()) : BoxedUnit.UNIT;
        Object object9 = params.sfRole().isDefined() ? jdbcProperties.put("role", params.sfRole().get()) : BoxedUnit.UNIT;
        Option<String> option3 = params.getTimeOutputFormat();
        if (option3 instanceof Some) {
            Some some = (Some)option3;
            String value = (String)some.value();
            object4 = jdbcProperties.put(Parameters$.MODULE$.PARAM_TIME_OUTPUT_FORMAT(), value);
        } else {
            object4 = BoxedUnit.UNIT;
        }
        Option<String> option4 = params.getQueryResultFormat();
        if (option4 instanceof Some) {
            Some some = (Some)option4;
            String value = (String)some.value();
            object3 = jdbcProperties.put(Parameters$.MODULE$.PARAM_JDBC_QUERY_RESULT_FORMAT(), value);
        } else {
            object3 = BoxedUnit.UNIT;
        }
        params.setJDBCProxyIfNecessary(jdbcProperties);
        Option<String> option5 = params.sfAuthenticator();
        if (option5 instanceof Some) {
            Some some = (Some)option5;
            String value = (String)some.value();
            object2 = jdbcProperties.put("authenticator", value);
        } else {
            object2 = BoxedUnit.UNIT;
        }
        jdbcProperties.put("client_session_keep_alive", "true");
        jdbcProperties.put("JDBC_TREAT_DECIMAL_AS_INT", "false");
        Map<String, Object> extraOptions = params.sfExtraOptions();
        extraOptions.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)JDBCWrapper.$anonfun$getConnector$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            String string;
            Object v;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x$1;
                    if (tuple2 == null) break block2;
                    String k = (String)tuple2._1();
                    v = tuple2._2();
                    if (k == null) break block2;
                    string = k;
                    if (v != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            Object object = v;
            Object object2 = jdbcProperties.put(string.toLowerCase(), object.toString());
            return object2;
        });
        if (!Utils$.MODULE$.CERTIFIED_JDBC_VERSION().equals(Utils$.MODULE$.jdbcVersion())) {
            this.log().warn((String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(107).append("JDBC ").append(Utils$.MODULE$.jdbcVersion()).append(" is being used.\n           | But the certified JDBC version\n           | ").append(Utils$.MODULE$.CERTIFIED_JDBC_VERSION()).append(" is recommended.\n           |").toString())).stripMargin())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)JDBCWrapper.$anonfun$getConnector$3(BoxesRunTime.unboxToChar((Object)x$2)))));
        }
        jdbcProperties.put(SFSessionProperty.CLIENT_INFO.getPropertyKey(), Utils$.MODULE$.getClientInfoString());
        Connection conn = DriverManager.getConnection(jdbcURL, jdbcProperties);
        if (jdbcProperties.getProperty(Parameters$.MODULE$.PARAM_JDBC_QUERY_RESULT_FORMAT()) != null) {
            try {
                String resultFormat = jdbcProperties.getProperty(Parameters$.MODULE$.PARAM_JDBC_QUERY_RESULT_FORMAT());
                object = BoxesRunTime.boxToBoolean((boolean)conn.createStatement().execute(new StringBuilder(47).append("alter session set JDBC_QUERY_RESULT_FORMAT = '").append(resultFormat).append("'").toString()));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (!(throwable2 instanceof SQLException)) {
                    if (throwable2 != null) {
                        Throwable throwable3 = throwable2;
                        throw throwable3;
                    }
                    throw throwable;
                }
                SQLException sQLException = (SQLException)throwable2;
                this.log().info(sQLException.getMessage());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                object = boxedUnit;
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        Map extraValues = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TelemetryClientInfoFields$.MODULE$.SFURL()), (Object)sfURL)}));
        SnowflakeTelemetry$.MODULE$.sendClientInfoTelemetry((Map<String, String>)extraValues, conn);
        return conn;
    }

    public String schemaString(StructType schema, Parameters.MergedParameters param) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)field -> {
            String name = param.keepOriginalColumnNameCase() ? Utils$.MODULE$.quotedNameIgnoreCase(field.name()) : Utils$.MODULE$.ensureQuoted(field.name());
            String type = this.schemaConversion((StructField)field);
            String nullable = field.nullable() ? "" : "NOT NULL";
            return new StringBuilder(2).append(name).append(" ").append(type).append(" ").append(nullable).toString();
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",");
    }

    public String schemaConversion(StructField field) {
        String string;
        DataType dataType = field.dataType();
        if (IntegerType$.MODULE$.equals(dataType)) {
            string = "INTEGER";
        } else if (LongType$.MODULE$.equals(dataType)) {
            string = "INTEGER";
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            string = "DOUBLE";
        } else if (FloatType$.MODULE$.equals(dataType)) {
            string = "FLOAT";
        } else if (ShortType$.MODULE$.equals(dataType)) {
            string = "INTEGER";
        } else if (ByteType$.MODULE$.equals(dataType)) {
            string = "INTEGER";
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            string = "BOOLEAN";
        } else if (StringType$.MODULE$.equals(dataType)) {
            string = field.metadata().contains("maxlength") ? new StringBuilder(9).append("VARCHAR(").append(field.metadata().getLong("maxlength")).append(")").toString() : "STRING";
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            string = field.metadata().contains("maxlength") ? new StringBuilder(8).append("BINARY(").append(field.metadata().getLong("maxlength")).append(")").toString() : "BINARY";
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            string = "TIMESTAMP";
        } else if (DateType$.MODULE$.equals(dataType)) {
            string = "DATE";
        } else if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            string = new StringBuilder(10).append("DECIMAL(").append(decimalType.precision()).append(",").append(decimalType.scale()).append(")").toString();
        } else {
            boolean bl = dataType instanceof StructType ? true : (dataType instanceof ArrayType ? true : dataType instanceof MapType);
            if (bl) {
                string = "VARIANT";
            } else {
                throw new IllegalArgumentException(new StringBuilder(45).append("Don't know how to save ").append(field).append(" of type ").append(field.name()).append(" to Snowflake").toString());
            }
        }
        return string;
    }

    public boolean tableExists(Parameters.MergedParameters params, String table) {
        boolean bl;
        try (Connection conn = this.getConnector(params);){
            Object object = params.checkTableExistenceInCurrentSchemaOnly() ? BoxesRunTime.boxToBoolean((boolean)conn.createStatement().execute("alter session set search_path='$current'")) : BoxedUnit.UNIT;
            DefaultJDBCWrapper.DataBaseOperations qual$1 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
            String x$1 = table;
            boolean x$2 = qual$1.tableExists$default$2();
            bl = qual$1.tableExists(x$1, x$2);
        }
        return bl;
    }

    public boolean executePreparedInterruptibly(PreparedStatement statement) {
        return BoxesRunTime.unboxToBoolean(this.executeInterruptibly((Statement)statement, (Function1 & Serializable & scala.Serializable)stmt -> BoxesRunTime.boxToBoolean((boolean)JDBCWrapper.$anonfun$executePreparedInterruptibly$1(stmt))));
    }

    public boolean executePreparedInterruptibly(Connection conn, String sql) {
        return this.executePreparedInterruptibly(conn.prepareStatement(sql));
    }

    public ResultSet executePreparedQueryInterruptibly(PreparedStatement statement) {
        return (ResultSet)this.executeInterruptibly((Statement)statement, (Function1 & Serializable & scala.Serializable)stmt -> {
            PreparedStatement prepStmt = (PreparedStatement)stmt;
            return prepStmt.executeQuery();
        });
    }

    public ResultSet executePreparedQueryAsyncInterruptibly(PreparedStatement statement) {
        return (ResultSet)this.executeInterruptibly((Statement)statement, (Function1 & Serializable & scala.Serializable)stmt -> {
            SnowflakePreparedStatement prepStmt = (SnowflakePreparedStatement)stmt;
            return prepStmt.executeAsyncQuery();
        });
    }

    public ResultSet executePreparedQueryInterruptibly(Connection conn, String sql) {
        return this.executePreparedQueryInterruptibly(conn.prepareStatement(sql));
    }

    public ResultSet executeQueryInterruptibly(Statement statement, String str) {
        return (ResultSet)this.executeInterruptibly(statement, (Function1 & Serializable & scala.Serializable)x$3 -> x$3.executeQuery(str));
    }

    public boolean executeInterruptibly(Statement statement, String str) {
        return BoxesRunTime.unboxToBoolean(this.executeInterruptibly(statement, (Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.execute(str))));
    }

    public ResultSet executeQueryInterruptibly(Connection conn, String sql) {
        Statement stmt = conn.createStatement();
        return this.executeQueryInterruptibly(stmt, sql);
    }

    public boolean executeInterruptibly(Connection conn, String sql) {
        Statement stmt = conn.createStatement();
        return this.executeInterruptibly(stmt, sql);
    }

    private <T> T executeInterruptibly(Statement statement, Function1<Statement, T> op) {
        Object object;
        try {
            this.log().debug(new StringBuilder(18).append("Running statement ").append(statement).toString());
            Future future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> op.apply((Object)statement), this.ec());
            object = Await$.MODULE$.result((Awaitable)future, (Duration)Duration$.MODULE$.Inf());
        }
        catch (InterruptedException e) {
            try {
                this.log().info(new StringBuilder(21).append("Cancelling statement ").append(statement).toString());
                statement.cancel();
                this.log().info("Cancelling succeeded");
                throw e;
            }
            catch (SQLException s) {
                this.log().error("Exception occurred while cancelling query", (Throwable)s);
                throw e;
            }
        }
        return (T)object;
    }

    private DataType getCatalystType(int sqlType, int precision, int scale, boolean signed) {
        BooleanType$ booleanType$;
        int n = sqlType;
        switch (n) {
            case 2003: {
                booleanType$ = null;
                break;
            }
            case -5: {
                if (signed) {
                    booleanType$ = LongType$.MODULE$;
                    break;
                }
                booleanType$ = new DecimalType(20, 0);
                break;
            }
            case 16: {
                booleanType$ = BooleanType$.MODULE$;
                break;
            }
            case 1: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case 2005: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case 70: {
                booleanType$ = null;
                break;
            }
            case 91: {
                booleanType$ = DateType$.MODULE$;
                break;
            }
            case 3: {
                if (precision != 0 || scale != 0) {
                    if (precision > DecimalType$.MODULE$.MAX_PRECISION()) {
                        booleanType$ = new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), scale + (precision - DecimalType$.MODULE$.MAX_SCALE()));
                        break;
                    }
                    booleanType$ = new DecimalType(precision, scale);
                    break;
                }
                booleanType$ = new DecimalType(38, 18);
                break;
            }
            case 2001: {
                booleanType$ = null;
                break;
            }
            case 8: {
                booleanType$ = DoubleType$.MODULE$;
                break;
            }
            case 6: {
                booleanType$ = FloatType$.MODULE$;
                break;
            }
            case 4: {
                if (signed) {
                    booleanType$ = IntegerType$.MODULE$;
                    break;
                }
                booleanType$ = LongType$.MODULE$;
                break;
            }
            case 2000: {
                booleanType$ = null;
                break;
            }
            case -16: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case -1: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case -15: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case 2011: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case 0: {
                booleanType$ = null;
                break;
            }
            case 2: {
                if (precision != 0 || scale != 0) {
                    booleanType$ = new DecimalType(precision, scale);
                    break;
                }
                booleanType$ = new DecimalType(38, 18);
                break;
            }
            case -9: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case 1111: {
                booleanType$ = null;
                break;
            }
            case 7: {
                booleanType$ = DoubleType$.MODULE$;
                break;
            }
            case 2006: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case -8: {
                booleanType$ = LongType$.MODULE$;
                break;
            }
            case 5: {
                booleanType$ = IntegerType$.MODULE$;
                break;
            }
            case 2009: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case 2002: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case 92: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case 93: {
                booleanType$ = TimestampType$.MODULE$;
                break;
            }
            case 2014: {
                booleanType$ = TimestampType$.MODULE$;
                break;
            }
            case -6: {
                booleanType$ = IntegerType$.MODULE$;
                break;
            }
            case 12: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case -2: {
                booleanType$ = BinaryType$.MODULE$;
                break;
            }
            default: {
                booleanType$ = null;
                break;
            }
        }
        BooleanType$ answer = booleanType$;
        if (answer == null) {
            throw new SQLException(new StringBuilder(17).append("Unsupported type ").append(sqlType).toString());
        }
        return answer;
    }

    public Telemetry getTelemetry(Connection conn) {
        return TelemetryClient.createTelemetry((Connection)conn);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$getConnector$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        if (tuple2 == null) return false;
        String k = (String)tuple2._1();
        Object v = tuple2._2();
        if (k == null) return false;
        if (v == null) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$getConnector$3(char x$2) {
        return x$2 >= ' ';
    }

    public static final /* synthetic */ boolean $anonfun$executePreparedInterruptibly$1(Statement stmt) {
        PreparedStatement prepStmt = (PreparedStatement)stmt;
        return prepStmt.execute();
    }

    public JDBCWrapper() {
        this.log().debug("Creating a new ExecutionContext");
        ThreadFactory threadFactory = new ThreadFactory(null){
            private final AtomicInteger count;

            /*
             * WARNING - void declaration
             */
            public Thread newThread(Runnable r) {
                void var2_2;
                Thread thread = new Thread(r);
                thread.setName(new StringBuilder(28).append("spark-snowflake-JDBCWrapper-").append(this.count.incrementAndGet()).toString());
                thread.setDaemon(true);
                return var2_2;
            }
            {
                this.count = new AtomicInteger();
            }
        };
        this.ec = ExecutionContext$.MODULE$.fromExecutorService(Executors.newCachedThreadPool(threadFactory));
    }
}

