/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake;

import java.io.Serializable;
import java.net.URI;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSSessionCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.BasicAWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.InstanceProfileCredentialsProvider;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageCredentialsSharedAccessSignature;
import net.snowflake.spark.snowflake.ConstantString;
import net.snowflake.spark.snowflake.EmptySnowflakeSQLStatement$;
import net.snowflake.spark.snowflake.FSType$;
import net.snowflake.spark.snowflake.Parameters;
import net.snowflake.spark.snowflake.S3Credentials;
import net.snowflake.spark.snowflake.SnowflakeSQLStatement;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.sql.SQLContext;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;

public final class CloudCredentialsUtils$ {
    public static CloudCredentialsUtils$ MODULE$;

    static {
        new CloudCredentialsUtils$();
    }

    public SnowflakeSQLStatement getSnowflakeCredentialsString(SQLContext sqlContext, Parameters.MergedParameters params) {
        SnowflakeSQLStatement snowflakeSQLStatement;
        Enumeration.Value value = params.rootTempDirStorageType();
        Enumeration.Value value2 = FSType$.MODULE$.LocalFile();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            throw new UnsupportedOperationException("only supports Azure and S3 stage");
        }
        Enumeration.Value value4 = FSType$.MODULE$.Azure();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            StorageCredentialsSharedAccessSignature creds = this.getAzureCreds(params);
            snowflakeSQLStatement = this.getSnowflakeCredentialsStringForAzure(creds);
        } else {
            Enumeration.Value value6 = FSType$.MODULE$.S3();
            Enumeration.Value value7 = value;
            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                AWSCredentials creds = this.getAWSCreds(sqlContext, params);
                snowflakeSQLStatement = this.getSnowflakeCredentialsStringForAWS(creds);
            } else {
                snowflakeSQLStatement = EmptySnowflakeSQLStatement$.MODULE$.apply();
            }
        }
        return snowflakeSQLStatement;
    }

    public SnowflakeSQLStatement getSnowflakeCredentialsStringForAWS(AWSCredentials creds) {
        String string;
        String awsAccessKey = creds.getAWSAccessKeyId();
        String awsSecretKey = creds.getAWSSecretKey();
        AWSCredentials aWSCredentials = creds;
        if (aWSCredentials instanceof AWSSessionCredentials) {
            AWSSessionCredentials aWSSessionCredentials = (AWSSessionCredentials)aWSCredentials;
            string = new StringBuilder(12).append("AWS_TOKEN='").append(aWSSessionCredentials.getSessionToken()).append("'").toString();
        } else {
            string = "";
        }
        String tokenString = string;
        return new ConstantString(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(112).append("\n       |CREDENTIALS = (\n       |    AWS_KEY_ID='").append(awsAccessKey).append("'\n       |    AWS_SECRET_KEY='").append(awsSecretKey).append("'\n       |    ").append(tokenString).append("\n       |)\n       |").toString())).stripMargin().trim()).$bang();
    }

    public SnowflakeSQLStatement getSnowflakeCredentialsStringForAzure(StorageCredentialsSharedAccessSignature creds) {
        String sasToken = creds.getToken();
        return new ConstantString(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(74).append("\n       |CREDENTIALS = (\n       |    AZURE_SAS_TOKEN='").append(sasToken).append("'\n       |)\n       |").toString())).stripMargin().trim()).$bang();
    }

    public AWSCredentials getAWSCreds(SQLContext sqlContext, Parameters.MergedParameters params) {
        Enumeration.Value value = params.rootTempDirStorageType();
        Enumeration.Value value2 = FSType$.MODULE$.S3();
        return !(value != null ? !value.equals(value2) : value2 != null) ? (AWSCredentials)params.temporaryAWSCredentials().getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.load(params.rootTempDir(), sqlContext.sparkContext().hadoopConfiguration())) : null;
    }

    public StorageCredentialsSharedAccessSignature getAzureCreds(Parameters.MergedParameters params) {
        Enumeration.Value value = params.rootTempDirStorageType();
        Enumeration.Value value2 = FSType$.MODULE$.Azure();
        return !(value != null ? !value.equals(value2) : value2 != null) ? (StorageCredentialsSharedAccessSignature)params.temporaryAzureStorageCredentials().getOrElse((Function0 & Serializable & scala.Serializable)() -> null) : null;
    }

    public AWSCredentials load(String tempPath, Configuration hadoopConfiguration) {
        BasicAWSCredentials basicAWSCredentials;
        URI uri = new URI(tempPath);
        String string = uri.getScheme();
        boolean bl = "s3".equals(string) ? true : "s3n".equals(string);
        if (bl) {
            S3Credentials creds = new S3Credentials();
            creds.initialize(uri, hadoopConfiguration);
            basicAWSCredentials = new BasicAWSCredentials(creds.getAccessKey(), creds.getSecretAccessKey());
        } else if ("s3a".equals(string)) {
            basicAWSCredentials = (AWSCredentials)Option$.MODULE$.apply((Object)uri.getUserInfo()).flatMap((Function1 & Serializable & scala.Serializable)userInfo -> {
                None$ none$;
                if (userInfo.contains(":")) {
                    String[] stringArray = userInfo.split(":");
                    Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                    if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) {
                        throw new MatchError((Object)stringArray);
                    }
                    String accessKey = (String)((SeqLike)option.get()).apply(0);
                    String secretKey = (String)((SeqLike)option.get()).apply(1);
                    Tuple2 tuple2 = new Tuple2((Object)accessKey, (Object)secretKey);
                    Tuple2 tuple22 = tuple2;
                    String accessKey2 = (String)tuple22._1();
                    String secretKey2 = (String)tuple22._2();
                    none$ = new Some((Object)new BasicAWSCredentials(accessKey2, secretKey2));
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            }).orElse((Function0 & Serializable & scala.Serializable)() -> {
                String accessKey = hadoopConfiguration.get("fs.s3a.access.key", null);
                String secretKey = hadoopConfiguration.get("fs.s3a.secret.key", null);
                return accessKey != null && secretKey != null ? new Some((Object)new BasicAWSCredentials(accessKey, secretKey)) : None$.MODULE$;
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> new InstanceProfileCredentialsProvider().getCredentials());
        } else if ("file".equals(string)) {
            basicAWSCredentials = null;
        } else {
            throw new IllegalArgumentException(new StringBuilder(46).append("Unrecognized scheme ").append(string).append("; expected s3, s3n, or s3a").toString());
        }
        return basicAWSCredentials;
    }

    private CloudCredentialsUtils$() {
        MODULE$ = this;
    }
}

