/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Timestamp;
import net.snowflake.spark.snowflake.Conversions$;
import net.snowflake.spark.snowflake.JDBCWrapper;
import net.snowflake.spark.snowflake.Parameters;
import net.snowflake.spark.snowflake.TableName;
import net.snowflake.spark.snowflake.Utils$;
import net.snowflake.spark.snowflake.io.SupportedFormat$;
import net.snowflake.spark.snowflake.io.package$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc!\u0002\u0005\n\u0001%\u0001\u0002\u0002C\f\u0001\u0005\u0003\u0005\u000b\u0011B\r\t\u000bu\u0001A\u0011\u0001\u0010\t\u000b\u0005\u0002A\u0011\u0001\u0012\t\u000bu\u0003A\u0011\u00010\t\u000bu\u0004A\u0011\u0002@\t\u000f\u0005\u0015\u0001\u0001\"\u0003\u0002\b!9\u0011Q\u0006\u0001\u0005\u0002\u0005=\"aD*o_^4G.Y6f/JLG/\u001a:\u000b\u0005)Y\u0011!C:o_^4G.Y6f\u0015\taQ\"A\u0003ta\u0006\u00148N\u0003\u0002\u000b\u001d)\tq\"A\u0002oKR\u001c\"\u0001A\t\u0011\u0005I)R\"A\n\u000b\u0003Q\tQa]2bY\u0006L!AF\n\u0003\r\u0005s\u0017PU3g\u0003-QGMY2Xe\u0006\u0004\b/\u001a:\u0004\u0001A\u0011!dG\u0007\u0002\u0013%\u0011A$\u0003\u0002\f\u0015\u0012\u00135i\u0016:baB,'/\u0001\u0004=S:LGO\u0010\u000b\u0003?\u0001\u0002\"A\u0007\u0001\t\u000b]\u0011\u0001\u0019A\r\u0002\tM\fg/\u001a\u000b\u0006G\u0019\u001at\t\u0014\t\u0003%\u0011J!!J\n\u0003\tUs\u0017\u000e\u001e\u0005\u0006O\r\u0001\r\u0001K\u0001\u000bgFd7i\u001c8uKb$\bCA\u00152\u001b\u0005Q#BA\u0016-\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00195R!AL\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0014aA8sO&\u0011!G\u000b\u0002\u000b'Fc5i\u001c8uKb$\b\"\u0002\u001b\u0004\u0001\u0004)\u0014\u0001\u00023bi\u0006\u0004\"A\u000e#\u000f\u0005]\u0012eB\u0001\u001dB\u001d\tI\u0004I\u0004\u0002;\u007f9\u00111HP\u0007\u0002y)\u0011Q\bG\u0001\u0007yI|w\u000e\u001e \n\u0003AJ!AL\u0018\n\u00051i\u0013BA\u0016-\u0013\t\u0019%&A\u0004qC\u000e\\\u0017mZ3\n\u0005\u00153%!\u0003#bi\u00064%/Y7f\u0015\t\u0019%\u0006C\u0003I\u0007\u0001\u0007\u0011*\u0001\u0005tCZ,Wj\u001c3f!\tI#*\u0003\u0002LU\tA1+\u0019<f\u001b>$W\rC\u0003N\u0007\u0001\u0007a*\u0001\u0004qCJ\fWn\u001d\t\u0003\u001fjs!\u0001\u0015-\u000f\u0005E;fB\u0001*W\u001d\t\u0019VK\u0004\u0002<)&\tq\"\u0003\u0002\u000b\u001d%\u0011A\"D\u0005\u0003\u0015-I!!W\u0005\u0002\u0015A\u000b'/Y7fi\u0016\u00148/\u0003\u0002\\9\n\u0001R*\u001a:hK\u0012\u0004\u0016M]1nKR,'o\u001d\u0006\u00033&\ta\u0002Z1uC\u001a\u0013\u0018-\\3U_J#E\tF\u0003`[:|\u0007\u000fE\u0002aG\u0016l\u0011!\u0019\u0006\u0003E2\n1A\u001d3e\u0013\t!\u0017MA\u0002S\t\u0012\u0003\"A\u001a6\u000f\u0005\u001dD\u0007CA\u001e\u0014\u0013\tI7#\u0001\u0004Qe\u0016$WMZ\u0005\u0003W2\u0014aa\u0015;sS:<'BA5\u0014\u0011\u00159C\u00011\u0001)\u0011\u0015!D\u00011\u00016\u0011\u0015iE\u00011\u0001O\u0011\u0015\tH\u00011\u0001s\u0003\u00191wN]7biB\u00111O\u001f\b\u0003i^t!\u0001U;\n\u0005YL\u0011AA5p\u0013\tA\u00180A\bTkB\u0004xN\u001d;fI\u001a{'/\\1u\u0015\t1\u0018\"\u0003\u0002|y\ny1+\u001e9q_J$X\r\u001a$pe6\fGO\u0003\u0002ys\u0006!\"/Z7pm\u0016,6/\u001a7fgN\u001cu\u000e\\;n]N$B!N@\u0002\u0004!1\u0011\u0011A\u0003A\u0002U\n\u0011\u0002Z1uC\u001a\u0013\u0018-\\3\t\u000b5+\u0001\u0019\u0001(\u0002#\u001d,g.\u001a:bi\u0016\u001cu\u000e\\;n]6\u000b\u0007\u000f\u0006\u0005\u0002\n\u0005=\u0011qDA\u0012!\u00151\u00171B3f\u0013\r\ti\u0001\u001c\u0002\u0004\u001b\u0006\u0004\bbBA\t\r\u0001\u0007\u00111C\u0001\u0005MJ|W\u000e\u0005\u0003\u0002\u0016\u0005mQBAA\f\u0015\r\tIBK\u0001\u0006if\u0004Xm]\u0005\u0005\u0003;\t9B\u0001\u0006TiJ,8\r\u001e+za\u0016Dq!!\t\u0007\u0001\u0004\t\u0019\"\u0001\u0002u_\"9\u0011Q\u0005\u0004A\u0002\u0005\u001d\u0012a\u0003:fa>\u0014H/\u0012:s_J\u00042AEA\u0015\u0013\r\tYc\u0005\u0002\b\u0005>|G.Z1o\u0003Y9WM\\\"p]Z,'o]5p]\u001a+hn\u0019;j_:\u001cH\u0003BA\u0019\u0003\u0007\u0002RAEA\u001a\u0003oI1!!\u000e\u0014\u0005\u0015\t%O]1z!\u001d\u0011\u0012\u0011HA\u001f\u0003{I1!a\u000f\u0014\u0005%1UO\\2uS>t\u0017\u0007E\u0002\u0013\u0003\u007fI1!!\u0011\u0014\u0005\r\te.\u001f\u0005\b\u0003\u000b:\u0001\u0019AA\n\u0003\u0019\u00198\r[3nC\u0002")
public class SnowflakeWriter {
    private final JDBCWrapper jdbcWrapper;

    public void save(SQLContext sqlContext, Dataset<Row> data, SaveMode saveMode, Parameters.MergedParameters params) {
        Option<Map<String, String>> option;
        Enumeration.Value format = Utils$.MODULE$.containVariant(data.schema()) ? SupportedFormat$.MODULE$.JSON() : SupportedFormat$.MODULE$.CSV();
        None$ toSchema = None$.MODULE$;
        if (params.columnMap().isEmpty()) {
            String string = params.columnMapping();
            String string2 = "name";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                try (Connection conn = this.jdbcWrapper.getConnector(params);){
                    toSchema = new Some((Object)SnowflakeWriter.removeQuote$1(this.jdbcWrapper.resolveTable(conn, ((TableName)params.table().get()).name(), params)));
                    String string3 = params.columnMismatchBehavior();
                    String string4 = "error";
                    params.setColumnMap(this.generateColumnMap(data.schema(), (StructType)toSchema.get(), !(string3 != null ? !string3.equals(string4) : string4 != null)));
                }
            }
        }
        if ((option = params.columnMap()) instanceof Some) {
            Some some = (Some)option;
            Map map = (Map)some.value();
            if (map.isEmpty()) {
                throw new UnsupportedOperationException(new StringOps(Predef$.MODULE$.augmentString("\n               |No column name matched between Snowflake Table and Spark Dataframe.\n               |Please check the column names or manually assign the ColumnMap\n         ")).stripMargin());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        Dataset<Row> output = this.removeUselessColumns(data, params);
        RDD<String> strRDD = this.dataFrameToRDD(sqlContext, output, params, format);
        package$.MODULE$.writeRDD(params, strRDD, output.schema(), saveMode, format, package$.MODULE$.writeRDD$default$6());
    }

    public RDD<String> dataFrameToRDD(SQLContext sqlContext, Dataset<Row> data, Parameters.MergedParameters params, Enumeration.Value format) {
        RDD rDD;
        SparkSession spark = sqlContext.sparkSession();
        Enumeration.Value value = format;
        Enumeration.Value value2 = SupportedFormat$.MODULE$.CSV();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            Function1<Object, Object>[] conversionFunction = this.genConversionFunctions(data.schema());
            rDD = data.rdd().map((Function1 & Serializable & scala.Serializable)row -> ((TraversableOnce)((TraversableLike)row.toSeq().zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])conversionFunction), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object element = tuple2._1();
                Function1 func = (Function1)tuple2._2();
                Object object = func.apply(element);
                return object;
            }, Seq$.MODULE$.canBuildFrom())).mkString("|"), ClassTag$.MODULE$.apply(String.class));
        } else {
            Enumeration.Value value4 = SupportedFormat$.MODULE$.JSON();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                rDD = data.toJSON().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString(), spark.implicits().newStringEncoder()).rdd();
            } else {
                throw new MatchError((Object)value);
            }
        }
        return rDD;
    }

    private Dataset<Row> removeUselessColumns(Dataset<Row> dataFrame, Parameters.MergedParameters params) {
        Dataset dataset;
        Option<Map<String, String>> option = params.columnMap();
        if (option instanceof Some) {
            Dataset dataset2;
            Some some = (Some)option;
            Map map = (Map)some.value();
            Seq names = map.keys().toSeq();
            try {
                dataset2 = dataFrame.select((String)names.head(), (Seq)names.tail());
            }
            catch (AnalysisException e) {
                throw new IllegalArgumentException(new StringBuilder(43).append("Incorrect column name when column mapping: ").append(e.toString()).toString());
            }
            dataset = dataset2;
        } else {
            dataset = dataFrame;
        }
        return dataset;
    }

    private Map<String, String> generateColumnMap(StructType from, StructType to, boolean reportError) {
        HashMap result = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        HashMap fromNameMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        HashMap toNameMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        from.foreach((Function1 & Serializable & scala.Serializable)field -> {
            SnowflakeWriter.$anonfun$generateColumnMap$2(fromNameMap, to, field);
            return BoxedUnit.UNIT;
        });
        to.foreach((Function1 & Serializable & scala.Serializable)field -> {
            SnowflakeWriter.$anonfun$generateColumnMap$3(toNameMap, from, field);
            return BoxedUnit.UNIT;
        });
        if (reportError && fromNameMap.size() != toNameMap.size()) {
            throw new UnsupportedOperationException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(108).append("\n           |column number of Spark Dataframe (").append(fromNameMap.size()).append(") doesn't match column number of Snowflake Table (").append(toNameMap.size()).append(")\n         ").toString())).stripMargin());
        }
        fromNameMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String index = (String)tuple2._1();
                String name = (String)tuple2._2();
                if (toNameMap.contains((Object)index)) {
                    boxedUnit = result.put((Object)name, toNameMap.apply((Object)index));
                } else {
                    if (reportError) {
                        throw new UnsupportedOperationException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(64).append("\n             |can't find column ").append(name).append(" in Snowflake Table\n           ").toString())).stripMargin());
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return boxedUnit2;
        });
        return result.toMap(Predef$.MODULE$.$conforms());
    }

    public Function1<Object, Object>[] genConversionFunctions(StructType schema) {
        return (Function1[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)field -> {
            DataType dataType = field.dataType();
            Function1 & Serializable & scala.Serializable intersect = DateType$.MODULE$.equals(dataType) ? (Function1 & Serializable & scala.Serializable)v -> {
                String string;
                Object object = v;
                if (object == null) {
                    string = "";
                } else if (object instanceof Timestamp) {
                    Timestamp timestamp = (Timestamp)object;
                    string = Conversions$.MODULE$.formatTimestamp(timestamp);
                } else if (object instanceof Date) {
                    Date date = (Date)object;
                    string = Conversions$.MODULE$.formatDate(date);
                } else {
                    throw new MatchError(object);
                }
                return string;
            } : (TimestampType$.MODULE$.equals(dataType) ? (Function1 & Serializable & scala.Serializable)v -> v == null ? "" : Conversions$.MODULE$.formatTimestamp((Timestamp)v) : (StringType$.MODULE$.equals(dataType) ? (Function1 & Serializable & scala.Serializable)v -> v == null ? "" : Conversions$.MODULE$.formatString((String)v) : (Function1 & Serializable & scala.Serializable)v -> Conversions$.MODULE$.formatAny(v)));
            return intersect;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function1.class)));
    }

    private static final StructType removeQuote$1(StructType schema) {
        return new StructType((StructField[])((TraversableOnce)schema.map((Function1 & Serializable & scala.Serializable)field -> new StructField(field.name().startsWith("\"") && field.name().endsWith("\"") ? field.name().substring(1, field.name().length() - 1) : field.name(), field.dataType(), field.nullable(), StructField$.MODULE$.apply$default$4()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(StructField.class)));
    }

    public static final /* synthetic */ boolean $anonfun$generateColumnMap$1(String name$1, StructField x$2) {
        return x$2.name().equalsIgnoreCase(name$1);
    }

    private static final boolean containsColumn$1(String name, StructType list) {
        return list.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SnowflakeWriter.$anonfun$generateColumnMap$1(name, x$2)));
    }

    public static final /* synthetic */ void $anonfun$generateColumnMap$2(HashMap fromNameMap$1, StructType to$1, StructField field) {
        Option option = fromNameMap$1.put((Object)field.name().toLowerCase(), (Object)field.name());
        if (option instanceof Some) {
            if (SnowflakeWriter.containsColumn$1(field.name(), to$1)) {
                throw new UnsupportedOperationException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(77).append("\n               |Duplicated column names in Spark DataFrame: ").append(fromNameMap$1.apply((Object)field.name().toLowerCase())).append(", ").append(field.name()).append("\n             ").toString())).stripMargin());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$generateColumnMap$3(HashMap toNameMap$1, StructType from$1, StructField field) {
        Option option = toNameMap$1.put((Object)field.name().toLowerCase(), (Object)field.name());
        if (option instanceof Some) {
            if (SnowflakeWriter.containsColumn$1(field.name(), from$1)) {
                throw new UnsupportedOperationException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(77).append("\n               |Duplicated column names in Snowflake table: ").append(toNameMap$1.apply((Object)field.name().toLowerCase())).append(", ").append(field.name()).append("\n             ").toString())).stripMargin());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public SnowflakeWriter(JDBCWrapper jdbcWrapper) {
        this.jdbcWrapper = jdbcWrapper;
    }
}

