/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake.io;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import net.snowflake.spark.snowflake.ConstantString;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper$;
import net.snowflake.spark.snowflake.EmptySnowflakeSQLStatement$;
import net.snowflake.spark.snowflake.Parameters;
import net.snowflake.spark.snowflake.SnowflakeSQLStatement;
import net.snowflake.spark.snowflake.TableName;
import net.snowflake.spark.snowflake.Utils$;
import net.snowflake.spark.snowflake.io.CloudStorage;
import net.snowflake.spark.snowflake.io.CloudStorageOperations$;
import net.snowflake.spark.snowflake.io.SupportedFormat$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;

public final class StageWriter$ {
    public static StageWriter$ MODULE$;
    private final Logger log;

    static {
        new StageWriter$();
    }

    private Logger log() {
        return this.log;
    }

    public void writeToStage(RDD<String> rdd, StructType schema, SaveMode saveMode, Parameters.MergedParameters params, Enumeration.Value format) {
        if (params.table().isEmpty()) {
            throw new IllegalArgumentException("For save operations you must specify a Snowflake table name with the 'dbtable' parameter");
        }
        SnowflakeSQLStatement prologueSql = Utils$.MODULE$.genPrologueSql(params);
        this.log().debug(prologueSql.toString());
        try (Connection conn = DefaultJDBCWrapper$.MODULE$.getConnector(params);){
            prologueSql.execute(params.bindVariableEnabled(), conn);
            Tuple2<CloudStorage, String> tuple2 = CloudStorageOperations$.MODULE$.createStorageClient(params, conn, true, (Option<String>)None$.MODULE$);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            CloudStorage storage = (CloudStorage)tuple2._1();
            String stage = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)storage, (Object)stage);
            Tuple2 tuple23 = tuple22;
            CloudStorage storage2 = (CloudStorage)tuple23._1();
            String stage2 = (String)tuple23._2();
            List<String> filesToCopy = storage2.upload(rdd, format, (Option<String>)None$.MODULE$, true);
            this.writeToTable(conn, schema, saveMode, params, ((String)filesToCopy.head()).substring(0, ((String)filesToCopy.head()).indexOf("/")), stage2, format);
        }
    }

    private void writeToTable(Connection conn, StructType schema, SaveMode saveMode, Parameters.MergedParameters params, String file, String tempStage, Enumeration.Value format) {
        TableName table = (TableName)params.table().get();
        TableName tempTable = new TableName(new StringBuilder(9).append(table.name().replace('\"', '_')).append("_staging_").append(((Object)BoxesRunTime.boxToInteger((int)Math.abs(Random$.MODULE$.nextInt()))).toString()).toString());
        SaveMode saveMode2 = saveMode;
        SaveMode saveMode3 = SaveMode.Overwrite;
        TableName targetTable = !(saveMode2 != null ? !saveMode2.equals(saveMode3) : saveMode3 != null) && params.useStagingTable() ? tempTable : table;
        try {
            Object object;
            SaveMode saveMode4 = saveMode;
            SaveMode saveMode5 = SaveMode.Overwrite;
            if (!(saveMode4 != null ? !saveMode4.equals(saveMode5) : saveMode5 != null) && DefaultJDBCWrapper$.MODULE$.tableExists(conn, table.toString())) {
                if (params.useStagingTable()) {
                    if (params.truncateTable()) {
                        DefaultJDBCWrapper.DataBaseOperations qual$1 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                        String x$1 = tempTable.name();
                        String x$2 = table.name();
                        boolean x$3 = qual$1.createTableLike$default$3();
                        qual$1.createTableLike(x$1, x$2, x$3);
                    }
                    object = BoxedUnit.UNIT;
                } else if (params.truncateTable()) {
                    DefaultJDBCWrapper.DataBaseOperations qual$2 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                    String x$4 = table.name();
                    boolean x$5 = qual$2.truncateTable$default$2();
                    qual$2.truncateTable(x$4, x$5);
                    object = BoxedUnit.UNIT;
                } else {
                    DefaultJDBCWrapper.DataBaseOperations qual$3 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                    String x$6 = table.name();
                    boolean x$7 = qual$3.dropTable$default$2();
                    object = BoxesRunTime.boxToBoolean((boolean)qual$3.dropTable(x$6, x$7));
                }
            } else {
                object = BoxedUnit.UNIT;
            }
            DefaultJDBCWrapper.DataBaseOperations qual$4 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
            String x$8 = targetTable.name();
            StructType x$9 = schema;
            Parameters.MergedParameters x$10 = params;
            boolean x$11 = qual$4.createTable$default$4();
            boolean x$12 = qual$4.createTable$default$5();
            boolean x$13 = qual$4.createTable$default$6();
            qual$4.createTable(x$8, x$9, x$10, x$11, x$12, x$13);
            Utils$.MODULE$.executePreActions(DefaultJDBCWrapper$.MODULE$, conn, params, (Option<TableName>)Option$.MODULE$.apply((Object)targetTable));
            SnowflakeSQLStatement copyStatement = this.copySql(schema, saveMode, params, targetTable, file, tempStage, format, conn);
            this.log().debug(Utils$.MODULE$.sanitizeQueryText(copyStatement.toString()));
            ResultSet resultSet = copyStatement.execute(params.bindVariableEnabled(), conn);
            if (params.continueOnError()) {
                long rowSkipped = 0L;
                while (resultSet.next()) {
                    rowSkipped += resultSet.getLong("rows_parsed") - resultSet.getLong("rows_loaded");
                }
                this.log().error(new StringBuilder(35).append("ON_ERROR: Continue -> Skipped ").append(rowSkipped).append(" rows").toString());
            }
            Utils$.MODULE$.setLastCopyLoad(copyStatement.toString());
            Utils$.MODULE$.executePostActions(DefaultJDBCWrapper$.MODULE$, conn, params, (Option<TableName>)Option$.MODULE$.apply((Object)targetTable));
            SaveMode saveMode6 = saveMode;
            SaveMode saveMode7 = SaveMode.Overwrite;
            if (!(saveMode6 != null ? !saveMode6.equals(saveMode7) : saveMode7 != null) && params.useStagingTable()) {
                boolean x$15;
                String x$14;
                DefaultJDBCWrapper.DataBaseOperations qual$5 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                if (qual$5.tableExists(x$14 = table.toString(), x$15 = qual$5.tableExists$default$2())) {
                    DefaultJDBCWrapper.DataBaseOperations qual$6 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                    String x$16 = table.name();
                    String x$17 = tempTable.name();
                    boolean x$18 = qual$6.swapTable$default$3();
                    qual$6.swapTable(x$16, x$17, x$18);
                    DefaultJDBCWrapper.DataBaseOperations qual$7 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                    String x$19 = tempTable.name();
                    boolean x$20 = qual$7.dropTable$default$2();
                    qual$7.dropTable(x$19, x$20);
                } else {
                    DefaultJDBCWrapper.DataBaseOperations qual$8 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                    String x$21 = table.name();
                    String x$22 = tempTable.name();
                    boolean x$23 = qual$8.renameTable$default$3();
                    qual$8.renameTable(x$21, x$22, x$23);
                }
            } else {
                conn.commit();
            }
        }
        catch (Exception e) {
            Object object;
            SaveMode saveMode8 = saveMode;
            SaveMode saveMode9 = SaveMode.Overwrite;
            if (!(saveMode8 != null ? !saveMode8.equals(saveMode9) : saveMode9 != null) && params.useStagingTable()) {
                TableName tableName = targetTable;
                TableName tableName2 = tempTable;
                if (!(tableName != null ? !((Object)tableName).equals(tableName2) : tableName2 != null)) {
                    DefaultJDBCWrapper.DataBaseOperations qual$9 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                    String x$24 = tempTable.name();
                    boolean x$25 = qual$9.dropTable$default$2();
                    object = BoxesRunTime.boxToBoolean((boolean)qual$9.dropTable(x$24, x$25));
                } else {
                    object = BoxedUnit.UNIT;
                }
            } else {
                object = BoxedUnit.UNIT;
            }
            this.log().error(new StringBuilder(49).append("Error occurred while loading files to Snowflake: ").append(e).toString());
            throw e;
        }
    }

    private SnowflakeSQLStatement copySql(StructType schema, SaveMode saveMode, Parameters.MergedParameters params, TableName table, String file, String tempStage, Enumeration.Value format, Connection conn) {
        SnowflakeSQLStatement snowflakeSQLStatement;
        None$ none$;
        SaveMode saveMode2 = saveMode;
        SaveMode saveMode3 = SaveMode.Append;
        if ((saveMode2 == null ? saveMode3 != null : !saveMode2.equals(saveMode3)) && params.columnMap().isDefined()) {
            throw new UnsupportedOperationException("The column mapping only works in append mode.");
        }
        SnowflakeSQLStatement fromString = new ConstantString(new StringBuilder(7).append("FROM @").append(tempStage).append("/").append(file).toString()).$bang();
        Option<Map<String, String>> option = params.columnMap();
        if (option instanceof Some) {
            Some some = (Some)option;
            Map map = (Map)some.value();
            none$ = new Some(map.toList().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2;
                Tuple2 tuple22 = x0$1;
                if (tuple22 != null) {
                    String key = (String)tuple22._1();
                    String value = (String)tuple22._2();
                    try {
                        tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)(schema.fieldIndex(key) + 1)), (Object)value);
                    }
                    catch (Exception e) {
                        MODULE$.log().error(new StringBuilder(37).append("Error occurred while column mapping: ").append(e).toString());
                        throw e;
                    }
                } else {
                    throw new MatchError((Object)tuple22);
                }
                Tuple2 tuple23 = tuple2;
                return tuple23;
            }, List$.MODULE$.canBuildFrom()));
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        None$ mappingList = none$;
        SnowflakeSQLStatement mappingToString = StageWriter$.getMappingToString$1((Option)mappingList, format, conn, table, params);
        SnowflakeSQLStatement mappingFromString = StageWriter$.getMappingFromString$1((Option)mappingList, fromString, format, schema);
        Enumeration.Value value = format;
        Enumeration.Value value2 = SupportedFormat$.MODULE$.CSV();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            snowflakeSQLStatement = new ConstantString(new StringOps(Predef$.MODULE$.augmentString("\n               |FILE_FORMAT = (\n               |    TYPE=CSV\n               |    FIELD_DELIMITER='|'\n               |    NULL_IF=()\n               |    FIELD_OPTIONALLY_ENCLOSED_BY='\"'\n               |    TIMESTAMP_FORMAT='TZHTZM YYYY-MM-DD HH24:MI:SS.FF3'\n               |    DATE_FORMAT='TZHTZM YYYY-MM-DD HH24:MI:SS.FF3'\n               |  )\n           ")).stripMargin()).$bang();
        } else {
            Enumeration.Value value4 = SupportedFormat$.MODULE$.JSON();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                snowflakeSQLStatement = new ConstantString(new StringOps(Predef$.MODULE$.augmentString("\n               |FILE_FORMAT = (\n               |    TYPE = JSON\n               |)\n           ")).stripMargin()).$bang();
            } else {
                throw new MatchError((Object)value);
            }
        }
        SnowflakeSQLStatement formatString = snowflakeSQLStatement;
        SnowflakeSQLStatement truncateCol = params.truncateColumns() ? new ConstantString("TRUNCATECOLUMNS = TRUE").$bang() : EmptySnowflakeSQLStatement$.MODULE$.apply();
        SnowflakeSQLStatement purge = params.purge() ? new ConstantString("PURGE = TRUE").$bang() : EmptySnowflakeSQLStatement$.MODULE$.apply();
        SnowflakeSQLStatement onError = params.continueOnError() ? new ConstantString("ON_ERROR = CONTINUE").$bang() : EmptySnowflakeSQLStatement$.MODULE$.apply();
        return new ConstantString("copy into").$plus(table.name()).$plus(mappingToString).$plus(mappingFromString).$plus(formatString).$plus(truncateCol).$plus(purge).$plus(onError);
    }

    private static final SnowflakeSQLStatement getMappingToString$1(Option list, Enumeration.Value format$1, Connection conn$1, TableName table$1, Parameters.MergedParameters params$1) {
        SnowflakeSQLStatement snowflakeSQLStatement;
        Enumeration.Value value = format$1;
        Enumeration.Value value2 = SupportedFormat$.MODULE$.JSON();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            StructType tableSchema = DefaultJDBCWrapper$.MODULE$.resolveTable(conn$1, table$1.name(), params$1);
            snowflakeSQLStatement = list.isEmpty() || ((SeqLike)list.get()).isEmpty() ? new ConstantString("(").$plus(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tableSchema.fields())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",")).$plus(")") : new ConstantString("(").$plus(((TraversableOnce)((List)list.get()).map((Function1 & Serializable & scala.Serializable)x -> params$1.keepOriginalColumnNameCase() ? Utils$.MODULE$.quotedNameIgnoreCase((String)x._2()) : Utils$.MODULE$.ensureQuoted((String)x._2()), List$.MODULE$.canBuildFrom())).mkString(", ")).$plus(")");
        } else {
            Enumeration.Value value4 = SupportedFormat$.MODULE$.CSV();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                snowflakeSQLStatement = list.isEmpty() || ((SeqLike)list.get()).isEmpty() ? EmptySnowflakeSQLStatement$.MODULE$.apply() : new ConstantString("(").$plus(((TraversableOnce)((List)list.get()).map((Function1 & Serializable & scala.Serializable)x -> params$1.keepOriginalColumnNameCase() ? Utils$.MODULE$.quotedNameIgnoreCase((String)x._2()) : Utils$.MODULE$.ensureQuoted((String)x._2()), List$.MODULE$.canBuildFrom())).mkString(", ")).$plus(")");
            } else {
                throw new MatchError((Object)value);
            }
        }
        return snowflakeSQLStatement;
    }

    private static final SnowflakeSQLStatement getMappingFromString$1(Option list, SnowflakeSQLStatement from, Enumeration.Value format$1, StructType schema$1) {
        SnowflakeSQLStatement snowflakeSQLStatement;
        Enumeration.Value value = format$1;
        Enumeration.Value value2 = SupportedFormat$.MODULE$.JSON();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            SnowflakeSQLStatement snowflakeSQLStatement2;
            if (list.isEmpty() || ((SeqLike)list.get()).isEmpty()) {
                String names = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema$1.fields())).map((Function1 & Serializable & scala.Serializable)x -> "parse_json($1):".concat(x.name()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",");
                snowflakeSQLStatement2 = new ConstantString("from (select").$plus(names).$plus(from).$plus("tmp)");
            } else {
                snowflakeSQLStatement2 = new ConstantString("from (select").$plus(((TraversableOnce)((List)list.get()).map((Function1 & Serializable & scala.Serializable)x -> "parse_json($1):".concat(schema$1.apply(x._1$mcI$sp() - 1).name()), List$.MODULE$.canBuildFrom())).mkString(", ")).$plus(from).$plus("tmp)");
            }
            snowflakeSQLStatement = snowflakeSQLStatement2;
        } else {
            Enumeration.Value value4 = SupportedFormat$.MODULE$.CSV();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                snowflakeSQLStatement = list.isEmpty() || ((SeqLike)list.get()).isEmpty() ? from : new ConstantString("from (select").$plus(((TraversableOnce)((List)list.get()).map((Function1 & Serializable & scala.Serializable)x -> "tmp.$".concat(((Object)BoxesRunTime.boxToInteger((int)x._1$mcI$sp())).toString()), List$.MODULE$.canBuildFrom())).mkString(", ")).$plus(from).$plus("tmp)");
            } else {
                throw new MatchError((Object)value);
            }
        }
        return snowflakeSQLStatement;
    }

    private StageWriter$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

