/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake.streaming;

import java.io.Serializable;
import java.sql.Connection;
import net.snowflake.spark.snowflake.ConstantString;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper$;
import net.snowflake.spark.snowflake.Parameters;
import net.snowflake.spark.snowflake.SnowflakeSQLStatement;
import net.snowflake.spark.snowflake.TableName;
import net.snowflake.spark.snowflake.Utils$;
import net.snowflake.spark.snowflake.io.CloudStorage;
import net.snowflake.spark.snowflake.io.SupportedFormat$;
import net.snowflake.spark.snowflake.streaming.SnowflakeIngestService;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class package$ {
    public static package$ MODULE$;
    private final Logger LOGGER;
    private final int SLEEP_TIME;
    private final int TIME_OUT;
    private final HashMap<String, SnowflakeIngestService> pipeList;

    static {
        new package$();
    }

    private Logger LOGGER() {
        return this.LOGGER;
    }

    private int SLEEP_TIME() {
        return this.SLEEP_TIME;
    }

    private int TIME_OUT() {
        return this.TIME_OUT;
    }

    private HashMap<String, SnowflakeIngestService> pipeList() {
        return this.pipeList;
    }

    public SnowflakeIngestService openIngestionService(Parameters.MergedParameters param, String pipeName, Enumeration.Value format, StructType schema, CloudStorage storage, Connection conn) {
        this.LOGGER().debug(new StringBuilder(41).append("create new ingestion service, pipe name: ").append(pipeName).toString());
        BooleanRef pipeDropped = BooleanRef.create((boolean)false);
        Future checkPrevious = Future$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            while (MODULE$.pipeList().contains((Object)pipeName)) {
                MODULE$.LOGGER().debug("waiting previous pipe dropped");
                Thread.sleep(MODULE$.SLEEP_TIME());
            }
            MODULE$.LOGGER().debug("previous pipe dropped");
            pipeDropped$1.elem = true;
            return pipeDropped$1.elem;
        }, ExecutionContext.Implicits$.MODULE$.global());
        Await$.MODULE$.result((Awaitable)checkPrevious, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(this.TIME_OUT())).minutes());
        if (pipeDropped.elem) {
            DefaultJDBCWrapper.DataBaseOperations qual$1 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
            String x$1 = ((TableName)param.table().get()).name();
            StructType x$2 = schema;
            Parameters.MergedParameters x$3 = param;
            boolean x$4 = false;
            boolean x$5 = qual$1.createTable$default$5();
            boolean x$6 = qual$1.createTable$default$6();
            qual$1.createTable(x$1, x$2, x$3, x$4, x$5, x$6);
            SnowflakeSQLStatement copy = new ConstantString(this.copySql(param, conn, format)).$bang();
            if (this.verifyPipe(conn, pipeName, copy.toString())) {
                this.LOGGER().info(new StringBuilder(12).append("reuse pipe: ").append(pipeName).toString());
            } else {
                DefaultJDBCWrapper.DataBaseOperations qual$2 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                String x$7 = pipeName;
                SnowflakeSQLStatement x$8 = copy;
                boolean x$9 = true;
                boolean x$10 = qual$2.createPipe$default$4();
                qual$2.createPipe(x$7, x$8, x$9, x$10);
            }
        } else {
            this.LOGGER().error("waiting pipe dropped time out");
            throw new IllegalStateException(new StringBuilder(42).append("Waiting pipe dropped time out, pipe name: ").append(pipeName).toString());
        }
        SnowflakeIngestService ingestion = new SnowflakeIngestService(param, pipeName, storage, conn);
        this.pipeList().put((Object)pipeName, (Object)ingestion);
        return ingestion;
    }

    public void closeIngestionService(String pipeName) {
        this.LOGGER().debug(new StringBuilder(38).append("closing ingestion service, pipe name: ").append(pipeName).toString());
        if (this.pipeList().contains((Object)pipeName)) {
            ((SnowflakeIngestService)this.pipeList().apply((Object)pipeName)).close();
            this.pipeList().remove((Object)pipeName);
            this.LOGGER().debug(new StringBuilder(37).append("ingestion service closed, pipe name: ").append(pipeName).toString());
        } else {
            this.LOGGER().error(new StringBuilder(40).append("ingestion service not found, pipe name: ").append(pipeName).toString());
        }
    }

    public void closeAllIngestionService() {
        this.LOGGER().debug("closing ingestion service");
        this.pipeList().par().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            package$.$anonfun$closeAllIngestionService$1(x$1);
            return BoxedUnit.UNIT;
        });
        this.LOGGER().debug("all ingestion service closed");
    }

    private String copySql(Parameters.MergedParameters param, Connection conn, Enumeration.Value format) {
        String string;
        None$ none$;
        TableName tableName = (TableName)param.table().get();
        String stageName = (String)param.streamingStage().get();
        StructType tableSchema = DefaultJDBCWrapper$.MODULE$.resolveTable(conn, tableName.toString(), param);
        String fromString = new StringBuilder(6).append("FROM @").append(stageName).toString();
        Option<Map<String, String>> option = param.columnMap();
        if (option instanceof Some) {
            Some some = (Some)option;
            Map map = (Map)some.value();
            none$ = new Some(map.toList().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2;
                Tuple2 tuple22 = x0$1;
                if (tuple22 != null) {
                    String key = (String)tuple22._1();
                    String value = (String)tuple22._2();
                    try {
                        tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)(tableSchema.fieldIndex(key) + 1)), (Object)value);
                    }
                    catch (Exception e) {
                        MODULE$.LOGGER().error(new StringBuilder(37).append("Error occurred while column mapping: ").append(e).toString());
                        throw e;
                    }
                } else {
                    throw new MatchError((Object)tuple22);
                }
                Tuple2 tuple23 = tuple2;
                return tuple23;
            }, List$.MODULE$.canBuildFrom()));
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        None$ mappingList = none$;
        String mappingToString = package$.getMappingToString$1((Option)mappingList, format, conn, tableName, param);
        String mappingFromString = package$.getMappingFromString$1((Option)mappingList, fromString, format, tableSchema);
        Enumeration.Value value = format;
        Enumeration.Value value2 = SupportedFormat$.MODULE$.CSV();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            string = new StringOps(Predef$.MODULE$.augmentString("\n             |FILE_FORMAT = (\n             |    TYPE=CSV\n             |    FIELD_DELIMITER='|'\n             |    NULL_IF=()\n             |    FIELD_OPTIONALLY_ENCLOSED_BY='\"'\n             |    TIMESTAMP_FORMAT='TZHTZM YYYY-MM-DD HH24:MI:SS.FF3'\n             |  )\n           ")).stripMargin();
        } else {
            Enumeration.Value value4 = SupportedFormat$.MODULE$.JSON();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                string = new StringOps(Predef$.MODULE$.augmentString("\n             |FILE_FORMAT = (\n             |    TYPE = JSON\n             |)\n           ")).stripMargin();
            } else {
                throw new MatchError((Object)value);
            }
        }
        String formatString = string;
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(43).append("\n       |COPY INTO ").append(tableName).append(" ").append(mappingToString).append("\n       |").append(mappingFromString).append("\n       |").append(formatString).append("\n    ").toString())).stripMargin().trim();
    }

    public boolean verifyPipe(Connection conn, String pipeName, String copyStatement) {
        boolean bl;
        boolean x$2;
        String x$1;
        DefaultJDBCWrapper.DataBaseOperations qual$1 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
        Option<String> option = qual$1.pipeDefinition(x$1 = pipeName, x$2 = qual$1.pipeDefinition$default$2());
        if (option instanceof Some) {
            Some some = (Some)option;
            String str = (String)some.value();
            bl = str.trim().equals(copyStatement.trim());
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$closeAllIngestionService$1(Tuple2 x$1) {
        ((SnowflakeIngestService)x$1._2()).close();
    }

    private static final String getMappingToString$1(Option list, Enumeration.Value format$1, Connection conn$1, TableName tableName$1, Parameters.MergedParameters param$1) {
        String string;
        Enumeration.Value value = format$1;
        Enumeration.Value value2 = SupportedFormat$.MODULE$.JSON();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            StructType schema = DefaultJDBCWrapper$.MODULE$.resolveTable(conn$1, tableName$1.name(), param$1);
            string = list.isEmpty() || ((SeqLike)list.get()).isEmpty() ? new StringBuilder(2).append("(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)x -> Utils$.MODULE$.quotedNameIgnoreCase(x.name()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",")).append(")").toString() : new StringBuilder(2).append("(").append(((TraversableOnce)((List)list.get()).map((Function1 & Serializable & scala.Serializable)x -> Utils$.MODULE$.quotedNameIgnoreCase((String)x._2()), List$.MODULE$.canBuildFrom())).mkString(", ")).append(")").toString();
        } else {
            Enumeration.Value value4 = SupportedFormat$.MODULE$.CSV();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                string = list.isEmpty() || ((SeqLike)list.get()).isEmpty() ? "" : new StringBuilder(2).append("(").append(((TraversableOnce)((List)list.get()).map((Function1 & Serializable & scala.Serializable)x -> Utils$.MODULE$.quotedNameIgnoreCase((String)x._2()), List$.MODULE$.canBuildFrom())).mkString(", ")).append(")").toString();
            } else {
                throw new MatchError((Object)value);
            }
        }
        return string;
    }

    private static final String getMappingFromString$1(Option list, String from, Enumeration.Value format$1, StructType tableSchema$1) {
        String string;
        Enumeration.Value value = format$1;
        Enumeration.Value value2 = SupportedFormat$.MODULE$.JSON();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            String string2;
            if (list.isEmpty() || ((SeqLike)list.get()).isEmpty()) {
                String names = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tableSchema$1.fields())).map((Function1 & Serializable & scala.Serializable)x -> "parse_json($1):".concat(Utils$.MODULE$.quotedNameIgnoreCase(x.name())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",");
                string2 = new StringBuilder(19).append("from (select ").append(names).append(" ").append(from).append(" tmp)").toString();
            } else {
                string2 = new StringBuilder(19).append("from (select ").append(((TraversableOnce)((List)list.get()).map((Function1 & Serializable & scala.Serializable)x -> "parse_json($1):".concat(Utils$.MODULE$.quotedNameIgnoreCase(tableSchema$1.apply(x._1$mcI$sp() - 1).name())), List$.MODULE$.canBuildFrom())).mkString(", ")).append(" ").append(from).append(" tmp)").toString();
            }
            string = string2;
        } else {
            Enumeration.Value value4 = SupportedFormat$.MODULE$.CSV();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                string = list.isEmpty() || ((SeqLike)list.get()).isEmpty() ? from : new StringBuilder(19).append("from (select ").append(((TraversableOnce)((List)list.get()).map((Function1 & Serializable & scala.Serializable)x -> "tmp.$".concat(Utils$.MODULE$.quotedNameIgnoreCase(((Object)BoxesRunTime.boxToInteger((int)x._1$mcI$sp())).toString())), List$.MODULE$.canBuildFrom())).mkString(", ")).append(" ").append(from).append(" tmp)").toString();
            } else {
                throw new MatchError((Object)value);
            }
        }
        return string;
    }

    private package$() {
        MODULE$ = this;
        this.LOGGER = LoggerFactory.getLogger((String)this.getClass().getName());
        this.SLEEP_TIME = 5000;
        this.TIME_OUT = 5;
        this.pipeList = new HashMap();
    }
}

