/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.AmazonS3Client;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.AmazonS3URI;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import net.snowflake.spark.snowflake.ConstantString;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper$;
import net.snowflake.spark.snowflake.FSType$;
import net.snowflake.spark.snowflake.JDBCWrapper;
import net.snowflake.spark.snowflake.Parameters;
import net.snowflake.spark.snowflake.Parameters$;
import net.snowflake.spark.snowflake.SnowflakeSQLStatement;
import net.snowflake.spark.snowflake.TableName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.control.NonFatal$;

public final class Utils$ {
    public static Utils$ MODULE$;
    private final String SNOWFLAKE_SOURCE_NAME;
    private final String SNOWFLAKE_SOURCE_SHORT_NAME;
    private final String VERSION;
    private final String JDBC_DRIVER;
    private final Logger log;
    private String lastCopyUnload;
    private String lastCopyLoad;
    private String lastSelect;
    private String lastPutCommand;
    private String lastGetCommand;

    static {
        new Utils$();
    }

    public String SNOWFLAKE_SOURCE_NAME() {
        return this.SNOWFLAKE_SOURCE_NAME;
    }

    public String SNOWFLAKE_SOURCE_SHORT_NAME() {
        return this.SNOWFLAKE_SOURCE_SHORT_NAME;
    }

    public String VERSION() {
        return this.VERSION;
    }

    public String JDBC_DRIVER() {
        return this.JDBC_DRIVER;
    }

    private Logger log() {
        return this.log;
    }

    public Class<?> classForName(String className) {
        ClassLoader classLoader = (ClassLoader)Option$.MODULE$.apply((Object)Thread.currentThread().getContextClassLoader()).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getClass().getClassLoader());
        return Class.forName(className, true, classLoader);
    }

    public String joinUrls(String a, String b) {
        return new java.lang.StringBuilder(2).append(new StringOps(Predef$.MODULE$.augmentString(a)).stripSuffix("/")).append("/").append(new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(b)).stripPrefix("/"))).stripSuffix("/")).append("/").toString();
    }

    public String fixS3Url(String url) {
        return url.replaceAll("s3[an]://", "s3://");
    }

    public String fixUrlForCopyCommand(String url) {
        String string;
        if (url.startsWith("wasb://") || url.startsWith("wasbs://")) {
            URI pathUri = URI.create(url);
            string = new java.lang.StringBuilder(9).append("azure://").append(pathUri.getHost()).append("/").append(pathUri.getUserInfo()).append(pathUri.getPath()).toString();
        } else {
            string = this.fixS3Url(url);
        }
        return string;
    }

    public URI removeCredentialsFromURI(URI uri) {
        return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
    }

    public String makeTempPath(String tempRoot) {
        return this.joinUrls(tempRoot, UUID.randomUUID().toString());
    }

    public void checkThatBucketHasObjectLifecycleConfiguration(String tempDir, Enumeration.Value tempDirStorageType, AmazonS3Client s3Client) {
        Enumeration.Value value = tempDirStorageType;
        Enumeration.Value value2 = FSType$.MODULE$.S3();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            BoxedUnit boxedUnit;
            try {
                AmazonS3URI s3URI = new AmazonS3URI(this.fixS3Url(tempDir));
                String bucket = s3URI.getBucket();
                BucketLifecycleConfiguration bucketLifecycleConfiguration = s3Client.getBucketLifecycleConfiguration(bucket);
                String key = (String)Option$.MODULE$.apply((Object)s3URI.getKey()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                boolean someRuleMatchesTempDir = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(bucketLifecycleConfiguration.getRules()).asScala()).exists((Function1 & Serializable & scala.Serializable)rule -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$checkThatBucketHasObjectLifecycleConfiguration$2(key, rule)));
                if (!someRuleMatchesTempDir) {
                    this.log().warn(new java.lang.StringBuilder(346).append("The S3 bucket ").append(bucket).append(" does not have an object lifecycle configuration to ").append("ensure cleanup of temporary files. Consider configuring `tempdir` ").append("to point to a bucket with an object lifecycle policy that automatically ").append("deletes files after an expiration period. For more information, see ").append("https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                this.log().warn("An error occurred while trying to read the S3 bucket lifecycle configuration", e);
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void checkFileSystem(URI uri, Configuration hadoopConfig) {
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)hadoopConfig);
        String string = fs.getClass().getCanonicalName();
        String string2 = "org.apache.hadoop.fs.s3.S3FileSystem";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new IllegalArgumentException("spark-snowflakedb does not support the S3 Block FileSystem. Please reconfigure `tempdir` to use a s3n:// or s3a:// scheme.");
        }
    }

    public scala.collection.immutable.Map<String, String> readMapFromFile(SparkContext sc, String file) {
        FileSystem fs = FileSystem.get((URI)URI.create(file), (Configuration)sc.hadoopConfiguration());
        FSDataInputStream is = fs.open(Path.getPathWithoutSchemeAndAuthority((Path)new Path(file)));
        BufferedSource src = Source$.MODULE$.fromInputStream((InputStream)is, Codec$.MODULE$.fallbackSystemCodec());
        return this.mapFromSource((Source)src);
    }

    public scala.collection.immutable.Map<String, String> readMapFromString(String string) {
        Source src = Source$.MODULE$.fromString(string);
        return this.mapFromSource(src);
    }

    private scala.collection.immutable.Map<String, String> mapFromSource(Source src) {
        ObjectRef map = ObjectRef.create((Object)new HashMap());
        src.getLines().foreach((Function1 & Serializable & scala.Serializable)line -> {
            int index = line.indexOf(61);
            Predef$.MODULE$.assert(index > 0, (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(23).append("Can't parse this line: ").append((String)line).toString());
            String key = line.substring(0, index).trim().toLowerCase();
            String value = line.substring(index + 1).trim();
            return !key.startsWith("#") ? ((HashMap)map$1.elem).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)) : BoxedUnit.UNIT;
        });
        return ((HashMap)map.elem).toMap(Predef$.MODULE$.$conforms());
    }

    public Connection getJDBCConnection(scala.collection.immutable.Map<String, String> params) {
        JDBCWrapper wrapper = new JDBCWrapper();
        scala.collection.immutable.Map lcParams = (scala.collection.immutable.Map)params.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)key.toLowerCase(), (Object)value);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        Parameters.MergedParameters mergedParams = new Parameters.MergedParameters((scala.collection.immutable.Map<String, String>)Parameters$.MODULE$.DEFAULT_PARAMETERS().$plus$plus((GenTraversableOnce)lcParams));
        return wrapper.getConnector(mergedParams);
    }

    public Connection getJDBCConnection(Map<String, String> params) {
        scala.collection.immutable.Map m2 = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(params).asScala()).toMap(Predef$.MODULE$.$conforms());
        return this.getJDBCConnection((scala.collection.immutable.Map<String, String>)m2);
    }

    private String lastCopyUnload() {
        return this.lastCopyUnload;
    }

    private void lastCopyUnload_$eq(String x$1) {
        this.lastCopyUnload = x$1;
    }

    private String lastCopyLoad() {
        return this.lastCopyLoad;
    }

    private void lastCopyLoad_$eq(String x$1) {
        this.lastCopyLoad = x$1;
    }

    private String lastSelect() {
        return this.lastSelect;
    }

    private void lastSelect_$eq(String x$1) {
        this.lastSelect = x$1;
    }

    private String lastPutCommand() {
        return this.lastPutCommand;
    }

    private void lastPutCommand_$eq(String x$1) {
        this.lastPutCommand = x$1;
    }

    private String lastGetCommand() {
        return this.lastGetCommand;
    }

    private void lastGetCommand_$eq(String x$1) {
        this.lastGetCommand = x$1;
    }

    public void setLastCopyUnload(String select) {
        this.lastCopyUnload_$eq(select);
    }

    public String getLastCopyUnload() {
        return this.lastCopyUnload();
    }

    public void setLastSelect(String select) {
        this.lastSelect_$eq(select);
    }

    public String getLastSelect() {
        return this.lastSelect();
    }

    public void setLastCopyLoad(String select) {
        this.lastCopyLoad_$eq(select);
    }

    public String getLastCopyLoad() {
        return this.lastCopyLoad();
    }

    public void setLastPutCommand(String set) {
        this.lastPutCommand_$eq(set);
    }

    public String getLastPutCommand() {
        return this.lastPutCommand();
    }

    public void setLastGetCommand(String get) {
        this.lastGetCommand_$eq(get);
    }

    public String getLastGetCommand() {
        return this.lastGetCommand();
    }

    public SnowflakeSQLStatement genPrologueSql(Parameters.MergedParameters params) {
        Option<String> tz = params.sfTimezone();
        String timezoneSetString = "";
        if (params.isTimezoneSpark()) {
            String tzStr = TimeZone.getDefault().getID();
            timezoneSetString = new java.lang.StringBuilder(14).append("timezone = '").append(tzStr).append("',").toString();
        } else if (!params.isTimezoneSnowflake()) {
            timezoneSetString = params.isTimezoneSnowflakeDefault() ? "timezone = default," : new java.lang.StringBuilder(14).append("timezone = '").append(tz.get()).append("',").toString();
        }
        this.log().debug(new java.lang.StringBuilder(37).append("sfTimezone: '").append(tz).append("'   timezoneSetString '").append(timezoneSetString).append("'").toString());
        return new ConstantString("alter session set").$plus(timezoneSetString).$plus(new ConstantString(new StringOps(Predef$.MODULE$.augmentString("\n         |timestamp_ntz_output_format = 'YYYY-MM-DD HH24:MI:SS.FF3',\n         |timestamp_ltz_output_format = 'TZHTZM YYYY-MM-DD HH24:MI:SS.FF3',\n         |timestamp_tz_output_format = 'TZHTZM YYYY-MM-DD HH24:MI:SS.FF3';\n       ")).stripMargin()));
    }

    public SnowflakeSQLStatement genEpilogueSql(Parameters.MergedParameters params) {
        String timezoneUnsetString = "";
        if (!params.isTimezoneSnowflake()) {
            timezoneUnsetString = "timezone,";
        }
        return new ConstantString("alter session unset").$plus(timezoneUnsetString).$plus(new ConstantString(new StringOps(Predef$.MODULE$.augmentString("\n         |date_output_format,\n         |timestamp_ntz_output_format,\n         |timestamp_ltz_output_format,\n         |timestamp_tz_output_format;\n       ")).stripMargin()));
    }

    public void executePreActions(JDBCWrapper jdbcWrapper, Connection conn, Parameters.MergedParameters params, Option<TableName> table) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])params.preActions())).foreach((Function1 & Serializable & scala.Serializable)action -> {
            Object object;
            if (action != null && !action.trim().isEmpty()) {
                String actionSql = action.contains("%s") ? new StringOps(Predef$.MODULE$.augmentString(action)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table.get()})) : action;
                MODULE$.log().info(new java.lang.StringBuilder(21).append("Executing preAction: ").append(actionSql).toString());
                object = BoxesRunTime.boxToBoolean((boolean)jdbcWrapper.executePreparedInterruptibly(conn.prepareStatement(actionSql)));
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
    }

    public void executePostActions(JDBCWrapper jdbcWrapper, Connection conn, Parameters.MergedParameters params, Option<TableName> table) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])params.postActions())).foreach((Function1 & Serializable & scala.Serializable)action -> {
            Object object;
            if (action != null && !action.trim().isEmpty()) {
                String actionSql = action.contains("%s") ? new StringOps(Predef$.MODULE$.augmentString(action)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table.get()})) : action;
                MODULE$.log().info(new java.lang.StringBuilder(22).append("Executing postAction: ").append(actionSql).toString());
                object = BoxesRunTime.boxToBoolean((boolean)jdbcWrapper.executePreparedInterruptibly(conn.prepareStatement(actionSql)));
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
    }

    public ResultSet runQuery(scala.collection.immutable.Map<String, String> params, String query) {
        Connection conn = this.getJDBCConnection(params);
        return conn.createStatement().executeQuery(query);
    }

    public ResultSet runQuery(Map<String, String> params, String query) {
        Connection conn = this.getJDBCConnection(params);
        return conn.createStatement().executeQuery(query);
    }

    public void printQuery(scala.collection.immutable.Map<String, String> params, String query) {
        System.out.println(new java.lang.StringBuilder(9).append("Running: ").append(query).toString());
        ResultSet res = this.runQuery(params, query);
        int columnCount = res.getMetaData().getColumnCount();
        int rowCnt = 0;
        while (res.next()) {
            ++rowCnt;
            StringBuilder s = package$.MODULE$.StringBuilder().newBuilder();
            s.append("| ");
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), columnCount).foreach((Function1 & Serializable & scala.Serializable)i -> Utils$.$anonfun$printQuery$1(s, res, BoxesRunTime.unboxToInt((Object)i)));
            s.append(" |");
            System.out.println(s);
        }
        System.out.println(new java.lang.StringBuilder(12).append("TOTAL: ").append(rowCnt).append(" rows").toString());
    }

    public String sanitizeQueryText(String q) {
        return new java.lang.StringBuilder(12).append("<SANITIZED> ").append(q.replaceAll("(AWS_KEY_ID|AWS_SECRET_KEY|AZURE_SAS_TOKEN)='[^']+'", "$1='\u2744\u2603\u2744\u263a\u2744\u2603\u2744'").replaceAll("(sfaccount|sfurl|sfuser|sfpassword|sfwarehouse|sfdatabase|sfschema|sfrole|awsaccesskey|awssecretkey) \"[^\"]+\"", "$1 \"\u2744\u2603\u2744\u263a\u2744\u2603\u2744\"")).toString();
    }

    public scala.collection.immutable.Map<String, String> parseMap(String source2) {
        if (source2 == null || source2.length() < 5 || !source2.startsWith("Map(") || !source2.endsWith(")")) {
            throw new UnsupportedOperationException("input map format is incorrect!");
        }
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])source2.substring(4, source2.length() - 1).split(","))).map((Function1 & Serializable & scala.Serializable)x -> {
            String[] names = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x.split("->"))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)names[0]), (Object)names[1]);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
    }

    public String ensureQuoted(String name) {
        return this.isQuoted(name) ? name : this.quotedName(name);
    }

    public boolean isQuoted(String name) {
        return name.startsWith("\"") && name.endsWith("\"");
    }

    public String quotedName(String name) {
        return name.matches("[_a-zA-Z]([_0-9a-zA-Z])*") ? new java.lang.StringBuilder(2).append("\"").append(name.toUpperCase()).append("\"").toString() : new java.lang.StringBuilder(2).append("\"").append(name).append("\"").toString();
    }

    public String quotedNameIgnoreCase(String name) {
        return this.isQuoted(name) ? name : new java.lang.StringBuilder(2).append("\"").append(name).append("\"").toString();
    }

    public boolean containVariant(StructType schema) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)field -> DefaultJDBCWrapper$.MODULE$.schemaConversion((StructField)field), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).contains((Object)"VARIANT");
    }

    public scala.collection.immutable.Map<String, String> generateColumnMap(StructType from, StructType to, boolean reportError) {
        HashMap result = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        HashMap fromNameMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        HashMap toNameMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        from.foreach((Function1 & Serializable & scala.Serializable)field -> {
            Utils$.$anonfun$generateColumnMap$2(fromNameMap, to, field);
            return BoxedUnit.UNIT;
        });
        to.foreach((Function1 & Serializable & scala.Serializable)field -> {
            Utils$.$anonfun$generateColumnMap$3(toNameMap, from, field);
            return BoxedUnit.UNIT;
        });
        if (reportError && fromNameMap.size() != toNameMap.size()) {
            throw new UnsupportedOperationException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(127).append("\n             |column number of Spark Dataframe (").append(fromNameMap.size()).append(")\n             | doesn't match column number of Snowflake Table (").append(toNameMap.size()).append(")\n           ").toString())).stripMargin());
        }
        fromNameMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String index = (String)tuple2._1();
                String name = (String)tuple2._2();
                if (toNameMap.contains((Object)index)) {
                    boxedUnit = result.put((Object)name, toNameMap.apply((Object)index));
                } else {
                    if (reportError) {
                        throw new UnsupportedOperationException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(64).append("\n             |can't find column ").append(name).append(" in Snowflake Table\n           ").toString())).stripMargin());
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return boxedUnit2;
        });
        return result.toMap(Predef$.MODULE$.$conforms());
    }

    public StructType removeQuote(StructType schema) {
        return new StructType((StructField[])((TraversableOnce)schema.map((Function1 & Serializable & scala.Serializable)field -> new StructField(field.name().startsWith("\"") && field.name().endsWith("\"") ? field.name().substring(1, field.name().length() - 1) : field.name(), field.dataType(), field.nullable(), StructField$.MODULE$.apply$default$4()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(StructField.class)));
    }

    public static final /* synthetic */ boolean $anonfun$checkThatBucketHasObjectLifecycleConfiguration$2(String key$1, BucketLifecycleConfiguration.Rule rule) {
        String string = rule.getStatus();
        String string2 = "Enabled";
        return !(string != null ? !string.equals(string2) : string2 != null) && key$1.startsWith(rule.getPrefix());
    }

    public static final /* synthetic */ StringBuilder $anonfun$printQuery$1(StringBuilder s$1, ResultSet res$1, int i) {
        Object object = i > 1 ? s$1.append(" | ") : BoxedUnit.UNIT;
        return s$1.append(res$1.getString(i));
    }

    public static final /* synthetic */ boolean $anonfun$generateColumnMap$1(String name$1, StructField x$2) {
        return x$2.name().equalsIgnoreCase(name$1);
    }

    private static final boolean containsColumn$1(String name, StructType list) {
        return list.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$generateColumnMap$1(name, x$2)));
    }

    public static final /* synthetic */ void $anonfun$generateColumnMap$2(HashMap fromNameMap$1, StructType to$1, StructField field) {
        Option option = fromNameMap$1.put((Object)field.name().toLowerCase(), (Object)field.name());
        if (option instanceof Some) {
            if (Utils$.containsColumn$1(field.name(), to$1)) {
                throw new UnsupportedOperationException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(81).append("\n                   |Duplicated column names in Spark DataFrame: ").append(fromNameMap$1.apply((Object)field.name().toLowerCase())).append(", ").append(field.name()).append("\n             ").toString())).stripMargin());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$generateColumnMap$3(HashMap toNameMap$1, StructType from$1, StructField field) {
        Option option = toNameMap$1.put((Object)field.name().toLowerCase(), (Object)field.name());
        if (option instanceof Some) {
            if (Utils$.containsColumn$1(field.name(), from$1)) {
                throw new UnsupportedOperationException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(81).append("\n                   |Duplicated column names in Snowflake table: ").append(toNameMap$1.apply((Object)field.name().toLowerCase())).append(", ").append(field.name()).append("\n             ").toString())).stripMargin());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private Utils$() {
        MODULE$ = this;
        this.SNOWFLAKE_SOURCE_NAME = "net.snowflake.spark.snowflake";
        this.SNOWFLAKE_SOURCE_SHORT_NAME = "snowflake";
        this.VERSION = "2.6.0";
        this.JDBC_DRIVER = "net.snowflake.client.jdbc.SnowflakeDriver";
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

