/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake.streaming;

import java.io.Serializable;
import java.security.PrivateKey;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeoutException;
import net.snowflake.ingest.SimpleIngestManager;
import net.snowflake.ingest.connection.HistoryRangeResponse;
import net.snowflake.ingest.connection.HistoryResponse;
import net.snowflake.ingest.connection.IngestStatus;
import net.snowflake.ingest.utils.StagedFileWrapper;
import net.snowflake.spark.snowflake.Parameters;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

public final class SnowflakeIngestConnector$ {
    public static SnowflakeIngestConnector$ MODULE$;

    static {
        new SnowflakeIngestConnector$();
    }

    public List<String> waitForFileHistory(List<String> files, long frequency, SimpleIngestManager manager) {
        ObjectRef checkList = ObjectRef.create((Object)files.toSet());
        ObjectRef beginMark = ObjectRef.create(null);
        ObjectRef failedFiles = ObjectRef.create((Object)Nil$.MODULE$);
        while (((Set)checkList.elem).nonEmpty()) {
            Thread.sleep(frequency);
            HistoryResponse response = manager.getHistory(null, null, (String)beginMark.elem);
            beginMark.elem = (String)Option$.MODULE$.apply((Object)response.getNextBeginMark()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (String)beginMark$1.elem);
            if (response == null || response.files == null) continue;
            JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(response.files).toList().foreach((Function1 & Serializable & scala.Serializable)entry -> {
                SnowflakeIngestConnector$.$anonfun$waitForFileHistory$2(checkList, failedFiles, entry);
                return BoxedUnit.UNIT;
            });
        }
        return (List)failedFiles.elem;
    }

    public long waitForFileHistory$default$2() {
        return 5000L;
    }

    public Function0<List<Tuple2<String, IngestStatus>>> createHistoryChecker(SimpleIngestManager ingestManager) {
        ObjectRef beginMark = ObjectRef.create(null);
        return (Function0 & Serializable & scala.Serializable)() -> {
            HistoryResponse response = ingestManager.getHistory(null, null, (String)beginMark$2.elem);
            beginMark$2.elem = (String)Option$.MODULE$.apply((Object)response.getNextBeginMark()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (String)beginMark$2.elem);
            return response != null && response.files != null ? (List)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(response.files).toList().flatMap((Function1 & Serializable & scala.Serializable)entry -> entry.getPath() != null && Predef$.MODULE$.Boolean2boolean(entry.isComplete()) ? new .colon.colon((Object)new Tuple2((Object)entry.getPath(), (Object)entry.getStatus()), (List)Nil$.MODULE$) : Nil$.MODULE$, List$.MODULE$.canBuildFrom()) : Nil$.MODULE$;
        };
    }

    public List<Tuple2<String, IngestStatus>> checkHistoryByRange(SimpleIngestManager ingestManager, long start, long end) {
        HistoryRangeResponse response = ingestManager.getHistoryRange(null, this.timestampToDate(start), this.timestampToDate(end));
        return response != null && response.files != null ? (List)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(response.files).toList().flatMap((Function1 & Serializable & scala.Serializable)entry -> entry.getPath() != null && Predef$.MODULE$.Boolean2boolean(entry.isComplete()) ? new .colon.colon((Object)new Tuple2((Object)entry.getPath(), (Object)entry.getStatus()), (List)Nil$.MODULE$) : Nil$.MODULE$, List$.MODULE$.canBuildFrom()) : Nil$.MODULE$;
    }

    private String timestampToDate(long time) {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(tz);
        return df.format(new Date(time - 1000L));
    }

    public SimpleIngestManager createIngestManager(String account, String user, String pipe, String host, PrivateKey privateKey, int port, String scheme) {
        return new SimpleIngestManager(account, user, pipe, privateKey, scheme, host, port);
    }

    public Option<List<String>> ingestFilesAndCheck(List<String> files, long sec, SimpleIngestManager manager) {
        Some some;
        LazyRef checker$lzy = new LazyRef();
        this.ingestFiles(files, manager);
        try {
            some = new Some(Await$.MODULE$.result((Awaitable)SnowflakeIngestConnector$.checker$1(checker$lzy, files, manager), (Duration)new package.DurationLong(package$.MODULE$.DurationLong(sec)).second()));
        }
        catch (TimeoutException timeoutException) {
            some = None$.MODULE$;
        }
        return some;
    }

    public void ingestFiles(List<String> files, SimpleIngestManager manager) {
        manager.ingestFiles((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)files.map((Function1 & Serializable & scala.Serializable)x$2 -> new StagedFileWrapper(x$2), List$.MODULE$.canBuildFrom())).asJava(), null);
    }

    public SimpleIngestManager createIngestManager(Parameters.MergedParameters param, String pipeName) {
        String string;
        int port;
        String scheme;
        String host;
        Regex urlPattern = new StringOps(Predef$.MODULE$.augmentString("^(https?://)?([^:]+)(:\\d+)?$")).r();
        Regex portPattern = new StringOps(Predef$.MODULE$.augmentString(":(\\d+)")).r();
        Regex accountPattern = new StringOps(Predef$.MODULE$.augmentString("([^.]+).+")).r();
        String string2 = param.sfURL().trim();
        Option option = urlPattern.unapplySeq((CharSequence)string2);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(3) == 0) {
            String account;
            int n;
            host = (String)((LinearSeqOptimized)option.get()).apply(1);
            String portStr = (String)((LinearSeqOptimized)option.get()).apply(2);
            String string3 = scheme = param.isSslON() ? "https" : "http";
            if (portStr != null) {
                String t;
                String string4 = portStr;
                Option option2 = portPattern.unapplySeq((CharSequence)string4);
                if (option2.isEmpty() || option2.get() == null || ((LinearSeqOptimized)option2.get()).lengthCompare(1) != 0) {
                    throw new MatchError((Object)string4);
                }
                String string5 = t = (String)((LinearSeqOptimized)option2.get()).apply(0);
                String t2 = string5;
                n = new StringOps(Predef$.MODULE$.augmentString(t2)).toInt();
            } else {
                n = param.isSslON() ? 443 : 80;
            }
            port = n;
            String string6 = host;
            Option option3 = accountPattern.unapplySeq((CharSequence)string6);
            if (option3.isEmpty() || option3.get() == null || ((LinearSeqOptimized)option3.get()).lengthCompare(1) != 0) {
                throw new MatchError((Object)string6);
            }
            string = account = (String)((LinearSeqOptimized)option3.get()).apply(0);
        } else {
            throw new IllegalArgumentException(new StringBuilder(15).append("incorrect url: ").append(param.sfURL()).toString());
        }
        String account = string;
        Predef$.MODULE$.require(param.privateKey().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "PEM Private key must be specified with 'pem_private_key' parameter");
        PrivateKey privateKey = (PrivateKey)param.privateKey().get();
        String pipe = new StringBuilder(2).append(param.sfDatabase()).append(".").append(param.sfSchema()).append(".").append(pipeName).toString();
        SimpleIngestManager simpleIngestManager = this.createIngestManager(account, param.sfUser(), pipe, host, privateKey, port, scheme);
        return simpleIngestManager;
    }

    public int createIngestManager$default$6() {
        return 443;
    }

    public String createIngestManager$default$7() {
        return "https";
    }

    public static final /* synthetic */ void $anonfun$waitForFileHistory$2(ObjectRef checkList$1, ObjectRef failedFiles$1, HistoryResponse.FileEntry entry) {
        block1: {
            if (entry.getPath() == null || !Predef$.MODULE$.Boolean2boolean(entry.isComplete()) || !((Set)checkList$1.elem).contains((Object)entry.getPath())) break block1;
            checkList$1.elem = (Set)((Set)checkList$1.elem).$minus((Object)entry.getPath());
            IngestStatus ingestStatus = entry.getStatus();
            IngestStatus ingestStatus2 = IngestStatus.LOADED;
            if (ingestStatus == null ? ingestStatus2 != null : !ingestStatus.equals(ingestStatus2)) {
                String string = entry.getPath();
                failedFiles$1.elem = ((List)failedFiles$1.elem).$colon$colon((Object)string);
            }
        }
    }

    private static final /* synthetic */ Future checker$lzycompute$1(LazyRef checker$lzy$1, List files$1, SimpleIngestManager manager$1) {
        Future future;
        LazyRef lazyRef = checker$lzy$1;
        synchronized (lazyRef) {
            future = checker$lzy$1.initialized() ? (Future)checker$lzy$1.value() : (Future)checker$lzy$1.initialize((Object)Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.waitForFileHistory((List<String>)files$1, MODULE$.waitForFileHistory$default$2(), manager$1), ExecutionContext.Implicits$.MODULE$.global()));
        }
        return future;
    }

    private static final Future checker$1(LazyRef checker$lzy$1, List files$1, SimpleIngestManager manager$1) {
        return checker$lzy$1.initialized() ? (Future)checker$lzy$1.value() : SnowflakeIngestConnector$.checker$lzycompute$1(checker$lzy$1, files$1, manager$1);
    }

    private SnowflakeIngestConnector$() {
        MODULE$ = this;
    }
}

