/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake;

import java.io.Serializable;
import java.security.PrivateKey;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.jdbc.telemetry.Telemetry;
import net.snowflake.client.jdbc.telemetry.TelemetryClient;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper$;
import net.snowflake.spark.snowflake.Parameters;
import net.snowflake.spark.snowflake.Parameters$;
import net.snowflake.spark.snowflake.SnowflakeTelemetry$;
import net.snowflake.spark.snowflake.TelemetryClientInfoFields$;
import net.snowflake.spark.snowflake.Utils$;
import org.apache.spark.sql.execution.datasources.jdbc.DriverRegistry$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]h!B\f\u0019\u0001ay\u0002\"\u0002\u0014\u0001\t\u0003A\u0003bB\u0016\u0001\u0005\u0004%I\u0001\f\u0005\u0007k\u0001\u0001\u000b\u0011B\u0017\t\u000fY\u0002!\u0019!C\u0005o!1a\b\u0001Q\u0001\naBQa\u0010\u0001\u0005\u0002\u0001CQa\u001d\u0001\u0005\u0002QDQ\u0001 \u0001\u0005\u0002uDaa \u0001\u0005\u0002\u0005\u0005\u0001bBA\u0006\u0001\u0011\u0005\u0011Q\u0002\u0005\t\u00033\u0001A\u0011\u0001\r\u0002\u001c!9\u0011q\u0005\u0001\u0005\u0002\u0005%\u0002bBA\u0014\u0001\u0011\u0005\u0011Q\u0007\u0005\b\u0003w\u0001A\u0011AA\u001f\u0011\u001d\tY\u0004\u0001C\u0001\u0003\u000fBq!!\u0014\u0001\t\u0003\ty\u0005C\u0004\u0002^\u0001!\t!a\u0018\t\u000f\u00055\u0003\u0001\"\u0001\u0002f!9\u0011Q\f\u0001\u0005\u0002\u0005-\u0004bBA/\u0001\u0011%\u0011\u0011\u000f\u0005\b\u0003/\u0003A\u0011BAM\u0011\u001d\t9\f\u0001C\u0001\u0003s\u00131B\u0013#C\u0007^\u0013\u0018\r\u001d9fe*\u0011\u0011DG\u0001\ng:|wO\u001a7bW\u0016T!a\u0007\u000f\u0002\u000bM\u0004\u0018M]6\u000b\u0005ei\"\"\u0001\u0010\u0002\u00079,Go\u0005\u0002\u0001AA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t1\u0011I\\=SK\u001a\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002SA\u0011!\u0006A\u0007\u00021\u0005\u0019An\\4\u0016\u00035\u0002\"AL\u001a\u000e\u0003=R!\u0001M\u0019\u0002\u000bMdg\r\u000e6\u000b\u0003I\n1a\u001c:h\u0013\t!tF\u0001\u0004M_\u001e<WM]\u0001\u0005Y><\u0007%\u0001\u0002fGV\t\u0001\b\u0005\u0002:y5\t!H\u0003\u0002<E\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005uR$\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003\r)7\rI\u0001\re\u0016\u001cx\u000e\u001c<f)\u0006\u0014G.\u001a\u000b\u0005\u00032+&\r\u0005\u0002C\u00156\t1I\u0003\u0002E\u000b\u0006)A/\u001f9fg*\u0011aiR\u0001\u0004gFd'BA\u000eI\u0015\tI\u0015'\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003\u0017\u000e\u0013!b\u0015;sk\u000e$H+\u001f9f\u0011\u0015ie\u00011\u0001O\u0003\u0011\u0019wN\u001c8\u0011\u0005=\u001bV\"\u0001)\u000b\u0005\u0019\u000b&\"\u0001*\u0002\t)\fg/Y\u0005\u0003)B\u0013!bQ8o]\u0016\u001cG/[8o\u0011\u00151f\u00011\u0001X\u0003\u0015!\u0018M\u00197f!\tAvL\u0004\u0002Z;B\u0011!LI\u0007\u00027*\u0011AlJ\u0001\u0007yI|w\u000e\u001e \n\u0005y\u0013\u0013A\u0002)sK\u0012,g-\u0003\u0002aC\n11\u000b\u001e:j]\u001eT!A\u0018\u0012\t\u000b\r4\u0001\u0019\u00013\u0002\rA\f'/Y7t!\t)\u0007O\u0004\u0002g]:\u0011q-\u001c\b\u0003Q2t!![6\u000f\u0005iS\u0017\"\u0001\u0010\n\u0005ei\u0012BA\u000e\u001d\u0013\tI\"$\u0003\u0002p1\u0005Q\u0001+\u0019:b[\u0016$XM]:\n\u0005E\u0014(\u0001E'fe\u001e,G\rU1sC6,G/\u001a:t\u0015\ty\u0007$\u0001\u000bsKN|GN^3UC\ndWM\u0012:p[6+G/\u0019\u000b\u0005\u0003V48\u0010C\u0003N\u000f\u0001\u0007a\nC\u0003x\u000f\u0001\u0007\u00010\u0001\u0003sg6$\u0007CA(z\u0013\tQ\bKA\tSKN,H\u000e^*fi6+G/\u0019#bi\u0006DQaY\u0004A\u0002\u0011\fAbZ3u\u0007>tg.Z2u_J$\"A\u0014@\t\u000b\rD\u0001\u0019\u00013\u0002\u0019M\u001c\u0007.Z7b'R\u0014\u0018N\\4\u0015\u000b]\u000b\u0019!a\u0002\t\r\u0005\u0015\u0011\u00021\u0001B\u0003\u0019\u00198\r[3nC\"1\u0011\u0011B\u0005A\u0002\u0011\fQ\u0001]1sC6\f\u0001c]2iK6\f7i\u001c8wKJ\u001c\u0018n\u001c8\u0015\u0007]\u000by\u0001C\u0004\u0002\u0012)\u0001\r!a\u0005\u0002\u000b\u0019LW\r\u001c3\u0011\u0007\t\u000b)\"C\u0002\u0002\u0018\r\u00131b\u0015;sk\u000e$h)[3mI\u0006YA/\u00192mK\u0016C\u0018n\u001d;t)\u0019\ti\"a\t\u0002&A\u0019\u0011%a\b\n\u0007\u0005\u0005\"EA\u0004C_>dW-\u00198\t\u000b\r\\\u0001\u0019\u00013\t\u000bY[\u0001\u0019A,\u00029\u0015DXmY;uKB\u0013X\r]1sK\u0012Le\u000e^3seV\u0004H/\u001b2msR!\u0011QDA\u0016\u0011\u001d\ti\u0003\u0004a\u0001\u0003_\t\u0011b\u001d;bi\u0016lWM\u001c;\u0011\u0007=\u000b\t$C\u0002\u00024A\u0013\u0011\u0003\u0015:fa\u0006\u0014X\rZ*uCR,W.\u001a8u)\u0019\ti\"a\u000e\u0002:!)Q*\u0004a\u0001\u001d\")a)\u0004a\u0001/\u0006\tS\r_3dkR,\u0007K]3qCJ,G-U;fefLe\u000e^3seV\u0004H/\u001b2msR!\u0011qHA#!\ry\u0015\u0011I\u0005\u0004\u0003\u0007\u0002&!\u0003*fgVdGoU3u\u0011\u001d\tiC\u0004a\u0001\u0003_!b!a\u0010\u0002J\u0005-\u0003\"B'\u0010\u0001\u0004q\u0005\"\u0002$\u0010\u0001\u00049\u0016!G3yK\u000e,H/Z)vKJL\u0018J\u001c;feJ,\b\u000f^5cYf$b!a\u0010\u0002R\u0005e\u0003bBA\u0017!\u0001\u0007\u00111\u000b\t\u0004\u001f\u0006U\u0013bAA,!\nI1\u000b^1uK6,g\u000e\u001e\u0005\u0007\u00037\u0002\u0002\u0019A,\u0002\u0007M$(/\u0001\u000bfq\u0016\u001cW\u000f^3J]R,'O];qi&\u0014G.\u001f\u000b\u0007\u0003;\t\t'a\u0019\t\u000f\u00055\u0012\u00031\u0001\u0002T!1\u00111L\tA\u0002]#b!a\u0010\u0002h\u0005%\u0004\"B'\u0013\u0001\u0004q\u0005\"\u0002$\u0013\u0001\u00049FCBA\u000f\u0003[\ny\u0007C\u0003N'\u0001\u0007a\nC\u0003G'\u0001\u0007q+\u0006\u0003\u0002t\u0005eDCBA;\u0003\u0017\u000bi\t\u0005\u0003\u0002x\u0005eD\u0002\u0001\u0003\b\u0003w\"\"\u0019AA?\u0005\u0005!\u0016\u0003BA@\u0003\u000b\u00032!IAA\u0013\r\t\u0019I\t\u0002\b\u001d>$\b.\u001b8h!\r\t\u0013qQ\u0005\u0004\u0003\u0013\u0013#aA!os\"9\u0011Q\u0006\u000bA\u0002\u0005M\u0003bBAH)\u0001\u0007\u0011\u0011S\u0001\u0003_B\u0004r!IAJ\u0003'\n)(C\u0002\u0002\u0016\n\u0012\u0011BR;oGRLwN\\\u0019\u0002\u001f\u001d,GoQ1uC2L8\u000f\u001e+za\u0016$\"\"a'\u0002\"\u0006-\u0016qVAZ!\r\u0011\u0015QT\u0005\u0004\u0003?\u001b%\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000f\u0005\rV\u00031\u0001\u0002&\u000691/\u001d7UsB,\u0007cA\u0011\u0002(&\u0019\u0011\u0011\u0016\u0012\u0003\u0007%sG\u000fC\u0004\u0002.V\u0001\r!!*\u0002\u0013A\u0014XmY5tS>t\u0007bBAY+\u0001\u0007\u0011QU\u0001\u0006g\u000e\fG.\u001a\u0005\b\u0003k+\u0002\u0019AA\u000f\u0003\u0019\u0019\u0018n\u001a8fI\u0006aq-\u001a;UK2,W.\u001a;ssR!\u00111XAh!\u0011\ti,a3\u000e\u0005\u0005}&\u0002BAa\u0003\u0007\f\u0011\u0002^3mK6,GO]=\u000b\t\u0005\u0015\u0017qY\u0001\u0005U\u0012\u00147MC\u0002\u0002Jr\taa\u00197jK:$\u0018\u0002BAg\u0003\u007f\u0013\u0011\u0002V3mK6,GO]=\t\u000b53\u0002\u0019\u0001()\u000fY\t\u0019.!7\u0002nB\u0019\u0011%!6\n\u0007\u0005]'E\u0001\u0006eKB\u0014XmY1uK\u0012\f\u0004bI,\u0002\\\u0006\r\u0018Q\\\u0005\u0005\u0003;\fy.A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0006\u0004\u0003C\u0014\u0013A\u00033faJ,7-\u0019;fIFJ1%!:\u0002h\u0006%\u0018\u0011\u001d\b\u0004C\u0005\u001d\u0018bAAqEE*!%\t\u0012\u0002l\n)1oY1mCFB1eVAx\u0003g\f\t0\u0003\u0003\u0002r\u0006}\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'M\u0005$\u0003K\f9/!>\u0002bF*!%\t\u0012\u0002l\u0002")
public class JDBCWrapper {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ExecutionContext ec;

    private Logger log() {
        return this.log;
    }

    private ExecutionContext ec() {
        return this.ec;
    }

    public StructType resolveTable(Connection conn, String table, Parameters.MergedParameters params) {
        return this.resolveTableFromMeta(conn, DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn).tableMetaData(table), params);
    }

    public StructType resolveTableFromMeta(Connection conn, ResultSetMetaData rsmd, Parameters.MergedParameters params) {
        int ncols = rsmd.getColumnCount();
        StructField[] fields = new StructField[ncols];
        for (int i = 0; i < ncols; ++i) {
            String columnName = rsmd.getColumnLabel(i + 1);
            int dataType = rsmd.getColumnType(i + 1);
            int fieldSize = rsmd.getPrecision(i + 1);
            int fieldScale = rsmd.getScale(i + 1);
            boolean isSigned = rsmd.isSigned(i + 1);
            boolean nullable = rsmd.isNullable(i + 1) != 0;
            DataType columnType = this.getCatalystType(dataType, fieldSize, fieldScale, isSigned);
            fields[i] = new StructField(params.keepOriginalColumnNameCase() ? columnName : (columnName.matches("[_A-Z]([_0-9A-Z])*") ? columnName : new StringBuilder(2).append("\"").append(columnName).append("\"").toString()), columnType, nullable, StructField$.MODULE$.apply$default$4());
        }
        return new StructType(fields);
    }

    public Connection getConnector(Parameters.MergedParameters params) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String driverClassName = Utils$.MODULE$.JDBC_DRIVER();
        try {
            Class<?> driverClass = Utils$.MODULE$.classForName(driverClassName);
            DriverRegistry$.MODULE$.register(driverClass.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundException(new StringBuilder(50).append("Could not load a Snowflake JDBC driver class < ").append(driverClassName).append(" > ").toString(), e);
        }
        String sfURL = params.sfURL();
        String jdbcURL = new StringBuilder(17).append("jdbc:snowflake://").append(sfURL).toString();
        Properties jdbcProperties = new Properties();
        jdbcProperties.put("db", params.sfDatabase());
        jdbcProperties.put("schema", params.sfSchema());
        jdbcProperties.put("user", params.sfUser());
        Option<PrivateKey> option = params.privateKey();
        if (option instanceof Some) {
            Some some = (Some)option;
            PrivateKey privateKey = (PrivateKey)some.value();
            object5 = jdbcProperties.put("privateKey", privateKey);
        } else if (None$.MODULE$.equals(option)) {
            Object object6;
            Option<String> option2 = params.sfToken();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                String value = (String)some.value();
                object6 = jdbcProperties.put("token", value);
            } else if (None$.MODULE$.equals(option2)) {
                object6 = jdbcProperties.put("password", params.sfPassword());
            } else {
                throw new MatchError(option2);
            }
            object5 = object6;
        } else {
            throw new MatchError(option);
        }
        jdbcProperties.put("ssl", params.sfSSL());
        Object object7 = params.sfAccount().isDefined() ? jdbcProperties.put("account", params.sfAccount().get()) : BoxedUnit.UNIT;
        Object object8 = params.sfWarehouse().isDefined() ? jdbcProperties.put("warehouse", params.sfWarehouse().get()) : BoxedUnit.UNIT;
        Object object9 = params.sfRole().isDefined() ? jdbcProperties.put("role", params.sfRole().get()) : BoxedUnit.UNIT;
        Option<String> option3 = params.getTimeOutputFormat();
        if (option3 instanceof Some) {
            Some some = (Some)option3;
            String value = (String)some.value();
            object4 = jdbcProperties.put(Parameters$.MODULE$.PARAM_TIME_OUTPUT_FORMAT(), value);
        } else {
            object4 = BoxedUnit.UNIT;
        }
        Option<String> option4 = params.getQueryResultFormat();
        if (option4 instanceof Some) {
            Some some = (Some)option4;
            String value = (String)some.value();
            object3 = jdbcProperties.put(Parameters$.MODULE$.PARAM_JDBC_QUERY_RESULT_FORMAT(), value);
        } else {
            object3 = BoxedUnit.UNIT;
        }
        params.setJDBCProxyIfNecessary(jdbcProperties);
        Option<String> option5 = params.sfAuthenticator();
        if (option5 instanceof Some) {
            Some some = (Some)option5;
            String value = (String)some.value();
            object2 = jdbcProperties.put("authenticator", value);
        } else {
            object2 = BoxedUnit.UNIT;
        }
        jdbcProperties.put("client_session_keep_alive", "true");
        jdbcProperties.put("JDBC_TREAT_DECIMAL_AS_INT", "false");
        Map<String, Object> extraOptions = params.sfExtraOptions();
        extraOptions.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)JDBCWrapper.$anonfun$getConnector$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            String string;
            Object v;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x$1;
                    if (tuple2 == null) break block2;
                    String k = (String)tuple2._1();
                    v = tuple2._2();
                    if (k == null) break block2;
                    string = k;
                    if (v != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            Object object = v;
            Object object2 = jdbcProperties.put(string.toLowerCase(), object.toString());
            return object2;
        });
        if (!Utils$.MODULE$.CERTIFIED_JDBC_VERSION().equals(Utils$.MODULE$.jdbcVersion())) {
            this.log().warn((String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(107).append("JDBC ").append(Utils$.MODULE$.jdbcVersion()).append(" is being used.\n           | But the certified JDBC version\n           | ").append(Utils$.MODULE$.CERTIFIED_JDBC_VERSION()).append(" is recommended.\n           |").toString())).stripMargin())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)JDBCWrapper.$anonfun$getConnector$3(BoxesRunTime.unboxToChar((Object)x$2)))));
        }
        jdbcProperties.put(SFSessionProperty.CLIENT_INFO.getPropertyKey(), Utils$.MODULE$.getClientInfoString());
        Connection conn = DriverManager.getConnection(jdbcURL, jdbcProperties);
        if (jdbcProperties.getProperty(Parameters$.MODULE$.PARAM_JDBC_QUERY_RESULT_FORMAT()) != null) {
            try {
                String resultFormat = jdbcProperties.getProperty(Parameters$.MODULE$.PARAM_JDBC_QUERY_RESULT_FORMAT());
                object = BoxesRunTime.boxToBoolean((boolean)conn.createStatement().execute(new StringBuilder(47).append("alter session set JDBC_QUERY_RESULT_FORMAT = '").append(resultFormat).append("'").toString()));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (!(throwable2 instanceof SQLException)) {
                    if (throwable2 != null) {
                        Throwable throwable3 = throwable2;
                        throw throwable3;
                    }
                    throw throwable;
                }
                SQLException sQLException = (SQLException)throwable2;
                this.log().info(sQLException.getMessage());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                object = boxedUnit;
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        Map extraValues = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TelemetryClientInfoFields$.MODULE$.SFURL()), (Object)sfURL)}));
        SnowflakeTelemetry$.MODULE$.sendClientInfoTelemetryIfNotYet((Map<String, String>)extraValues, conn);
        return conn;
    }

    public String schemaString(StructType schema, Parameters.MergedParameters param) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)field -> {
            String name = param.keepOriginalColumnNameCase() ? Utils$.MODULE$.quotedNameIgnoreCase(field.name()) : Utils$.MODULE$.ensureQuoted(field.name());
            String type = this.schemaConversion((StructField)field);
            String nullable = field.nullable() ? "" : "NOT NULL";
            return new StringBuilder(2).append(name).append(" ").append(type).append(" ").append(nullable).toString();
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",");
    }

    public String schemaConversion(StructField field) {
        String string;
        DataType dataType = field.dataType();
        if (IntegerType$.MODULE$.equals(dataType)) {
            string = "INTEGER";
        } else if (LongType$.MODULE$.equals(dataType)) {
            string = "INTEGER";
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            string = "DOUBLE";
        } else if (FloatType$.MODULE$.equals(dataType)) {
            string = "FLOAT";
        } else if (ShortType$.MODULE$.equals(dataType)) {
            string = "INTEGER";
        } else if (ByteType$.MODULE$.equals(dataType)) {
            string = "INTEGER";
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            string = "BOOLEAN";
        } else if (StringType$.MODULE$.equals(dataType)) {
            string = field.metadata().contains("maxlength") ? new StringBuilder(9).append("VARCHAR(").append(field.metadata().getLong("maxlength")).append(")").toString() : "STRING";
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            string = field.metadata().contains("maxlength") ? new StringBuilder(8).append("BINARY(").append(field.metadata().getLong("maxlength")).append(")").toString() : "BINARY";
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            string = "TIMESTAMP";
        } else if (DateType$.MODULE$.equals(dataType)) {
            string = "DATE";
        } else if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            string = new StringBuilder(10).append("DECIMAL(").append(decimalType.precision()).append(",").append(decimalType.scale()).append(")").toString();
        } else {
            boolean bl = dataType instanceof StructType ? true : (dataType instanceof ArrayType ? true : dataType instanceof MapType);
            if (bl) {
                string = "VARIANT";
            } else {
                throw new IllegalArgumentException(new StringBuilder(45).append("Don't know how to save ").append(field).append(" of type ").append(field.name()).append(" to Snowflake").toString());
            }
        }
        return string;
    }

    public boolean tableExists(Parameters.MergedParameters params, String table) {
        boolean bl;
        try (Connection conn = this.getConnector(params);){
            Object object = params.checkTableExistenceInCurrentSchemaOnly() ? BoxesRunTime.boxToBoolean((boolean)conn.createStatement().execute("alter session set search_path='$current'")) : BoxedUnit.UNIT;
            DefaultJDBCWrapper.DataBaseOperations qual$1 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
            String x$1 = table;
            boolean x$2 = qual$1.tableExists$default$2();
            bl = qual$1.tableExists(x$1, x$2);
        }
        return bl;
    }

    public boolean executePreparedInterruptibly(PreparedStatement statement) {
        return BoxesRunTime.unboxToBoolean(this.executeInterruptibly((Statement)statement, (Function1 & Serializable & scala.Serializable)stmt -> BoxesRunTime.boxToBoolean((boolean)JDBCWrapper.$anonfun$executePreparedInterruptibly$1(stmt))));
    }

    public boolean executePreparedInterruptibly(Connection conn, String sql) {
        return this.executePreparedInterruptibly(conn.prepareStatement(sql));
    }

    public ResultSet executePreparedQueryInterruptibly(PreparedStatement statement) {
        return (ResultSet)this.executeInterruptibly((Statement)statement, (Function1 & Serializable & scala.Serializable)stmt -> {
            PreparedStatement prepStmt = (PreparedStatement)stmt;
            return prepStmt.executeQuery();
        });
    }

    public ResultSet executePreparedQueryInterruptibly(Connection conn, String sql) {
        return this.executePreparedQueryInterruptibly(conn.prepareStatement(sql));
    }

    public ResultSet executeQueryInterruptibly(Statement statement, String str) {
        return (ResultSet)this.executeInterruptibly(statement, (Function1 & Serializable & scala.Serializable)x$3 -> x$3.executeQuery(str));
    }

    public boolean executeInterruptibly(Statement statement, String str) {
        return BoxesRunTime.unboxToBoolean(this.executeInterruptibly(statement, (Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.execute(str))));
    }

    public ResultSet executeQueryInterruptibly(Connection conn, String sql) {
        Statement stmt = conn.createStatement();
        return this.executeQueryInterruptibly(stmt, sql);
    }

    public boolean executeInterruptibly(Connection conn, String sql) {
        Statement stmt = conn.createStatement();
        return this.executeInterruptibly(stmt, sql);
    }

    private <T> T executeInterruptibly(Statement statement, Function1<Statement, T> op) {
        Object object;
        try {
            this.log().debug(new StringBuilder(18).append("Running statement ").append(statement).toString());
            Future future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> op.apply((Object)statement), this.ec());
            object = Await$.MODULE$.result((Awaitable)future, (Duration)Duration$.MODULE$.Inf());
        }
        catch (InterruptedException e) {
            try {
                this.log().info(new StringBuilder(21).append("Cancelling statement ").append(statement).toString());
                statement.cancel();
                this.log().info("Cancelling succeeded");
                throw e;
            }
            catch (SQLException s) {
                this.log().error("Exception occurred while cancelling query", (Throwable)s);
                throw e;
            }
        }
        return (T)object;
    }

    private DataType getCatalystType(int sqlType, int precision, int scale, boolean signed) {
        BooleanType$ booleanType$;
        int n = sqlType;
        switch (n) {
            case 2003: {
                booleanType$ = null;
                break;
            }
            case -5: {
                if (signed) {
                    booleanType$ = LongType$.MODULE$;
                    break;
                }
                booleanType$ = new DecimalType(20, 0);
                break;
            }
            case 16: {
                booleanType$ = BooleanType$.MODULE$;
                break;
            }
            case 1: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case 2005: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case 70: {
                booleanType$ = null;
                break;
            }
            case 91: {
                booleanType$ = DateType$.MODULE$;
                break;
            }
            case 3: {
                if (precision != 0 || scale != 0) {
                    if (precision > DecimalType$.MODULE$.MAX_PRECISION()) {
                        booleanType$ = new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), scale + (precision - DecimalType$.MODULE$.MAX_SCALE()));
                        break;
                    }
                    booleanType$ = new DecimalType(precision, scale);
                    break;
                }
                booleanType$ = new DecimalType(38, 18);
                break;
            }
            case 2001: {
                booleanType$ = null;
                break;
            }
            case 8: {
                booleanType$ = DoubleType$.MODULE$;
                break;
            }
            case 6: {
                booleanType$ = FloatType$.MODULE$;
                break;
            }
            case 4: {
                if (signed) {
                    booleanType$ = IntegerType$.MODULE$;
                    break;
                }
                booleanType$ = LongType$.MODULE$;
                break;
            }
            case 2000: {
                booleanType$ = null;
                break;
            }
            case -16: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case -1: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case -15: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case 2011: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case 0: {
                booleanType$ = null;
                break;
            }
            case 2: {
                if (precision != 0 || scale != 0) {
                    booleanType$ = new DecimalType(precision, scale);
                    break;
                }
                booleanType$ = new DecimalType(38, 18);
                break;
            }
            case -9: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case 1111: {
                booleanType$ = null;
                break;
            }
            case 7: {
                booleanType$ = DoubleType$.MODULE$;
                break;
            }
            case 2006: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case -8: {
                booleanType$ = LongType$.MODULE$;
                break;
            }
            case 5: {
                booleanType$ = IntegerType$.MODULE$;
                break;
            }
            case 2009: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case 2002: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case 92: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case 93: {
                booleanType$ = TimestampType$.MODULE$;
                break;
            }
            case -6: {
                booleanType$ = IntegerType$.MODULE$;
                break;
            }
            case 12: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case -2: {
                booleanType$ = BinaryType$.MODULE$;
                break;
            }
            default: {
                booleanType$ = null;
                break;
            }
        }
        BooleanType$ answer = booleanType$;
        if (answer == null) {
            throw new SQLException(new StringBuilder(17).append("Unsupported type ").append(sqlType).toString());
        }
        return answer;
    }

    public Telemetry getTelemetry(Connection conn) {
        return TelemetryClient.createTelemetry((Connection)conn);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$getConnector$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        if (tuple2 == null) return false;
        String k = (String)tuple2._1();
        Object v = tuple2._2();
        if (k == null) return false;
        if (v == null) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$getConnector$3(char x$2) {
        return x$2 >= ' ';
    }

    public static final /* synthetic */ boolean $anonfun$executePreparedInterruptibly$1(Statement stmt) {
        PreparedStatement prepStmt = (PreparedStatement)stmt;
        return prepStmt.execute();
    }

    public JDBCWrapper() {
        this.log().debug("Creating a new ExecutionContext");
        ThreadFactory threadFactory = new ThreadFactory(null){
            private final AtomicInteger count;

            /*
             * WARNING - void declaration
             */
            public Thread newThread(Runnable r) {
                void var2_2;
                Thread thread = new Thread(r);
                thread.setName(new StringBuilder(28).append("spark-snowflake-JDBCWrapper-").append(this.count.incrementAndGet()).toString());
                thread.setDaemon(true);
                return var2_2;
            }
            {
                this.count = new AtomicInteger();
            }
        };
        this.ec = ExecutionContext$.MODULE$.fromExecutorService(Executors.newCachedThreadPool(threadFactory));
    }
}

