/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.sql.Connection;
import java.util.regex.Pattern;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.BaseJsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ObjectNode;
import net.snowflake.client.jdbc.telemetry.Telemetry;
import net.snowflake.client.jdbc.telemetry.TelemetryClient;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryEvent;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryService;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper$;
import net.snowflake.spark.snowflake.SnowflakePushdownUnsupportedException;
import net.snowflake.spark.snowflake.SparkConnectorContext$;
import net.snowflake.spark.snowflake.TelemetryClientInfoFields$;
import net.snowflake.spark.snowflake.TelemetryConstValues$;
import net.snowflake.spark.snowflake.TelemetryFieldNames$;
import net.snowflake.spark.snowflake.TelemetryOOBFields$;
import net.snowflake.spark.snowflake.TelemetryOOBTags$;
import net.snowflake.spark.snowflake.TelemetryPushdownFailFields$;
import net.snowflake.spark.snowflake.TelemetryQueryStatusFields$;
import net.snowflake.spark.snowflake.TelemetryTaskInfoFields$;
import net.snowflake.spark.snowflake.TelemetryTypes$;
import net.snowflake.spark.snowflake.Utils$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SnowflakeTelemetry$ {
    public static SnowflakeTelemetry$ MODULE$;
    private final String TELEMETRY_TYPE_FIELD_NAME;
    private final String TELEMETRY_SOURCE_FIELD_NAME;
    private final String TELEMETRY_DATA_FIELD_NAME;
    private final String TELEMETRY_SOURCE;
    private final String TELEMETRY_OOB_NAME_PREFIX;
    private List<Tuple2<ObjectNode, Object>> logs;
    private final Logger logger;
    private final ObjectMapper mapper;
    private boolean hasClientInfoSent;
    private final int MB;
    private ObjectNode output;
    private final Set<String> sparkOptions;

    static {
        new SnowflakeTelemetry$();
    }

    private String TELEMETRY_TYPE_FIELD_NAME() {
        return this.TELEMETRY_TYPE_FIELD_NAME;
    }

    private String TELEMETRY_SOURCE_FIELD_NAME() {
        return this.TELEMETRY_SOURCE_FIELD_NAME;
    }

    private String TELEMETRY_DATA_FIELD_NAME() {
        return this.TELEMETRY_DATA_FIELD_NAME;
    }

    private String TELEMETRY_SOURCE() {
        return this.TELEMETRY_SOURCE;
    }

    private String TELEMETRY_OOB_NAME_PREFIX() {
        return this.TELEMETRY_OOB_NAME_PREFIX;
    }

    private List<Tuple2<ObjectNode, Object>> logs() {
        return this.logs;
    }

    private void logs_$eq(List<Tuple2<ObjectNode, Object>> x$1) {
        this.logs = x$1;
    }

    private Logger logger() {
        return this.logger;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    private boolean hasClientInfoSent() {
        return this.hasClientInfoSent;
    }

    private void hasClientInfoSent_$eq(boolean x$1) {
        this.hasClientInfoSent = x$1;
    }

    public int MB() {
        return this.MB;
    }

    public ObjectNode output() {
        return this.output;
    }

    public void output_$eq(ObjectNode x$1) {
        this.output = x$1;
    }

    /*
     * WARNING - void declaration
     */
    private TelemetryService getOobTelemetryService() {
        void var1_1;
        TelemetryService service = TelemetryService.getInstance();
        service.setDeployment(TelemetryService.TELEMETRY_SERVER_DEPLOYMENT.PROD);
        return var1_1;
    }

    public void sendClientInfoTelemetryIfNotYet(Map<String, String> extraValues, Connection conn) {
        block0: {
            if (this.hasClientInfoSent()) break block0;
            SparkConnectorContext$.MODULE$.recordConfig();
            ObjectNode metric = Utils$.MODULE$.getClientInfoJson();
            extraValues.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SnowflakeTelemetry$.$anonfun$sendClientInfoTelemetryIfNotYet$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                ObjectNode objectNode = metric.put(key, value);
                return objectNode;
            });
            this.addLog((Tuple2<Tuple2<Enumeration.Value, ObjectNode>, Object>)new Tuple2((Object)new Tuple2((Object)TelemetryTypes$.MODULE$.SPARK_CLIENT_INFO(), (Object)metric), (Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
            this.send(DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn).getTelemetry());
            this.hasClientInfoSent_$eq(true);
        }
    }

    public void addLog(Tuple2<Tuple2<Enumeration.Value, ObjectNode>, Object> log) {
        this.logger().debug(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(65).append("\n        |Telemetry Output\n        |Type: ").append(((Tuple2)log._1())._1()).append("\n        |Data: ").append(((BaseJsonNode)((Tuple2)log._1())._2()).toString()).append("\n      ").toString())).stripMargin());
        SnowflakeTelemetry$ snowflakeTelemetry$ = this;
        synchronized (snowflakeTelemetry$) {
            this.output_$eq(this.mapper().createObjectNode());
            this.output().put(this.TELEMETRY_TYPE_FIELD_NAME(), ((Tuple2)log._1())._1().toString());
            this.output().put(this.TELEMETRY_SOURCE_FIELD_NAME(), this.TELEMETRY_SOURCE());
            this.output().set(this.TELEMETRY_DATA_FIELD_NAME(), (JsonNode)((Tuple2)log._1())._2());
            Tuple2 tuple2 = new Tuple2((Object)this.output(), (Object)BoxesRunTime.boxToLong((long)log._2$mcJ$sp()));
            this.logs_$eq((List<Tuple2<ObjectNode, Object>>)this.logs().$colon$colon((Object)tuple2));
        }
    }

    public void sendTelemetryOOB(String sfurl, String senderClass, String operation, int retryCount, int maxRetryCount, boolean success, boolean useProxy, Option<String> queryID, Option<Throwable> throwable) {
        BoxedUnit boxedUnit;
        ObjectNode metric = this.mapper().createObjectNode();
        metric.put(TelemetryOOBFields$.MODULE$.SPARK_CONNECTOR_VERSION(), Utils$.MODULE$.VERSION());
        metric.put(TelemetryOOBFields$.MODULE$.SFURL(), sfurl);
        metric.put(TelemetryOOBFields$.MODULE$.SENDER_CLASS(), senderClass);
        metric.put(TelemetryOOBFields$.MODULE$.OPERATION(), operation);
        metric.put(TelemetryOOBFields$.MODULE$.RETRY_COUNT(), retryCount);
        metric.put(TelemetryOOBFields$.MODULE$.MAX_RETRY_COUNT(), maxRetryCount);
        metric.put(TelemetryOOBFields$.MODULE$.SUCCESS(), success);
        metric.put(TelemetryOOBFields$.MODULE$.USE_PROXY(), useProxy);
        metric.put(TelemetryOOBFields$.MODULE$.QUERY_ID(), (String)queryID.getOrElse((Function0 & Serializable & scala.Serializable)() -> "NA"));
        if (throwable.isDefined()) {
            this.addThrowable(metric, (Throwable)throwable.get());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            metric.put(TelemetryOOBFields$.MODULE$.EXCEPTION_CLASS_NAME(), "NA");
            metric.put(TelemetryOOBFields$.MODULE$.EXCEPTION_MESSAGE(), "NA");
            boxedUnit = metric.put(TelemetryOOBFields$.MODULE$.STACKTRACE(), "NA");
        }
        TelemetryService oobTelemetryService = this.getOobTelemetryService();
        TelemetryEvent.LogBuilder logBuilder = new TelemetryEvent.LogBuilder();
        TelemetryEvent log = ((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)logBuilder.withName(new StringBuilder(2).append(this.TELEMETRY_OOB_NAME_PREFIX()).append("_").append(operation).append("_").append(senderClass).toString())).withValue(metric.toString()).withTag(TelemetryOOBTags$.MODULE$.CONNECTION_STRING(), new StringBuilder(12).append("https://").append(sfurl).append(":443").toString())).withTag(TelemetryOOBTags$.MODULE$.CTX_ACCOUNT(), sfurl.substring(0, sfurl.indexOf(".")))).withTag(TelemetryOOBTags$.MODULE$.CTX_HOST(), sfurl.substring(sfurl.indexOf(".") + 1))).withTag(TelemetryOOBTags$.MODULE$.CTX_PORT(), "443")).withTag(TelemetryOOBTags$.MODULE$.CTX_PROTOCAL(), "https")).withTag(TelemetryOOBTags$.MODULE$.CTX_USER(), "fake_spark_user")).withTag(TelemetryOOBTags$.MODULE$.SPARK_CONNECTOR_VERSION(), Utils$.MODULE$.VERSION())).withTag(TelemetryOOBTags$.MODULE$.SENDER_CLASS_NAME(), senderClass)).withTag(TelemetryOOBTags$.MODULE$.OPERATION(), operation)).build();
        this.logger().info(new StringBuilder(29).append("Send OOB Telemetry message: ").append(senderClass).append(" ").append(operation).toString());
        oobTelemetryService.report(log);
    }

    public void send(Telemetry telemetry) {
        List<Tuple2<ObjectNode, Object>> curLogs = Nil$.MODULE$;
        SnowflakeTelemetry$ snowflakeTelemetry$ = this;
        synchronized (snowflakeTelemetry$) {
            curLogs = this.logs();
            this.logs_$eq((List<Tuple2<ObjectNode, Object>>)Nil$.MODULE$);
        }
        curLogs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SnowflakeTelemetry$.$anonfun$send$1(telemetry, x0$1);
            return BoxedUnit.UNIT;
        });
        telemetry.sendBatchAsync();
    }

    public void addPushdownFailMessage(LogicalPlan plan, SnowflakePushdownUnsupportedException exception) {
        this.logger().info(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(91).append("Pushdown fails because of operation: ").append(exception.unsupportedOperation()).append("\n         | message: ").append(exception.getMessage()).append("\n         | isKnown: ").append(exception.isKnownUnsupportedOperation()).append("\n           ").toString())).stripMargin());
        if (exception.isKnownUnsupportedOperation()) {
            return;
        }
        ObjectNode metric = this.mapper().createObjectNode();
        metric.put(TelemetryPushdownFailFields$.MODULE$.SPARK_CONNECTOR_VERSION(), Utils$.MODULE$.VERSION());
        metric.put(TelemetryPushdownFailFields$.MODULE$.UNSUPPORTED_OPERATION(), exception.unsupportedOperation());
        metric.put(TelemetryPushdownFailFields$.MODULE$.EXCEPTION_MESSAGE(), exception.getMessage());
        metric.put(TelemetryPushdownFailFields$.MODULE$.EXCEPTION_DETAILS(), exception.details());
        this.addLog((Tuple2<Tuple2<Enumeration.Value, ObjectNode>, Object>)new Tuple2((Object)new Tuple2((Object)TelemetryTypes$.MODULE$.SPARK_PUSHDOWN_FAIL(), (Object)metric), (Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
    }

    public void addThrowable(ObjectNode metric, Throwable th) {
        metric.put(TelemetryFieldNames$.MODULE$.EXCEPTION_CLASS_NAME(), th.getClass().toString());
        if (th instanceof SnowflakeSQLException) {
            SnowflakeSQLException e = (SnowflakeSQLException)th;
            String proposedMessage = new StringBuilder(52).append("SnowflakeSQLException: ErrorCode=").append(e.getErrorCode()).append(" SQLState=").append(e.getSQLState()).append(" QueryId=").append(e.getQueryId()).toString();
            metric.put(TelemetryFieldNames$.MODULE$.EXCEPTION_MESSAGE(), proposedMessage);
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            String stacktraceString = stringWriter.toString().replaceAll(Pattern.quote(e.getMessage()), proposedMessage);
            metric.put(TelemetryFieldNames$.MODULE$.STACKTRACE(), stacktraceString);
        } else {
            metric.put(TelemetryFieldNames$.MODULE$.EXCEPTION_MESSAGE(), th.getMessage());
            StringWriter stringWriter = new StringWriter();
            th.printStackTrace(new PrintWriter(stringWriter));
            metric.put(TelemetryFieldNames$.MODULE$.STACKTRACE(), stringWriter.toString());
        }
    }

    public void sendQueryStatus(Connection conn, String operation, String queryId, String queryStatus, long elapse, Option<Throwable> throwable, String details) {
        try {
            ObjectNode metric = this.mapper().createObjectNode();
            metric.put(TelemetryQueryStatusFields$.MODULE$.SPARK_CONNECTOR_VERSION(), Utils$.MODULE$.VERSION());
            metric.put(TelemetryQueryStatusFields$.MODULE$.OPERATION(), operation);
            metric.put(TelemetryQueryStatusFields$.MODULE$.QUERY_ID(), queryId);
            metric.put(TelemetryQueryStatusFields$.MODULE$.QUERY_STATUS(), queryStatus);
            metric.put(TelemetryQueryStatusFields$.MODULE$.ELAPSED_TIME(), elapse);
            if (throwable.isDefined()) {
                this.addThrowable(metric, (Throwable)throwable.get());
            }
            metric.put(TelemetryQueryStatusFields$.MODULE$.DETAILS(), details);
            this.addLog((Tuple2<Tuple2<Enumeration.Value, ObjectNode>, Object>)new Tuple2((Object)new Tuple2((Object)TelemetryTypes$.MODULE$.SPARK_QUERY_STATUS(), (Object)metric), (Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
            this.send(DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn).getTelemetry());
        }
        catch (Throwable th) {
            this.logger().warn(new StringBuilder(41).append("Fail to send spark_query_status. reason: ").append(th.getMessage()).toString());
        }
    }

    public ObjectNode getClientConfig() {
        ObjectNode objectNode;
        ObjectNode metric = this.mapper().createObjectNode();
        try {
            Utils$.MODULE$.addVersionInfo(metric);
            metric.put(TelemetryClientInfoFields$.MODULE$.OS_NAME(), System.getProperty(TelemetryConstValues$.MODULE$.JVM_PROPERTY_NAME_OS_NAME()));
            Runtime rt = Runtime.getRuntime();
            metric.put(TelemetryClientInfoFields$.MODULE$.MAX_MEMORY_IN_MB(), rt.maxMemory() / (long)this.MB());
            metric.put(TelemetryClientInfoFields$.MODULE$.TOTAL_MEMORY_IN_MB(), rt.totalMemory() / (long)this.MB());
            metric.put(TelemetryClientInfoFields$.MODULE$.FREE_MEMORY_IN_MB(), rt.freeMemory() / (long)this.MB());
            metric.put(TelemetryClientInfoFields$.MODULE$.CPU_CORES(), rt.availableProcessors());
            SparkConf sparkConf = SparkEnv$.MODULE$.get().conf();
            ObjectNode sparkMetric = this.mapper().createObjectNode();
            this.sparkOptions().foreach((Function1 & Serializable & scala.Serializable)optionName -> sparkConf.contains(optionName) ? sparkMetric.put(optionName, sparkConf.get(optionName)) : BoxedUnit.UNIT);
            Object object = !sparkMetric.isEmpty() ? metric.set(TelemetryClientInfoFields$.MODULE$.SPARK_CONFIG(), (JsonNode)sparkMetric) : BoxedUnit.UNIT;
            objectNode = this.addTaskInfo(metric);
        }
        catch (Throwable throwable) {
            objectNode = metric;
        }
        return objectNode;
    }

    private Set<String> sparkOptions() {
        return this.sparkOptions;
    }

    public ObjectNode getTaskInfo() {
        ObjectNode objectNode;
        ObjectNode metric = this.mapper().createObjectNode();
        try {
            objectNode = this.addTaskInfo(metric);
        }
        catch (Throwable throwable) {
            objectNode = metric;
        }
        return objectNode;
    }

    private ObjectNode addTaskInfo(ObjectNode metric) {
        BoxedUnit boxedUnit;
        TaskContext task = TaskContext$.MODULE$.get();
        if (task != null) {
            metric.put(TelemetryTaskInfoFields$.MODULE$.TASK_PARTITION_ID(), task.partitionId());
            metric.put(TelemetryTaskInfoFields$.MODULE$.TASK_ATTEMPT_ID(), task.taskAttemptId());
            metric.put(TelemetryTaskInfoFields$.MODULE$.TASK_ATTEMPT_NUMBER(), task.attemptNumber());
            metric.put(TelemetryTaskInfoFields$.MODULE$.TASK_STAGE_ATTEMPT_NUMBER(), task.stageAttemptNumber());
            metric.put(TelemetryTaskInfoFields$.MODULE$.TASK_STAGE_ID(), task.stageId());
            boxedUnit = metric.put(TelemetryTaskInfoFields$.MODULE$.THREAD_ID(), Thread.currentThread().getId());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return metric;
    }

    public static final /* synthetic */ boolean $anonfun$sendClientInfoTelemetryIfNotYet$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$send$1(Telemetry telemetry$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ObjectNode log = (ObjectNode)tuple2._1();
        long timestamp = tuple2._2$mcJ$sp();
        MODULE$.logger().debug(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(86).append("\n             |Send Telemetry\n             |timestamp:").append(timestamp).append("\n             |log:").append(log.toString()).append("\"\n           ").toString())).stripMargin());
        ((TelemetryClient)telemetry$1).addLogToBatch(log, timestamp);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private SnowflakeTelemetry$() {
        MODULE$ = this;
        this.TELEMETRY_TYPE_FIELD_NAME = "type";
        this.TELEMETRY_SOURCE_FIELD_NAME = "source";
        this.TELEMETRY_DATA_FIELD_NAME = "data";
        this.TELEMETRY_SOURCE = "spark_connector";
        this.TELEMETRY_OOB_NAME_PREFIX = "spark";
        this.logs = Nil$.MODULE$;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.mapper = new ObjectMapper();
        this.hasClientInfoSent = false;
        this.MB = 0x100000;
        TelemetryService.enable();
        this.sparkOptions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark.app.name", "spark.app.id", "spark.submit.deployMode", "spark.jars", "spark.master", "spark.repl.local.jars", "spark.driver.host", "spark.driver.extraJavaOptions", "spark.driver.extraClassPath", "spark.driver.cores", "spark.executor.cores", "spark.executor.instances", "spark.executor.extraJavaOptions", "spark.executor.extraClassPath", "spark.executor.id", "spark.driver.memory", "spark.driver.memoryOverhead", "spark.executor.memory", "spark.executor.memoryOverhead", "spark.executor.pyspark.memory", "spark.python.worker.memory", "spark.memory.fraction", "spark.memory.storageFraction", "spark.memory.offHeap.enabled", "spark.memory.offHeap.size", "spark.default.parallelism", "spark.dynamicAllocation.enabled", "spark.dynamicAllocation.initialExecutors", "spark.dynamicAllocation.maxExecutors", "spark.dynamicAllocation.minExecutors", "spark.sql.ansi.enabled", "spark.pyspark.driver.python", "spark.pyspark.python", "spark.sql.session.timeZone"}));
    }
}

