/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake.io;

import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import net.snowflake.spark.snowflake.Parameters;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ParquetUtils$ {
    public static ParquetUtils$ MODULE$;
    private final String nameSpace;

    static {
        new ParquetUtils$();
    }

    private String nameSpace() {
        return this.nameSpace;
    }

    public GenericData.Record rowToAvroRecord(Row row, Schema schema, StructType snowflakeStyleSchema, Parameters.MergedParameters params) {
        GenericData.Record record = new GenericData.Record(schema);
        ((IterableLike)row.toSeq().zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])snowflakeStyleSchema.names()), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ParquetUtils$.$anonfun$rowToAvroRecord$1(record, schema, snowflakeStyleSchema, params, x0$1);
            return BoxedUnit.UNIT;
        });
        return record;
    }

    public Schema convertStructToAvro(StructType structType) {
        return (Schema)this.convertStructToAvro(structType, (SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"root").namespace(this.nameSpace()));
    }

    private <T> T convertStructToAvro(StructType structType, SchemaBuilder.RecordBuilder<T> builder) {
        SchemaBuilder.FieldAssembler filedAssembler = builder.fields();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).foreach((Function1 & Serializable & scala.Serializable)field -> {
            SchemaBuilder.FieldTypeBuilder newField = filedAssembler.name(field.name()).type();
            return MODULE$.convertFieldToAvro(field.dataType(), (SchemaBuilder.BaseFieldTypeBuilder)(field.nullable() ? newField.nullable() : newField), field.name()).noDefault();
        });
        return (T)filedAssembler.endRecord();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> SchemaBuilder.FieldDefault<T, ?> convertFieldToAvro(DataType dataType, SchemaBuilder.BaseFieldTypeBuilder<T> builder, String name) {
        DataType dataType2 = dataType;
        boolean bl = ByteType$.MODULE$.equals(dataType2) ? true : (ShortType$.MODULE$.equals(dataType2) ? true : IntegerType$.MODULE$.equals(dataType2));
        if (bl) {
            return builder.intType();
        }
        if (LongType$.MODULE$.equals(dataType2)) {
            return builder.longType();
        }
        if (FloatType$.MODULE$.equals(dataType2)) {
            return builder.floatType();
        }
        if (DoubleType$.MODULE$.equals(dataType2)) {
            return builder.doubleType();
        }
        if (dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            return (SchemaBuilder.FieldDefault)((SchemaBuilder.BytesBuilder)builder.bytesBuilder().prop("logicalType", "decimal").prop("precision", (Object)BoxesRunTime.boxToInteger((int)decimalType.precision())).prop("scale", (Object)BoxesRunTime.boxToInteger((int)decimalType.scale()))).endBytes();
        }
        if (StringType$.MODULE$.equals(dataType2)) {
            return builder.stringType();
        }
        if (BinaryType$.MODULE$.equals(dataType2)) {
            return builder.bytesType();
        }
        if (BooleanType$.MODULE$.equals(dataType2)) {
            return builder.booleanType();
        }
        if (DateType$.MODULE$.equals(dataType2)) {
            return (SchemaBuilder.FieldDefault)((SchemaBuilder.StringBldr)builder.stringBuilder().prop("logicalType", "date")).endString();
        }
        if (TimestampType$.MODULE$.equals(dataType2)) {
            return (SchemaBuilder.FieldDefault)((SchemaBuilder.StringBldr)builder.stringBuilder().prop("logicalType", " timestamp-micros")).endString();
        }
        if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            boolean nullable = arrayType.containsNull();
            return (SchemaBuilder.FieldDefault)builder.array().items(this.convertTypeToAvro(elementType, this.getSchemaBuilder(nullable), name));
        }
        if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType dataType3 = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            if (StringType$.MODULE$.equals(dataType3)) {
                return (SchemaBuilder.FieldDefault)builder.map().values(this.convertTypeToAvro(valueType, this.getSchemaBuilder(valueContainsNull), name));
            }
        }
        if (!(dataType2 instanceof StructType)) throw new UnsupportedOperationException(new StringBuilder(17).append("Unexpected type: ").append(dataType).toString());
        StructType structType = (StructType)dataType2;
        return (SchemaBuilder.FieldDefault)this.convertStructToAvro(structType, (SchemaBuilder.RecordBuilder)builder.record(name).namespace(this.nameSpace()));
    }

    /*
     * Enabled aggressive block sorting
     */
    private <T> T convertTypeToAvro(DataType dataType, SchemaBuilder.BaseTypeBuilder<T> builder, String name) {
        Object object;
        DataType dataType2 = dataType;
        boolean bl = ByteType$.MODULE$.equals(dataType2) ? true : (ShortType$.MODULE$.equals(dataType2) ? true : IntegerType$.MODULE$.equals(dataType2));
        if (bl) {
            object = builder.intType();
            return (T)object;
        }
        if (LongType$.MODULE$.equals(dataType2)) {
            object = builder.longType();
            return (T)object;
        }
        if (FloatType$.MODULE$.equals(dataType2)) {
            object = builder.floatType();
            return (T)object;
        }
        if (DoubleType$.MODULE$.equals(dataType2)) {
            object = builder.doubleType();
            return (T)object;
        }
        if (dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            object = ((SchemaBuilder.BytesBuilder)builder.bytesBuilder().prop("logicalType", "decimal").prop("precision", (Object)BoxesRunTime.boxToInteger((int)decimalType.precision())).prop("scale", (Object)BoxesRunTime.boxToInteger((int)decimalType.scale()))).endBytes();
            return (T)object;
        }
        if (StringType$.MODULE$.equals(dataType2)) {
            object = builder.stringType();
            return (T)object;
        }
        if (BinaryType$.MODULE$.equals(dataType2)) {
            object = builder.bytesType();
            return (T)object;
        }
        if (BooleanType$.MODULE$.equals(dataType2)) {
            object = builder.booleanType();
            return (T)object;
        }
        if (DateType$.MODULE$.equals(dataType2)) {
            object = ((SchemaBuilder.StringBldr)builder.stringBuilder().prop("logicalType", "date")).endString();
            return (T)object;
        }
        boolean bl2 = TimestampType$.MODULE$.equals(dataType2) ? true : TimestampNTZType$.MODULE$.equals(dataType2);
        if (bl2) {
            object = ((SchemaBuilder.StringBldr)builder.stringBuilder().prop("logicalType", "timestamp-micros")).endString();
            return (T)object;
        }
        if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            boolean nullable = arrayType.containsNull();
            object = builder.array().items(this.convertTypeToAvro(elementType, this.getSchemaBuilder(nullable), name));
            return (T)object;
        }
        if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType dataType3 = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            if (StringType$.MODULE$.equals(dataType3)) {
                object = builder.map().values(this.convertTypeToAvro(valueType, this.getSchemaBuilder(valueContainsNull), name));
                return (T)object;
            }
        }
        if (!(dataType2 instanceof StructType)) throw new UnsupportedOperationException(new StringBuilder(17).append("Unexpected type: ").append(dataType).toString());
        StructType structType = (StructType)dataType2;
        object = this.convertStructToAvro(structType, (SchemaBuilder.RecordBuilder)builder.record(name).namespace(this.nameSpace()));
        return (T)object;
    }

    private SchemaBuilder.BaseTypeBuilder<Schema> getSchemaBuilder(boolean isNullable) {
        return isNullable ? SchemaBuilder.nullable() : SchemaBuilder.builder();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$rowToAvroRecord$1(GenericData.Record record$1, Schema schema$1, StructType snowflakeStyleSchema$1, Parameters.MergedParameters params$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object row = tuple2._1();
            String name = (String)tuple2._2();
            if (row instanceof Row) {
                Row row2 = (Row)row;
                record$1.put(name, (Object)MODULE$.rowToAvroRecord(row2, (Schema)schema$1.getField(name).schema().getTypes().get(0), (StructType)snowflakeStyleSchema$1.apply(name).dataType(), params$1));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            Object map = tuple2._1();
            String name = (String)tuple2._2();
            if (map instanceof scala.collection.immutable.Map) {
                scala.collection.immutable.Map map2 = (scala.collection.immutable.Map)map;
                record$1.put(name, JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)map2).asJava());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            Object str = tuple2._1();
            String name = (String)tuple2._2();
            if (str instanceof String) {
                String string = (String)str;
                record$1.put(name, (Object)(params$1.trimSpace() ? string.trim() : string));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            Object arr = tuple2._1();
            String name = (String)tuple2._2();
            if (arr instanceof WrappedArray) {
                WrappedArray wrappedArray = (WrappedArray)arr;
                record$1.put(name, wrappedArray.toArray(ClassTag$.MODULE$.Any()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            Object decimal = tuple2._1();
            String name = (String)tuple2._2();
            if (decimal instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)decimal;
                record$1.put(name, (Object)ByteBuffer.wrap(bigDecimal.unscaledValue().toByteArray()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            Object timestamp = tuple2._1();
            String name = (String)tuple2._2();
            if (timestamp instanceof Timestamp) {
                Timestamp timestamp2 = (Timestamp)timestamp;
                record$1.put(name, (Object)timestamp2.toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            Object date = tuple2._1();
            String name = (String)tuple2._2();
            if (date instanceof Date) {
                Date date2 = (Date)date;
                record$1.put(name, (Object)date2.toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            Object date = tuple2._1();
            String name = (String)tuple2._2();
            if (date instanceof LocalDateTime) {
                LocalDateTime localDateTime = (LocalDateTime)date;
                record$1.put(name, (Object)BoxesRunTime.boxToLong((long)localDateTime.toEpochSecond(ZoneOffset.UTC)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Object value = tuple2._1();
        String name = (String)tuple2._2();
        record$1.put(name, value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private ParquetUtils$() {
        MODULE$ = this;
        this.nameSpace = "snowflake";
    }
}

