/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake;

import java.io.Serializable;
import java.net.URI;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSSessionCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.BasicAWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.InstanceProfileCredentialsProvider;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageCredentialsSharedAccessSignature;
import net.snowflake.spark.snowflake.ConstantString;
import net.snowflake.spark.snowflake.EmptySnowflakeSQLStatement$;
import net.snowflake.spark.snowflake.FSType$;
import net.snowflake.spark.snowflake.Parameters;
import net.snowflake.spark.snowflake.SnowflakeSQLStatement;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.sql.SQLContext;
import scala.;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;

public final class CloudCredentialsUtils$ {
    public static final CloudCredentialsUtils$ MODULE$ = new CloudCredentialsUtils$();

    public SnowflakeSQLStatement getSnowflakeCredentialsString(SQLContext sqlContext, Parameters.MergedParameters params) {
        SnowflakeSQLStatement snowflakeSQLStatement;
        Enumeration.Value value = params.rootTempDirStorageType();
        Enumeration.Value value2 = FSType$.MODULE$.LocalFile();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            throw new UnsupportedOperationException("only supports Azure and S3 stage");
        }
        Enumeration.Value value4 = FSType$.MODULE$.Azure();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            StorageCredentialsSharedAccessSignature creds = this.getAzureCreds(params);
            snowflakeSQLStatement = this.getSnowflakeCredentialsStringForAzure(creds);
        } else {
            Enumeration.Value value6 = FSType$.MODULE$.S3();
            Enumeration.Value value7 = value;
            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                AWSCredentials creds = this.getAWSCreds(sqlContext, params);
                snowflakeSQLStatement = this.getSnowflakeCredentialsStringForAWS(creds);
            } else {
                snowflakeSQLStatement = EmptySnowflakeSQLStatement$.MODULE$.apply();
            }
        }
        return snowflakeSQLStatement;
    }

    public SnowflakeSQLStatement getSnowflakeCredentialsStringForAWS(AWSCredentials creds) {
        String string;
        String awsAccessKey = creds.getAWSAccessKeyId();
        String awsSecretKey = creds.getAWSSecretKey();
        AWSCredentials aWSCredentials = creds;
        if (aWSCredentials instanceof AWSSessionCredentials) {
            AWSSessionCredentials aWSSessionCredentials = (AWSSessionCredentials)aWSCredentials;
            string = new StringBuilder(12).append("AWS_TOKEN='").append(aWSSessionCredentials.getSessionToken()).append("'").toString();
        } else {
            string = "";
        }
        String tokenString = string;
        return new ConstantString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(112).append("\n       |CREDENTIALS = (\n       |    AWS_KEY_ID='").append(awsAccessKey).append("'\n       |    AWS_SECRET_KEY='").append(awsSecretKey).append("'\n       |    ").append(tokenString).append("\n       |)\n       |").toString())).trim()).$bang();
    }

    public SnowflakeSQLStatement getSnowflakeCredentialsStringForAzure(StorageCredentialsSharedAccessSignature creds) {
        String sasToken = creds.getToken();
        return new ConstantString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(74).append("\n       |CREDENTIALS = (\n       |    AZURE_SAS_TOKEN='").append(sasToken).append("'\n       |)\n       |").toString())).trim()).$bang();
    }

    public AWSCredentials getAWSCreds(SQLContext sqlContext, Parameters.MergedParameters params) {
        Enumeration.Value value = params.rootTempDirStorageType();
        Enumeration.Value value2 = FSType$.MODULE$.S3();
        return !(value != null ? !value.equals(value2) : value2 != null) ? (AWSCredentials)params.temporaryAWSCredentials().getOrElse((Function0 & Serializable)() -> MODULE$.load(params.rootTempDir(), sqlContext.sparkContext().hadoopConfiguration())) : null;
    }

    public StorageCredentialsSharedAccessSignature getAzureCreds(Parameters.MergedParameters params) {
        Enumeration.Value value = params.rootTempDirStorageType();
        Enumeration.Value value2 = FSType$.MODULE$.Azure();
        return !(value != null ? !value.equals(value2) : value2 != null) ? (StorageCredentialsSharedAccessSignature)params.temporaryAzureStorageCredentials().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()) : null;
    }

    private Tuple2<String, String> getS3Credentials(URI uri, Configuration conf) {
        if (uri.getHost() == null) {
            throw new IllegalArgumentException(new StringBuilder(24).append("Invalid hostname in URI ").append(uri).toString());
        }
        String accessKey = null;
        String secretAccessKey = null;
        String userInfo = uri.getUserInfo();
        if (userInfo != null) {
            int index = userInfo.indexOf(58);
            if (index != -1) {
                accessKey = userInfo.substring(0, index);
                secretAccessKey = userInfo.substring(index + 1);
            } else {
                accessKey = userInfo;
            }
        }
        String scheme = uri.getScheme();
        String accessKeyProperty = String.format("fs.%s.awsAccessKeyId", scheme);
        String secretAccessKeyProperty = String.format("fs.%s.awsSecretAccessKey", scheme);
        if (accessKey == null) {
            accessKey = conf.get(accessKeyProperty);
        }
        if (secretAccessKey == null) {
            secretAccessKey = conf.get(secretAccessKeyProperty);
        }
        if (accessKey == null && secretAccessKey == null) {
            throw new IllegalArgumentException(new StringBuilder(161).append("AWS Access Key ID and Secret Access Key must be specified as the username or password (respectively) of a ").append(scheme).append(" URL, or by setting the ").append(accessKeyProperty).append(" or ").append(secretAccessKeyProperty).append(" properties (respectively).").toString());
        }
        if (accessKey == null) {
            throw new IllegalArgumentException(new StringBuilder(91).append("AWS Access Key ID must be specified as the username of a ").append(scheme).append(" URL, or by setting the ").append(accessKeyProperty).append(" property.").toString());
        }
        if (secretAccessKey == null) {
            throw new IllegalArgumentException(new StringBuilder(95).append("AWS Secret Access Key must be specified as the password of a ").append(scheme).append(" URL, or by setting the ").append(secretAccessKeyProperty).append(" property.").toString());
        }
        return new Tuple2((Object)accessKey, (Object)secretAccessKey);
    }

    public AWSCredentials load(String tempPath, Configuration hadoopConfiguration) {
        AWSCredentials aWSCredentials;
        block10: {
            String string;
            block9: {
                URI uri = new URI(tempPath);
                string = uri.getScheme();
                switch (string == null ? 0 : string.hashCode()) {
                    case 3616: {
                        if ("s3".equals(string)) {
                            break;
                        }
                        break block9;
                    }
                    case 112193: {
                        if (!"s3a".equals(string)) break block9;
                        aWSCredentials = (AWSCredentials)Option$.MODULE$.apply((Object)uri.getUserInfo()).flatMap((Function1 & Serializable)userInfo -> {
                            None$ none$;
                            if (userInfo.contains(":")) {
                                Object object;
                                String[] stringArray = userInfo.split(":");
                                if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) {
                                    throw new MatchError((Object)stringArray);
                                }
                                String accessKey = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                                String secretKey = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                                Tuple2 tuple2 = new Tuple2((Object)accessKey, (Object)secretKey);
                                Tuple2 tuple22 = tuple2;
                                String accessKey2 = (String)tuple22._1();
                                String secretKey2 = (String)tuple22._2();
                                none$ = new Some((Object)new BasicAWSCredentials(accessKey2, secretKey2));
                            } else {
                                none$ = None$.MODULE$;
                            }
                            return none$;
                        }).orElse((Function0 & Serializable)() -> {
                            String accessKey = hadoopConfiguration.get("fs.s3a.access.key", null);
                            String secretKey = hadoopConfiguration.get("fs.s3a.secret.key", null);
                            return accessKey != null && secretKey != null ? new Some((Object)new BasicAWSCredentials(accessKey, secretKey)) : None$.MODULE$;
                        }).getOrElse((Function0 & Serializable)() -> new InstanceProfileCredentialsProvider().getCredentials());
                        break block10;
                    }
                    case 112206: {
                        if ("s3n".equals(string)) {
                            break;
                        }
                        break block9;
                    }
                    case 3143036: {
                        if (!"file".equals(string)) break block9;
                        aWSCredentials = null;
                        break block10;
                    }
                    default: {
                        break block9;
                    }
                }
                Tuple2<String, String> tuple2 = this.getS3Credentials(uri, hadoopConfiguration);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String accessKey = (String)tuple2._1();
                String secretAccessKey = (String)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)accessKey, (Object)secretAccessKey);
                Tuple2 tuple23 = tuple22;
                String accessKey2 = (String)tuple23._1();
                String secretAccessKey2 = (String)tuple23._2();
                aWSCredentials = new BasicAWSCredentials(accessKey2, secretAccessKey2);
                break block10;
            }
            throw new IllegalArgumentException(new StringBuilder(46).append("Unrecognized scheme ").append(string).append("; expected s3, s3n, or s3a").toString());
        }
        return aWSCredentials;
    }

    private CloudCredentialsUtils$() {
    }
}

