/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.TimeZone;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.spark.snowflake.SnowflakeConnectorException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class Conversions$ {
    public static final Conversions$ MODULE$ = new Conversions$();
    private static final String net$snowflake$spark$snowflake$Conversions$$PATTERN_TZLTZ = System.getProperty("java.version").startsWith("1.6.") ? "Z yyyy-MM-dd HH:mm:ss.SSS" : "XX yyyy-MM-dd HH:mm:ss.SSS";
    private static final String net$snowflake$spark$snowflake$Conversions$$PATTERN_NTZ = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String net$snowflake$spark$snowflake$Conversions$$PATTERN_DATE = "yyyy-MM-dd";
    private static final DateFormat snowflakeTimestampFormat = new DateFormat(){
        private final ThreadLocal<SimpleDateFormat> formatTzLtz;
        private final ThreadLocal<SimpleDateFormat> formatNtz;

        private ThreadLocal<SimpleDateFormat> formatTzLtz() {
            return this.formatTzLtz;
        }

        private ThreadLocal<SimpleDateFormat> formatNtz() {
            return this.formatNtz;
        }

        public StringBuffer format(java.util.Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            return this.formatTzLtz().get().format(date, toAppendTo, fieldPosition);
        }

        public java.util.Date parse(String source2, ParsePosition pos) {
            java.util.Date date;
            int idx = pos.getIndex();
            int errIdx = pos.getErrorIndex();
            java.util.Date res = this.formatNtz().get().parse(source2, pos);
            if (res == null) {
                pos.setIndex(idx);
                pos.setErrorIndex(errIdx);
                date = this.formatTzLtz().get().parse(source2, pos);
            } else {
                date = res;
            }
            return date;
        }
        {
            this.formatTzLtz = new ThreadLocal<SimpleDateFormat>(null){

                public SimpleDateFormat initialValue() {
                    return new SimpleDateFormat(Conversions$.MODULE$.net$snowflake$spark$snowflake$Conversions$$PATTERN_TZLTZ());
                }
            };
            this.formatNtz = new ThreadLocal<SimpleDateFormat>(null){

                public SimpleDateFormat initialValue() {
                    return new SimpleDateFormat(Conversions$.MODULE$.net$snowflake$spark$snowflake$Conversions$$PATTERN_NTZ());
                }
            };
        }
    };
    private static final String PATTERN_WRITE_TZLTZ = "XX yyyy-MM-dd HH:mm:ss.SSSSSSSSS";
    private static final DateTimeFormatter timestampWriteFormatter = DateTimeFormatter.ofPattern(MODULE$.PATTERN_WRITE_TZLTZ());
    private static final ThreadLocal<SimpleDateFormat> snowflakeDateFormat = new ThreadLocal<SimpleDateFormat>(){

        public SimpleDateFormat initialValue() {
            return new SimpleDateFormat(Conversions$.MODULE$.net$snowflake$spark$snowflake$Conversions$$PATTERN_DATE());
        }
    };
    private static final ThreadLocal<DecimalFormat> snowflakeDecimalFormat = new ThreadLocal<DecimalFormat>(){

        /*
         * WARNING - void declaration
         */
        public DecimalFormat initialValue() {
            void var1_1;
            DecimalFormat df = new DecimalFormat();
            df.setParseBigDecimal(true);
            return var1_1;
        }
    };

    public String net$snowflake$spark$snowflake$Conversions$$PATTERN_TZLTZ() {
        return net$snowflake$spark$snowflake$Conversions$$PATTERN_TZLTZ;
    }

    public String net$snowflake$spark$snowflake$Conversions$$PATTERN_NTZ() {
        return net$snowflake$spark$snowflake$Conversions$$PATTERN_NTZ;
    }

    public String net$snowflake$spark$snowflake$Conversions$$PATTERN_DATE() {
        return net$snowflake$spark$snowflake$Conversions$$PATTERN_DATE;
    }

    private DateFormat snowflakeTimestampFormat() {
        return snowflakeTimestampFormat;
    }

    private String PATTERN_WRITE_TZLTZ() {
        return PATTERN_WRITE_TZLTZ;
    }

    private DateTimeFormatter timestampWriteFormatter() {
        return timestampWriteFormatter;
    }

    private ThreadLocal<SimpleDateFormat> snowflakeDateFormat() {
        return snowflakeDateFormat;
    }

    private ThreadLocal<DecimalFormat> snowflakeDecimalFormat() {
        return snowflakeDecimalFormat;
    }

    public String formatDate(java.util.Date d) {
        return ((DateFormat)this.snowflakeDateFormat().get()).format(d);
    }

    public String formatTimestamp(Timestamp t) {
        return this.timestampWriteFormatter().format(ZonedDateTime.of(t.toLocalDateTime(), TimeZone.getDefault().toZoneId()));
    }

    public String formatString(String s) {
        return new StringBuilder(2).append("\"").append(s.replace("\"", "\"\"")).append("\"").toString();
    }

    public String formatAny(Object v) {
        return v == null ? "" : v.toString();
    }

    public <T> Function1<String[], T> createRowConverter(StructType schema, ClassTag<T> evidence$1) {
        return (Function1 & Serializable)x$1 -> MODULE$.convertRow(schema, (String[])x$1, evidence$1);
    }

    private <T> T convertRow(StructType schema, String[] fields, ClassTag<T> evidence$2) {
        boolean isIR = this.isInternalRow(evidence$2);
        Object[] converted = (Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (IterableOnce)schema)), (Function1 & Serializable)x0$1 -> {
            Byte by;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String data;
                String input = (String)tuple2._1();
                StructField field = (StructField)tuple2._2();
                String string = data = input == null && !field.nullable() ? "" : input;
                if (data == null) {
                    by = null;
                } else {
                    DataType dataType = field.dataType();
                    Object object = ByteType$.MODULE$.equals(dataType) ? BoxesRunTime.boxToByte((byte)StringOps$.MODULE$.toByte$extension(Predef$.MODULE$.augmentString(data))) : (BooleanType$.MODULE$.equals(dataType) ? BoxesRunTime.boxToBoolean((boolean)MODULE$.parseBoolean(data)) : (DateType$.MODULE$.equals(dataType) ? MODULE$.parseDate(data, isIR) : (DoubleType$.MODULE$.equals(dataType) ? BoxesRunTime.boxToDouble((double)MODULE$.parseDouble(data)) : (FloatType$.MODULE$.equals(dataType) ? BoxesRunTime.boxToFloat((float)MODULE$.parseFloat(data)) : (dataType instanceof DecimalType ? MODULE$.parseDecimal(data, isIR) : (IntegerType$.MODULE$.equals(dataType) ? BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(data))) : (LongType$.MODULE$.equals(dataType) ? BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(data))) : (ShortType$.MODULE$.equals(dataType) ? BoxesRunTime.boxToShort((short)StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(data))) : (StringType$.MODULE$.equals(dataType) ? (isIR ? UTF8String.fromString((String)data) : data) : (TimestampType$.MODULE$.equals(dataType) ? MODULE$.parseTimestamp(data, isIR) : data))))))))));
                    by = object;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Byte by2 = by;
            return by2;
        }, ClassTag$.MODULE$.Any());
        return (T)(isIR ? InternalRow$.MODULE$.fromSeq((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)converted)) : Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)converted)));
    }

    /*
     * WARNING - void declaration
     */
    private Object parseTimestamp(String s, boolean isInternalRow) {
        void var3_3;
        Timestamp res = new Timestamp(this.snowflakeTimestampFormat().parse(s).getTime());
        return isInternalRow ? BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromJavaTimestamp(res)) : var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Object parseDate(String s, boolean isInternalRow) {
        void var3_3;
        Date d = new Date(((DateFormat)this.snowflakeDateFormat().get()).parse(s).getTime());
        return isInternalRow ? BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(d)) : var3_3;
    }

    private boolean parseBoolean(String s) {
        boolean bl;
        String string = s;
        String string2 = "true";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            bl = true;
        } else {
            String string3 = s;
            String string4 = "false";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                bl = false;
            } else {
                throw new IllegalArgumentException(new StringBuilder(37).append("Expected 'true' or 'false' but got '").append(s).append("'").toString());
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public Object parseDecimal(String s, boolean isInternalRow) {
        void var3_3;
        BigDecimal res = (BigDecimal)((NumberFormat)this.snowflakeDecimalFormat().get()).parse(s);
        return isInternalRow ? Decimal$.MODULE$.apply(res) : var3_3;
    }

    private double parseDouble(String s) {
        return s.equalsIgnoreCase("inf") ? Double.POSITIVE_INFINITY : (s.equalsIgnoreCase("-inf") ? Double.NEGATIVE_INFINITY : (s.equalsIgnoreCase("NaN") ? Double.NaN : StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(s))));
    }

    private float parseFloat(String s) {
        return s.equalsIgnoreCase("inf") ? Float.POSITIVE_INFINITY : (s.equalsIgnoreCase("-inf") ? Float.NEGATIVE_INFINITY : (s.equalsIgnoreCase("NaN") ? Float.NaN : StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(s))));
    }

    public <T> Object jsonStringToRow(JsonNode data, DataType dataType, ClassTag<T> evidence$3) {
        Object object;
        boolean isIR = this.isInternalRow(evidence$3);
        DataType dataType2 = dataType;
        if (ByteType$.MODULE$.equals(dataType2)) {
            object = BoxesRunTime.boxToByte((byte)((byte)data.asInt()));
        } else if (BooleanType$.MODULE$.equals(dataType2)) {
            object = BoxesRunTime.boxToBoolean((boolean)data.asBoolean());
        } else if (DateType$.MODULE$.equals(dataType2)) {
            object = this.parseDate(data.asText(), isIR);
        } else if (DoubleType$.MODULE$.equals(dataType2)) {
            object = BoxesRunTime.boxToDouble((double)data.asDouble());
        } else if (FloatType$.MODULE$.equals(dataType2)) {
            object = BoxesRunTime.boxToFloat((float)((float)data.asDouble()));
        } else if (dataType2 != null && DecimalType$.MODULE$.unapply(dataType2)) {
            object = Decimal$.MODULE$.apply(data.decimalValue());
        } else if (IntegerType$.MODULE$.equals(dataType2)) {
            object = BoxesRunTime.boxToInteger((int)data.asInt());
        } else if (LongType$.MODULE$.equals(dataType2)) {
            object = BoxesRunTime.boxToLong((long)data.asLong());
        } else if (ShortType$.MODULE$.equals(dataType2)) {
            object = BoxesRunTime.boxToShort((short)data.shortValue());
        } else if (StringType$.MODULE$.equals(dataType2)) {
            object = isIR ? UTF8String.fromString((String)data.asText()) : data.asText();
        } else if (TimestampType$.MODULE$.equals(dataType2)) {
            object = this.parseTimestamp(data.asText(), isIR);
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType dt = arrayType.elementType();
            Object[] result = new Object[data.size()];
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), data.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                result$1[i] = MODULE$.jsonStringToRow(data.get(i), dt, evidence$3);
            });
            object = new GenericArrayData(result);
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            StructField[] fields = structType.fields();
            Object[] converted = (Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)field -> {
                JsonNode value = data.findValue(field.name());
                if (value == null) {
                    if (!field.nullable()) throw new IllegalArgumentException("data is not nullable");
                    return null;
                }
                Object object = MODULE$.jsonStringToRow(value, field.dataType(), evidence$3);
                return object;
            }, ClassTag$.MODULE$.Any());
            object = isIR ? InternalRow$.MODULE$.fromSeq((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)converted)) : Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)converted));
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType dt = mapType.valueType();
            Iterator keys = data.fieldNames();
            Nil$ keyList = package$.MODULE$.Nil();
            Nil$ valueList = package$.MODULE$.Nil();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                UTF8String uTF8String = UTF8String.fromString((String)key);
                keyList = keyList.$colon$colon((Object)uTF8String);
                Object object2 = this.jsonStringToRow(data.get(key), dt, evidence$3);
                valueList = valueList.$colon$colon(object2);
            }
            object = new ArrayBasedMapData((ArrayData)new GenericArrayData(keyList.reverse().toArray(ClassTag$.MODULE$.apply(UTF8String.class))), (ArrayData)new GenericArrayData((Object[])valueList.reverse().toArray(ClassTag$.MODULE$.Any())));
        } else {
            object = isIR ? UTF8String.fromString((String)data.toString()) : data.toString();
        }
        return object;
    }

    public <U> boolean isInternalRow(ClassTag<U> evidence$4) {
        boolean bl;
        ClassTag row = (ClassTag)Predef$.MODULE$.implicitly((Object)ClassTag$.MODULE$.apply(Row.class));
        ClassTag internalRow = (ClassTag)Predef$.MODULE$.implicitly((Object)ClassTag$.MODULE$.apply(InternalRow.class));
        ClassTag classTag = (ClassTag)Predef$.MODULE$.implicitly(evidence$4);
        ClassTag classTag2 = row;
        ClassTag classTag3 = classTag;
        if (!(classTag2 != null ? !classTag2.equals(classTag3) : classTag3 != null)) {
            bl = false;
        } else {
            ClassTag classTag4 = internalRow;
            ClassTag classTag5 = classTag;
            if (!(classTag4 != null ? !classTag4.equals(classTag5) : classTag5 != null)) {
                bl = true;
            } else {
                throw new SnowflakeConnectorException("Wrong type for convertRow.");
            }
        }
        return bl;
    }

    private Conversions$() {
    }
}

