/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import net.snowflake.spark.snowflake.BooleanVariable;
import net.snowflake.spark.snowflake.ByteVariable;
import net.snowflake.spark.snowflake.ConstantString;
import net.snowflake.spark.snowflake.ConstantStringVal$;
import net.snowflake.spark.snowflake.DoubleVariable;
import net.snowflake.spark.snowflake.EmptySnowflakeSQLStatement$;
import net.snowflake.spark.snowflake.FloatVariable;
import net.snowflake.spark.snowflake.IntVariable;
import net.snowflake.spark.snowflake.LongVariable;
import net.snowflake.spark.snowflake.ShortVariable;
import net.snowflake.spark.snowflake.SnowflakeSQLStatement;
import net.snowflake.spark.snowflake.StringVariable;
import net.snowflake.spark.snowflake.Utils$;
import net.snowflake.spark.snowflake.pushdowns.querygeneration.package$;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class FilterPushdown$ {
    public static final FilterPushdown$ MODULE$ = new FilterPushdown$();

    public SnowflakeSQLStatement buildWhereStatement(StructType schema, Seq<Filter> filters, boolean keepNameCase) {
        SnowflakeSQLStatement filterStatement = package$.MODULE$.mkStatement((Seq<SnowflakeSQLStatement>)((Seq)filters.flatMap((Function1 & Serializable)x$1 -> MODULE$.buildFilterStatement(schema, (Filter)x$1, keepNameCase))), "AND");
        return filterStatement.isEmpty() ? EmptySnowflakeSQLStatement$.MODULE$.apply() : new ConstantString("WHERE").$plus(filterStatement);
    }

    public boolean buildWhereStatement$default$3() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<SnowflakeSQLStatement> buildFilterStatement(StructType schema, Filter filter, boolean keepNameCase) {
        Filter filter2 = filter;
        if (filter2 instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)filter2;
            String attr = equalTo.attribute();
            Object value = equalTo.value();
            return this.buildComparison$1(attr, value, "=", schema, keepNameCase);
        }
        if (filter2 instanceof LessThan) {
            LessThan lessThan = (LessThan)filter2;
            String attr = lessThan.attribute();
            Object value = lessThan.value();
            return this.buildComparison$1(attr, value, "<", schema, keepNameCase);
        }
        if (filter2 instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)filter2;
            String attr = greaterThan.attribute();
            Object value = greaterThan.value();
            return this.buildComparison$1(attr, value, ">", schema, keepNameCase);
        }
        if (filter2 instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter2;
            String attr = lessThanOrEqual.attribute();
            Object value = lessThanOrEqual.value();
            return this.buildComparison$1(attr, value, "<=", schema, keepNameCase);
        }
        if (filter2 instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter2;
            String attr = greaterThanOrEqual.attribute();
            Object value = greaterThanOrEqual.value();
            return this.buildComparison$1(attr, value, ">=", schema, keepNameCase);
        }
        if (filter2 instanceof In) {
            In in = (In)filter2;
            String attr = in.attribute();
            Object[] values = in.values();
            if (values != null) {
                Object[] objectArray = values;
                DataType dataType = (DataType)this.getTypeForAttribute(schema, attr).get();
                SnowflakeSQLStatement valueStrings = package$.MODULE$.mkStatement((Seq<SnowflakeSQLStatement>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps((Object)objectArray), (Function1 & Serializable)v -> FilterPushdown$.buildValueWithType$1(dataType, v), ClassTag$.MODULE$.apply(SnowflakeSQLStatement.class))), ", ");
                return new Some((Object)new ConstantString("(").$plus(FilterPushdown$.wrap$1(attr, keepNameCase)).$plus("IN").$plus("(").$plus(valueStrings).$plus("))"));
            }
        }
        if (filter2 instanceof IsNull) {
            IsNull isNull = (IsNull)filter2;
            String attr = isNull.attribute();
            return new Some((Object)new ConstantString("(").$plus(FilterPushdown$.wrap$1(attr, keepNameCase)).$plus("IS NULL)"));
        }
        if (filter2 instanceof IsNotNull) {
            IsNotNull isNotNull = (IsNotNull)filter2;
            String attr = isNotNull.attribute();
            return new Some((Object)new ConstantString("(").$plus(FilterPushdown$.wrap$1(attr, keepNameCase)).$plus("IS NOT NULL)"));
        }
        if (filter2 instanceof And) {
            And and = (And)filter2;
            Filter left = and.left();
            Filter right = and.right();
            return this.buildBinaryFilter$1(left, right, "AND", schema, keepNameCase);
        }
        if (filter2 instanceof Or) {
            Or or = (Or)filter2;
            Filter left = or.left();
            Filter right = or.right();
            return this.buildBinaryFilter$1(left, right, "OR", schema, keepNameCase);
        }
        if (filter2 instanceof Not) {
            Not not = (Not)filter2;
            Filter child = not.child();
            Option<SnowflakeSQLStatement> childStr = this.buildFilterStatement(schema, child, keepNameCase);
            return childStr.isEmpty() ? None$.MODULE$ : new Some((Object)new ConstantString("(NOT (").$plus((SnowflakeSQLStatement)childStr.get()).$plus("))"));
        }
        if (filter2 instanceof StringStartsWith) {
            StringStartsWith stringStartsWith = (StringStartsWith)filter2;
            String attr = stringStartsWith.attribute();
            String value = stringStartsWith.value();
            return new Some((Object)new ConstantString("STARTSWITH(").$plus(FilterPushdown$.wrap$1(attr, keepNameCase)).$plus(",").$plus(FilterPushdown$.buildValue$1(value)).$plus(")"));
        }
        if (filter2 instanceof StringEndsWith) {
            StringEndsWith stringEndsWith = (StringEndsWith)filter2;
            String attr = stringEndsWith.attribute();
            String value = stringEndsWith.value();
            return new Some((Object)new ConstantString("ENDSWITH(").$plus(FilterPushdown$.wrap$1(attr, keepNameCase)).$plus(",").$plus(FilterPushdown$.buildValue$1(value)).$plus(")"));
        }
        if (!(filter2 instanceof StringContains)) return None$.MODULE$;
        StringContains stringContains = (StringContains)filter2;
        String attr = stringContains.attribute();
        String value = stringContains.value();
        return new Some((Object)new ConstantString("CONTAINS(").$plus(FilterPushdown$.wrap$1(attr, keepNameCase)).$plus(",").$plus(FilterPushdown$.buildValue$1(value)).$plus(")"));
    }

    private Option<DataType> getTypeForAttribute(StructType schema, String attribute) {
        return ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames()), (Object)attribute) ? new Some((Object)schema.apply(attribute).dataType()) : None$.MODULE$;
    }

    private static final SnowflakeSQLStatement buildValueWithType$1(DataType dataType, Object value) {
        SnowflakeSQLStatement snowflakeSQLStatement;
        DataType dataType2 = dataType;
        if (StringType$.MODULE$.equals(dataType2)) {
            snowflakeSQLStatement = new StringVariable((Option<String>)Option$.MODULE$.apply(value).map((Function1 & Serializable)x$2 -> x$2.toString().replace("'", "''").replace("\\", "\\\\"))).$bang();
        } else if (DateType$.MODULE$.equals(dataType2)) {
            snowflakeSQLStatement = new StringVariable((Option<String>)Option$.MODULE$.apply(value).map((Function1 & Serializable)x$3 -> ((Date)x$3).toString())).$plus("::DATE");
        } else if (TimestampType$.MODULE$.equals(dataType2)) {
            snowflakeSQLStatement = new StringVariable((Option<String>)Option$.MODULE$.apply(value).map((Function1 & Serializable)x$4 -> ((Timestamp)x$4).toString())).$plus("::TIMESTAMP(3)");
        } else {
            SnowflakeSQLStatement snowflakeSQLStatement2;
            Object object = value;
            if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                snowflakeSQLStatement2 = new IntVariable((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)n))).$bang();
            } else if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                snowflakeSQLStatement2 = new LongVariable((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)l))).$bang();
            } else if (object instanceof Short) {
                short s = BoxesRunTime.unboxToShort((Object)object);
                snowflakeSQLStatement2 = new ShortVariable((Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)s))).$bang();
            } else if (object instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                snowflakeSQLStatement2 = new BooleanVariable((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)bl))).$bang();
            } else if (object instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)object);
                snowflakeSQLStatement2 = new FloatVariable((Option<Object>)new Some((Object)BoxesRunTime.boxToFloat((float)f))).$bang();
            } else if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                snowflakeSQLStatement2 = new DoubleVariable((Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)d))).$bang();
            } else if (object instanceof Byte) {
                byte by = BoxesRunTime.unboxToByte((Object)object);
                snowflakeSQLStatement2 = new ByteVariable((Option<Object>)new Some((Object)BoxesRunTime.boxToByte((byte)by))).$bang();
            } else {
                snowflakeSQLStatement2 = ConstantStringVal$.MODULE$.apply(value).$bang();
            }
            snowflakeSQLStatement = snowflakeSQLStatement2;
        }
        return snowflakeSQLStatement;
    }

    private static final SnowflakeSQLStatement buildValue$1(Object value) {
        SnowflakeSQLStatement snowflakeSQLStatement;
        Object object = value;
        if (object instanceof String) {
            String string = (String)object;
            snowflakeSQLStatement = new StringVariable((Option<String>)Option$.MODULE$.apply((Object)string).map((Function1 & Serializable)x$5 -> x$5.replace("'", "''").replace("\\", "\\\\"))).$bang();
        } else if (object instanceof Date) {
            Date date = (Date)object;
            snowflakeSQLStatement = new StringVariable((Option<String>)Option$.MODULE$.apply((Object)date).map((Function1 & Serializable)x$6 -> x$6.toString())).$plus("::DATE");
        } else if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            snowflakeSQLStatement = new StringVariable((Option<String>)Option$.MODULE$.apply((Object)timestamp).map((Function1 & Serializable)x$7 -> x$7.toString())).$plus("::TIMESTAMP(3)");
        } else if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            snowflakeSQLStatement = new IntVariable((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)n))).$bang();
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            snowflakeSQLStatement = new LongVariable((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)l))).$bang();
        } else if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            snowflakeSQLStatement = new ShortVariable((Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)s))).$bang();
        } else if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            snowflakeSQLStatement = new BooleanVariable((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)bl))).$bang();
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            snowflakeSQLStatement = new FloatVariable((Option<Object>)new Some((Object)BoxesRunTime.boxToFloat((float)f))).$bang();
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            snowflakeSQLStatement = new DoubleVariable((Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)d))).$bang();
        } else if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            snowflakeSQLStatement = new ByteVariable((Option<Object>)new Some((Object)BoxesRunTime.boxToByte((byte)by))).$bang();
        } else {
            snowflakeSQLStatement = ConstantStringVal$.MODULE$.apply(value).$bang();
        }
        return snowflakeSQLStatement;
    }

    private final Option buildComparison$1(String attr, Object value, String comparisonOp, StructType schema$2, boolean keepNameCase$2) {
        Option<DataType> dataType = this.getTypeForAttribute(schema$2, attr);
        if (dataType.isEmpty()) {
            return None$.MODULE$;
        }
        SnowflakeSQLStatement sqlEscapedValue = FilterPushdown$.buildValueWithType$1((DataType)dataType.get(), value);
        return new Some((Object)new ConstantString(FilterPushdown$.wrap$1(attr, keepNameCase$2)).$plus(comparisonOp).$plus(sqlEscapedValue));
    }

    private final Option buildBinaryFilter$1(Filter left, Filter right, String op, StructType schema$2, boolean keepNameCase$2) {
        Option<SnowflakeSQLStatement> leftStr = this.buildFilterStatement(schema$2, left, keepNameCase$2);
        Option<SnowflakeSQLStatement> rightStr = this.buildFilterStatement(schema$2, right, keepNameCase$2);
        return leftStr.isEmpty() || rightStr.isEmpty() ? None$.MODULE$ : new Some((Object)new ConstantString("((").$plus((SnowflakeSQLStatement)leftStr.get()).$plus(")").$plus(op).$plus("(").$plus((SnowflakeSQLStatement)rightStr.get()).$plus("))"));
    }

    private static final String wrap$1(String name, boolean keepNameCase$2) {
        return keepNameCase$2 ? Utils$.MODULE$.quotedNameIgnoreCase(name) : name;
    }

    private FilterPushdown$() {
    }
}

