/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Timestamp;
import net.snowflake.client.jdbc.internal.apache.commons.codec.binary.Base64;
import net.snowflake.spark.snowflake.Conversions$;
import net.snowflake.spark.snowflake.JDBCWrapper;
import net.snowflake.spark.snowflake.Parameters;
import net.snowflake.spark.snowflake.TableName;
import net.snowflake.spark.snowflake.Utils$;
import net.snowflake.spark.snowflake.io.SupportedFormat$;
import net.snowflake.spark.snowflake.io.package$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005%b!B\u0004\t\u0001!y\u0001\u0002\u0003\f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\t\u000bq\u0001A\u0011A\u000f\t\u000b\u0001\u0002A\u0011A\u0011\t\u000bq\u0003A\u0011A/\t\u000bq\u0004A\u0011B?\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006\ty1K\\8xM2\f7.Z,sSR,'O\u0003\u0002\n\u0015\u0005I1O\\8xM2\f7.\u001a\u0006\u0003\u00171\tQa\u001d9be.T!!C\u0007\u000b\u00039\t1A\\3u'\t\u0001\u0001\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VMZ\u0001\fU\u0012\u00147m\u0016:baB,'o\u0001\u0001\u0011\u0005eQR\"\u0001\u0005\n\u0005mA!a\u0003&E\u0005\u000e;&/\u00199qKJ\fa\u0001P5oSRtDC\u0001\u0010 !\tI\u0002\u0001C\u0003\u0017\u0005\u0001\u0007\u0001$\u0001\u0003tCZ,G#\u0002\u0012&e\u0019[\u0005CA\t$\u0013\t!#C\u0001\u0003V]&$\b\"\u0002\u0014\u0004\u0001\u00049\u0013AC:rY\u000e{g\u000e^3yiB\u0011\u0001\u0006M\u0007\u0002S)\u0011!fK\u0001\u0004gFd'BA\u0006-\u0015\tic&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002_\u0005\u0019qN]4\n\u0005EJ#AC*R\u0019\u000e{g\u000e^3yi\")1g\u0001a\u0001i\u0005!A-\u0019;b!\t)4I\u0004\u00027\u0003:\u0011q\u0007\u0011\b\u0003q}r!!\u000f \u000f\u0005ijT\"A\u001e\u000b\u0005q:\u0012A\u0002\u001fs_>$h(C\u00010\u0013\tic&\u0003\u0002\fY%\u0011!fK\u0005\u0003\u0005&\nq\u0001]1dW\u0006<W-\u0003\u0002E\u000b\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003\u0005&BQaR\u0002A\u0002!\u000b\u0001b]1wK6{G-\u001a\t\u0003Q%K!AS\u0015\u0003\u0011M\u000bg/Z'pI\u0016DQ\u0001T\u0002A\u00025\u000ba\u0001]1sC6\u001c\bC\u0001(Z\u001d\tyuK\u0004\u0002Q-:\u0011\u0011+\u0016\b\u0003%Rs!AO*\n\u00039I!!C\u0007\n\u0005-a\u0011BA\u0005\u000b\u0013\tA\u0006\"\u0001\u0006QCJ\fW.\u001a;feNL!AW.\u0003!5+'oZ3e!\u0006\u0014\u0018-\\3uKJ\u001c(B\u0001-\t\u00039!\u0017\r^1Ge\u0006lW\rV8S\t\u0012#RA\u00187n]>\u00042a\u00182e\u001b\u0005\u0001'BA1,\u0003\r\u0011H\rZ\u0005\u0003G\u0002\u00141A\u0015#E!\t)\u0017N\u0004\u0002gOB\u0011!HE\u0005\u0003QJ\ta\u0001\u0015:fI\u00164\u0017B\u00016l\u0005\u0019\u0019FO]5oO*\u0011\u0001N\u0005\u0005\u0006M\u0011\u0001\ra\n\u0005\u0006g\u0011\u0001\r\u0001\u000e\u0005\u0006\u0019\u0012\u0001\r!\u0014\u0005\u0006a\u0012\u0001\r!]\u0001\u0007M>\u0014X.\u0019;\u0011\u0005ILhBA:w\u001d\tyE/\u0003\u0002v\u0011\u0005\u0011\u0011n\\\u0005\u0003ob\fqbU;qa>\u0014H/\u001a3G_Jl\u0017\r\u001e\u0006\u0003k\"I!A_>\u0003\u001fM+\b\u000f]8si\u0016$gi\u001c:nCRT!a\u001e=\u0002)I,Wn\u001c<f+N,G.Z:t\u0007>dW/\u001c8t)\u0011!d0!\u0001\t\u000b},\u0001\u0019\u0001\u001b\u0002\u0013\u0011\fG/\u0019$sC6,\u0007\"\u0002'\u0006\u0001\u0004i\u0015AF4f]\u000e{gN^3sg&|gNR;oGRLwN\\:\u0015\t\u0005\u001d\u0011\u0011\u0004\t\u0006#\u0005%\u0011QB\u0005\u0004\u0003\u0017\u0011\"!B!se\u0006L\bcB\t\u0002\u0010\u0005M\u00111C\u0005\u0004\u0003#\u0011\"!\u0003$v]\u000e$\u0018n\u001c82!\r\t\u0012QC\u0005\u0004\u0003/\u0011\"aA!os\"9\u00111\u0004\u0004A\u0002\u0005u\u0011AB:dQ\u0016l\u0017\r\u0005\u0003\u0002 \u0005\u0015RBAA\u0011\u0015\r\t\u0019#K\u0001\u0006if\u0004Xm]\u0005\u0005\u0003O\t\tC\u0001\u0006TiJ,8\r\u001e+za\u0016\u0004")
public class SnowflakeWriter {
    private final JDBCWrapper jdbcWrapper;

    public void save(SQLContext sqlContext, Dataset<Row> data, SaveMode saveMode, Parameters.MergedParameters params) {
        Enumeration.Value format;
        Enumeration.Value value = format = Utils$.MODULE$.containVariant(data.schema()) ? SupportedFormat$.MODULE$.JSON() : SupportedFormat$.MODULE$.CSV();
        if (params.columnMap().isEmpty()) {
            String string = params.columnMapping();
            String string2 = "name";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                try (Connection conn = this.jdbcWrapper.getConnector(params);){
                    Some toSchema = new Some((Object)Utils$.MODULE$.removeQuote(this.jdbcWrapper.resolveTable(conn, ((TableName)params.table().get()).name(), params)));
                    params.setColumnMap((Option<StructType>)Option$.MODULE$.apply((Object)data.schema()), (Option<StructType>)toSchema);
                }
            }
        }
        Dataset<Row> output = this.removeUselessColumns(data, params);
        RDD<String> strRDD = this.dataFrameToRDD(sqlContext, output, params, format);
        package$.MODULE$.writeRDD(sqlContext, params, strRDD, output.schema(), saveMode, format, package$.MODULE$.writeRDD$default$7());
    }

    public RDD<String> dataFrameToRDD(SQLContext sqlContext, Dataset<Row> data, Parameters.MergedParameters params, Enumeration.Value format) {
        RDD rDD;
        SparkSession spark = sqlContext.sparkSession();
        Enumeration.Value value = format;
        Enumeration.Value value2 = SupportedFormat$.MODULE$.CSV();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            Function1<Object, Object>[] conversionFunction = this.genConversionFunctions(data.schema());
            rDD = data.rdd().map((Function1 & Serializable)row -> ((IterableOnceOps)((IterableOps)row.toSeq().zip((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])conversionFunction))).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object element = tuple2._1();
                Function1 func = (Function1)tuple2._2();
                Object object = func.apply(element);
                return object;
            })).mkString("|"), ClassTag$.MODULE$.apply(String.class));
        } else {
            Enumeration.Value value4 = SupportedFormat$.MODULE$.JSON();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                rDD = data.toJSON().map((Function1 & Serializable)x$1 -> x$1.toString(), spark.implicits().newStringEncoder()).rdd();
            } else {
                throw new MatchError((Object)value);
            }
        }
        return rDD;
    }

    private Dataset<Row> removeUselessColumns(Dataset<Row> dataFrame, Parameters.MergedParameters params) {
        Dataset dataset;
        Option<Map<String, String>> option = params.columnMap();
        if (option instanceof Some) {
            Dataset dataset2;
            Some some = (Some)option;
            Map map = (Map)some.value();
            Seq names = (Seq)map.keys().toSeq().map((Function1 & Serializable)name -> name.contains(".") ? new StringBuilder(2).append("`").append((String)name).append("`").toString() : name);
            try {
                dataset2 = dataFrame.select((String)names.head(), (Seq)names.tail());
            }
            catch (AnalysisException e) {
                throw new IllegalArgumentException(new StringBuilder(43).append("Incorrect column name when column mapping: ").append(e.toString()).toString());
            }
            dataset = dataset2;
        } else {
            dataset = dataFrame;
        }
        return dataset;
    }

    public Function1<Object, Object>[] genConversionFunctions(StructType schema) {
        return (Function1[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)field -> {
            DataType dataType = field.dataType();
            Function1 & Serializable intersect = DateType$.MODULE$.equals(dataType) ? (Function1 & Serializable)v -> {
                String string;
                Object object = v;
                if (object == null) {
                    string = "";
                } else if (object instanceof Timestamp) {
                    Timestamp timestamp = (Timestamp)object;
                    string = Conversions$.MODULE$.formatTimestamp(timestamp);
                } else if (object instanceof Date) {
                    Date date = (Date)object;
                    string = Conversions$.MODULE$.formatDate(date);
                } else {
                    throw new MatchError(object);
                }
                return string;
            } : (TimestampType$.MODULE$.equals(dataType) ? (Function1 & Serializable)v -> v == null ? "" : Conversions$.MODULE$.formatTimestamp((Timestamp)v) : (StringType$.MODULE$.equals(dataType) ? (Function1 & Serializable)v -> v == null ? "" : Conversions$.MODULE$.formatString((String)v) : (BinaryType$.MODULE$.equals(dataType) ? (Function1 & Serializable)v -> {
                String string;
                Object object = v;
                if (object == null) {
                    string = "";
                } else if (object instanceof byte[]) {
                    byte[] byArray = (byte[])object;
                    string = Base64.encodeBase64String((byte[])byArray);
                } else {
                    throw new MatchError(object);
                }
                return string;
            } : (Function1 & Serializable)v -> Conversions$.MODULE$.formatAny(v))));
            return intersect;
        }, ClassTag$.MODULE$.apply(Function1.class));
    }

    public SnowflakeWriter(JDBCWrapper jdbcWrapper) {
        this.jdbcWrapper = jdbcWrapper;
    }
}

