/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake.io;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import net.snowflake.client.jdbc.SnowflakeResultSet;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ObjectNode;
import net.snowflake.spark.snowflake.ConstantString;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper$;
import net.snowflake.spark.snowflake.Parameters;
import net.snowflake.spark.snowflake.SnowflakeSQLStatement;
import net.snowflake.spark.snowflake.SnowflakeTelemetry$;
import net.snowflake.spark.snowflake.SparkConnectorContext$;
import net.snowflake.spark.snowflake.TelemetryConstValues$;
import net.snowflake.spark.snowflake.TelemetryFieldNames$;
import net.snowflake.spark.snowflake.TelemetryTypes$;
import net.snowflake.spark.snowflake.Utils$;
import net.snowflake.spark.snowflake.io.CloudStorage;
import net.snowflake.spark.snowflake.io.CloudStorageOperations$;
import net.snowflake.spark.snowflake.io.SupportedFormat$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;

public final class StageReader$ {
    public static final StageReader$ MODULE$ = new StageReader$();
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(MODULE$.getClass());
    private static final String OUTPUT_BYTES = TelemetryFieldNames$.MODULE$.OUTPUT_BYTES();

    private ObjectMapper mapper() {
        return mapper;
    }

    private Logger logger() {
        return logger;
    }

    private String OUTPUT_BYTES() {
        return OUTPUT_BYTES;
    }

    public RDD<String> readFromStage(SQLContext sqlContext, Parameters.MergedParameters params, SnowflakeSQLStatement statement, Enumeration.Value format) {
        ResultSet resultSet;
        Connection conn = DefaultJDBCWrapper$.MODULE$.getConnector(params);
        Tuple2<CloudStorage, String> tuple2 = CloudStorageOperations$.MODULE$.createStorageClient(params, conn, CloudStorageOperations$.MODULE$.createStorageClient$default$3(), CloudStorageOperations$.MODULE$.createStorageClient$default$4(), CloudStorageOperations$.MODULE$.createStorageClient$default$5());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        CloudStorage storage = (CloudStorage)tuple2._1();
        String stage = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)storage, (Object)stage);
        Tuple2 tuple23 = tuple22;
        CloudStorage storage2 = (CloudStorage)tuple23._1();
        String stage2 = (String)tuple23._2();
        boolean compress = params.sfCompress();
        String compressFormat = params.sfCompress() ? "gzip" : "none";
        Utils$.MODULE$.genPrologueSql(params).foreach((Function1 & Serializable)x -> x.execute(params.bindVariableEnabled(), conn));
        Utils$.MODULE$.executePreActions(DefaultJDBCWrapper$.MODULE$, conn, params, params.table());
        String prefix = Random$.MODULE$.alphanumeric().take(10).mkString("");
        SnowflakeSQLStatement copyStatement = this.buildUnloadStatement(params, statement, new StringBuilder(3).append("@").append(stage2).append("/").append(prefix).append("/").toString(), compressFormat, format);
        this.logger().info(new StringBuilder(52).append("Now executing below command to read from snowflake:\n").append(copyStatement.toString()).toString());
        long startTime = System.currentTimeMillis();
        try {
            if (params.isExecuteQueryWithSyncMode()) {
                resultSet = copyStatement.execute(params.bindVariableEnabled(), conn);
            } else {
                ResultSet asyncRs = copyStatement.executeAsync(false, conn);
                String queryID = ((SnowflakeResultSet)asyncRs).getQueryID();
                this.logger().info(new StringBuilder(0).append("The query ID for async reading from snowflake with COPY INTO LOCATION is: ").append(new StringBuilder(23).append(queryID).append("; The query ID URL is:\n").append(params.getQueryIDUrl(queryID)).toString()).toString());
                SparkConnectorContext$.MODULE$.addRunningQuery(sqlContext.sparkContext(), conn, queryID);
                asyncRs.getMetaData();
                SparkConnectorContext$.MODULE$.removeRunningQuery(sqlContext.sparkContext(), conn, queryID);
                resultSet = asyncRs;
            }
        }
        catch (Throwable th) {
            SnowflakeTelemetry$.MODULE$.sendQueryStatus(conn, TelemetryConstValues$.MODULE$.OPERATION_READ(), copyStatement.getLastQueryID(), TelemetryConstValues$.MODULE$.STATUS_FAIL(), System.currentTimeMillis() - startTime, (Option<Throwable>)new Some((Object)th), "Hit exception when reading with COPY INTO LOCATION");
            throw th;
        }
        ResultSet res = resultSet;
        ResultSetMetaData sch = res.getMetaData();
        if (sch.getColumnCount() >= 3) {
            String thirdColumnName = sch.getColumnName(3);
            String thirdColumnType = sch.getColumnTypeName(3);
            if (("output_bytes".equalsIgnoreCase(thirdColumnName) || "FILE_SIZE".equalsIgnoreCase(thirdColumnName)) && "number".equalsIgnoreCase(thirdColumnType)) {
                long dataSize = 0L;
                while (res.next()) {
                    dataSize += res.getLong(3);
                }
                this.sendEgressUsage(dataSize, conn);
            } else {
                this.logger().warn(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(75).append("The result format of COPY INTO LOCATION is not recognized.\n             | ").append(thirdColumnName).append(" ").append(thirdColumnType).toString())));
            }
        } else {
            this.logger().warn(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(72).append("The result format of COPY INTO LOCATION is not recognized.\n           | ").append(sch.getColumnCount()).toString())));
        }
        Utils$.MODULE$.executePostActions(DefaultJDBCWrapper$.MODULE$, conn, params, params.table());
        SnowflakeTelemetry$.MODULE$.send(DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn).getTelemetry());
        RDD<String> resultRDD = storage2.download(sqlContext.sparkContext(), format, compress, prefix);
        conn.close();
        return resultRDD;
    }

    private SnowflakeSQLStatement buildUnloadStatement(Parameters.MergedParameters params, SnowflakeSQLStatement statement, String location, String compression, Enumeration.Value format) {
        Tuple2 tuple2;
        Utils$.MODULE$.setLastSelect(statement.toString());
        Enumeration.Value value = format;
        Enumeration.Value value2 = SupportedFormat$.MODULE$.CSV();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            tuple2 = new Tuple2((Object)new ConstantString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(329).append("\n                 |FILE_FORMAT = (\n                 |    TYPE=CSV\n                 |    COMPRESSION='").append(compression).append("'\n                 |    FIELD_DELIMITER='|'\n                 |    FIELD_OPTIONALLY_ENCLOSED_BY='\"'\n                 |    ESCAPE_UNENCLOSED_FIELD = none\n                 |    NULL_IF= ()\n                 |  )\n                 |  ").toString()))).$bang(), (Object)new ConstantString("FROM (").$plus(statement).$plus(")"));
        } else {
            Enumeration.Value value4 = SupportedFormat$.MODULE$.JSON();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                tuple2 = new Tuple2((Object)new ConstantString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(142).append("\n                 |FILE_FORMAT = (\n                 |    TYPE=JSON\n                 |    COMPRESSION='").append(compression).append("'\n                 |)\n                 |").toString()))).$bang(), (Object)new ConstantString("FROM (SELECT object_construct(*) FROM (").$plus(statement).$plus("))"));
            } else {
                throw new MatchError((Object)value);
            }
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        SnowflakeSQLStatement formatStmt = (SnowflakeSQLStatement)tuple22._1();
        SnowflakeSQLStatement queryStmt = (SnowflakeSQLStatement)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)formatStmt, (Object)queryStmt);
        Tuple2 tuple24 = tuple23;
        SnowflakeSQLStatement formatStmt2 = (SnowflakeSQLStatement)tuple24._1();
        SnowflakeSQLStatement queryStmt2 = (SnowflakeSQLStatement)tuple24._2();
        SnowflakeSQLStatement result = new ConstantString(new StringBuilder(12).append("COPY INTO '").append(location).append("'").toString()).$plus(queryStmt2).$plus(formatStmt2).$plus("MAX_FILE_SIZE = ").$plus(params.s3maxfilesize());
        Utils$.MODULE$.setLastCopyUnload(result.toString());
        return result;
    }

    private Enumeration.Value buildUnloadStatement$default$5() {
        return SupportedFormat$.MODULE$.CSV();
    }

    public void sendEgressUsage(long bytes, Connection conn) {
        ObjectNode metric = this.mapper().createObjectNode();
        metric.put(this.OUTPUT_BYTES(), bytes);
        SnowflakeTelemetry$.MODULE$.addLog((Tuple2<Tuple2<Enumeration.Value, ObjectNode>, Object>)new Tuple2((Object)new Tuple2((Object)TelemetryTypes$.MODULE$.SPARK_EGRESS(), (Object)metric), (Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
        SnowflakeTelemetry$.MODULE$.send(DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn).getTelemetry());
        this.logger().debug(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(25).append("Data Egress Usage: ").append(bytes).append(" bytes").toString())));
    }

    private StageReader$() {
    }
}

