/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake.streaming;

import java.io.Serializable;
import java.security.PrivateKey;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import net.snowflake.ingest.SimpleIngestManager;
import net.snowflake.ingest.connection.HistoryRangeResponse;
import net.snowflake.ingest.connection.HistoryResponse;
import net.snowflake.ingest.connection.IngestStatus;
import net.snowflake.ingest.utils.StagedFileWrapper;
import net.snowflake.spark.snowflake.Parameters;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class SnowflakeIngestConnector$ {
    public static final SnowflakeIngestConnector$ MODULE$ = new SnowflakeIngestConnector$();

    public Function0<List<Tuple2<String, IngestStatus>>> createHistoryChecker(SimpleIngestManager ingestManager) {
        ObjectRef beginMark = ObjectRef.create(null);
        return (Function0 & Serializable)() -> {
            HistoryResponse response = ingestManager.getHistory(null, null, (String)beginMark$1.elem);
            beginMark$1.elem = (String)Option$.MODULE$.apply((Object)response.getNextBeginMark()).getOrElse((Function0 & Serializable)() -> (String)beginMark$1.elem);
            return response != null && response.files != null ? ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(response.files).asScala()).toList().flatMap((Function1 & Serializable)entry -> entry.getPath() != null && Predef$.MODULE$.Boolean2boolean(entry.isComplete()) ? (IterableOnce)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)entry.getPath(), (Object)entry.getStatus())})) : package$.MODULE$.Nil()) : package$.MODULE$.Nil();
        };
    }

    public List<Tuple2<String, IngestStatus>> checkHistoryByRange(SimpleIngestManager ingestManager, long start, long end) {
        HistoryRangeResponse response = ingestManager.getHistoryRange(null, this.timestampToDate(start), this.timestampToDate(end));
        return response != null && response.files != null ? ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(response.files).asScala()).toList().flatMap((Function1 & Serializable)entry -> entry.getPath() != null && Predef$.MODULE$.Boolean2boolean(entry.isComplete()) ? (IterableOnce)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)entry.getPath(), (Object)entry.getStatus())})) : package$.MODULE$.Nil()) : package$.MODULE$.Nil();
    }

    private String timestampToDate(long time) {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(tz);
        return df.format(new Date(time - 1000L));
    }

    public SimpleIngestManager createIngestManager(String account, String user, String pipe, String host, PrivateKey privateKey, int port, String scheme) {
        return new SimpleIngestManager(account, user, pipe, privateKey, scheme, host, port);
    }

    public void ingestFiles(List<String> files, SimpleIngestManager manager) {
        manager.ingestFiles((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)files.map((Function1 & Serializable)x$1 -> new StagedFileWrapper(x$1))).asJava(), null);
    }

    public SimpleIngestManager createIngestManager(Parameters.MergedParameters param, String pipeName) {
        String string;
        int port;
        String scheme;
        String host;
        Option option;
        Regex urlPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(https?://)?([^:]+)(:\\d+)?$"));
        Regex portPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(":(\\d+)"));
        Regex accountPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("([^.]+).+"));
        String string2 = param.sfURL().trim();
        if (string2 != null && !(option = urlPattern.unapplySeq((CharSequence)string2)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(3) == 0) {
            String account;
            Option option2;
            int n;
            host = (String)((LinearSeqOps)option.get()).apply(1);
            String portStr = (String)((LinearSeqOps)option.get()).apply(2);
            String string3 = scheme = param.isSslON() ? "https" : "http";
            if (portStr != null) {
                String t;
                Option option3;
                String string4 = portStr;
                if (string4 == null || (option3 = portPattern.unapplySeq((CharSequence)string4)).isEmpty() || option3.get() == null || ((List)option3.get()).lengthCompare(1) != 0) {
                    throw new MatchError((Object)string4);
                }
                String string5 = t = (String)((LinearSeqOps)option3.get()).apply(0);
                String t2 = string5;
                n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(t2));
            } else {
                n = param.isSslON() ? 443 : 80;
            }
            port = n;
            String string6 = host;
            if (string6 == null || (option2 = accountPattern.unapplySeq((CharSequence)string6)).isEmpty() || option2.get() == null || ((List)option2.get()).lengthCompare(1) != 0) {
                throw new MatchError((Object)string6);
            }
            string = account = (String)((LinearSeqOps)option2.get()).apply(0);
        } else {
            throw new IllegalArgumentException(new StringBuilder(15).append("incorrect url: ").append(param.sfURL()).toString());
        }
        String account = string;
        Predef$.MODULE$.require(param.privateKey().isDefined(), (Function0 & Serializable)() -> "PEM Private key must be specified with 'pem_private_key' parameter");
        PrivateKey privateKey = (PrivateKey)param.privateKey().get();
        String pipe = new StringBuilder(2).append(param.sfDatabase()).append(".").append(param.sfSchema()).append(".").append(pipeName).toString();
        SimpleIngestManager simpleIngestManager = this.createIngestManager(account, param.sfUser(), pipe, host, privateKey, port, scheme);
        return simpleIngestManager;
    }

    public int createIngestManager$default$6() {
        return 443;
    }

    public String createIngestManager$default$7() {
        return "https";
    }

    private SnowflakeIngestConnector$() {
    }
}

