/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake;

import java.nio.file.Paths;
import java.security.InvalidKeyException;
import net.snowflake.spark.snowflake.ServerConnection$;
import net.snowflake.spark.snowflake.SnowflakeConnectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SnowflakeConnectorUtils$ {
    public static final SnowflakeConnectorUtils$ MODULE$ = new SnowflakeConnectorUtils$();
    private static transient Logger log;
    private static volatile transient boolean bitmap$trans$0;

    private Logger log$lzycompute() {
        SnowflakeConnectorUtils$ snowflakeConnectorUtils$ = this;
        synchronized (snowflakeConnectorUtils$) {
            if (!bitmap$trans$0) {
                log = LoggerFactory.getLogger((String)this.getClass().getName());
                bitmap$trans$0 = true;
            }
        }
        return log;
    }

    public Logger log() {
        if (!bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return log;
    }

    public void handleS3Exception(Exception ex) throws SnowflakeConnectorException {
        if (ex.getCause() instanceof InvalidKeyException) {
            String msg = "Strong encryption with Java JRE requires JCE Unlimited Strength Jurisdiction Policy files. Follow JDBC client installation instructions provided by Snowflake or contact Snowflake Support. This needs to be installed in the Java runtime for all Spark executor nodes.";
            this.log().error("JCE Unlimited Strength policy files missing: {}. {}.", (Object)ex.getMessage(), (Object)ex.getCause().getMessage());
            String bootLib = System.getProperty("sun.boot.library.path");
            if (bootLib != null) {
                msg = new StringBuilder(41).append(msg).append(" The target directory on your system is: ").append(((Object)Paths.get(bootLib, "security")).toString()).toString();
                this.log().error(msg);
            }
            throw new SnowflakeConnectorException(msg);
        }
        throw ex;
    }

    public void enableSharingJDBCConnection() {
        ServerConnection$.MODULE$.setSupportSharingJDBCConnection(true);
    }

    public void disableSharingJDBCConnection() {
        ServerConnection$.MODULE$.setSupportSharingJDBCConnection(false);
    }

    private SnowflakeConnectorUtils$() {
    }
}

