/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.common.mqtt;

import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.solarnetwork.common.mqtt.BasicMqttConnectionConfig;
import net.solarnetwork.common.mqtt.MqttConnectReturnCode;
import net.solarnetwork.common.mqtt.MqttConnection;
import net.solarnetwork.common.mqtt.MqttConnectionConfig;
import net.solarnetwork.common.mqtt.MqttConnectionObserver;
import net.solarnetwork.common.mqtt.MqttMessageHandler;
import net.solarnetwork.common.mqtt.ReconfigurableMqttConnection;
import net.solarnetwork.service.PingTest;
import net.solarnetwork.service.PingTestResult;
import net.solarnetwork.service.support.BasicIdentifiable;
import net.solarnetwork.settings.SettingsChangeObserver;
import net.solarnetwork.util.StatTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.TaskScheduler;

public abstract class BaseMqttConnection
extends BasicIdentifiable
implements MqttConnection,
ReconfigurableMqttConnection,
SettingsChangeObserver,
PingTest {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Executor executor;
    protected final TaskScheduler scheduler;
    protected final BasicMqttConnectionConfig connectionConfig;
    protected volatile MqttMessageHandler messageHandler;
    protected volatile MqttConnectionObserver connectionObserver;
    private boolean closed;
    private CompletableFuture<MqttConnectReturnCode> connectFuture;
    private CompletableFuture<Void> reconfigureFuture;

    public BaseMqttConnection(Executor executor, TaskScheduler scheduler) {
        this(executor, scheduler, new BasicMqttConnectionConfig());
    }

    public BaseMqttConnection(Executor executor, TaskScheduler scheduler, MqttConnectionConfig connectionConfig) {
        this.executor = executor;
        this.scheduler = scheduler;
        this.closed = false;
        this.connectionConfig = connectionConfig instanceof BasicMqttConnectionConfig ? (BasicMqttConnectionConfig)connectionConfig : new BasicMqttConnectionConfig(connectionConfig);
    }

    public synchronized void init() {
        try {
            this.open();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void configurationChanged(Map<String, Object> properties) {
        this.reconfigure();
    }

    @Override
    public final synchronized Future<?> reconfigure() {
        if (this.reconfigureFuture != null) {
            return this.reconfigureFuture;
        }
        if (this.connectFuture != null) {
            if (!this.connectFuture.isDone()) {
                try {
                    this.log.info("Cancelling scheduled connection to {} MQTT server from configuration change", (Object)this.getUid());
                    this.connectFuture.cancel(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.connectFuture = null;
        }
        final CompletableFuture f = new CompletableFuture();
        this.reconfigureFuture = f;
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Exception t = null;
                try {
                    try {
                        BaseMqttConnection.this.closeConnection().get(BaseMqttConnection.this.connectionConfig.getConnectTimeoutSeconds(), TimeUnit.SECONDS);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    BaseMqttConnection.this.log.info("Scheduling re-connection to {} MQTT server from configuration change in {}s", (Object)BaseMqttConnection.this.getUid(), (Object)BaseMqttConnection.this.connectionConfig.getReconnectDelaySeconds());
                    long reconnectDelay = Math.max(200L, (long)BaseMqttConnection.this.connectionConfig.getReconnectDelaySeconds() * 1000L);
                    try {
                        Thread.sleep(reconnectDelay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        BaseMqttConnection.this.open().get(BaseMqttConnection.this.connectionConfig.getConnectTimeoutSeconds(), TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        t = e;
                    }
                    this.complete(t);
                }
                catch (Throwable throwable) {
                    this.complete(t);
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void complete(Throwable t) {
                BaseMqttConnection baseMqttConnection = BaseMqttConnection.this;
                synchronized (baseMqttConnection) {
                    BaseMqttConnection.this.reconfigureFuture = null;
                }
                if (t != null) {
                    f.completeExceptionally(t);
                } else {
                    f.complete(null);
                }
            }
        });
        return f;
    }

    @Override
    public final synchronized Future<MqttConnectReturnCode> open() throws IOException {
        if (this.connectFuture != null) {
            return this.connectFuture;
        }
        if (this.isEstablished()) {
            return CompletableFuture.completedFuture(null);
        }
        this.closed = false;
        long connectDelay = Math.max(200L, (long)this.connectionConfig.getReconnectDelaySeconds() * 1000L / 4L);
        Date connectDate = new Date(System.currentTimeMillis() + connectDelay);
        CompletableFuture<MqttConnectReturnCode> f = new CompletableFuture<MqttConnectReturnCode>();
        this.connectFuture = f;
        this.log.info("Scheduling connection to {} MQTT server in {}ms", (Object)this.getUid(), (Object)connectDelay);
        this.scheduler.schedule(this.createConnectScheduledTask(f), connectDate);
        return f;
    }

    protected abstract Runnable createConnectScheduledTask(CompletableFuture<MqttConnectReturnCode> var1);

    protected CompletableFuture<MqttConnectReturnCode> connectFuture() {
        return this.connectFuture;
    }

    protected CompletableFuture<Void> reconfigureFuture() {
        return this.reconfigureFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        BaseMqttConnection baseMqttConnection = this;
        synchronized (baseMqttConnection) {
            this.closed = true;
            this.connectFuture = null;
        }
        URI serverUri = this.connectionConfig.getServerUri();
        try {
            this.closeConnection().get(this.connectionConfig.getConnectTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            this.log.warn("Error closing connection to MQTT server {}", (Object)serverUri);
            throw new IOException("Error closing connection to MQTT server " + serverUri, e);
        }
        catch (InterruptedException | TimeoutException e) {
            this.log.warn("Timeout closing connection to MQTT server {}", (Object)serverUri);
        }
    }

    protected abstract Future<?> closeConnection();

    @Override
    public final synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public final void setMessageHandler(MqttMessageHandler handler) {
        this.messageHandler = handler;
    }

    @Override
    public final void setConnectionObserver(MqttConnectionObserver observer) {
        this.connectionObserver = observer;
    }

    public String toString() {
        URI uri;
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append("{");
        if (this.getUid() != null) {
            builder.append(this.getUid());
            builder.append(',');
        }
        if ((uri = this.getConnectionConfig().getServerUri()) != null) {
            builder.append(uri);
        } else {
            builder.append("n/a");
        }
        builder.append("}");
        return builder.toString();
    }

    public String getPingTestId() {
        return this.getClass().getName() + "-" + this.getUid();
    }

    public String getPingTestName() {
        return "MQTT Service";
    }

    public long getPingTestMaximumExecutionMilliseconds() {
        return 10000L;
    }

    public PingTest.Result performPingTest() throws Exception {
        boolean healthy = this.isEstablished();
        URI serverUri = this.connectionConfig.getServerUri();
        String msg = healthy ? "Connected to " + serverUri : "Not connected";
        StatTracker stats = this.connectionConfig.getStats();
        NavigableMap allStats = stats != null ? stats.allCounts() : null;
        LinkedHashMap<String, URI> props = new LinkedHashMap<String, URI>(1 + (allStats != null ? allStats.size() : 0));
        props.put("serverUri", serverUri);
        if (allStats != null) {
            props.putAll(allStats);
        }
        PingTestResult result = new PingTestResult(healthy, msg, props);
        return result;
    }

    public String getUid() {
        return this.connectionConfig.getUid();
    }

    public void setUid(String uid) {
        this.connectionConfig.setUid(uid);
    }

    public final BasicMqttConnectionConfig getConnectionConfig() {
        return this.connectionConfig;
    }
}

