/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.common.mqtt;

import java.io.IOException;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.NavigableMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import net.solarnetwork.common.mqtt.BasicMqttConnectionConfig;
import net.solarnetwork.common.mqtt.MqttConnection;
import net.solarnetwork.common.mqtt.MqttConnectionFactory;
import net.solarnetwork.common.mqtt.MqttConnectionObserver;
import net.solarnetwork.common.mqtt.MqttMessageHandler;
import net.solarnetwork.common.mqtt.MqttQos;
import net.solarnetwork.service.PingTest;
import net.solarnetwork.service.PingTestResult;
import net.solarnetwork.service.support.BasicIdentifiable;
import net.solarnetwork.util.StatTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMqttConnectionService
extends BasicIdentifiable
implements PingTest {
    public static final MqttQos DEFAULT_PUBLISH_QOS = MqttQos.AtLeastOnce;
    public static final MqttQos DEFAULT_SUBSCRIBE_QOS = MqttQos.AtLeastOnce;
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final MqttConnectionFactory connectionFactory;
    private final BasicMqttConnectionConfig mqttConfig;
    private MqttQos publishQos = DEFAULT_PUBLISH_QOS;
    private MqttQos subscribeQos = DEFAULT_SUBSCRIBE_QOS;
    private MqttConnection connection;

    public BaseMqttConnectionService(MqttConnectionFactory connectionFactory, StatTracker mqttStats) {
        this.connectionFactory = connectionFactory;
        this.mqttConfig = new BasicMqttConnectionConfig();
        this.mqttConfig.setStats(mqttStats);
    }

    public synchronized void init() {
        this.startup();
    }

    public synchronized Future<?> startup() {
        if (this.connection != null) {
            return CompletableFuture.completedFuture(null);
        }
        this.connection = this.connectionFactory.createConnection(this.mqttConfig);
        if (this.connection == null) {
            CompletableFuture f = new CompletableFuture();
            f.completeExceptionally(new RuntimeException("Failed to obtain MQTT connection from factory."));
            return f;
        }
        this.connectionCreated(this.connection);
        try {
            return this.connection.open();
        }
        catch (IOException e) {
            throw new RuntimeException("Error opening MQTT connection to " + this.mqttConfig.getServerUri(), e);
        }
    }

    protected void connectionCreated(MqttConnection conn) {
        if (this instanceof MqttConnectionObserver) {
            conn.setConnectionObserver((MqttConnectionObserver)((Object)this));
        }
        if (this instanceof MqttMessageHandler) {
            conn.setMessageHandler((MqttMessageHandler)((Object)this));
        }
    }

    public synchronized void shutdown() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException e) {
                this.log.warn("Error closing MQTT connection to {}: {}", (Object)this.mqttConfig.getServerUri(), (Object)e.toString());
            }
            finally {
                this.connection = null;
            }
        }
    }

    protected MqttConnection connection() {
        return this.connection;
    }

    public String getPingTestId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public long getPingTestMaximumExecutionMilliseconds() {
        return 10000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PingTest.Result performPingTest() throws Exception {
        MqttConnection conn = null;
        BaseMqttConnectionService baseMqttConnectionService = this;
        synchronized (baseMqttConnectionService) {
            conn = this.connection;
        }
        if (conn != null) {
            if (conn instanceof PingTest) {
                return ((PingTest)conn).performPingTest();
            }
            boolean healthy = conn.isEstablished();
            URI serverUri = this.mqttConfig.getServerUri();
            String msg = healthy ? "Connected to " + serverUri : "Not connected";
            StatTracker stats = this.mqttConfig.getStats();
            NavigableMap allStats = stats != null ? stats.allCounts() : null;
            LinkedHashMap<String, URI> props = new LinkedHashMap<String, URI>(1 + (allStats != null ? allStats.size() : 0));
            props.put("serverUri", serverUri);
            if (allStats != null) {
                props.putAll(allStats);
            }
            PingTestResult result = new PingTestResult(healthy, msg, props);
            return result;
        }
        return new PingTestResult(false, "No MQTT connection available.");
    }

    public MqttQos getPublishQos() {
        return this.publishQos;
    }

    public void setPublishQos(MqttQos publishQos) {
        if (publishQos == null) {
            throw new IllegalArgumentException("The publishQos value must not be null.");
        }
        this.publishQos = publishQos;
    }

    public int getPublishQosValue() {
        return this.getPublishQos().getValue();
    }

    public void setPublishQosValue(int value) {
        try {
            this.setPublishQos(MqttQos.valueOf(value));
        }
        catch (IllegalArgumentException e) {
            this.setPublishQos(MqttQos.AtLeastOnce);
        }
    }

    public MqttQos getSubscribeQos() {
        return this.subscribeQos;
    }

    public void setSubscribeQos(MqttQos subscribeQos) {
        if (subscribeQos == null) {
            throw new IllegalArgumentException("The subscribeQos value must not be null.");
        }
        this.subscribeQos = subscribeQos;
    }

    public int getSubscribeQosValue() {
        return this.getSubscribeQos().getValue();
    }

    public void setSubscribeQosValue(int value) {
        try {
            this.setSubscribeQos(MqttQos.valueOf(value));
        }
        catch (IllegalArgumentException e) {
            this.setSubscribeQos(MqttQos.AtLeastOnce);
        }
    }

    public StatTracker getMqttStats() {
        return this.mqttConfig.getStats();
    }

    public BasicMqttConnectionConfig getMqttConfig() {
        return this.mqttConfig;
    }

    public void setUid(String uid) {
        super.setUid(uid);
        this.mqttConfig.setUid(uid);
    }
}

