/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.common.mqtt;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import net.solarnetwork.common.mqtt.BasicMutableMqttProperties;
import net.solarnetwork.common.mqtt.MqttConnectionConfig;
import net.solarnetwork.common.mqtt.MqttMessage;
import net.solarnetwork.common.mqtt.MqttVersion;
import net.solarnetwork.service.OptionalService;
import net.solarnetwork.service.SSLService;
import net.solarnetwork.service.StaticOptionalService;
import net.solarnetwork.util.StatTracker;

public class BasicMqttConnectionConfig
implements MqttConnectionConfig {
    public static final boolean DEFAULT_RECONNECT = true;
    public static final int DEFAULT_RECONNECT_DELAY_SECONDS = 10;
    public static final int DEFAULT_CONNECT_TIMEOUT_SECONDS = 10;
    public static final int DEFAULT_KEEP_ALIVE_SECONDS = 60;
    public static final int DEFAULT_MAXIMUM_MESSAGE_SIZE = 8192;
    public static final boolean DEFAULT_CLEAN_SESSION = true;
    public static final MqttVersion DEFAULT_VERSION = MqttVersion.Mqtt311;
    private String uid = UUID.randomUUID().toString();
    private URI serverUri;
    private MqttVersion version = DEFAULT_VERSION;
    private OptionalService<SSLService> optionalSslService;
    private String clientId;
    private String username;
    private String password;
    private boolean cleanSession = true;
    private int connectTimeoutSeconds = 10;
    private boolean reconnect = true;
    private int reconnectDelaySeconds = 10;
    private MqttMessage lastWill;
    private int maximumMessageSize = 8192;
    private int keepAliveSeconds = 60;
    private int readTimeoutSeconds = -1;
    private int writeTimeoutSeconds = -1;
    private StatTracker stats;
    private boolean wireLoggingEnabled;
    private final BasicMutableMqttProperties properties = new BasicMutableMqttProperties();

    public BasicMqttConnectionConfig() {
    }

    public BasicMqttConnectionConfig(MqttConnectionConfig other) {
        this();
        if (other == null) {
            return;
        }
        this.setUid(other.getUid());
        this.setServerUri(other.getServerUri());
        this.setVersion(other.getVersion());
        this.setSslService(other.getSslService());
        this.setClientId(other.getClientId());
        this.setUsername(other.getUsername());
        this.setPassword(other.getPassword());
        this.setCleanSession(other.isCleanSession());
        this.setConnectTimeoutSeconds(other.getConnectTimeoutSeconds());
        this.setReconnect(other.isReconnect());
        this.setReconnectDelaySeconds(other.getReconnectDelaySeconds());
        this.setLastWill(other.getLastWill());
        this.setMaximumMessageSize(other.getMaximumMessageSize());
        this.setKeepAliveSeconds(other.getKeepAliveSeconds());
        this.setStats(other.getStats());
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("The uid value must not be empty.");
        }
        this.uid = uid;
        if (this.stats != null) {
            this.stats.setUid(uid);
        }
    }

    @Override
    public URI getServerUri() {
        return this.serverUri;
    }

    public void setServerUri(URI serverUri) {
        this.serverUri = serverUri;
    }

    public String getServerUriValue() {
        URI uri = this.getServerUri();
        return uri != null ? uri.toString() : null;
    }

    public void setServerUriValue(String serverUri) {
        try {
            this.setServerUri(new URI(serverUri));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid MQTT server URI [" + serverUri + "]: " + e.getMessage());
        }
    }

    @Override
    public boolean isUseSsl() {
        URI uri = this.getServerUri();
        String scheme = uri != null ? uri.getScheme() : "mqtt";
        int port = uri != null ? uri.getPort() : -1;
        boolean useSsl = port == 8883 || "mqtts".equalsIgnoreCase(scheme) || "ssl".equalsIgnoreCase(scheme);
        return useSsl;
    }

    public String getHost() {
        URI uri = this.getServerUri();
        return uri != null ? uri.getHost() : null;
    }

    public int getPort() {
        int port;
        URI uri = this.getServerUri();
        int n = port = uri != null ? uri.getPort() : -1;
        if (port == -1) {
            port = this.isUseSsl() ? 8883 : 1883;
        }
        return port;
    }

    @Override
    public MqttVersion getVersion() {
        return this.version;
    }

    public void setVersion(MqttVersion version) {
        if (version == null) {
            throw new IllegalArgumentException("The version value must not be null.");
        }
        this.version = version;
    }

    @Override
    public SSLService getSslService() {
        return this.optionalSslService != null ? (SSLService)this.optionalSslService.service() : null;
    }

    public void setSslService(SSLService sslService) {
        this.setOptionalSslService((OptionalService<SSLService>)new StaticOptionalService((Object)sslService));
    }

    public OptionalService<SSLService> getOptionalSslService() {
        return this.optionalSslService;
    }

    public void setOptionalSslService(OptionalService<SSLService> optionalSslService) {
        this.optionalSslService = optionalSslService;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public boolean isCleanSession() {
        return this.cleanSession;
    }

    @Override
    public boolean isReconnect() {
        return this.reconnect;
    }

    public void setReconnect(boolean reconnect) {
        this.reconnect = reconnect;
    }

    @Override
    public int getReconnectDelaySeconds() {
        return this.reconnectDelaySeconds;
    }

    public void setReconnectDelaySeconds(int reconnectDelaySeconds) {
        this.reconnectDelaySeconds = reconnectDelaySeconds;
    }

    public void setCleanSession(boolean cleanSession) {
        this.cleanSession = cleanSession;
    }

    @Override
    public MqttMessage getLastWill() {
        return this.lastWill;
    }

    public void setLastWill(MqttMessage lastWill) {
        this.lastWill = lastWill;
    }

    @Override
    public int getMaximumMessageSize() {
        return this.maximumMessageSize;
    }

    public void setMaximumMessageSize(int maximumMessageSize) {
        if (maximumMessageSize <= 0 || maximumMessageSize > 256000000) {
            throw new IllegalArgumentException("The maximumMessageSize value must be between 1 and 256_000_000.");
        }
        this.maximumMessageSize = maximumMessageSize;
    }

    @Override
    public int getConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds;
    }

    public void setConnectTimeoutSeconds(int connectTimeoutSeconds) {
        if (connectTimeoutSeconds < 1) {
            throw new IllegalArgumentException("The connectTimeoutSeconds value must be > 0.");
        }
        this.connectTimeoutSeconds = connectTimeoutSeconds;
    }

    @Override
    public int getKeepAliveSeconds() {
        return this.keepAliveSeconds;
    }

    public void setKeepAliveSeconds(int keepAliveSeconds) {
        if (keepAliveSeconds != -1 && keepAliveSeconds <= 0) {
            throw new IllegalArgumentException("The keepAliveSeconds value must be -1 or > 0.");
        }
        this.keepAliveSeconds = keepAliveSeconds;
    }

    @Override
    public StatTracker getStats() {
        return this.stats;
    }

    public void setStats(StatTracker stats) {
        this.stats = stats;
        if (stats != null && this.uid != null) {
            stats.setUid(this.uid);
        }
    }

    @Override
    public BasicMutableMqttProperties getProperties() {
        return this.properties;
    }

    @Override
    public boolean isWireLoggingEnabled() {
        return this.wireLoggingEnabled;
    }

    @Override
    public void setWireLoggingEnabled(boolean wireLoggingEnabled) {
        this.wireLoggingEnabled = wireLoggingEnabled;
    }

    @Override
    public int getReadTimeoutSeconds() {
        return this.readTimeoutSeconds;
    }

    public void setReadTimeoutSeconds(int readTimeoutSeconds) {
        this.readTimeoutSeconds = readTimeoutSeconds;
    }

    @Override
    public int getWriteTimeoutSeconds() {
        return this.writeTimeoutSeconds;
    }

    public void setWriteTimeoutSeconds(int writeTimeoutSeconds) {
        this.writeTimeoutSeconds = writeTimeoutSeconds;
    }
}

