/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.common.mqtt;

import java.util.Objects;
import net.solarnetwork.common.mqtt.MqttProperty;
import net.solarnetwork.common.mqtt.MqttPropertyType;

public class BasicMqttProperty<T>
implements MqttProperty<T> {
    private final MqttPropertyType type;
    private final T value;

    public BasicMqttProperty(MqttPropertyType type, T value) {
        this.type = type;
        if (type == null) {
            throw new IllegalArgumentException("The type argument must not be null.");
        }
        this.value = value;
    }

    @Override
    public MqttPropertyType getType() {
        return this.type;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.value});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BasicMqttProperty)) {
            return false;
        }
        BasicMqttProperty other = (BasicMqttProperty)obj;
        return this.type == other.type && Objects.equals(this.value, other.value);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BasicMqttProperty{");
        if (this.type != null) {
            builder.append("type=");
            builder.append((Object)this.type);
            builder.append(", ");
        }
        if (this.value != null) {
            builder.append("value=");
            builder.append(this.value);
        }
        builder.append("}");
        return builder.toString();
    }
}

