/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.common.mqtt;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import net.solarnetwork.common.mqtt.MqttProperties;
import net.solarnetwork.common.mqtt.MqttPropertyType;
import net.solarnetwork.common.mqtt.MqttTopicAliases;
import net.solarnetwork.common.mqtt.SingletonProperties;

public class BasicMqttTopicAliases
implements MqttTopicAliases {
    private int maximumAliasCount;
    private final ConcurrentMap<String, Integer> topicAliases;
    private final ConcurrentMap<Integer, String> aliasedTopics;
    private final ConcurrentMap<Integer, MqttProperties> topicAliasProperties;

    public BasicMqttTopicAliases(int maximumAliasCount) {
        this(maximumAliasCount, new ConcurrentHashMap<String, Integer>(maximumAliasCount, 0.9f, 2), new ConcurrentHashMap<Integer, String>(maximumAliasCount, 0.9f, 2), new ConcurrentHashMap<Integer, MqttProperties>(maximumAliasCount, 0.9f, 2));
    }

    public BasicMqttTopicAliases(int maximumAliasCount, ConcurrentMap<String, Integer> topicAliases, ConcurrentMap<Integer, String> aliasedTopics, ConcurrentMap<Integer, MqttProperties> topicAliasProperties) {
        this.maximumAliasCount = maximumAliasCount;
        if (topicAliases == null) {
            throw new IllegalArgumentException("The topicAliases parameter must not be null.");
        }
        this.topicAliases = topicAliases;
        if (aliasedTopics == null) {
            throw new IllegalArgumentException("The aliasedTopics parameter must not be null.");
        }
        this.aliasedTopics = aliasedTopics;
        if (topicAliasProperties == null) {
            throw new IllegalArgumentException("The topicAliasProperties parameter must not be null.");
        }
        this.topicAliasProperties = topicAliasProperties;
    }

    @Override
    public int getMaximumAliasCount() {
        return this.maximumAliasCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaximumAliasCount(int maximumAliasCount) {
        ConcurrentMap<Integer, String> concurrentMap = this.aliasedTopics;
        synchronized (concurrentMap) {
            this.maximumAliasCount = maximumAliasCount;
            if (maximumAliasCount < 1 || this.topicAliases.size() > maximumAliasCount) {
                this.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ConcurrentMap<Integer, String> concurrentMap = this.aliasedTopics;
        synchronized (concurrentMap) {
            this.topicAliases.clear();
            this.aliasedTopics.clear();
            this.topicAliasProperties.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String topicAlias(String topic, Consumer<Integer> aliasConsumer) {
        Integer topicAlias = null;
        ConcurrentMap<Integer, String> concurrentMap = this.aliasedTopics;
        synchronized (concurrentMap) {
            int maxCount = this.getMaximumAliasCount();
            if (maxCount < 1) {
                return topic;
            }
            topicAlias = (Integer)this.topicAliases.get(topic);
            if (topicAlias == null) {
                String topicToAlias = topic;
                for (int i = 1; i <= maxCount; ++i) {
                    String aliasedTopic = this.aliasedTopics.computeIfAbsent(i, k -> topicToAlias);
                    if (!aliasedTopic.equals(topic)) continue;
                    topicAlias = i;
                    this.aliasedTopics.put(topicAlias, topic);
                    this.topicAliases.put(topic, -topicAlias.intValue());
                    break;
                }
            } else if (topicAlias < 0) {
                topicAlias = -topicAlias.intValue();
            } else {
                topic = "";
            }
        }
        if (topicAlias != null && aliasConsumer != null) {
            aliasConsumer.accept(topicAlias);
        }
        return topic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean confirmTopicAlias(String topic) {
        ConcurrentMap<Integer, String> concurrentMap = this.aliasedTopics;
        synchronized (concurrentMap) {
            Integer alias = this.topicAliases.computeIfPresent(topic, (k, v) -> {
                int a = v;
                if (a < 0) {
                    return -a;
                }
                return v;
            });
            return alias != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String aliasedTopic(String topic, Integer alias) {
        if (topic == null || topic.isEmpty()) {
            return (String)this.aliasedTopics.get(alias);
        }
        ConcurrentMap<Integer, String> concurrentMap = this.aliasedTopics;
        synchronized (concurrentMap) {
            this.aliasedTopics.put(alias, topic);
            this.topicAliases.put(topic, alias);
        }
        return topic;
    }

    @Override
    public MqttProperties propertiesForAliasedTopic(Integer alias) {
        return this.topicAliasProperties.computeIfAbsent(alias, a -> this.aliasedTopics.containsKey(a) ? SingletonProperties.property(MqttPropertyType.TOPIC_ALIAS, alias) : null);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BasicMqttTopicAliases{max=");
        builder.append(this.maximumAliasCount);
        builder.append(", aliases=");
        builder.append(this.topicAliases);
        builder.append("}");
        return builder.toString();
    }
}

