/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.common.mqtt;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.solarnetwork.common.mqtt.MqttProperties;
import net.solarnetwork.common.mqtt.MqttProperty;
import net.solarnetwork.common.mqtt.MqttPropertyType;
import net.solarnetwork.domain.KeyValuePair;
import net.solarnetwork.util.UnionIterator;

public class BasicMutableMqttProperties
implements MqttProperties.MutableMqttProperties {
    private final Map<MqttPropertyType, MqttProperty<?>> properties = new ConcurrentSkipListMap();
    private final List<MqttProperty<KeyValuePair>> userProperties = new CopyOnWriteArrayList<MqttProperty<KeyValuePair>>();
    private final List<MqttProperty<Integer>> subscriptionIds = new CopyOnWriteArrayList<MqttProperty<Integer>>();

    @Override
    public MqttProperty<?> getProperty(MqttPropertyType type) {
        switch (type) {
            case USER_PROPERTY: {
                return this.userProperties.iterator().next();
            }
            case SUBSCRIPTION_IDENTIFIER: {
                return this.subscriptionIds.iterator().next();
            }
        }
        return this.properties.get((Object)type);
    }

    @Override
    public List<? extends MqttProperty<?>> getAllProperties(MqttPropertyType type) {
        switch (type) {
            case USER_PROPERTY: {
                return this.userProperties;
            }
            case SUBSCRIPTION_IDENTIFIER: {
                return this.subscriptionIds;
            }
        }
        MqttProperty<?> prop = this.properties.get((Object)type);
        return prop != null ? Collections.singletonList(prop) : Collections.emptyList();
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty() && this.userProperties.isEmpty() && this.subscriptionIds.isEmpty();
    }

    @Override
    public void clear() {
        this.properties.clear();
        this.userProperties.clear();
        this.subscriptionIds.clear();
    }

    @Override
    public Iterator<MqttProperty<?>> iterator() {
        Iterator<MqttProperty<?>> propsItr = this.properties.values().iterator();
        Iterator<MqttProperty<KeyValuePair>> userPropsItr = this.userProperties.iterator();
        Iterator<MqttProperty<Integer>> subsItr = this.subscriptionIds.iterator();
        List<Iterator> itrs = Arrays.asList(propsItr, userPropsItr, subsItr);
        return new UnionIterator(itrs);
    }

    @Override
    public void addProperty(MqttProperty<?> property) {
        if (property == null || property.getType() == null) {
            return;
        }
        switch (property.getType()) {
            case USER_PROPERTY: {
                if (!(property.getValue() instanceof KeyValuePair)) break;
                this.userProperties.add(property);
                break;
            }
            case SUBSCRIPTION_IDENTIFIER: {
                if (!(property.getValue() instanceof Integer)) break;
                this.subscriptionIds.add(property);
                break;
            }
            default: {
                this.properties.put(property.getType(), property);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BasicMutableMqttProperties{");
        if (this.properties != null) {
            builder.append("properties=");
            builder.append(this.properties);
            builder.append(", ");
        }
        if (this.userProperties != null) {
            builder.append("userProperties=");
            builder.append(this.userProperties);
            builder.append(", ");
        }
        if (this.subscriptionIds != null) {
            builder.append("subscriptionIds=");
            builder.append(this.subscriptionIds);
        }
        builder.append("}");
        return builder.toString();
    }
}

