/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.common.mqtt;

public enum MqttConnectReturnCode {
    Accepted(0),
    UnacceptableProtocolVersion(1),
    ClientIdRejected(2),
    ServerUnavailable(3),
    BadCredentials(4),
    NotAuthorized(5);

    private final byte byteValue;

    private MqttConnectReturnCode(byte byteValue) {
        this.byteValue = byteValue;
    }

    public byte byteValue() {
        return this.byteValue;
    }

    public static MqttConnectReturnCode valueOf(int value) {
        return MqttConnectReturnCode.valueOf((byte)(value & 0xFF));
    }

    public static MqttConnectReturnCode valueOf(byte value) {
        switch (value) {
            case 0: {
                return Accepted;
            }
            case 1: {
                return UnacceptableProtocolVersion;
            }
            case 2: {
                return ClientIdRejected;
            }
            case 3: {
                return ServerUnavailable;
            }
            case 4: {
                return BadCredentials;
            }
            case 5: {
                return NotAuthorized;
            }
        }
        throw new IllegalArgumentException("Connect return code value not supported: " + (value & 0xFF));
    }
}

