/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.common.mqtt;

import java.net.URI;
import java.util.UUID;
import net.solarnetwork.common.mqtt.MqttMessage;
import net.solarnetwork.common.mqtt.MqttProperties;
import net.solarnetwork.common.mqtt.MqttProperty;
import net.solarnetwork.common.mqtt.MqttPropertyType;
import net.solarnetwork.common.mqtt.MqttVersion;
import net.solarnetwork.common.mqtt.WireLoggingSupport;
import net.solarnetwork.service.SSLService;
import net.solarnetwork.util.StatTracker;

public interface MqttConnectionConfig
extends WireLoggingSupport {
    public static final int DEFAULT_PORT = 1883;
    public static final int DEFAULT_PORT_SSL = 8883;

    public String getUid();

    public URI getServerUri();

    public boolean isUseSsl();

    public MqttVersion getVersion();

    public SSLService getSslService();

    public String getClientId();

    public String getUsername();

    public String getPassword();

    public boolean isCleanSession();

    public MqttMessage getLastWill();

    public int getMaximumMessageSize();

    public int getKeepAliveSeconds();

    public int getConnectTimeoutSeconds();

    default public int getReadTimeoutSeconds() {
        return -1;
    }

    default public int getWriteTimeoutSeconds() {
        return -1;
    }

    public boolean isReconnect();

    public int getReconnectDelaySeconds();

    public StatTracker getStats();

    public MqttProperties getProperties();

    default public <T> MqttProperty<T> getProperty(MqttPropertyType type) {
        MqttProperties props = this.getProperties();
        if (props != null) {
            return props.getProperty(type);
        }
        return null;
    }

    default public void setProperty(MqttProperty<?> property) {
        MqttProperties props = this.getProperties();
        if (props instanceof MqttProperties.MutableMqttProperties) {
            ((MqttProperties.MutableMqttProperties)props).addProperty(property);
        }
    }

    public static String randomClientId(String prefix) {
        return (prefix != null ? prefix : "") + UUID.randomUUID().toString().replaceAll("-", "");
    }
}

