/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.common.mqtt;

import net.solarnetwork.domain.KeyValuePair;

public enum MqttPropertyType {
    PAYLOAD_FORMAT_INDICATOR(1, Integer.class, 1),
    REQUEST_PROBLEM_INFORMATION(23, Integer.class, 1),
    REQUEST_RESPONSE_INFORMATION(25, Integer.class, 1),
    MAXIMUM_QOS(36, Integer.class, 1),
    RETAIN_AVAILABLE(37, Integer.class, 1),
    WILDCARD_SUBSCRIPTION_AVAILABLE(40, Integer.class, 1),
    SUBSCRIPTION_IDENTIFIER_AVAILABLE(41, Integer.class, 1),
    SHARED_SUBSCRIPTION_AVAILABLE(42, Integer.class, 1),
    SERVER_KEEP_ALIVE(19, Integer.class, 2),
    RECEIVE_MAXIMUM(33, Integer.class, 2),
    TOPIC_ALIAS_MAXIMUM(34, Integer.class, 2),
    TOPIC_ALIAS(35, Integer.class, 2),
    PUBLICATION_EXPIRY_INTERVAL(2, Integer.class, 4),
    SESSION_EXPIRY_INTERVAL(17, Integer.class, 4),
    WILL_DELAY_INTERVAL(24, Integer.class, 4),
    MAXIMUM_PACKET_SIZE(39, Integer.class, 4),
    SUBSCRIPTION_IDENTIFIER(11, Integer.class),
    CONTENT_TYPE(3, String.class),
    RESPONSE_TOPIC(8, String.class),
    ASSIGNED_CLIENT_IDENTIFIER(18, String.class),
    AUTHENTICATION_METHOD(21, String.class),
    RESPONSE_INFORMATION(26, String.class),
    SERVER_REFERENCE(28, String.class),
    REASON_STRING(31, String.class),
    USER_PROPERTY(38, KeyValuePair.class),
    CORRELATION_DATA(9, byte[].class),
    AUTHENTICATION_DATA(22, byte[].class);

    private static final MqttPropertyType[] VALUES;
    private final Integer key;
    private final Class<?> valueType;
    private final int length;

    private MqttPropertyType(int key, Class<?> valueType) {
        this(key, valueType, -1);
    }

    private MqttPropertyType(int key, Class<?> valueType, int length) {
        this.key = key;
        this.valueType = valueType;
        this.length = length;
    }

    public Integer getKey() {
        return this.key;
    }

    public Class<?> getValueType() {
        return this.valueType;
    }

    public int getLength() {
        return this.length;
    }

    public static MqttPropertyType valueOf(int key) {
        MqttPropertyType t = null;
        try {
            t = VALUES[key];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (t == null) {
            throw new IllegalArgumentException("Unknown MQTT property key: " + key);
        }
        return t;
    }

    static {
        VALUES = new MqttPropertyType[43];
        MqttPropertyType[] mqttPropertyTypeArray = MqttPropertyType.values();
        int n = mqttPropertyTypeArray.length;
        for (int i = 0; i < n; ++i) {
            MqttPropertyType v;
            MqttPropertyType.VALUES[v.key.intValue()] = v = mqttPropertyTypeArray[i];
        }
    }
}

