/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.common.mqtt;

import java.text.StringCharacterIterator;
import net.solarnetwork.common.mqtt.MqttVersion;
import net.solarnetwork.util.StringUtils;

public final class MqttUtils {
    private MqttUtils() {
    }

    public static void validateTopicName(String topic) {
        MqttUtils.validateTopicName(topic, MqttVersion.Mqtt311);
    }

    public static void validateTopicName(String topic, MqttVersion version) {
        if (topic == null || topic.isEmpty()) {
            throw new IllegalArgumentException("MQTT topic must be at least one character (MQTT-4.7.3-1).");
        }
        if (StringUtils.utf8length((CharSequence)topic) > 65535) {
            throw new IllegalArgumentException("MQTT topic must not be longer than 65535 bytes (MQTT-4.7.3-3).");
        }
        StringCharacterIterator itr = new StringCharacterIterator(topic);
        char c = itr.first();
        while (c != '\uffff') {
            switch (c) {
                case '\u0000': {
                    throw new IllegalArgumentException(String.format("MQTT topic must not include the null character, found at index %d (MQTT-4.7.3-2).", itr.getIndex()));
                }
                case '#': 
                case '+': {
                    throw new IllegalArgumentException(String.format("MQTT topic must not include the subscription wildcard character '%c', found at index %d (MQTT-4.7.1-1).", Character.valueOf(c), itr.getIndex()));
                }
            }
            c = itr.next();
        }
    }
}

