/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.common.mqtt;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.solarnetwork.common.mqtt.BasicMqttProperty;
import net.solarnetwork.common.mqtt.MqttProperties;
import net.solarnetwork.common.mqtt.MqttProperty;
import net.solarnetwork.common.mqtt.MqttPropertyType;

public class SingletonProperties
implements MqttProperties {
    private final MqttProperty<?> property;
    private final List<MqttProperty<?>> list;

    public SingletonProperties(MqttProperty<?> property) {
        this.property = property;
        this.list = Collections.singletonList(property);
    }

    public static <T> MqttProperties property(MqttPropertyType type, T value) {
        return new SingletonProperties(new BasicMqttProperty<T>(type, value));
    }

    @Override
    public Iterator<MqttProperty<?>> iterator() {
        return this.list.iterator();
    }

    @Override
    public MqttProperty<?> getProperty(MqttPropertyType type) {
        return type == this.property.getType() ? this.property : null;
    }

    @Override
    public List<? extends MqttProperty<?>> getAllProperties(MqttPropertyType type) {
        return type == this.property.getType() ? this.list : null;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

